<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * X-Cart
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the software license agreement
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.x-cart.com/license-agreement.html
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to licensing@x-cart.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not modify this file if you wish to upgrade X-Cart to newer versions
 * in the future. If you wish to customize X-Cart for your needs please
 * refer to http://www.x-cart.com/ for more information.
 *
 * @category  X-Cart 5
 * @author    Magic Toolbox <support@magictoolbox.com>
 * @copyright Copyright (c) 2013 Magic Toolbox <support@magictoolbox.com>. All rights reserved
 * @license   http://www.x-cart.com/license-agreement.html X-Cart 5 License Agreement
 * @link      http://www.magictoolbox.com/
*/

namespace XLite\Module\MagicToolbox\Magic360\Model;

/**
 * Columns
 *
 * @Entity
 * @Table (name="magic360_columns",
 *      indexes={
 *          @Index (name="product_id", columns={"product_id"})
 *      }
 * )
 */
class Columns extends \XLite\Model\AEntity
{
    /**
     * Product unique id
     *
     * @var integer
     *
     * @Id
     * @Column         (type="integer", options={ "unsigned": true })
     */
    protected $product_id;

    /**
     * Columns
     *
     * @var integer
     *
     * @Column         (type="smallint", options={ "unsigned": true })
     */
    protected $columns = 0;

    /**
     * Set product id
     *
     * @param integer $product_id
     * @return Columns
     */
    public function setProductId($product_id)
    {
        $this->product_id = $product_id;
        return $this;
    }

    /**
     * Get product id
     *
     * @return integer
     */
    public function getProductId()
    {
        return $this->product_id;
    }

    /**
     * Set columns
     *
     * @param integer $columns
     * @return Columns
     */
    public function setColumns($columns)
    {
        $this->columns = $columns;
        return $this;
    }

    /**
     * Get columns
     *
     * @return integer
     */
    public function getColumns()
    {
        return $this->columns;
    }
}
