<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * X-Cart
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the software license agreement
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.x-cart.com/license-agreement.html
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to licensing@x-cart.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not modify this file if you wish to upgrade X-Cart to newer versions
 * in the future. If you wish to customize X-Cart for your needs please
 * refer to http://www.x-cart.com/ for more information.
 *
 * @category  X-Cart 5
 * @author    Magic Toolbox <support@magictoolbox.com>
 * @copyright Copyright (c) 2013 Magic Toolbox <support@magictoolbox.com>. All rights reserved
 * @license   http://www.x-cart.com/license-agreement.html X-Cart 5 License Agreement
 * @link      http://www.magictoolbox.com/
*/

namespace XLite\Module\MagicToolbox\Magic360\Controller\Admin;

/**
 * Magic 360 page controller (Product modify section)
 */
class Product extends \XLite\Controller\Admin\Product implements \XLite\Base\IDecorator
{
    /**
     * Get pages
     *
     * @return array
     */
    public function getPages()
    {
        $list = parent::getPages();

        if (!$this->isNew()) {
            $list['magic360'] = static::t('Magic 360');
        }

        return $list;
    }

    /**
     * Get pages templates
     *
     * @return array
     */
    protected function getPageTemplates()
    {
        $list = parent::getPageTemplates();

        if (!$this->isNew()) {
            $list['magic360'] = 'modules/MagicToolbox/Magic360/product/tab.twig';
        }

        return $list;
    }

    /**
     * Whether multi rows are used for this product
     *
     * @return bool
     */
    public function isMultiRowsEnabled()
    {
        static $isMultiRowsEnabled = null;
        if ($isMultiRowsEnabled === null) {
            $isMultiRowsEnabled = false;
            if ($this->getSpinRows() > 1 || ($this->getSpinColumns() < $this->getSpinImagesCount())) {
                $isMultiRowsEnabled = true;
            }
        }
        return $isMultiRowsEnabled;
    }

    /**
     * Get number of columns
     *
     * @return integer
     */
    public function getSpinColumns()
    {
        static $columns = null;
        if ($columns === null) {
            $columns = $this->getProduct()->getSpinColumns();
        }
        return $columns;
    }

    /**
     * Get number of rows
     *
     * @return integer
     */
    public function getSpinRows()
    {
        static $rows = null;
        if ($rows === null) {
            $rows = 0;
            $columns = $this->getSpinColumns();
            if ($columns) {
                $rows = 1;
                $count = $this->getSpinImagesCount();
                if ($count != $columns) {
                    $rows = (int)floor($count / $columns);
                }
            }
        }
        return $rows;
    }

    /**
     * Get spin images
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getSpinImages()
    {
        static $images = null;
        if ($images === null) {
            $images = $this->getProduct()->getSpinImages();
        }
        return $images;
    }

    /**
     * Get spin images count
     *
     * @return integer
     */
    public function getSpinImagesCount()
    {
        static $count = null;
        if ($count === null) {
            $count = $this->getProduct()->getSpinImagesCount();
        }
        return $count;
    }

    /**
     * Update Magic360 action handler
     *
     * @return void
     */
    public function doActionUpdateMagic360()
    {
        $product = $this->getProduct();
        $productId = $product->getId();
        $request = \XLite\Core\Request::getInstance();

        $data = isset($request->magic360) ? $request->magic360 : array();

        $isMultiRowsEnabled = isset($data['multi_rows_enabled']) ? (bool)$data['multi_rows_enabled'] : false;
        $columns = isset($data['columns']) ? (int)$data['columns'] : 0;
        $rows = isset($data['rows']) ? (int)$data['rows'] : 0;
        $images = isset($data['images']) ? $data['images'] : array();

        $product->processFiles('spinImages', $images);

        $imagesCount = $product->getSpinImagesCount();

        if (!$isMultiRowsEnabled || !$columns || ($columns > $imagesCount)) {
            $columns = $imagesCount;
        }

        $product->setSpinColumns($columns);

        \XLite\Core\TopMessage::addInfo('Magic360 data have been successfully updated');
    }
}
