<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * X-Cart
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the software license agreement
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.x-cart.com/license-agreement.html
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to licensing@x-cart.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not modify this file if you wish to upgrade X-Cart to newer versions
 * in the future. If you wish to customize X-Cart for your needs please
 * refer to http://www.x-cart.com/ for more information.
 *
 * @category  X-Cart 5
 * @author    Magic Toolbox <support@magictoolbox.com>
 * @copyright Copyright (c) 2013 Magic Toolbox <support@magictoolbox.com>. All rights reserved
 * @license   http://www.x-cart.com/license-agreement.html X-Cart 5 License Agreement
 * @link      http://www.magictoolbox.com/
*/

namespace XLite\Module\MagicToolbox\Magic360\Classes;

/**
 * Helper class
 *
 */
class Helper extends \XLite\Base\Singleton
{
    /**
     * Magic360 module core class
     *
     * @var \XLite\Module\MagicToolbox\Magic360\Classes\Magic360ModuleCoreClass
     *
     */
    protected $primaryTool = null;

    /**
     * Protected constructor.
     * Load and set up Magic360 module core class
     *
     * @return void
     */
    protected function __construct()
    {
        $this->primaryTool = new \XLite\Module\MagicToolbox\Magic360\Classes\Magic360ModuleCoreClass();

        $repo = \XLite\Core\Database::getRepo('XLite\Module\MagicToolbox\Magic360\Model\Config');
        if (!($repo && $repo->count())) {
            $this->doLoadDefaults();
        }

        $config = $repo->getEditableAndActiveOptions();
        foreach ($config as $profile => $options) {
            foreach ($options as $id => $value) {
                $this->primaryTool->params->setValue($id, $value, $profile);
            }
        }
    }

    /**
     * Load defaults
     *
     * @return void
     */
    protected function doLoadDefaults()
    {
        $yaml = \Includes\Utils\ModulesManager::getModuleYAMLFiles('MagicToolbox', 'Magic360');
        $yaml = $yaml[0];
        if (\Includes\Utils\FileManager::isFileReadable($yaml)) {
            \XLite\Core\Database::getRepo('\XLite\Module\MagicToolbox\Magic360\Model\Config')->clearAll();
            \XLite\Core\Database::getInstance()->loadFixturesFromYaml($yaml);
        }
    }

    /**
     * Method to get Magic360 module core class
     *
     * @return \XLite\Module\MagicToolbox\Magic360\Classes\Magic360ModuleCoreClass
     */
    public function getPrimaryTool()
    {
        return $this->primaryTool;
    }
}
