<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text" />
<xsl:template match="/">
    <xsl:choose>
        <xsl:when test="count(DATASET/ITEM) &lt; $magiczoommainimageid$ or $magiczoommainimageid$ &lt; 1">
            <xsl:call-template name="MagicToolbox">
                <xsl:with-param name="noMainImage">true</xsl:with-param>
            </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
            <xsl:call-template name="MagicToolboxImage">
                <xsl:with-param name="img"    select="DATASET/ITEM[$magiczoommainimageid$]/IMAGE" />
                <xsl:with-param name="medium" select="DATASET/ITEM[$magiczoommainimageid$]/MEDIUM" />
                <xsl:with-param name="thumb"  select="DATASET/ITEM[$magiczoommainimageid$]/THUMBNAIL" />
                <xsl:with-param name="title"  select="DATASET/ITEM[$magiczoommainimageid$]/TITLE" />
                <xsl:with-param name="isMainImage">true</xsl:with-param>
                <xsl:with-param name="curID">$magiczoommainimageid$</xsl:with-param>
            </xsl:call-template>
            <xsl:call-template name="MagicToolbox">
                <xsl:with-param name="noMainImage">false</xsl:with-param>
            </xsl:call-template>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>
<xsl:template name="MagicToolbox">
    <xsl:param name="noMainImage" />
    <xsl:for-each select="DATASET/ITEM">
        <xsl:call-template name="MagicToolboxImage">
            <xsl:with-param name="img" select="IMAGE" />
            <xsl:with-param name="medium" select="MEDIUM" />
            <xsl:with-param name="thumb" select="THUMBNAIL" />
            <xsl:with-param name="title" select="TITLE" />
            <xsl:with-param name="isMainImage" select="$noMainImage"/>
            <xsl:with-param name="curID" select="position()"/>
        </xsl:call-template>
    </xsl:for-each>
</xsl:template>
<xsl:template name="MagicToolboxImage">
    <xsl:param name="isMainImage" />
    <xsl:param name="img" />
    <xsl:param name="medium" />
    <xsl:param name="thumb" />
    <xsl:param name="title" />
    <xsl:param name="curID" />
    <xsl:text>&lt;a</xsl:text>
    <xsl:choose>
        <xsl:when test="$isMainImage = 'true'">
            <xsl:text> id=&quot;MagicZoom$magiczoomelementid$</xsl:text><xsl:value-of select="$curID"/><xsl:text>&quot;</xsl:text>
            <xsl:text> class=&quot;MagicZoom</xsl:text>
            <xsl:text>&quot;</xsl:text>
            <xsl:choose>
                <xsl:when test="'magiczoom' = 'magicthumb'">
                    <xsl:text> rel=&quot;'zoomWidth':'$magiczoomzoomWidth$','zoomHeight':'$magiczoomzoomHeight$','zoomPosition':'$magiczoomzoomPosition$','zoomDistance':$magiczoomzoomDistance$,'selectorTrigger':'$magiczoomselectorTrigger$','transitionEffect':'$magiczoomtransitionEffect$','lazyZoom':'$magiczoomlazyZoom$','rightClick':'$magiczoomrightClick$','cssClass':'$magiczoomcssClass$','zoomMode':'$magiczoomzoomMode$','zoomOn':'$magiczoomzoomOn$','upscale':'$magiczoomupscale$','smoothing':'$magiczoomsmoothing$','variableZoom':'$magiczoomvariableZoom$','zoomCaption':'$magiczoomzoomCaption$','hint':'$magiczoomhint$','textHoverZoomHint':'$magiczoomtextHoverZoomHint$','textClickZoomHint':'$magiczoomtextClickZoomHint$'&quot;</xsl:text>
                </xsl:when>
                <xsl:when test="'magiczoom' = 'magiczoom' or 'magiczoom' = 'magiczoomplus'">
                    <xsl:text> data-options=&quot;'zoomWidth':'$magiczoomzoomWidth$','zoomHeight':'$magiczoomzoomHeight$','zoomPosition':'$magiczoomzoomPosition$','zoomDistance':$magiczoomzoomDistance$,'selectorTrigger':'$magiczoomselectorTrigger$','transitionEffect':'$magiczoomtransitionEffect$','lazyZoom':'$magiczoomlazyZoom$','rightClick':'$magiczoomrightClick$','cssClass':'$magiczoomcssClass$','zoomMode':'$magiczoomzoomMode$','zoomOn':'$magiczoomzoomOn$','upscale':'$magiczoomupscale$','smoothing':'$magiczoomsmoothing$','variableZoom':'$magiczoomvariableZoom$','zoomCaption':'$magiczoomzoomCaption$','hint':'$magiczoomhint$','textHoverZoomHint':'$magiczoomtextHoverZoomHint$','textClickZoomHint':'$magiczoomtextClickZoomHint$'&quot;</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text> rel=&quot;'zoomWidth':'$magiczoomzoomWidth$','zoomHeight':'$magiczoomzoomHeight$','zoomPosition':'$magiczoomzoomPosition$','zoomDistance':$magiczoomzoomDistance$,'selectorTrigger':'$magiczoomselectorTrigger$','transitionEffect':'$magiczoomtransitionEffect$','lazyZoom':'$magiczoomlazyZoom$','rightClick':'$magiczoomrightClick$','cssClass':'$magiczoomcssClass$','zoomMode':'$magiczoomzoomMode$','zoomOn':'$magiczoomzoomOn$','upscale':'$magiczoomupscale$','smoothing':'$magiczoomsmoothing$','variableZoom':'$magiczoomvariableZoom$','zoomCaption':'$magiczoomzoomCaption$','hint':'$magiczoomhint$','textHoverZoomHint':'$magiczoomtextHoverZoomHint$','textClickZoomHint':'$magiczoomtextClickZoomHint$'&quot;</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:when>
        <xsl:otherwise>
            <xsl:choose>
                <xsl:when test="'magiczoom' = 'magicthumb'">
                    <xsl:text> rel=&quot;thumb-id:MagicZoom$magiczoomelementid$$magiczoommainimageid$&quot;</xsl:text>
                </xsl:when>
                <xsl:when test="'magiczoom' = 'magiczoom' or 'magiczoom' = 'magiczoomplus'">
                    <xsl:text> data-zoom-id=&quot;MagicZoom$magiczoomelementid$$magiczoommainimageid$&quot;</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text> rel=&quot;MagicZoom$magiczoomelementid$$magiczoommainimageid$&quot;</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:text> rev=&quot;</xsl:text><xsl:value-of select="$medium"/><xsl:text>&quot;</xsl:text>
        </xsl:otherwise>
    </xsl:choose>
    <xsl:text> href=&quot;</xsl:text><xsl:value-of select="$img"/><xsl:text>&quot;</xsl:text>
    <xsl:text> title=&quot;</xsl:text><xsl:value-of select="$title"/><xsl:text>&quot;</xsl:text>
    <xsl:text>&gt;</xsl:text>
    <xsl:text>&lt;img</xsl:text>
    <xsl:choose>
        <xsl:when test="$isMainImage = 'true'">
            <xsl:text> src=&quot;</xsl:text><xsl:value-of select="$medium"/><xsl:text>&quot;</xsl:text>
            <xsl:text> itemprop=&quot;image&quot;</xsl:text>
        </xsl:when>
        <xsl:otherwise>
            <xsl:text> src=&quot;</xsl:text><xsl:value-of select="$thumb"/><xsl:text>&quot;</xsl:text>
        </xsl:otherwise>
    </xsl:choose>
    <xsl:text>&#047;&gt;</xsl:text>
    <xsl:text>&lt;&#047;a&gt;</xsl:text>
    <xsl:if test="'$magiczoomshow_message$' = 'true'">
        <xsl:text>$magiczoommessage$</xsl:text>
    </xsl:if>
</xsl:template>
</xsl:stylesheet>
