<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text" />
<xsl:template match="/">
    <xsl:choose>
        <xsl:when test="count(DATASET/ITEM) &lt; $magicthumbmainimageid$ or $magicthumbmainimageid$ &lt; 1">
            <xsl:call-template name="MagicToolbox">
                <xsl:with-param name="noMainImage">true</xsl:with-param>
            </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
            <xsl:call-template name="MagicToolboxImage">
                <xsl:with-param name="img"    select="DATASET/ITEM[$magicthumbmainimageid$]/IMAGE" />
                <xsl:with-param name="medium" select="DATASET/ITEM[$magicthumbmainimageid$]/MEDIUM" />
                <xsl:with-param name="thumb"  select="DATASET/ITEM[$magicthumbmainimageid$]/THUMBNAIL" />
                <xsl:with-param name="title"  select="DATASET/ITEM[$magicthumbmainimageid$]/TITLE" />
                <xsl:with-param name="isMainImage">true</xsl:with-param>
                <xsl:with-param name="curID">$magicthumbmainimageid$</xsl:with-param>
            </xsl:call-template>
            <xsl:call-template name="MagicToolbox">
                <xsl:with-param name="noMainImage">false</xsl:with-param>
            </xsl:call-template>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>
<xsl:template name="MagicToolbox">
    <xsl:param name="noMainImage" />
    <xsl:for-each select="DATASET/ITEM">
        <xsl:call-template name="MagicToolboxImage">
            <xsl:with-param name="img" select="IMAGE" />
            <xsl:with-param name="medium" select="MEDIUM" />
            <xsl:with-param name="thumb" select="THUMBNAIL" />
            <xsl:with-param name="title" select="TITLE" />
            <xsl:with-param name="isMainImage" select="$noMainImage"/>
            <xsl:with-param name="curID" select="position()"/>
        </xsl:call-template>
    </xsl:for-each>
</xsl:template>
<xsl:template name="MagicToolboxImage">
    <xsl:param name="isMainImage" />
    <xsl:param name="img" />
    <xsl:param name="medium" />
    <xsl:param name="thumb" />
    <xsl:param name="title" />
    <xsl:param name="curID" />
    <xsl:text>&lt;a</xsl:text>
    <xsl:choose>
        <xsl:when test="$isMainImage = 'true'">
            <xsl:text> id=&quot;MagicThumb$magicthumbelementid$</xsl:text><xsl:value-of select="$curID"/><xsl:text>&quot;</xsl:text>
            <xsl:text> class=&quot;MagicThumb</xsl:text>
            <xsl:text>&quot;</xsl:text>
            <xsl:choose>
                <xsl:when test="'magicthumb' = 'magicthumb'">
                    <xsl:text> rel=&quot;'expandEffect':'$magicthumbexpandEffect$','expandSpeed':$magicthumbexpandSpeed$,'expandImageSize':'$magicthumbexpandImageSize$','expandTrigger':'$magicthumbexpandTrigger$','expandAlign':'$magicthumbexpandAlign$','expandEasing':'$magicthumbexpandEasing$','gallerySpeed':$magicthumbgallerySpeed$,'loop':'$magicthumbloop$','selectorTrigger':'$magicthumbselectorTrigger$','selectorEffect':'$magicthumbselectorEffect$','captionPosition':'$magicthumbcaptionPosition$','keyboard':'$magicthumbkeyboard$','cssClass':'$magicthumbcssClass$','rightClick':'$magicthumbrightClick$','lazyLoad':'$magicthumblazyLoad$','autostart':'$magicthumbautostart$','buttons':'$magicthumbbuttons$','textBtnClose':'$magicthumbtextBtnClose$','textBtnNext':'$magicthumbtextBtnNext$','textBtnPrev':'$magicthumbtextBtnPrev$','hint':'$magicthumbhint$','textClickHint':'$magicthumbtextClickHint$','textHoverHint':'$magicthumbtextHoverHint$'&quot;</xsl:text>
                </xsl:when>
                <xsl:when test="'magicthumb' = 'magiczoom' or 'magicthumb' = 'magiczoomplus'">
                    <xsl:text> data-options=&quot;'expandEffect':'$magicthumbexpandEffect$','expandSpeed':$magicthumbexpandSpeed$,'expandImageSize':'$magicthumbexpandImageSize$','expandTrigger':'$magicthumbexpandTrigger$','expandAlign':'$magicthumbexpandAlign$','expandEasing':'$magicthumbexpandEasing$','gallerySpeed':$magicthumbgallerySpeed$,'loop':'$magicthumbloop$','selectorTrigger':'$magicthumbselectorTrigger$','selectorEffect':'$magicthumbselectorEffect$','captionPosition':'$magicthumbcaptionPosition$','keyboard':'$magicthumbkeyboard$','cssClass':'$magicthumbcssClass$','rightClick':'$magicthumbrightClick$','lazyLoad':'$magicthumblazyLoad$','autostart':'$magicthumbautostart$','buttons':'$magicthumbbuttons$','textBtnClose':'$magicthumbtextBtnClose$','textBtnNext':'$magicthumbtextBtnNext$','textBtnPrev':'$magicthumbtextBtnPrev$','hint':'$magicthumbhint$','textClickHint':'$magicthumbtextClickHint$','textHoverHint':'$magicthumbtextHoverHint$'&quot;</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text> rel=&quot;'expandEffect':'$magicthumbexpandEffect$','expandSpeed':$magicthumbexpandSpeed$,'expandImageSize':'$magicthumbexpandImageSize$','expandTrigger':'$magicthumbexpandTrigger$','expandAlign':'$magicthumbexpandAlign$','expandEasing':'$magicthumbexpandEasing$','gallerySpeed':$magicthumbgallerySpeed$,'loop':'$magicthumbloop$','selectorTrigger':'$magicthumbselectorTrigger$','selectorEffect':'$magicthumbselectorEffect$','captionPosition':'$magicthumbcaptionPosition$','keyboard':'$magicthumbkeyboard$','cssClass':'$magicthumbcssClass$','rightClick':'$magicthumbrightClick$','lazyLoad':'$magicthumblazyLoad$','autostart':'$magicthumbautostart$','buttons':'$magicthumbbuttons$','textBtnClose':'$magicthumbtextBtnClose$','textBtnNext':'$magicthumbtextBtnNext$','textBtnPrev':'$magicthumbtextBtnPrev$','hint':'$magicthumbhint$','textClickHint':'$magicthumbtextClickHint$','textHoverHint':'$magicthumbtextHoverHint$'&quot;</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:when>
        <xsl:otherwise>
            <xsl:choose>
                <xsl:when test="'magicthumb' = 'magicthumb'">
                    <xsl:text> rel=&quot;thumb-id:MagicThumb$magicthumbelementid$$magicthumbmainimageid$&quot;</xsl:text>
                </xsl:when>
                <xsl:when test="'magicthumb' = 'magiczoom' or 'magicthumb' = 'magiczoomplus'">
                    <xsl:text> data-zoom-id=&quot;MagicThumb$magicthumbelementid$$magicthumbmainimageid$&quot;</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text> rel=&quot;MagicThumb$magicthumbelementid$$magicthumbmainimageid$&quot;</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:text> rev=&quot;</xsl:text><xsl:value-of select="$medium"/><xsl:text>&quot;</xsl:text>
        </xsl:otherwise>
    </xsl:choose>
    <xsl:text> href=&quot;</xsl:text><xsl:value-of select="$img"/><xsl:text>&quot;</xsl:text>
    <xsl:text>&gt;</xsl:text>
    <xsl:text>&lt;img</xsl:text>
    <xsl:choose>
        <xsl:when test="$isMainImage = 'true'">
            <xsl:text> src=&quot;</xsl:text><xsl:value-of select="$medium"/><xsl:text>&quot;</xsl:text>
            <xsl:text> itemprop=&quot;image&quot;</xsl:text>
        </xsl:when>
        <xsl:otherwise>
            <xsl:text> src=&quot;</xsl:text><xsl:value-of select="$thumb"/><xsl:text>&quot;</xsl:text>
        </xsl:otherwise>
    </xsl:choose>
    <xsl:text>&#047;&gt;</xsl:text>
    <xsl:text>&lt;span&gt;</xsl:text><xsl:value-of select="$title"/><xsl:text>&lt;&#047;span&gt;</xsl:text>
    <xsl:text>&lt;&#047;a&gt;</xsl:text>
    <xsl:if test="'$magicthumbshow_message$' = 'true'">
        <xsl:text>&lt;br &#047;&gt;</xsl:text>
        <xsl:text>$magicthumbmessage$</xsl:text>
    </xsl:if>
</xsl:template>
</xsl:stylesheet>
