<?php

function magictoolbox_WordPress_MagicZoomPlus_get_path_to_magicscroll() {
    $result = null;

    if (magictoolbox_WordPress_MagicZoomPlus_is_magicscroll_active()) {
        $result = plugin_dir_url(plugin_dir_path('')).'mod_wordpress_magicscroll/magicscroll/core/';
    }

    return $result;
}

function magictoolbox_WordPress_MagicZoomPlus_set_global_variable($isWithScroll=false) {
    global $magictoolbox_MagicZoomPlus_page_has_shortcode;
    $magictoolbox_MagicZoomPlus_page_has_shortcode = true;
    if ($isWithScroll) {
        global $magictoolbox_page_has_gallery;
        $magictoolbox_page_has_gallery = true;
    }
}


function magictoolbox_WordPress_MagicZoomPlus_get_wordpress_image_sizes( $unset_disabled = true ) {
    $wais = & $GLOBALS['_wp_additional_image_sizes'];

    $sizes = array();

    foreach ( get_intermediate_image_sizes() as $_size ) {
        if ( in_array( $_size, array('thumbnail', 'medium', 'medium_large', 'large') ) ) {
            $sizes[ $_size ] = array(
                'width'  => get_option( "{$_size}_size_w" ),
                'height' => get_option( "{$_size}_size_h" ),
                'crop'   => (bool) get_option( "{$_size}_crop" ),
            );
        }
        elseif ( isset( $wais[$_size] ) ) {
            $sizes[ $_size ] = array(
                'width'  => $wais[ $_size ]['width'],
                'height' => $wais[ $_size ]['height'],
                'crop'   => $wais[ $_size ]['crop'],
            );
        }

        // size registered, but has 0 width and height
        if( $unset_disabled && ($sizes[ $_size ]['width'] == 0) && ($sizes[ $_size ]['height'] == 0) )
            unset( $sizes[ $_size ] );
    }

    return $sizes;
}

function magictoolbox_WordPress_MagicZoomPlus_get_option($arr) {
    return empty($arr['value']) ? $arr['default'] : $arr['value'];
}

// "key: value; key: value; ..."
function magictoolbox_WordPress_MagicZoomPlus_parse_option_from_string($options) {
    $opt = array();

    $options = explode(";", $options);
    array_pop($options);

    foreach ($options as $value) {
        $value = trim($value);
        if (!empty($value)) {
            $value = explode(":", $value);
            // $opt[$value[0]] = trim($value[1]);
            $k = array_shift($value);
            $v = join(":",$value);
            $opt[$k] = trim($v);
        }
    }
    return $opt;
}

function magictoolbox_WordPress_MagicZoomPlus_correct_options_value($options) {
    $opt = array();
    foreach ($options as $key => $value) {
        if ('Yes' === $value) {
            $value = 'true';
        } else if ('No' === $value) {
            $value = 'false';
        }

        $opt[$key] = $value;
    }
    return $opt;
}

function magictoolbox_WordPress_MagicZoomPlus_options_to_string($options) {
    $str = '';
    foreach ($options as $key => $value) {
        if ('background' === $key) { continue; }
        if ('Yes' == $value || 'yes' == $value) {
            $value = true;
        } else if ('No' == $value || 'no' == $value) {
            $value = false;
        }
        $str .= ($key.': '.$value.'; ');
    }
    return $str;
}

function magictoolbox_WordPress_MagicZoomPlus_convert_size($size, $width, $height) {
    if ('custom' == $size) {
        return array($width, $height);
    } else {
        return $size;
    }
}

function magictoolbox_WordPress_MagicZoomPlus_get_size($id, $mediumSize, $thumbSize) {
    $sizes = array();
    if ($mediumSize) { $sizes['medium'] = $mediumSize; }
    if ($thumbSize) { $sizes['thumbnail'] = $thumbSize; }
    return array('id' => (int)$id, 'sizes' => $sizes);
}

function magictoolbox_WordPress_MagicZoomPlus_get_sizes($ids, $mediumSize, $thumbSize) {
    $arr = array();
    foreach ($ids as $value) {
        $arr[] = magictoolbox_WordPress_MagicZoomPlus_get_size($value, $mediumSize, $thumbSize);
    }
    return $arr;
}

function magictoolbox_WordPress_MagicZoomPlus_get_style_html($nameOfStyle, $value, $ids) {
    $result = null;

    if($value || is_string($value) && '' != trim($value)) {
        $result = '';
        $count = count($ids);
        $result .= '<style type=\'text/css\'> ';
        $tmp1 = '';
        $tmp2 = '';
        for ($i = 0; $i < $count; $i++) {
            $result .= ('.mz-expand.mz-bg-color-' . $ids[$i] . ' .mz-expand-bg { display: none !important; } ');
            $result .= ('.mz-expand.mz-bg-color-' . $ids[$i] . ' { ' . $nameOfStyle . ': ' . $value . ' !important; }');
        }
        $result .= '</style>';
    }
    return $result;
}

function magictoolbox_WordPress_MagicZoomPlus_set_extra_class($options, $id) {
    $extraClass = 'mz-bg-color-'.$id;

    if(isset($options['cssClass'])) {
        $options['cssClass'] .= (' '.$extraClass);
    } else {
        $options['cssClass'] = $extraClass;
    }

    return $options;
}

function magictoolbox_WordPress_MagicZoomPlus_is_video( $thumbnail ) {
    return preg_match('/vimeo|youtube/i', $thumbnail);
}

function magictoolbox_WordPress_MagicZoomPlus_run_activate_plugin($plugin) {
    if (!function_exists('activate_plugin')) {
        require_once ABSPATH . 'wp-admin/includes/plugin.php';
    }

    if(!is_plugin_active($plugin)) {
        activate_plugin($plugin);
    }

    return null;
}

function magictoolbox_WordPress_MagicZoomPlus_is_magicscroll_exist() {
    require_once ABSPATH . 'wp-admin/includes/plugin.php';
    return in_array('mod_wordpress_magicscroll/mod_wordpress_magicscroll.php', array_keys(get_plugins()));
}

function magictoolbox_WordPress_MagicZoomPlus_is_magicscroll_active() {
    $result = false;

    require_once ABSPATH . 'wp-admin/includes/plugin.php';

    if (is_plugin_active('mod_wordpress_magicscroll/mod_wordpress_magicscroll.php')) {
        $result = true;
    }

    return $result;
}


function magictoolbox_WordPress_MagicZoomPlus_get_thumbnail($id, $thumbnails) {
    $result = null;

    foreach ($thumbnails as $value) {
        if ($value['id'].'' === $id) {
            $result = $value;
            break;
        }
    }

    return $result;
}

function magictoolbox_WordPress_MagicZoomPlus_get_clear_thumbnails($thumbnails) {
    $result = array();

    foreach ($thumbnails as $value) {
        if (!magictoolbox_WordPress_MagicZoomPlus_is_video($value)) {
            $result[] = $value;
        }
    }

    return $result;
}

function magictoolbox_WordPress_MagicZoomPlus_create_video( $thumbnail, $id ) {
    return '<iframe id="'.$id.'" src="'.$thumbnail.'" frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>';
}

function magictoolbox_WordPress_MagicZoomPlus_check_video( $thumbnails ) {
    $result = false;

    if (is_array($thumbnails) && count($thumbnails)) {
        for ($i = 0; $i < count($thumbnails); $i++) {
            if (magictoolbox_WordPress_MagicZoomPlus_is_video($thumbnails[$i])) {
                $result = true;
                break;
            }
        }
    }

    return $result;
}

function magictoolbox_WordPress_MagicZoomPlus_shortcode( $attrs ) {
    $additional_id = '';
    if (isset($attrs['additional_id'])) {
        $additional_id = $attrs['additional_id'];
    }

    if (is_numeric($attrs['id'])) {
        $m_tool = magictoolbox_WordPress_MagicZoomPlus_get_data("id", $attrs['id']);
    } else {
        $m_tool = magictoolbox_WordPress_MagicZoomPlus_get_data("shortcode", '"'.$attrs['id'].'"');
    }

    if (!$m_tool || 0 == count($m_tool)) { return ''; }
    require_once(dirname(__DIR__).wp_normalize_path('/core/magictoolbox.templatehelper.class.php'));
    MagicToolboxTemplateHelperClass::setPath(dirname(__DIR__) . wp_normalize_path('/core/templates'));

    require_once(dirname(__DIR__).wp_normalize_path('/constructor_magiczoomplus/magictoolbox.videohelper.class.php'));

    $html = '';
    $defImg = '';
    $thumbImg = array();
    $tool_image = (int)$m_tool[0]->image;
    $tool_thumbnails = array();

    $allOptions = $m_tool[0]->options;
    $allOptions = explode('|', $allOptions);
    $tool_options = magictoolbox_WordPress_MagicZoomPlus_parse_option_from_string($allOptions[0]);
    $tool_options = magictoolbox_WordPress_MagicZoomPlus_correct_options_value($tool_options);
    $tool_mobile_options = magictoolbox_WordPress_MagicZoomPlus_parse_option_from_string($m_tool[0]->mobile_options);
    $tool_mobile_options = magictoolbox_WordPress_MagicZoomPlus_correct_options_value($tool_mobile_options);
    $tool_additional_options = magictoolbox_WordPress_MagicZoomPlus_parse_option_from_string($m_tool[0]->additional_options);
    $gallery_mode =  isset($tool_additional_options['gallery_mode']) && $tool_additional_options['gallery_mode'] == 'true';
    $ids = array();
    $lastVideoId = 0;
    $videoIds = array();
    if ($m_tool[0]->thumbnails) {
        $tool_thumbnails = explode(",", $m_tool[0]->thumbnails);
    }

    $isUseGallery = false;
    $tool_scroll_options = '';
    if (magictoolbox_WordPress_MagicZoomPlus_is_magicscroll_active()) {
        $tool_scroll_options = $allOptions[1];
    }

    $isGalleryWithVideo = magictoolbox_WordPress_MagicZoomPlus_check_video($tool_thumbnails);

    $tool_options = magictoolbox_WordPress_MagicZoomPlus_set_extra_class($tool_options, 'MagicZoomPlus-shortcode-'.$attrs['id'].$additional_id);
    if (!$gallery_mode) {
        $ids[] = 'MagicZoomPlus-shortcode-'.$attrs['id'].$additional_id;

        if ($isGalleryWithVideo) {
            $defImg .= '<div>';
        }

        $defImg .= ('<a class="MagicZoom" id="MagicZoomPlus-shortcode-'.$attrs['id'].$additional_id.'" title="'.get_the_title($tool_image).'" href="'.wp_get_attachment_url($tool_image).'" data-shortcode');
        if ('custom' === $tool_additional_options['settings'] || $isGalleryWithVideo) {
            if (count($tool_options)) {
                $defImg .= (' data-options="'.magictoolbox_WordPress_MagicZoomPlus_options_to_string($tool_options).'" ');
            }

            if (count($tool_mobile_options)) {
                $defImg .= ('data-mobile-options="'.magictoolbox_WordPress_MagicZoomPlus_options_to_string($tool_mobile_options).'" ');
            }
        }
        $defImg .= '>';

        $tool_image = magictoolbox_WordPress_MagicZoomPlus_get_img_url_with_size(
            magictoolbox_WordPress_MagicZoomPlus_get_sizes(
                array($tool_image),
                magictoolbox_WordPress_MagicZoomPlus_convert_size($tool_additional_options['image_size'], $tool_additional_options['image_width'], $tool_additional_options['image_height']),
                magictoolbox_WordPress_MagicZoomPlus_convert_size($tool_additional_options['thumbnail_size'], $tool_additional_options['thumbnail_width'], $tool_additional_options['thumbnail_height'])
            )
        );
        $tool_image = $tool_image[0];

        $defImg .= ('<img src="'.$tool_image['medium'].'" alt="'.get_post_meta($tool_image['id'], '_wp_attachment_image_alt', true).'"/>');
        $defImg .= '</a>';

        if ($isGalleryWithVideo) {
            $defImg .= '</div>';
            foreach ($tool_thumbnails as $value) {
                if (magictoolbox_WordPress_MagicZoomPlus_is_video($value)) {
                    $defImg .= '<div>';
                    $lastVideoId += 1;
                    $vId = 'magictoolbox-gallery-video-'.$lastVideoId;
                    $videoIdsх[$value] = $vId;
                    $defImg .= magictoolbox_WordPress_MagicZoomPlus_create_video($value, $vId);
                    $defImg .= '</div>';
                }
            }
        }
    }

    if (is_array($tool_thumbnails) && count($tool_thumbnails)) {
        $clear_tool_thumbnails = magictoolbox_WordPress_MagicZoomPlus_get_clear_thumbnails($tool_thumbnails);

        $clear_tool_thumbnails = magictoolbox_WordPress_MagicZoomPlus_get_img_url_with_size(
            magictoolbox_WordPress_MagicZoomPlus_get_sizes(
                $clear_tool_thumbnails,
                magictoolbox_WordPress_MagicZoomPlus_convert_size($tool_additional_options['image_size'], $tool_additional_options['image_width'], $tool_additional_options['image_height']),
                magictoolbox_WordPress_MagicZoomPlus_convert_size($tool_additional_options['thumbnail_size'], $tool_additional_options['thumbnail_width'], $tool_additional_options['thumbnail_height'])
            )
        );

        // $tool_thumbnails = magictoolbox_WordPress_MagicZoomPlus_get_img_url_with_size(
        //     magictoolbox_WordPress_MagicZoomPlus_get_sizes(
        //         $tool_thumbnails,
        //         magictoolbox_WordPress_MagicZoomPlus_convert_size($tool_additional_options['image_size'], $tool_additional_options['image_width'], $tool_additional_options['image_height']),
        //         magictoolbox_WordPress_MagicZoomPlus_convert_size($tool_additional_options['thumbnail_size'], $tool_additional_options['thumbnail_width'], $tool_additional_options['thumbnail_height'])
        //     )
        // );

        $cOpt = '';
        $cMOpt = '';
        $index = 0;

        if ('custom' === $tool_additional_options['settings']) {
            if (count($tool_options)) {
                $cOpt = magictoolbox_WordPress_MagicZoomPlus_options_to_string($tool_options);
            }

            if (count($tool_mobile_options)) {
                $cMOpt = magictoolbox_WordPress_MagicZoomPlus_options_to_string($tool_mobile_options);
            }
        }

        if ($tool_additional_options['thumbnail_size'] === 'custom') {
            $maxVideoWidth = $tool_additional_options['thumbnail_width'];
            $maxVideoHeight = $tool_additional_options['thumbnail_height'];
        } else {
            $tmp = magictoolbox_WordPress_MagicZoomPlus_get_wordpress_image_sizes();
            $tmp = $tmp[$tool_additional_options['thumbnail_size']];
            $maxVideoWidth = $tmp['width'];
            $maxVideoHeight = $tmp['height'];
        }

        foreach ($tool_thumbnails as $value) {
            $thumb = magictoolbox_WordPress_MagicZoomPlus_get_thumbnail($value, $clear_tool_thumbnails);
            if ($gallery_mode) {
                if (!$thumb) { continue; }
                $tmp = '';
                $tmp .= '<a class="MagicZoom" ';
                $tmp .= ('id="MagicZoomPlus-shortcode-'.$attrs['id'].$additional_id.'-'.$index.'" ');
                $tmp .= ('data-gallery="MagicZoomPlus-shortcode-'.$attrs['id'].$additional_id.'"');
                if (!$thumb) {
                    $tmp .= ('href="'.$value.'"');
                    if ($maxVideoWidth || $maxVideoHeight) {
                        $tmp .= ' style="';
                        if ($maxVideoWidth) { $tmp .= 'max-width:'.$maxVideoWidth.'px;'; }
                        if ($maxVideoHeight) { $tmp .= 'max-height:'.$maxVideoHeight.'px;'; }
                        $tmp .= '"';
                    }
                } else {
                    $tmp .= ('title="'.get_the_title($thumb['id']).'" ');
                    $tmp .= ('href="'.wp_get_attachment_url($thumb['id']).'"');
                }
                if ('custom' === $tool_additional_options['settings']) {
                    if (count($tool_options)) {
                        $tmp .= (' data-options="'.$cOpt.'"');
                    }

                    if (count($tool_mobile_options)) {
                        $tmp .= (' data-mobile-options="'.$cMOpt.'"');
                    }
                }
                $tmp .= ' data-shortcode >';

                if ($thumb) {
                    $tmp .= ('<img src="'.$thumb['thumbnail'].'" alt="'.get_post_meta($thumb['id'], '_wp_attachment_image_alt', true).'"/>');
                }

                $tmp .= '</a>';
                $thumbImg[] = $tmp;
                $index++;
            } else {
                $tmp = '';
                if (!$thumb) {
                    $thumb = $value;
                    $src = MagicToolboxVideoHelperClass::getImages($thumb);
                    $tmp .= ('<a data-video-id="'.$videoIdsх[$thumb].'" href="" class="shortcode-video-selector" ');

                    if (!$src) {
                        $tmp .= 'data-max-width="'.$maxVideoWidth.'" ';
                        $tmp .= 'data-max-height="'.$maxVideoHeight.'" ';
                    }

                    $tmp .= '>';

                    if ($src) {
                        if ($maxVideoWidth > $src['thumbnail']['width']) {
                            $src = $src['medium']['url'];
                        } else {
                            $src = $src['thumbnail']['url'];
                        }
                        $tmp .= '<img src="'.$src.'" style="max-width:'.$maxVideoWidth.'px;max-height:'.$maxVideoHeight.'px;"/>';
                    }

                } else {
                    $tmp .= ('<a ');
                    $tmp .= ('data-zoom-id="MagicZoomPlus-shortcode-'.$attrs['id'].$additional_id.'" ');
                    $tmp .= ('data-slide-id="zoom"');
                    $tmp .= ('title="'.get_the_title($thumb['id']).'" ');
                    $tmp .= ('href="'.wp_get_attachment_url($thumb['id']).'" ');
                    $tmp .= ('data-image="'.$thumb['medium'].'" ');
                    $tmp .= 'data-shortcode >';
                    $tmp .= ('<img src="'.$thumb['thumbnail'].'" alt="'.get_post_meta($thumb['id'], '_wp_attachment_image_alt', true).'"/>');
                }
                $tmp .= '</a>';
                $thumbImg[] = $tmp;
            }
        }
    }

    $params = $GLOBALS['magictoolbox']['WordPressMagicZoomPlus'];

    if ('left' == $tool_additional_options['thumbnails_position'] || 'right' == $tool_additional_options['thumbnails_position'] && !$gallery_mode) {
        if ('custom' == $tool_additional_options['thumbnail_size']) {
            $params->params->setValue('selector-max-width', $tool_additional_options['thumbnail_width']);
        } else {
            $tmp = magictoolbox_WordPress_MagicZoomPlus_get_wordpress_image_sizes();
            $params->params->setValue('selector-max-width', $tmp[$tool_additional_options['thumbnail_size']]['width']);
        }
    }

    if ($isGalleryWithVideo) { $isUseGallery = true; }

    if (magictoolbox_WordPress_MagicZoomPlus_is_magicscroll_active() && isset($tool_additional_options['thumbnail_mode']) && $tool_additional_options['thumbnail_mode'] == 'scroll' && !$gallery_mode) {
        $isUseGallery = true;
        $params->params->setValue('magicscroll', 'Yes');
    } else {
        $params->params->setValue('magicscroll', 'No');
    }

    magictoolbox_WordPress_MagicZoomPlus_set_global_variable($isUseGallery);

    MagicToolboxTemplateHelperClass::setOptions($params->params);

    $styleValue = null;
    if (array_key_exists('background', $tool_options)) {
        $styleValue = $tool_options['background'];
    }
    $ids = array('MagicZoomPlus-shortcode-'.$attrs['id'].$additional_id);
    $style = magictoolbox_WordPress_MagicZoomPlus_get_style_html('background-color', $styleValue, $ids);
    if($style) {
        if ($gallery_mode) {
            if (count($thumbImg)) {
                $thumbImg[0] = $style.$thumbImg[0];
            }
        } else {
            $defImg = $style.$defImg;
        }
    }
    if (isset($thumbImg) && is_array($thumbImg)) {
        if (count($thumbImg) == 1) $thumbImg[] = '';
    } else {
        $thumbImg = array();
    }

    $html = MagicToolboxTemplateHelperClass::render($tool_additional_options['thumbnails_position'], array(
        'main' => $defImg,
        'thumbs' => $thumbImg,
        'magicscrollOptions' => $tool_scroll_options,
        'pid' => "-MagicZoomPlus-".$attrs['id'].$additional_id
    ));

    if ($isGalleryWithVideo && !$gallery_mode) {
        $html = str_replace('MagicToolboxContainer', 'MagicToolboxContainer MagicToolboxGallery', $html);
    }
    return $html;
}


function magictoolbox_WordPress_MagicZoomPlus_get_tiny_mce_data() {
    if(!(is_array($_POST) && defined('DOING_AJAX') && DOING_AJAX)){
        return;
    }

    $nonce = $_POST['nonce'];
    $result = '{"error": "error"}';

    if ( !wp_verify_nonce( $nonce, 'magic-everywhere' ) ) {
        $result = '{"error": "verification failed"}';
    } else {
        $table_data = magictoolbox_WordPress_MagicZoomPlus_get_data();
        if ($table_data && count($table_data) > 0) {
            $result = '[';
            foreach($table_data as $value) {
                $sc = $value->shortcode;
                if (empty($sc)) {
                    $sc = "null";
                }
                $result .= '{';
                $result .= '"id":"'.$value->id.'",';
                $result .= '"name":"'.$value->name.'",';
                $result .= '"shortcode":"'.$sc.'"';
                $result .= '},';
            }
            $result = preg_replace('/,$/is', '', $result);
            $result .= ']';
        } else {
            $result = '{"error": "empty"}';
        }
    }
    echo $result;
    wp_die();
}

function magictoolbox_WordPress_MagicZoomPlus_add_my_tc_button() {
    global $typenow;
    // check user permissions
    if ( !current_user_can('edit_posts') && !current_user_can('edit_pages') ) {
        return;
    }

    // verify the post type
    if( ! in_array( $typenow, array( 'post', 'page', 'product' , 'wpsc-product', 'tcp_product' ) ) ) {
        return;
    }

    // check if WYSIWYG is enabled
    if ( get_user_option('rich_editing') == 'true') {
        add_filter("mce_external_plugins", "magictoolbox_WordPress_MagicZoomPlus_add_tinymce_plugin");
        add_filter('mce_buttons', 'magictoolbox_WordPress_MagicZoomPlus_register_tinymce_button');
        echo '<script>'.
            'var magictoolbox_WordPress_MagicZoomPlus_admin_modal_object = {'.
                'ajax: "'.(get_site_url() . wp_normalize_path('/wp-admin/admin-ajax.php')).'",'.
                'nonce: "'.wp_create_nonce('magic-everywhere'). '"'.
            '};'.
        '</script>';
    }
}

function magictoolbox_WordPress_MagicZoomPlus_add_tinymce_plugin($plugin_array) {
    $plugin_array["magictoolbox_WordPress_MagicZoomPlus_shortcode"] = plugins_url( 'js/magiczoomplus_tiny_mce_button.js', __FILE__ );
    return $plugin_array;
}

function magictoolbox_WordPress_MagicZoomPlus_register_tinymce_button($buttons) {
   array_push($buttons, "magictoolbox_WordPress_MagicZoomPlus_shortcode");
   return $buttons;
}

function magictoolbox_WordPress_MagicZoomPlus_button_css() {
    $screen = get_current_screen();

    if ( $screen->id == 'page' || $screen->id == 'post' || $screen->id == 'product' || $screen->id == 'wpsc-product' || $screen->id == 'tcp_product') {
        wp_register_style('magictoolbox_WordPress_MagicZoomPlus_tinymce_button_css', plugin_dir_url( __FILE__ ).wp_normalize_path('css/magiczoomplus_tiny_mce_button.css'), array());
        wp_enqueue_style('magictoolbox_WordPress_MagicZoomPlus_tinymce_button_css');
    }
}

function magictoolbox_ajax_WordPress_MagicZoomPlus_copy() {
    if(!(is_array($_POST) && defined('DOING_AJAX') && DOING_AJAX)){
        return;
    }

    $nonce = $_POST['nonce'];
    $id = (int)$_POST['id'];
    $result = "null";
    $tableId = "null";

    if ( !wp_verify_nonce( $nonce, 'magic-everywhere' ) ) {
        $result = "\"verification_failed\"";
    } else {
        $res = magictoolbox_WordPress_MagicZoomPlus_get_data("id", $id);
        if (!$res) {
            $result = "\"error\"";
        } else {
            $tableId = magictoolbox_WordPress_MagicZoomPlus_add_data_to_table($res[0]->name.' (copy)', '', $res[0]->image, $res[0]->thumbnails, $res[0]->options, $res[0]->mobile_options, $res[0]->additional_options);
        }
    }
    ob_end_clean();
    echo "{\"error\":".$result.",\"id\":".$tableId."}";
    wp_die();
}

function magictoolbox_WordPress_MagicZoomPlus_get_img_url_with_size($images) {
    //require_once(preg_replace('/\/constructor_MagicZoomPlus/is', '', dirname(__FILE__)) . '/core/magictoolbox.imagehelper.class.php');
    //require_once(preg_replace('/\\'.DIRECTORY_SEPARATOR.'constructor_MagicZoomPlus/is', '', dirname(__FILE__)) . DIRECTORY_SEPARATOR.'core'.DIRECTORY_SEPARATOR.'magictoolbox.imagehelper.class.php'); 

    require_once(dirname(__FILE__) . '/../core/magictoolbox.imagehelper.class.php');

    
    $result = array();

    $url = site_url();
    $shop_dir = ABSPATH;
    $image_dir = 'wp-content/uploads/';

    // $imagehelper = new MagicToolboxImageHelperClass($shop_dir, $image_dir.'magictoolbox_cache', new MagicToolboxParamsClass(), null, $url);
    $imagehelper = new MagicToolboxImageHelperClass($shop_dir, $image_dir.'magictoolbox_cache', $GLOBALS['magictoolbox']['WordPressMagicZoomPlus']->params, null, $url);

    foreach ($images as $value) {
        $img = array('id' => $value['id']);
        foreach ($value['sizes'] as $key => $size) {
            if (is_array($size)) {
                $url = wp_get_attachment_metadata($value['id']);
                $url = '/'.$image_dir.$url['file'];
                $tmp = $imagehelper->create($url, $size);
                //$tmp2x = $imagehelper->create($url, array($size[0]*2,$size[1]*2));
                $tmp2x = $imagehelper->create($url, array((int)$size[0]*2,(int)$size[1]*2));
            } else {
                $tmp = wp_get_attachment_image_src($value['id'], $size);
                $tmp = $tmp[0];
            }
            $img[$key] = $tmp;
            if (!empty($tmp2x)) {
                $img[$key.'2x'] = $tmp2x;
            }

        }

        $result[] = $img;
    }

    return $result;
}

function magictoolbox_ajax_WordPress_MagicZoomPlus_get_img_urls() {
    if(!(is_array($_POST) && defined('DOING_AJAX') && DOING_AJAX)){
        return;
    }

    $result = "null";
    $nonce = $_POST['nonce'];
    $ids = $_POST['ids'];
    $urls = array();

    if ( !wp_verify_nonce( $nonce, 'magic-everywhere' ) ) {
        $result = "\"verification_failed\"";
    } else {
        $urls = magictoolbox_WordPress_MagicZoomPlus_get_img_url_with_size($ids);
    }

    $urls = json_encode($urls);

    ob_end_clean();
    echo "{\"error\":".$result.",\"urls\":".$urls."}";
    wp_die();
}

function magictoolbox_ajax_WordPress_MagicZoomPlus_remove_tools() {
    if(!(is_array($_POST) && defined('DOING_AJAX') && DOING_AJAX)){
        return;
    }

    $nonce = $_POST['nonce'];
    $ids = $_POST['ids'];
    $result = 'null';

    if ( !wp_verify_nonce( $nonce, 'magic-everywhere' ) ) {
        $result = "\"verification_failed\"";
    } else {
        foreach ($ids as $value) {
            magictoolbox_WordPress_MagicZoomPlus_remove_element($value);
        }
    }

    ob_end_clean();
    echo "{\"error\":".$result."}";
    wp_die();
}

function magictoolbox_ajax_WordPress_MagicZoomPlus_check_shortcode() {
    if(!(is_array($_POST) && defined('DOING_AJAX') && DOING_AJAX)) { return; }

    $result = "null";
    $nonce = $_POST['nonce'];
    $shortcode = $_POST['shortcode'];

    $id = $_POST['id'];
    if ('null' != $id) {
        $id = (int)$id;
    }

    if ( !wp_verify_nonce( $nonce, 'magic-everywhere' ) ) {
        $result = "\"verification_failed\"";
    } else {
        $data = magictoolbox_WordPress_MagicZoomPlus_get_data();

        foreach ($data as $spin) {
            if ('null' == $id || $id != $spin->id) {
                if ($spin->shortcode == $shortcode) {
                    $result = "\"not_unique\"";
                    break;
                }
            }
        }
    }

    ob_end_clean();
    echo "{\"error\":".$result."}";
    wp_die();
}

function magictoolbox_ajax_WordPress_MagicZoomPlus_save() {
    global $wpdb;

    if(!(is_array($_POST) && defined('DOING_AJAX') && DOING_AJAX)) { return; }

    $result = "null";
    $tableId = "null";
    $nonce = $_POST['nonce'];
    $id = (int)$_POST['id'];
    $name = $_POST['name'];
    $shortcode = $_POST['shortcode'];
    $image = $_POST['image'];
    $thumbnails = $_POST['thumbnails'];
    $options = $_POST['options'];
    $mobile_options = $_POST['mobile_options'];
    $additional_options = $_POST['additional_options'];

    if ( !wp_verify_nonce( $nonce, 'magic-everywhere' ) ) {
        $result = "\"verification_failed\"";
    } else {
        $oldData = magictoolbox_WordPress_MagicZoomPlus_get_data("id", $id);

        if (!count($oldData)) {
            $tableId = magictoolbox_WordPress_MagicZoomPlus_add_data_to_table($name, $shortcode, $image, $thumbnails, $options, $mobile_options, $additional_options);
            if (false == $tableId) {
                $result = "\"db_insert_failed\"";
                $tableId = "null";
            }
        } else {
            $table_name = $wpdb->prefix . 'magiczoomplus_store';

            $res = $wpdb->update($table_name, array(
                    'name' => $name,
                    'shortcode' => $shortcode,
                    'image' => $image,
                    'thumbnails' => $thumbnails,
                    'options' => $options,
                    'mobile_options' => $mobile_options,
                    'additional_options' => $additional_options
                ),
                array('id' => $id),
                array( '%s', '%s', '%s', '%s', '%s', '%s', '%s' ),
                array( '%d' )
            );

            if (false == $res) {
                $result = "\"db_update_failed\"";
            }
        }
    }

    ob_end_clean();
    echo "{\"error\":".$result.",\"id\":".$tableId."}";
    wp_die();
}

function magictoolbox_ajax_WordPress_MagicZoomPlus_activate_magicscroll() {
    $nonce = $_POST['nonce'];

    $result = 'null';

    if ( !wp_verify_nonce( $nonce, 'magic-everywhere' ) ) {
        $result = "\"verification_failed\"";
    } else {
        magictoolbox_WordPress_MagicZoomPlus_run_activate_plugin('mod_wordpress_magicscroll/mod_wordpress_magicscroll.php');
    }

    ob_end_clean();
    echo "{\"error\":".$result."}";
    wp_die();
}

?>
