<?php
    $pageURL = get_admin_url(null, 'admin.php?page=WordPressMagicThumb-shortcodes-page');

    $magic = magictoolbox_WordPress_MagicThumb_get_data();
    $shortcode_img_url = preg_replace('/\/magicthumb\/constructor_magicthumb\/view\//is', '/magicthumb/', plugin_dir_url( __FILE__ ));
    $shortcode_img_url .= 'core/admin_graphics/icon.svg';
?>
<div class="list-container">
    <div class="loader"><div class="magictoolbox-loader"></div></div>
    <h1>Magic Thumb shortcodes</h1>
    <p>
        Create Magic Thumb below, to insert with the <img src="<?php echo $shortcode_img_url; ?>" alt="Magic Thumb" style="vertical-align: middle;"/> shortcut into any page or post.
    </p>
    <p style="margin-right:20px; float:right; font-size:15px; white-space: nowrap;">
        &nbsp;<a href="<?php echo WordPressMagicThumb_url('http://www.magictoolbox.com/magicthumb/modules/wordpress/',' configuration page resources settings link'); ?>" target="_blank">Documentation<span class="dashicons dashicons-share-alt2" style="text-decoration: none;line-height:1.3;margin-left:5px;"></span></a>&nbsp;|
        &nbsp;<a href="<?php echo WordPressMagicThumb_url('http://www.magictoolbox.com/magicthumb/examples/',' configuration page resources examples link'); ?>" target="_blank">Examples<span class="dashicons dashicons-share-alt2" style="text-decoration: none;line-height:1.3;margin-left:5px;"></span></a>&nbsp;|
        &nbsp;<a href="<?php echo WordPressMagicThumb_url('http://www.magictoolbox.com/contact/','configuration page resources support link'); ?>" target="_blank">Support<span class="dashicons dashicons-share-alt2" style="text-decoration: none;line-height:1.3;margin-left:5px;"></span></a>&nbsp;
    |&nbsp;<a href="<?php echo WordPressMagicThumb_url('http://www.magictoolbox.com/buy/magicthumb/','configuration page resources buy link'); ?>" target="_blank">Buy<span class="dashicons dashicons-share-alt2" style="text-decoration: none;line-height:1.3;margin-left:5px;"></span></a>
    </p><br/>
    <?php
        if (count($magic)) {
    ?>
    <button style="margin-right: 5px; margin-bottom: 5px; <?php if (!count($magic)) { echo 'display: none;'; } ?>" class="button delete-selected">Delete selected</button>
    <?php
        }
    ?>
    <a style="margin-right: 5px; margin-bottom: 5px;" class="button button-primary new-tool" href="<?php echo $pageURL;?>&id=new">Add shortcode</a>
    <input type="text" name="search" id="search" placeholder="Search by Name or Id" />
    <table class="shortcodes-list" cellspacing="0" cellpadding="0">
        <thead>
            <tr <?php if (!count($magic)) { echo 'style="display: none;"'; } ?>>
                <td class="t-cb"><input type="checkbox"></td>
                <td class="t-id">ID</td>
                <td class="t-pv" style="width:auto;">Preview</td>
                <td class="t-name" style="width:50%">Name</td>
                <td class="t-sc" style="width:50%">Shortcode</td>
            </tr>
        </thead>
        <tbody>
            <?php
                if (count($magic)) {
                    foreach($magic as $val) {
                        if (strrpos($val->additional_options, 'gallery_mode:true;') > 0) {
                            $image = $val->thumbnails;
                            $image = explode(",", $image);
                            $image = $image[0];
                        } else {
                            $image = $val->image;
                        }
                        $url = wp_get_attachment_url( $image );
                        $toolId = $val->id;
            ?>
                <tr class="sc-row" id="<?php echo $toolId; ?>" data-name="<?php echo $val->name; ?>">
                    <td class="t-cb"><input type="checkbox"></td>
                    <td class="t-id"><?php echo $toolId; ?></td>
                    <td class="t-pv"><img src="<?php echo $url; ?>" /></td>
                    <td class="t-name">
                        <a href="<?php echo $pageURL;?>&id=<?php echo $toolId; ?>"><?php echo $val->name; ?></a></br>
                        <a href="<?php echo $pageURL;?>&id=<?php echo $toolId; ?>">Edit</a> |
                        <a href="#" class="copy-tool" title="Copy shortcode">Duplicate shortcode</button>
                    </td>
                    <?php
                        $sc = $val->shortcode;
                        if (empty($sc)) {
                            $sc = $val->id;
                        }
                    ?>
                    <td class="t-sc">[magicthumb id="<?php echo $sc; ?>"]</td>
                </tr>
            <?php
                    }
                }
            ?>
        </tbody>
    </table>
    <div id="down-buttons">
        <button style="margin-right: 5px; margin-top: 5px; <?php if (0 == count($magic)) { echo 'display: none;'; } ?>" class="button delete-selected">Delete selected</button>
        <a style="margin-right: 5px; margin-top: 5px; <?php if (0 == count($magic)) { echo 'display: none;'; } ?>" class="button button-primary new-tool" href="<?php echo $pageURL;?>&id=new">Add shortcode</a>
    </div>
</div>
