(function ($) {
    'use strict';

    if (!$) {
        throw new Error('jQuery is not found!');
    }

    function tabs () {
        $("#tabs").tabs({
            activate: function(event, ui) {
                $('.nav-tab').removeClass('nav-tab-active');
                $(ui.newTab).children().addClass('nav-tab-active');
            }
        });
    }

    function scrollableButton () {
        var headingTop = $('#set-main-settings').position().top - $(window).height() + 120;

        if(!$('#set-main-settings').hasClass('fixed')) {
            $('#set-main-settings').addClass('fixed');
        }

        $(window).scroll(function() {
            if(headingTop <= $(window).scrollTop()) {
                if ($('#set-main-settings').hasClass('fixed')) {
                    $('#set-main-settings').removeClass('fixed');
                }
            } else { 
                if (!$('#set-main-settings').hasClass('fixed')) {
                    $('#set-main-settings').addClass('fixed');
                }
            }
        });
    }

    function createPluginFormGroupElement() {
        var GROUPED_ELEMENT_CLASS = 'magictoolbox-technologies-grouped-element',
            defaultOptions = {
                classOfHiddenInput: 'grouped-element',
            };

        var Instance = function (node, options) {
            this.node = $(node);

            this.container = null;
            this.radioButtons = null;
            this.inputs = null;

            this.find();
            this.setEvents();
            this.setFirstValue();
        };

        $.extend(Instance.prototype, {
            find: function () {
                this.container = this.node.parent();
                this.radioButtons = this.container.find('input[type="radio"]');
                this.inputs = this.container.find('input[type!="radio"]');
            },

            setFirstValue: function () {
                var self = this, input,
                    currentValue = this.node.val();

                this.radioButtons.each(function (index, node) {
                    if (currentValue.replace(/[0-9]+(px|%)/, '$1') === $(node).val()) {
                        $(node).prop('checked', true);

                        input = $(node).parent().find('input[type!="radio"]');

                        if (input.length) {
                            input.val(parseInt(currentValue, 10));
                        }

                        $(node).parent().find('').val()
                        self.makeMagicWithRadio(node);
                        return false;
                    }
                });
            },

            makeMagicWithRadio: function (activatedElement) {
                var self = this;

                $(activatedElement)
                    .parent()
                    .css({ color: '' })
                    .find('input[type!="radio"]')
                    .prop('disabled', false);

                this.makeMagicWithInput(activatedElement);

                this.radioButtons
                    .filter(function () { return this !== activatedElement; })
                    .prop('checked', false)
                    .each(function (index, radio) {
                        $(radio)
                            .parent()
                            .css({ color: '#aaa' })
                            .find('input[type!="radio"]')
                            .prop('disabled', true);
                    });
            },

            makeMagicWithInput: function (activatedElement) {
                var inputButton, radioButtonValue, value;

                activatedElement = $(activatedElement);
                radioButtonValue = activatedElement.val();

                if (/px|%/.test(radioButtonValue)) {
                    inputButton = $(activatedElement.parent().find('input[type!="radio"]'));
                    value = $.trim(inputButton.val() + '');
                    if (value === '' || value === '0') {
                        value = 'auto';
                    } else {
                        value += radioButtonValue;
                    }
                } else {
                    value = activatedElement.val();
                }

                this.node.val(value);
            },

            setEvents: function () {
                var self = this;

                this.radioButtons.on('change', function (e) {
                    self.makeMagicWithRadio(this);
                });

                this.inputs.on('change', function (e) {
                    self.makeMagicWithInput($(this).parent().find('input[type="radio"]'));
                });

                this.inputs.on("paste", function(e) {
                    e.preventDefault();
                    e.stopPropagation();

                    var pastedData = parseInt(e.originalEvent.clipboardData.getData('text'), 10);

                    if (!isNaN(pastedData)) {
                        pastedData = Math.abs(pastedData);
                    } else {
                        pastedData = '';
                    }

                    $(this).val(pastedData);
                    self.makeMagicWithInput($(this).parent().find('input[type="radio"]'));
                });
            },

            destroy: function () {
                this.radioButtons.off('change');
                this.inputs.off('change');
            }
        });

        $.fn.startMagicWithGroupingElements = function () {
            return this.each(function() {
                if (!$(this).data(GROUPED_ELEMENT_CLASS)) {
                    $(this).data(GROUPED_ELEMENT_CLASS, new Instance(this));
                }

                return this;
            });
        };

        $.fn.stopMagicWithGroupingElements = function () {
            return this.each(function() {
                if ($(this).data(GROUPED_ELEMENT_CLASS)) {
                    $(this).data(GROUPED_ELEMENT_CLASS).destroy();
                    $(this).data(GROUPED_ELEMENT_CLASS, null);
                }
                return this;
            });
        };
    }

    function formGroupElement() {
        createPluginFormGroupElement();
        $('.grouped-element').startMagicWithGroupingElements();
    }

    $(document).ready(function () {
        formGroupElement();
        tabs();
        scrollableButton();
    });
})(window.jQuery);