<?php

function magictoolbox_WordPress_MagicSlideshow_array_sort($array, $on, $order = SORT_ASC) {
    $new_array = array();
    $sortable_array = array();

    if (count($array) > 0) {
        foreach ($array as $k => $v) {
            if (is_array($v)) {
                foreach ($v as $k2 => $v2) {
                    if ($k2 == $on) {
                        $sortable_array[$k] = $v2;
                    }
                }
            } else {
                $sortable_array[$k] = $v;
            }
        }

        switch ($order) {
            case SORT_ASC:
                asort($sortable_array);
            break;
            case SORT_DESC:
                arsort($sortable_array);
            break;
        }

        foreach ($sortable_array as $k => $v) {
            $new_array[$k] = $array[$k];
        }
    }

    return $new_array;
}

function magictoolbox_WordPress_MagicSlideshow_get_options_by_group($opt, $group) {
    $params = array();

    foreach ($opt as $key => $param) {
        if (in_array($param['scope'], array('module'))) { continue; }
        if ($param['group'] == $group) { $params[$key] = $param; }
    }

    $params = magictoolbox_WordPress_MagicSlideshow_array_sort($params, 'order');

    return $params;
}

$toolId = 'null';

$options = get_option("WordPressMagicSlideshowCoreSettings");
$options = $options['default'];

$groups = array( array('Common settings', 'Autoplay'), array('Selectors', 'Caption', 'Other settings') );
$toolImages = 'null';
$toolOptions = 'null';
$toolMobileOptions = 'null';
$name = 'null';

if (array_key_exists('id', $_GET) && 'new' != $_GET['id']) {
    $toolId = $_GET['id'];
    $toolData = magictoolbox_WordPress_MagicSlideshow_get_saved_data($toolId);

    if (count($toolData) != 0) {
        $toolData = $toolData[0];
        $toolImages = $toolData->html;
        $allToolOptions = magictoolbox_WordPress_MagicSlideshow_parse_saved_options($toolData->saved_data);

        if (!(bool)preg_match('/^magicslideshow-[0-9]+$/', $toolData->name)) {
            $name = '"'.$toolData->name.'"';
        }

        if ($allToolOptions['options']) {
            $toolOptions = $allToolOptions['options'];
        }

        if ($allToolOptions['mobileOptions']) {
            $toolMobileOptions = $allToolOptions['mobileOptions'];
        }

        $toolImages = str_replace("simple,", "", $toolImages);
    } else {
        $toolId = 'null';
    }
}

$script = '<script>';
$script .= 'var savedData = {';
$script .= 'id:'.$toolId.',';
$script .= 'name:'.$name.',';
$script .= 'images:'.$toolImages.',';
$script .= 'options:"'.$toolOptions.'",';
$script .= 'mobileOptions:"'.$toolMobileOptions.'"';
$script .= '};';
$script .= '</script>';

require_once ABSPATH."wp-includes/class-wp-editor.php";
_WP_Editors::wp_link_dialog();

?>

<div class="magicslideshow-tool shortcode-container">
    <div id="load-loader">
        <div class="animation-container">
            <div class="left">
                <div class="dashicons dashicons-laptop"></div>
            </div>
            <div class="center">
                <div class="line"></div>
                <div class="slideshow-data-container">
                    <div class="slideshow-data dashicons dashicons-images-alt2"></div>
                </div>
            </div>
            <div class="right">
                <div class="dashicons dashicons-cloud"></div>
            </div>
        </div>
        <p class="magic-message">Magic Slideshow is loading...</p>
    </div>
    <div class="shortcode-body" style="display: none;">
        <?php echo $script; ?>

        <h1 style="display:<?php echo ('null' == $toolId) ? 'none' : 'block'; ?>;" id="exist-tool">Edit Magic Slideshow ID #<span><?php echo $toolId; ?></span></h1>
        <h1 style="display:<?php echo ('null' == $toolId) ? 'block' : 'none'; ?>;" id="new-tool">Add new Magic Slideshow</h1>

        <div class="loader"></div>

        <div class=constructor-content></div>

        <div class="save-container">
            <button class="button save-button">Save</button>
            <button class="button button-primary save-and-close-button">Save and close</button>
            <button class="button close-button">Close</button>
        </div>

        <div class="horizontal-block">
            <div class="flex-container">
                <div class="title-of-field">
                    <span>Custom shortcode string</span>
                </div>
                <div class="value-of-field">
                    <span><input id="tool-shortcode-param" type="text" maxlength="20" value=""></span>
                    <div class="">(optional, if you want to use a custom name instead of a number)</div>
                    <div class="mt-error" id="shortcode-error">Shortcode name must be maximum 20 characters, with no spaces. It can only contain letters, numbers, underscores and dashes.</div>
                </div>
            </div>
        </div>

        <div class="horizontal-block">
            <h2>Slides</h2>
            <div style="padding-left: 10px; padding-right: 10px;">
                <div class="gallery-container"><ul id="sortable"></ul></div>
                <div class="gallery-controls">
                    <button id="remove-images-button" class="button">Remove images</button>
                    <button id="add-images-button" class="button button-primary">Add images</button>
                </div>
            </div>
        </div>

        <div class="horizontal-block">
            <h2>Live preview</h2>
            <div class="slideshow-container">
                <div class="browser-magictoolbox-technologies">
                    <div class="b-top-panel-wrapper">
                        <div class="b-top-panel">
                            <div class="b-buttons-panel"><div class="b-buttons-wrapper"><span class="dot-1"></span><span class="dot-2"></span><span class="dot-3"></span></div></div>
                            <div class="b-address-panel"><div class="b-address">&nbsp;</div></div>
                            <div class="b-menu-panel"><div class="b-menu-wrapper"><div></div><div></div><div></div></div></div>
                        </div>
                    </div>
                    <div class="b-display-panel">
                        <div class="slideshow-preview"></div>
                        <div id="overlay">
                            <button class="button button-primary">Refresh</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="horizontal-block">
            <h2>Custom settings</h2>
            <div id="options-container">
                <div id="tabs">
                    <ul>
                        <li><a href="#tabs-1"><span class="dashicons dashicons-laptop"></span>Desktop</a></li>
                        <li><a href="#tabs-2"><span class="dashicons dashicons-smartphone"></span>Mobile</a></li>
                    </ul>

                    <?php foreach (array('desktop', 'mobile') as $key => $value) { ?>
                    <div id="tabs-<?php echo $key + 1; ?>">
                        <div class=tabs-border><div></div></div>
                        <div class="custom-slideshow-options" id="<?php echo $value == 'desktop' ? 'custom-options-container' : 'custom-mobile-options-container' ?>">
                            <?php
                                foreach ($groups as $key => $subgroup) {
                            ?>

                            <div class="<?php echo $key == 0 ? 'left-side' : 'right-side';?>">
                                <table>
                                    <thead>
                                        <tr>
                                            <th colspan="2">Parameter</th>
                                            <th>Value</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                            foreach ($subgroup as $group) {
                                        ?>
                                        <tr class="caption">
                                            <th colspan="4"><?php echo $group; ?></th>
                                        </tr>
                                        <?php
                                                $params = magictoolbox_WordPress_MagicSlideshow_get_options_by_group($options, $group);
                                                foreach ($params as $param) {
                                                    $currentValue = empty($param['value']) ? $param['default'] : $param['value'];
                                        ?>
                            
                                        <tr class="disabled-option">
                                            <td><button type="button" title="Unlock" class="button dashicons dashicons-lock"></button></td>
                                            <td class="param-label"><?php echo $param['label']; ?></td>
                                            <td>
                                            <?php
                                                    switch ($param['type']) {
                                                        case 'text':
                                                        case 'num':
                                            ?>
                                            <input type="<?php echo $param['type'] == 'num' ? 'number' : 'text'; ?>" name="<?php echo $param['id']; ?>" value="<?php echo $currentValue; ?>" disabled data-default-value="<?php echo $currentValue; ?>">
                                            <?php
                                                            break;
                                                        case 'array':
                                                            if ($param['default'] == 'Yes' || $param['default'] == 'No') {
                                            ?>
                                            
                                            <label class="switch-control">
                                                <input type="checkbox" name="<?php echo $param['id']; ?>" value="<?php echo $currentValue; ?>" disabled data-default-value="<?php echo $currentValue; ?>">
                                                <span class="switch-slider"></span>
                                            </label>
                                            
                                            <?php
                                                            } else {
                                            ?>
                                            <select name="<?php echo $param['id']; ?>" disabled data-default-value="<?php echo $currentValue; ?>">
                                            <?php
                                                            foreach ($param['values'] as $value) {
                                            ?>
                                                <option value="<?php echo $value; ?>" <?php echo ($value == $currentValue) ? 'selected' : ''; ?>><?php echo $value; ?></option>
                                            <?php
                                                            }
                                            ?>
                                            </select>
                                            <?php
                                                            }
                                                            break;
                                                        default:
                                            ?>
                                            <span>None</span>
                                            <?php
                                                            break;
                                                    }

                                                    $description = '';
                                                    if (isset($param['description'])) {
                                                        $desc = preg_replace('/(Customize your)/', '<br />${1}',$param['description']);
                                                        $desc = str_replace('&#34;', '"',$param['description']);
                                                        $desc = str_replace('<a', '<a target="_blank"',$param['description']);
                                                        if (!empty($desc)) {
                                                            $description = '<br/><div class="magic-description">'.$desc.'</div>';
                                                        }
                                                    }
                                                    echo $description;
                                            ?>

                                            </td>
                                        </tr>
                                        <?php
                                                }
                                            }  
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                            <?php
                                }
                            ?>
                        </div>
                    </div>
                    <?php
                        }
                    ?>
                </div>
            </div>
        </div>

        <div class="save-container">
            <button class="button save-button">Save</button>
            <button class="button button-primary save-and-close-button">Save and close</button>
            <button class="button close-button">Close</button>
        </div>

        <div id="save-loader">
            <div class="animation-container" id="loading-animation">
                <div class="left">
                    <div class="dashicons dashicons-laptop"></div>
                </div>
                <div class="center">
                    <div class="line"></div>
                    <div class="slideshow-data-container">
                        <div class="slideshow-data dashicons dashicons-images-alt2"></div>
                    </div>
                </div>
                <div class="right">
                    <div class="dashicons dashicons-cloud"></div>
                </div>
            </div>
            <p class="magic-message" id="slideshow-is-saving">Magic Slideshow is saving...</p>
            <p class="magic-message hidden" id="slideshow-was-saved">Magic Slideshow was saved.</p>
            <p class="magic-error-message hidden" id="is-not-saved">Magic Slideshow has not been saved.</p>
            <p class="magic-error-message hidden" id="is-not-unique">Shortcode is not unique.</p>
            <p class="magic-error-message hidden" id="try-again">Something went wrong, please try again.</p>
            <p class="magic-error-message hidden" id="nothing-to-save">Nothing to save.</p>
        </div>
    </div>
</div>
