(function () {
    'use strict';'use strict';
var angular = window.angular;
// var constructorApp = angular.module('constructorApp', ['angularColorPicker', 'mgcrea.ngStrap.select'], function($httpProvider) {
//     $httpProvider.defaults.headers.post['Content-Type'] = 'application/x-www-form-urlencoded;charset=utf-8';
// });

var constructorApp = angular.module('constructorApp', [
    'ngSanitize',
    'summernote',
    'angularColorPicker',
    'angularInfobar',
    'aModalWindow'
]);

constructorApp.config(['$provide', function($provide) {
    $provide.decorator('acpOptions', ['$delegate', function(acpOptions) { // $delegate is the acpOptions we are decorating
        // set the path to the bgGradient.png
        acpOptions.imgPath = 'constructor/img/bgGradient.png';
        acpOptions.imgPathLine = 'constructor/img/transparent-mini.png';

        acpOptions.startPosition.x = 'root';
        acpOptions.startPosition.y = 'root';
        acpOptions.topPanel = false;

        return acpOptions;
    }]);
}]);

constructorApp.value('paths', {
    json: [
        'constructor/json/options.json',
        'constructor/json/slide.options.json',
        'constructor/json/block.options.json',
        'constructor/json/groups.json'
    ],
    zipMagicSLideshow: '../trial/magicslideshow-trial/magicslideshow' // path to magicslideshow folder
});

constructorApp.controller('constructor', [
    'parseSlide',
    '$scope',
    '$window',
    '$http',
    'slideshowAPI',
    '$timeout',
    '$rootScope',
    'lib',
    'loader',
    '$compile',
    'convertFontSize',
    '$q',
    'acpManager',
    'activeTab',
    'orderBlocksApi',
    'globalMenuAPI',
    '$location',
    'editSlideF',
    'messages',
    'paths',
    'getHtmlSlideshow',
    'aModalWindowManager',
    'saveSlideshow',
    function(parseSlide, $scope, $window, $http, slideshowAPI, $timeout, $rootScope, lib, loader, $compile, convertFontSize, $q, acpManager, activeTab, orderBlocksApi, globalMenuAPI, $location, editSlideF, messages, paths, getHtmlSlideshow, aModalWindowManager, saveSlideshow) {

    $rootScope.dontsave = false;

    $rootScope.defaultContent = {
        // img = 'http://www.ipukr.com/wp-content/uploads/2014/07/1376578323_molodozheny-iz-odessy-priobreli-bilety-v-kosmos.jpg',
        // img = 'http://rewalls.com/large/201010/6476.jpg',
        img: 'https://sirv.sirv.com/website/screenshots/sirv-for-magento-830x291.png',
        // youtube = 'f1i6jTbisYM',
        youtube: '10BFj6aPjVU',
        vimeo: '104587370'
    };

    $rootScope.outlineIsShow = true;

    $rootScope.colorPickerOpened = false;

    $rootScope.newItemWindowIsOpened = false;

    $rootScope.zoomIcon = 'fit';

    $rootScope.idSlideshow = {};

    $rootScope.dataCss = [
        'top',
        'left',
        'width',
        'color',
        'height',
        'filter',
        'padding',
        'opacity',
        'position',
        'font-size',
        'background',
        'padding-top',
        'border',
        'border-color',
        'border-style',
        'border-width',
        'padding-left',
        'padding-right',
        'padding-bottom',
        'background-color'
    ];

    $rootScope.defCss = {
        'top': '10%',
        'left': '10%',
        'width': 'auto',
        'height': 'auto',
        'font-size': '20px',
        'color': 'rgb(0,0,0)',
        'background-color': 'none',
        'padding': '0px',
        'border-width': '0px',
        'border-style': 'none',
        'line-height': '100%',
        'z-index': '0',
        'opacity': 1,
        'font-family': 'Arial, Helvetica, sans-serif',
        'text-align': 'left',
        'border-color': 'none'
    };

    function copy_ (value) {
        var o;
        function check(v) {
            var tmp;

            if (angular.isElement(v)) {
                tmp = null;
            } else if (angular.isArray(v)) {
                tmp = arr(v);
            } else if (angular.isObject(v)) {
                tmp = obj(v);
            } else {
                tmp = v;
            }
            return tmp;
        }
        function arr(v) {
            var f, o2 = [];
            angular.forEach(v, function(v_, k_) {
                f = check(v_);
                if (null !== f) {
                    o2.push(f);
                }
            });
            return o2;
        }
        function obj(v) {
            var f, o2 = {};
            angular.forEach(v, function(v_, k_) {
                if (v.hasOwnProperty(k_) && !(/^$/.test(k_)) && 'scope' !== k_) {
                    f = check(v_);
                    if (null !== f) {
                        o2[k_] = f;
                    }
                }
            });
            return o2;
        }

        if (angular.isArray(value)) {
            o = arr(value);
        } else if (angular.isObject(value)) {
            o = obj(value);
        }
        return o;
    }

    $scope.allVisible = true; // for loading slides and render
    $rootScope.loader = false;
    // $rootScope.slideSize = null;
    $rootScope.slideSize = { width: 0, height: 0 };

    $rootScope.globalMenuIsOpen = false;

    $rootScope.getSlideshowJSON = function() {
        var ss, opt = [], id;

        function replaceContent (content) {
            content = content.replace(/'/g, '&#39');
            content = content.replace(/"/g, '&#34');
            return content;
        }

        opt = copy_($scope.slideshowOptions);
        opt = JSON.stringify($scope.slideshowOptions);

        ss = copy_($scope.slides);
        angular.forEach(ss, function(s) {
            s.activeBlock = null;
            angular.forEach(s.blocks, function(b) {
                b.content = replaceContent(b.content);
                b.newBlock = false;
                b.load = false;
            });
        });

        ss = JSON.stringify(ss);

        if ('id' in $rootScope.idSlideshow) {
            id = $rootScope.idSlideshow.id;
        } else {
            id = null;
        }

        return {
            slideshow: ss,
            options: opt,
            id: id
        };
    };

    $rootScope.oldSlideshow = '';

    $scope.globalMenuTimer = null;

    $scope.inIframe = messages.status;

    $scope.empty = true;
    $scope.zoomIcon = 'fit';
    $scope.zoomIconsDefault = [
        { value: 0.25, label: '25%'},
        { value: 0.5, label: '50%'},
        { value: 0.75, label: '75%'},
        { value: 1, label: '100%' },
        { value: 1.5, label: '150%' },
        { value: 2, label: '200%' },
        { value: 2.5, label: '250%' }
    ];
    $scope.zoomIcons = [
        { value: 0.25, label: '25%'},
        { value: 0.5, label: '50%'},
        { value: 0.75, label: '75%'},
        { value: 1, label: '100%' },
        { value: 1.5, label: '150%' },
        { value: 2, label: '200%' },
        { value: 2.5, label: '250%' }
    ];


    $scope.summernoteOptions = {
        disableDragAndDrop: true,
        lang: "en-US",
        forButton: false,
        // fontSizes: ['8', '9', '10', '11', '12', '14', '18', '24', '36']
        fontSizes: ['12', '14', '18', '24', '30', '36', '42', '48', '56', '64', '73', '82', '100', '150'],
        toolbar: [
            ['style', ['bold', 'italic', 'underline', 'clear']],
            ['fontsize', ['fontsize']],
            ['color', ['color']],
            ['para', ['ul', 'ol', 'paragraph']],
            ['height', ['height']],
            ['link', ['link']],
            ['fontname', ['fontname']]
         ]
    };

    $scope.buttonSummernoteOptions = {
        disableDragAndDrop: true,
        lang: "en-US",
        forButton: true,
        fontSizes: ['12', '14', '18', '24', '30', '36', '42', '48', '56', '64', '73', '82', '100', '150'],
        toolbar: [
            ['style', ['bold', 'italic', 'underline', 'clear']],
            ['fontsize', ['fontsize']],
            ['color', ['color']],
            ['fontname', ['fontname']]
         ]
    };

    $scope.defBlock = {
        wrapper: '',
        outline: '',
        title: '',
        node: '',
        imgName: null,
        index: null,
        type: '',
        url: '',
        imgId: null, // for cms(wordpress)
        base64: null,
        load: false,
        newBlock: true,
        isBackground: false,
        backgroundOldStyle: false,
        baseWidth: null,
        baseHeihgt: null,
        activeBlock: null,
        ta: { isActive: false },
        styles: {},
        options: [],
        size: { width: 0, height: 0 },
        customCss: {},
        href: '',
        link: false,
        saveProportions: true,
        video: {
            'videoType': '',
            'video-autoplay': false,
            'video-fullsize': false
        },
        content: '<p style="line-height:1;">Text... Text... Text... Text... Text... Text...</p>',
        correctStyles: {
            'font-size': 20,
            'font-family': 'Arial, Helvetica, sans-serif',
            'color': 'black',
            'background-color': 'transparent',
            'padding': 0,
            'border-width': 0,
            'border-style': 'none',
            'border-color': 'black',
            'border-radius': 0,
            'top': 0,
            'left': 0,
            'width': 0,
            'height': 0,
            'opacity': 100,
            'bs-x': 0,
            'bs-y': 0,
            'bs-blur': 0,
            'bs-size': 0,
            'bs-color': 'rgba(0,0,0,1)',
            'bs-inset': false,
            'ts-x': 0,
            'ts-y': 0,
            'ts-blur': 0,
            'ts-size': 0,
            'ts-color': 'rgba(0,0,0,1)',
            'ts-inset': false,
            'bg-color': 'none'
        }
    };

    $scope.slideshowSlides = [];

    // $scope.thumbnailsType = 'img';  // img or text

    $scope.defSlide = {
        node: null,
        blocks: [],
        rightSideSize: 0,
        index: null,
        focusClass: '',
        backgroundBlock: null,
        slideOptions: [],
        blockNumber: 0,
        styles: { 'background-color': 'transparent' },
        correctStyles: { 'bg-color': 'transparent' },

        // thumbnails: {
        //     textContent: '',
        //     img: {
        //         node: null,
        //         list: [angular.element('<img src="http://photoholic24.com/wp-content/uploads/2012/01/u234280.jpg">')[0]]
        //     },
        // },

        panel: {
            node: null,
            styles: {
                'top': '0%',
                'left': '0%',
                'width': '0%',
                'height': '0%'
            },
            show: false
        }
        // taToolbarName: 'ta-toolbar'
    };

    $scope.defaults = {
        slideshowOptions: [],
        slides: [],
        slideOptions: {},
        blockOptions: {}
    };

    $scope.slideshowOptions = [];
    $scope.slides = [];

    $scope.defSlideEditor = {
        editor: 0,
        editorStyles: {
            'top': '0px',
            'left': '0px',
            'width': '100%',
            'height': '100%'
        },
        cSlide: null,
        cBlock: null,
        flags: {
            slide: true,
            block: false,
            colorPicker: false
        },
        colorPickerType: '',
        type: 'text',
        url: '',
        title: ''
    };

    $scope.slideEditor = angular.copy($scope.defSlideEditor, {});

    $scope.borderType = [
        'none',
        'dotted',
        'dashed',
        'solid',
        'double',
        'groove',
        'ridge',
        'inset',
        'outset'
    ];

    // $scope._fontFamily = [
    //     { name: 'sans-serif',          value: 'sans-serif'                                       },
    //     { name: 'Arial',               value: 'Arial, Helvetica, sans-serif'                     },
    //     { name: 'Arial Black',         value: "Arial Black, Gadget, sans-serif"                  },
    //     { name: 'Comic Sans MS',       value: 'Comic Sans MS, cursive'                           },
    //     { name: 'Courier New',         value: 'Courier New, Courier, monospace'                  },
    //     { name: 'Georgia',             value: 'Georgia, serif'                                   },
    //     { name: 'Impact',              value: 'Impact, Charcoal, sans-serif'                     },
    //     { name: 'Lucida Console',      value: 'Lucida Console, Monaco, monospace'                },
    //     { name: 'Lucida Sans Unicode', value: 'Lucida Sans Unicode, Lucida Grande, sans-serif'   },
    //     { name: 'Palatino Linotype',   value: 'Palatino Linotype, Book Antiqua, Palatino, serif' },
    //     { name: 'Tahoma',              value: 'Tahoma, Geneva, sans-serif'                       },
    //     { name: 'Times New Roman',     value: 'Times New Roman, Times, serif'                    },
    //     { name: 'Trebuchet MS',        value: 'Trebuchet MS, Helvetica, sans-serif'              },
    //     { name: 'Verdana',             value: 'Verdana, Geneva, sans-serif'                      },
    //     { name: 'Symbol',              value: 'Symbol'                                           },
    //     { name: 'Webdings',            value: 'Webdings'                                         },
    //     { name: 'Wingdings',           value: 'Wingdings, "Zapf Dingbats"'                       },
    //     { name: 'MS Sans Serif',       value: 'MS Sans Serif, Geneva, sans-serif'                },
    //     { name: 'MS Serif',            value: 'MS Serif, New York, serif'                        }
    // ];

    $scope.proportionsIsSet = null;
    $scope.mainField = null;

    $scope.toolbarClick = function(e) {
        e.preventDefault();
        return false;
    };

    $scope.setAsBackground = function(isStore, currentBlock) {
        var slideIndex = currentBlock ? currentBlock.slide : $scope.slideEditor.cSlide,
            blockIndex = currentBlock ? currentBlock.block : $scope.slideEditor.cBlock,
            cs = $scope.slides[slideIndex],
            cb = cs.blocks[blockIndex],
            isBackground = cb.isBackground,

            setStyle = function(t, l, w, h) {
                cb.styles['top'] = t;
                cb.styles['left'] = l;
                cb.styles['width'] = w;
                cb.styles['height'] = h;
            };
        if (isStore) {
            isBackground = !isStore.isBackground;
            $scope.$apply(function() { cb.isBackground = isBackground; });
        }

        if (isBackground) {
            cb.backgroundOldStyle = {
                'top': cb.styles['top'],
                'left': cb.styles['left'],
                'width': cb.styles['width'],
                'height': cb.styles['height'],
                'z-index': cb.styles['z-index'],
                'box-shadow': cb.styles['box-shadow'],

                'border-width': cb.correctStyles['border-width'], // 0
                'border-style': cb.correctStyles['border-style'] // 'none'
            };

            angular.element(cb.node.parentNode).addClass('mss-centering-img');
            // angular.element(cb.node).addClass('mss-centering-img');
            angular.element(cb.node).removeAttr('data-mss-animation-block');

            setStyle('0%', '0%', '', '');
            if (cb.baseWidth / cb.baseHeight * lib.getOption($scope.slideshowOptions, 'base-width').value <= lib.getOption($scope.slideshowOptions, 'base-height').value) {
                angular.element(cb.node).addClass('mss-img-horizontal');
            } else {
                angular.element(cb.node).addClass('mss-img-vertical');
            }

            cb.correctStyles['border-width'] = 0;
            cb.correctStyles['border-style'] = 'none';
            $scope.setStyles('border-width', 'px', true);
            $scope.setStyles('border-style', '', true);

            cb.styles['box-shadow'] = 'none';

            orderBlocksApi.setFirstZIndex(cb, cs.blocks);

            cs.backgroundBlock = cb;
        } else {
            cs.backgroundBlock = null;

            angular.element(cb.node.parentNode).removeClass('mss-centering-img');
            // angular.element(cb.node).removeClass('mss-centering-img');
            angular.element(cb.node).removeClass('mss-img-horizontal');
            angular.element(cb.node).removeClass('mss-img-vertical');
            angular.element(cb.node).attr('data-mss-animation-block', '');

            setStyle(cb.backgroundOldStyle['top'], cb.backgroundOldStyle['left'], cb.backgroundOldStyle['width'], cb.backgroundOldStyle['height']);

            cb.correctStyles['border-width'] = cb.backgroundOldStyle['border-width'];
            cb.correctStyles['border-style'] = cb.backgroundOldStyle['border-style'];
            $scope.setStyles('border-width', 'px', true);
            $scope.setStyles('border-style', '', true);

            cb.styles['box-shadow'] = cb.backgroundOldStyle['box-shadow'];

            orderBlocksApi.setDesiredZIndex(cb.backgroundOldStyle['z-index'], cb, cs.blocks);

            cb.backgroundOldStyle = null;
        }

        $scope.$broadcast('checkButtonsEvent');

        if (!isStore && !currentBlock) {
            $scope.$broadcast('savingActionAddEvent', {
                event: {
                    type: 'setBeckground',
                    slideIndex: cs.index,
                    blockIndex: cb.index,
                    isBackground: cb.isBackground,
                    backgroundOldStyle: angular.copy(cb.backgroundOldStyle, {})
                }
            });
            $scope.$broadcast('slidePreviewUpdateEvent', {
                index: $scope.slideEditor.cSlide
            });
        }

        !currentBlock && $scope.$broadcast('auxiliaryPanelUpdateSizeEvent');
    };

    $scope.setUpProportionsToSlide = function() {
        var cs = $scope.slides[$scope.slideEditor.cSlide];
        var cb = cs.blocks[$scope.slideEditor.cBlock];
        var pis = $scope.slideEditor.cSlide + '' + $scope.slideEditor.cBlock;
        var w;
        var h;
        var oldSize;
        var oldProportions;

        if (null === $scope.slideEditor.cBlock || pis === $scope.proportionsIsSet) {
            return;
        }

        oldProportions = $scope.proportionsIsSet;

        if (!cb.size.width) {
            cb.size.width = cb.node.offsetWidth;
        }

        if (!cb.size.height) {
            cb.size.height = cb.node.offsetHeight;
        }

        $scope.proportionsIsSet = pis;

        oldSize = {
            'width': lib.getOption($scope.slideshowOptions, 'base-width').value,
            'height': lib.getOption($scope.slideshowOptions, 'base-height').value
        };

        $scope.$broadcast('edtorZoomEvent', {type: 'resize', param: {
            width: cb.baseWidth,
            height: cb.baseHeight,
            callback: function() {
                $timeout(function() {
                    angular.forEach(cs.blocks, function(b) {
                        var w_ = b.node.offsetWidth + 'px',
                            h_ = b.node.offsetHeight + 'px';

                        if ($scope.slideEditor.cBlock === b.index && cb.isBackground) {
                            angular.element(b.outline).css({
                                'top': ($rootScope.slideSize.height - parseInt(h_)) / 2 + 'px',
                                'left': ($rootScope.slideSize.width - parseInt(w_)) / 2 + 'px'
                            });
                        }
                        angular.element(b.outline).css({
                            'width': w_,
                            'height': h_
                        });
                    });
                }, 0);

                $scope.$broadcast('savingActionAddEvent', {
                    event: {
                        type: 'canvasResize',
                        slideIndex: cs.index,
                        blockIndex: cb.index,
                        oldSize: oldSize,
                        newSize: {
                            // width: cb.size.width,
                            // height: cb.size.height
                            width: $rootScope.slideSize.width,
                            height: $rootScope.slideSize.height
                        },
                        oldProportions: oldProportions,
                        newProportions: $scope.proportionsIsSet
                    }
                });
            }
        }});

        $scope.$$correctBlocksPosition();
        $scope.$broadcast('auxiliaryPanelUpdateSizeEvent');
        $scope.$broadcast('slidePreviewSlideSizeEvent', {
            index: $scope.slideEditor.cSlide,
            width: cb.size.width,
            height: cb.size.height,
        });
    };

    $scope.$$correctBlocksPosition = function() {
        var edrst = $scope.slideEditor.editorStyles,
            pf = function(v) { return parseFloat(v); },
            canvasTop = pf(edrst.top),
            canvasLeft = pf(edrst.left),
            canvasWidth = pf(edrst.width),
            canvasHeight = pf(edrst.height);

        angular.forEach($scope.slides, function(s, i) {
            angular.forEach(s.blocks, function(b, j) {
                var bt, bl, bw, bh;

                if (/%$/.test(b.styles.top)) {
                    if (pf(b.styles.top) > 100) {
                        bt = '90%';
                    }
                } else {
                    bt = pf(b.styles.top);
                }

                if (/%$/.test(b.styles.left)) {
                    if (pf(b.styles.left) > 100) {
                        bl = '90%';
                    }
                } else {
                    bl = pf(b.styles.left);
                }

                if (/%$/.test(b.styles.width)) {
                    bw = pf(b.styles.width);
                    bw = canvasWidth / 100 * bw;
                } else if ('auto' === b.styles.width) {
                    // bw = b.node.offsetWidth; // display: none
                    bw = b.size.width;
                } else {
                    bw = pf(b.styles.width);
                }

                if (/%$/.test(b.styles.height)) {
                    bh = pf(b.styles.height);
                    bh = canvasHeight / 100 * bh;
                } else if ('auto' === b.styles.height) {
                    if ('image' === b.type) {
                        bh = b.size.height / b.size.width * pf(b.styles.height);
                    } else {
                        // bh = b.node.offsetHeight;  // display: none
                        bh = b.size.height;
                    }
                } else {
                    bh = pf(b.styles.height);
                }

                if (!(/%$/.test(b.styles.left))) {
                    if (bl > canvasWidth + 15) {
                        bl = (canvasWidth - 15) + 'px';
                    } else if (bl + bw + 15 < 0) {
                        bl = (0 - (bl + bw - 15)) + 'px';
                    } else {
                        bl = b.styles.left;
                    }
                } else {
                    if (pf(b.styles.left) > 90) {
                        bl = '90%';
                    } else {
                        bl = b.styles.left;
                    }
                }

                if (!(/%$/.test(b.styles.top))) {
                    if (bt > canvasHeight + 15) {
                        bt = (canvasHeight - 15) + 'px';
                    } else if (bt + bh - 15 < 0) {
                        bt = (0 - (bt + bh - 15)) + 'px';
                    } else {
                        bt = b.styles.top;
                    }
                } else {
                    if (pf(b.styles.top) > 90) {
                        bt = '90%';
                    } else {
                        bt = b.styles.top;
                    }
                }

                b.styles.top = bt;
                b.styles.left = bl;
                if (s.fakeImg) {
                    s.fakeImgStyles.top = bt;
                    s.fakeImgStyles.left = bl;
                }

                $scope.changeField('top', i, j);
                $scope.changeField('left', i, j);
            });
            s.node.style.cssText = 'display: ""';
        });
    };

    var controlLineTimer = null;
    $scope.$on('controlLineEventResize', function(e) {
        $timeout.cancel(controlLineTimer);
        controlLineTimer = $timeout(function() {
            // $scope.$apply(function() {
                $scope.$broadcast('edtorZoomEvent', { type: 'control-line' });
            // });
        // }, 100);
        }, 100);
    });

    $scope.appendImgToSecretContainer = (function() {
        var allUrls = [],
            container = angular.element('<div>'),
            append = function(url) {
                var img = angular.element('img');
                img.attr('src', url);
                allUrls.push(url);
                container.append(img);
            };

        container.css({
            'position': 'absolute',
            'top': '-10000px',
            'left': '-10000px',
            'width': '10px',
            'height': '10px',
            'overflow': 'hidden'
        });
        container.appendTo(document.body);
        return function(url) {
            for (var i = 0; i < allUrls.length; i++) {
                if (url === allUrls[i]) { return; }
            }
            append(url);
        };
    })();

    $scope.$$loadAllImg = function(callback, arr) {
        var ss = arr || $scope.slides, slideIndex = 0, blockIndex = -1,
        getNextBlock = function() {
            if (slideIndex < ss.length) {
                if (blockIndex + 1 < ss[slideIndex].blocks.length) {
                    blockIndex += 1;
                    return ss[slideIndex].blocks[blockIndex];
                } else {
                    blockIndex = 0;
                    slideIndex += 1;
                    if (slideIndex < ss.length) {
                        return ss[slideIndex].blocks[blockIndex];
                    } else {
                        return null;
                    }
                }
            } else {
                return null;
            }
        },

        loadBlock = function(block, cb) {
            if (!block.load && 'image' === block.type) {
                loader.load(block.url, {
                    onload: function (e) {
                        block.load = true;
                        block.size = e.size;
                        block.styles.height = 'auto';
                        $scope.appendImgToSecretContainer(block.url);
                        cb();
                    },
                    error: function(e) {
                        block.load = true;
                        cb();
                    }
                });
            } else {
                cb();
            }
        },

        loadBlocks = function(cb) {
            var b = getNextBlock();
            if (b) {
                loadBlock(b, function() {
                    loadBlocks(cb);
                });
            } else {
                cb();
            }
        };

        loadBlocks(callback);
    };

    $scope.setMagicSlideshowOptions = function() {
        // $window.MagicSlideshow.options
        if ($window.MagicSlideshow) {
            angular.forEach($scope.defaults.slideshowOptions, function(o) {
                $window.MagicSlideshow.options[o.name] = o.value;
            });
        }
    };

    function getResources(resources, callback) {
        var results = [],

            get_ = function(res) {
                var deferred = $q.defer();
                $http.get(res, {})
                .success(function(data, status, headers, config) {
                    deferred.resolve(data);
                }).error(function(data) {
                    deferred.reject('Can not get ' + res);
                });
                return deferred.promise;
            },

            q = function() {
                var promise = get_(resources.shift());
                promise.then(function(data) {
                    results.push(data);
                    load();
                }, function(reason) {
                    results.push(null);
                    load();
                    throw reason;
                });
            },

            load = function() {
                if (resources.length > 0) {
                    q();
                } else {
                    callback(results);
                }
            };
        load();
    }

    $scope.openGlobalMenu = function() {
        if (!$scope.slides[$scope.slideEditor.cSlide].panel.show) {
            // $scope.$broadcast('activeBlockEvent', { index: null });
            // $scope.toggleBlocks(null);
            var el = $scope.slides[$scope.slideEditor.cSlide].blocks[$scope.slideEditor.cBlock];
            if (el) {
                angular.element(el.node)
                    .removeClass('ta-border-shadow');

                $scope.slides[$scope.slideEditor.cSlide].panel.show = true;
            }
        }

        globalMenuAPI.open();
    };
    $scope.closeGlobalMenu = function() {
        globalMenuAPI.close();
    };

    $scope.activateSlide = function(index, noSaveAction, deferred, callback) {
        var i, newSlide = (undefined === index),
            last = $scope.slideEditor.cSlide,
            sld, ocb;

        globalMenuAPI.close();

        if (null !== $scope.slideEditor.cSlide && $scope.slideEditor.cSlide < $scope.slides.length) {
            sld = $scope.slides[$scope.slideEditor.cSlide];
            sld.focusClass = '';
            sld.activeBlock = null;

            ocb = sld.blocks[$scope.slideEditor.cBlock];

            $scope.slideEditor.cBlock = null;
        }

        if (undefined === index) {
            index = $scope.slides.length;
            $scope.slides.push(angular.extend({}, $scope.defSlide));
            $scope.defSlide.blocks = [];
            $scope.slides[index].index = index;
            $scope.slides[index].node = document.createElement('div');
            $scope.slides[index].slideOptions = angular.copy($scope.defaults.slideOptions, []);
            $scope.slides[index].styles = angular.copy($scope.defSlide.styles, {});
            $scope.slides[index].correctStyles = angular.copy($scope.defSlide.correctStyles, {});
        } else {
            // (null !== last && $scope.slides.length < last) && angular.forEach($scope.slides[last].blocks, function(b) {
            //     if ('text' === b.type && b.ta.isActive) {
            //         b.ta.isActive = false;
            //         b.node.innerHTML = b.content;
            //     }
            // });
        }

        angular.element($scope.slides[index].node).addClass('mss-content');

        $scope.slides[index].focusClass = 'active';
        $scope.empty = false;
        $scope.slideEditor.cSlide = index;
        $timeout(function() {
            $scope.slideEditor.title = 'Slide ' + (index + 1) + '.';
            if (undefined === noSaveAction && newSlide) {
                $scope.$broadcast('savingActionAddEvent', {
                    event: {
                        type: 'newSlide',
                        index: index,
                        slide: $scope.slides[index],
                        lastActiveSlide: last
                    }
                });
            }

            // $scope.slideEditor.cSlide = index;
            $scope.slides[index].panel.show = false;
            $scope.toggleBlocks(null);

            deferred && deferred.resolve();
            callback && callback();
        }, 0);
    };

    $scope.removeSlide = function (index, activateSlide, noSaveAction, deferred) {
        var _slides = [];

        globalMenuAPI.close();

        if ($scope.slides.length > 0 && undefined !== index) {
            if (undefined === activateSlide) {
                if (index === $scope.slideEditor.cSlide || undefined === index) {
                    activateSlide = 0;
                } else {
                    if ($scope.slideEditor.cSlide > index) {
                        activateSlide = $scope.slideEditor.cSlide - 1;
                    } else {
                        activateSlide = $scope.slideEditor.cSlide;
                    }
                }
            }

            angular.forEach($scope.slides, function(s, i) {
                if (index !== i) {
                    _slides.push(s);
                    _slides[_slides.length - 1].index = _slides.length - 1;
                } else {
                    if (undefined === noSaveAction) {
                        noSaveAction = 0;
                    }
                    $scope.$broadcast('savingActionAddEvent', {
                        event: {
                            type: 'removeSlide',
                            activeIndex: $scope.slideEditor.cSlide,
                            index: i,
                            slide: s
                        }
                    });
                }
            });

            if ($scope.slides.length !== _slides.length) {
                $scope.slides = _slides;
            }

            if ($scope.slides.length > 0) {
                $scope.activateSlide(activateSlide, noSaveAction, deferred);
            } else {
                $scope.empty = true;
                $scope.slideEditor.cSlide = null;
                $scope.slideEditor.cBlock = null;
                // $scope.$broadcast('componentsEmptyEvent');
                deferred && deferred.resolve();
            }
        }
    };

    $scope.saveSlide = function(index) {
        var s = '',
            size, t,
            border, a,
            obj = {},
            slide = {},
            cs, spans,
            cloneSlide,
            correctSize = function(key, value, block) {
                if ('width' === key || 'height' === key || 'top' === key || 'left' === key) {
                    !size && (size = { width: $rootScope.slideSize.width, height: $rootScope.slideSize.height });

                    if ('width' === key || 'height' === key) {
                        if ('image' === block.type || ('text' === block.type || 'shape' === block.type || 'button' === block.type) && /px$/.test(value)) {
                            if ('width' === key) {
                                t = border.left + border.right;
                            } else {
                                t = border.top + border.bottom;
                            }

                            if ('auto' !== value && !(/%$/.test(value))) {
                                value = ((parseInt(value) - t) / size[key] * 100) + '%';
                            }
                        }
                    } else {
                        if (!(/%$/.test(value))) {
                            value = (parseInt(value) / size['top' === key ? 'height' : 'width'] * 100) + '%';
                        }
                    }
                }
                return value;
            };

        // if (undefined !== index) {
        //     $scope.slideEditor.cSlide = index;
        // }
        // cs = $scope.slides[$scope.slideEditor.cSlide];
        // cs = $scope.slides[index || $scope.slideEditor.cSlide];
        cs = $scope.slides[index];
        cloneSlide = cs.node.cloneNode(true);
        cloneSlide.innerHTML = '';


        angular.forEach(cs.blocks, function(b, i) {
            var cloneBlock = b.node.cloneNode(true);
            border = lib.getBorder(cloneBlock);

            angular.element(cloneBlock)
                .attr('data-rwd', true)
                .removeClass('ng-scope')
                .removeAttr('style')
                .removeAttr('ng-style')
                .removeAttr('ng-model')
                .removeAttr('text-angular')
                .removeAttr('name')
                .removeAttr('ng-if')
                .removeAttr('ng-src')
                .removeAttr('block-text')
                .removeAttr('index');


            if ('image' === b.type && b.link) {
                a = angular.element('<a>');
                a.attr('href', b.href);

                if (!b.isBackground) {
                    a.attr('data-mss-animation-block', '');
                    angular.element(cloneBlock).css({
                        'position': 'relative',
                        'max-width': '100%'
                    }).removeAttr('data-mss-animation-block');
                } else {
                    a.attr('data-mss-constr-bg', '');
                }


                a.append(cloneBlock);
                cloneBlock = a[0];
            }

            if ('text' === b.type || 'button' === b.type) {
                // angular.element(b.node).find('span').removeClass('ng-scope');
                spans = angular.element(cloneBlock).find('span');
                angular.forEach(spans, function(sp) {
                    sp = angular.element(sp);
                    sp.removeClass('ng-scope');
                    // .css('font-size', convertFontSize.convertToEm(sp.css('font-size')));
                });
                // convertFontSize.convertInvestedEm(cloneBlock);
                if ('text' === b.type) {
                    cloneBlock = angular.element('<div data-mss-animation-block data-rwd="true">' + b.content + '</div>')[0];
                }
                convertFontSize.convertInvestedEm(cloneBlock);
            }

            if ('button' === b.type) {
                angular.element(cloneBlock).attr('href', b.href);
            }

            angular.forEach(b.options, function(o, i2) {
                if (true === o.value || false === o.value) { o.value += ''; }
                if ($scope.defaults.blockOptions[i2].value !== o.value) {
                    angular.element(cloneBlock).attr('data-'+ o.name, o.value);
                } else {
                    angular.element(cloneBlock).removeAttr('data-'+ o.name);
                }
            });
            // b.focusClass = '';

            if ('text' !== b.type && 'button' !== b.type && 'shape' !== b.type && !b.isBackground) {
                if (/%$/.test(b.styles.width)) {
                    b.styles.width = ($rootScope.slideSize.width / 100 * parseInt(b.styles.width)) + 'px';
                }
                if (/%$/.test(b.styles.height)) {
                    b.styles.height = ($rootScope.slideSize.height / 100 * parseInt(b.styles.height)) + 'px';
                }

                angular.element(cloneBlock).attr('data-width', b.styles.width);
                if ('video' === b.type) {
                    angular.element(cloneBlock).attr('data-height', b.styles.height);
                }
            }

            if (!b.isBackground) {
                s = '';
                angular.forEach(b.styles, function(value, key) {
                    s += key + ':' + correctSize(key, value, b) + ';';
                });

                angular.element(cloneBlock).attr('style', s);
            }
            angular.element(cloneSlide).append(cloneBlock);
        });

        angular.forEach(cs.slideOptions, function(o, i) {
            // TODO
            // if ($scope.defaults.slideOptions[i].value !== o.value) {
                angular.element(cloneSlide).attr('data-'+ o.name, o.value);
            // } else {
                // angular.element(cloneSlide).removeAttr('data-'+ o.name);
            // }
        });

        angular.element(cloneSlide).removeAttr('ng-style');

        s = '';
        angular.forEach(cs.styles, function(value, key) {
            if ($scope.defSlide.styles[key] !== value) {
                s += (key + ':' + value + ';');
            }
        });

        // cs.focusClass = '';

        // angular.forEach(cs.blocks, function(b) {
        //     angular.element(cs.node).append(b.node);
        //     b.wrapper && angular.element(b.wrapper).remove();
        // });

        // angular.element(cs.panel.node).remove();
        // cs.panel.node = null;
        return cloneSlide;
    };

    $scope.tmpStyle = {
        timer: null,
        styles: null,
        correctStyles: null,
        panelStyles: null,
        size: null,
        fakeImg: null,
        content: null,
        saveProportions: null,
        customCss: null
    };

    $scope.$on('blockTextReCalcEvent', function() {
        // data.value
        var s = $scope.slides[$scope.slideEditor.cSlide],
            b = s.blocks[$scope.slideEditor.cBlock], e;

        $timeout.cancel($scope.tmpStyle.timer);
        $scope.tmpStyle.timer = $timeout(function() {
            $scope.tmpStyle.timer = null;
            e = {
                type: 'setStyles',
                slideIndex: $scope.slideEditor.cSlide,
                blockIndex: $scope.slideEditor.cBlock,
                oldPanelStyles: $scope.tmpStyle.panelStyles,
                newPanelStyles: angular.copy(s.panel.styles, {}),
                oldContent: $scope.tmpStyle.content,
                newContent: b.content,
                oldSize: $scope.tmpStyle.size,
                newSize: angular.copy(s.size, {})
            };

            if (null !== $scope.tmpStyle.saveProportions) {
                e.oldSaveProportions = $scope.tmpStyle.saveProportions;
                e.newSaveProportions = b.saveProportions;
            }

            $scope.$broadcast('savingActionAddEvent', { event: e });
            $scope.tmpStyle.content = null;
            $scope.tmpStyle.panelStyles = null;
            $scope.tmpStyle.size = null;
            $scope.tmpStyle.saveProportions = null;
        }, 450);
        $scope.setStyles('', '', true);
    });

    $scope.setStyles = function(style, units, notSave) {
        var s, p, v, e;
        s = $scope.slides[$scope.slideEditor.cSlide].blocks[$scope.slideEditor.cBlock];
        if (undefined === s) { return; }
        p = $scope.slides[$scope.slideEditor.cSlide].panel;
        v = s.correctStyles[style];

        if ('opacity' === style) {
            v = v / 100;
            units = 0;
        }

        if (!$scope.tmpStyle.styles && !notSave) {
            $scope.tmpStyle.styles = angular.copy(s.styles, {});
            $scope.tmpStyle.correctStyles = angular.copy(s.correctStyles, {});
            $scope.tmpStyle.panelStyles = angular.copy(p.styles, {});
            $scope.tmpStyle.size = angular.copy(s.size, {});
            $scope.tmpStyle.correctStyles[style] = parseInt($scope.tmpStyle.styles[style]);
        }

        if ('' !== style) {
            s.styles[style] = v + units;
        }

        $timeout(function() {
            if ('top' === style || 'left' === style) {
                p.styles.top = s.styles.top;
                p.styles.left = s.styles.left;
            }

            p.styles.width = (s.node.offsetWidth || 0) + 'px';
            p.styles.height = (s.node.offsetHeight || 0) + 'px';
            s.size = {
                width: s.node.offsetWidth,
                height: s.node.offsetHeight
            };
            if (!notSave) {
                $timeout.cancel($scope.tmpStyle.timer);
                $scope.tmpStyle.timer = $timeout(function() {
                    $scope.tmpStyle.timer = null;

                    e = {
                        type: 'setStyles',
                        slideIndex: $scope.slideEditor.cSlide,
                        blockIndex: $scope.slideEditor.cBlock,
                        oldStyles: $scope.tmpStyle.styles,
                        newStyles: angular.copy(s.styles, {}),
                        oldCorrectStyles: $scope.tmpStyle.correctStyles,
                        newCorrectStyles: angular.copy(s.correctStyles, {}),
                        oldPanelStyles: $scope.tmpStyle.panelStyles,
                        newPanelStyles: angular.copy(p.styles, {}),
                        oldSize: $scope.tmpStyle.size,
                        newSize: angular.copy(s.size, {})
                    };

                    if (null !== $scope.tmpStyle.saveProportions) {
                        e.oldSaveProportions = $scope.tmpStyle.saveProportions;
                        e.newSaveProportions = s.saveProportions;
                    }

                    $scope.$broadcast('savingActionAddEvent', { event: e });
                    $scope.tmpStyle.styles = null;
                    $scope.tmpStyle.correctStyles = null;
                    $scope.tmpStyle.panelStyles = null;
                    $scope.tmpStyle.saveProportions = null;
                }, 450);
            }
        }, 0);
    };

    $scope.$on('buttonCheckboxEvent', function(e, data) {
        $scope.$apply(function() {
            $scope.slides[$scope.slideEditor.cSlide].blocks[$scope.slideEditor.cBlock].styles['text-align'] = data.target;
        });
    });

    $scope.changeField = function(style, slide, block) {
        var s = $scope.slides[!isNaN(slide) ? slide : $scope.slideEditor.cSlide].blocks[!isNaN(block) ? block : $scope.slideEditor.cBlock],
            p = $scope.slides[!isNaN(slide) ? slide : $scope.slideEditor.cSlide].panel,
            e;

        $timeout(function() {
            if ('top' === style || 'left' === style) {
                p.styles[style] = s.styles[style];
                if (s.fakeImg) {
                    s.fakeImgStyles[style] = s.styles[style];
                }
            }

            if (undefined === slide || slide === $scope.slideEditor.cSlide && block === $scope.slideEditor.cBlock) {
                if (s.saveProportions && 'text' !== s.type) {
                    if ($scope.$$phase) {
                        lib.getProportionsSize(s, style);
                    } else {
                        $scope.$apply(function() {
                            lib.getProportionsSize(s, style);
                        });
                    }
                }

                p.styles.width = (s.node.offsetWidth || 0) + 'px';
                p.styles.height = (s.node.offsetHeight || 0) + 'px';
                if ('text' === s.type) {
                    s.size = {
                        width: s.node.offsetWidth,
                        height: s.node.offsetHeight
                    };
                }

                if (s.fakeImg) {
                    s.fakeImgStyles.width = p.styles.width;
                    s.fakeImgStyles.height = p.styles.height;
                }
            }

            if (undefined === slide) {
                $timeout.cancel($scope.tmpStyle.timer);
                $scope.tmpStyle.timer = $timeout(function() {
                    if ('auto' === s.styles[style] || (/(%|px)$/.test(s.styles[style]))) {
                        $scope.tmpStyle.timer = null;
                        e = {
                            type: 'setStyles',
                            slideIndex: $scope.slideEditor.cSlide,
                            blockIndex: $scope.slideEditor.cBlock,
                            oldStyles: $scope.tmpStyle.styles,
                            newStyles: angular.copy(s.styles, {}),
                            oldPanelStyles: $scope.tmpStyle.panelStyles,
                            newPanelStyles: angular.copy(p.styles, {}),
                            oldSize: $scope.tmpStyle.size,
                            newSize: angular.copy(s.size, {})
                        };
                        if (s.fakeImg) {
                            e.oldFakeImg = $scope.tmpStyle.fakeImg;
                            e.newFakeImg = angular.copy(s.fakeImgStyles, {});
                        }

                        if (null !== $scope.tmpStyle.saveProportions) {
                            e.oldSaveProportions = $scope.tmpStyle.saveProportions;
                            e.newSaveProportions = s.saveProportions;
                        }

                        $scope.$broadcast('savingActionAddEvent', { event: e });
                        $scope.tmpStyle.styles = null;
                        $scope.tmpStyle.fakeImg = null;
                        $scope.tmpStyle.panelStyles = null;
                        $scope.tmpStyle.size = null;
                        $scope.tmpStyle.saveProportions = null;
                    }
                }, 450);
            }
        }, 0);
    };

    $scope.$on('blockOptionsEvent', function(e, args) {
        var opt;
        if ('slideshow' === args.type) {
            opt = $scope.slideshowOptions;
        } else if ('slide' === args.type) {
            opt = $scope.slides[$scope.slideEditor.cSlide].slideOptions;
        } else {
            opt = $scope.slides[$scope.slideEditor.cSlide].blocks[$scope.slideEditor.cBlock].options;
        }
        angular.forEach(opt, function(v) {
            if (args.name === v.name) {
                v.value = args.value;
            }
        });
    });

    $scope.$on('keepColorEvent', function(ev, data) {
        var s = $scope.slides[$scope.slideEditor.cSlide],
            b = s.blocks[$scope.slideEditor.cBlock], e;

        if (!$rootScope.colorPickerOpened) { return; }

        if (lib.checkArr(['box-shadow', 'text-shadow', 'background-color'], data.style)) {
            if (!$scope.tmpStyle.styles) {
                $scope.tmpStyle.styles = angular.copy(b.styles, {});
                $scope.tmpStyle.correctStyles = angular.copy(b.correctStyles, {});
                $scope.tmpStyle.size = angular.copy(b.size, {});
            }

            if ('background-color' === data.style) {
                $scope.setBGColor();
            } else {
                $scope.setShadow(data.style);
            }
        } else {
            if (!$scope.tmpStyle.styles) {
                $scope.tmpStyle.styles = angular.copy(b.styles, {});
                $scope.tmpStyle.styles[data.style] = data.oldValue;
                $scope.tmpStyle.size = angular.copy(b.size, {});
            }
        }

        $timeout.cancel($scope.tmpStyle.timer);
        $scope.tmpStyle.timer = $timeout(function() {
            $scope.tmpStyle.timer = null;

            e = {
                type: 'setStyles',
                slideIndex: $scope.slideEditor.cSlide,
                blockIndex: $scope.slideEditor.cBlock,
                oldStyles: $scope.tmpStyle.styles,
                newStyles: angular.copy(b.styles, {})
            };

            if (null !== $scope.tmpStyle.saveProportions) {
                e.oldSaveProportions = $scope.tmpStyle.saveProportions;
                e.newSaveProportions = b.saveProportions;
            }

            $scope.$broadcast('savingActionAddEvent', { event: e });
            $scope.tmpStyle.styles = null;
            $scope.tmpStyle.correctStyles = null;
            $scope.tmpStyle.saveProportions = null;
            $scope.tmpStyle.size = null;
        }, 450);
    });

    $scope.selectSlide = function(e) {
        var click = true,
            target = e.target, editorScope,
            cs = $scope.slides[$scope.slideEditor.cSlide],
            check = function(node) {
                if (node === cs.panel.node) {
                    click = false;
                }

                if (click) {
                    angular.forEach(cs.blocks, function(b) {
                        if (node === b.wrapper) {
                            click = false;
                        }
                    });
                }
            };

        if (1 === e.which) {
            // TODO video - acpManager.close();
            acpManager.close();
            globalMenuAPI.close();
            e.stopPropagation();
            if ('BUTTON' !== e.target.tagName && click) {
                if ($scope.slides.length > 0 && null !== $scope.slideEditor.cSlide && null !== $scope.slideEditor.cBlock) {
                    while(click && target !== $window.document.body) {
                        check(target);
                        target = target.parentNode;
                    }
                    if (click) {
                        e.preventDefault();

                        $scope.$broadcast('slidePreviewUpdateEvent', {
                            index: $scope.slideEditor.cSlide
                        });

                        $scope.toggleBlocks(null);
                        $scope.$broadcast('activeBlockEvent', {
                            index: null
                        });
                    }
                }
            }
        }
    };

    $scope.preserveProportions = function() {
        if ($scope.slides[$scope.slideEditor.cSlide].blocks[$scope.slideEditor.cBlock].saveProportions) {
            $scope.tmpStyle.saveProportions = false;
            $scope.restoreProportions();
        } else {
            $scope.tmpStyle.saveProportions = true;
        }
    };

    $scope.restoreProportions = function() {
        $scope.$broadcast('auxiliaryPanelRestoreProportionsEvent');
    };

    $scope.createFakeImg = function() {
        var fakeImgStyles, fakeImg = angular.element(new Image());
        fakeImg.attr('src', 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNgYAAAAAMAASsJTYQAAAAASUVORK5CYII=');

        fakeImgStyles = {
            'top': '10%',
            'left': '10%',
            'width': '100%',
            'height': '100%',
            'position': 'absolute',
            'z-index': 100
        };
        fakeImg.bind('click', function(e) {
            e.preventDefault();
        });

        fakeImg.addClass('video-border');

        return {
            img: fakeImg,
            style: fakeImgStyles
        };
    };

    $scope.setShadow = function(style, notSave) {
        var cs = $scope.slides[$scope.slideEditor.cSlide],
            cb = cs.blocks[$scope.slideEditor.cBlock],
            crst = cb.correctStyles, color, inset, t, e;

        !style && (style = 'box-shadow');

        t = 'box-shadow' === style ? 'b' : 't';

        color = crst[t + 's-color'];
        inset = crst[t + 's-inset'] ? 'inset' : '';


        if (!$scope.tmpStyle.styles && !notSave) {
            $scope.tmpStyle.styles = angular.copy(cb.styles, {});
            $scope.tmpStyle.correctStyles = angular.copy(cb.correctStyles, {});
            $scope.tmpStyle.size = angular.copy(cb.size, {});
            $scope.tmpStyle.correctStyles[style] = parseInt($scope.tmpStyle.styles[style]);
        }

        if ('box-shadow' === style) {
            cb.styles['box-shadow'] = crst['bs-x'] + 'px ' + crst['bs-y'] + 'px ' + crst['bs-blur'] + 'px ' + crst['bs-size'] + 'px ' + color + ' ' + inset;
        } else {
            cb.styles['text-shadow'] = crst['ts-x'] + 'px ' + crst['ts-y'] + 'px ' + crst['ts-blur'] + 'px ' + color + ' ' + inset;
        }

        $timeout(function() {
            if (!notSave) {
                $timeout.cancel($scope.tmpStyle.timer);
                $scope.tmpStyle.timer = $timeout(function() {
                    $scope.tmpStyle.timer = null;

                    e = {
                        type: 'setStyles',
                        slideIndex: $scope.slideEditor.cSlide,
                        blockIndex: $scope.slideEditor.cBlock,
                        oldStyles: $scope.tmpStyle.styles,
                        newStyles: angular.copy(cb.styles, {}),
                        oldCorrectStyles: $scope.tmpStyle.correctStyles,
                        newCorrectStyles: angular.copy(cb.correctStyles, {}),
                        oldSize: $scope.tmpStyle.size,
                        newSize: angular.copy(cb.size, {})
                    };

                    if (null !== $scope.tmpStyle.saveProportions) {
                        e.oldSaveProportions = $scope.tmpStyle.saveProportions;
                        e.newSaveProportions = s.saveProportions;
                    }

                    $scope.$broadcast('savingActionAddEvent', { event: e });
                    $scope.tmpStyle.styles = null;
                    $scope.tmpStyle.correctStyles = null;
                    $scope.tmpStyle.saveProportions = null;
                    $scope.tmpStyle.size = null;
                }, 450);
            }
        }, 0);
    };

    $scope.setBGColor = function(slideBG, notSave) {
        var cs = $scope.slides[$scope.slideEditor.cSlide],
            cb, receiving, crst, color, value, e;

        if (!cs.blocks) { return; }

        cb = cs.blocks[$scope.slideEditor.cBlock];
        receiving = slideBG ? cs : cb;
        crst = receiving.correctStyles;
        color = crst['bg-color'];

        if (!$scope.tmpStyle.styles && !slideBG) {
            $scope.tmpStyle.styles = angular.copy(cb.styles, {});
            $scope.tmpStyle.correctStyles = angular.copy(cb.correctStyles, {});
            $scope.tmpStyle.size = angular.copy(cb.size, {});
        }

        value = color;

        receiving.styles['background-color'] = value;

        $timeout(function() {
            if (!notSave && !slideBG) {
                $timeout.cancel($scope.tmpStyle.timer);
                $scope.tmpStyle.timer = $timeout(function() {
                    $scope.tmpStyle.timer = null;

                    e = {
                        type: 'setStyles',
                        slideIndex: $scope.slideEditor.cSlide,
                        blockIndex: $scope.slideEditor.cBlock,
                        oldStyles: $scope.tmpStyle.styles,
                        newStyles: angular.copy(cb.styles, {}),
                        oldCorrectStyles: $scope.tmpStyle.correctStyles,
                        newCorrectStyles: angular.copy(cb.correctStyles, {}),
                        oldSize: $scope.tmpStyle.size,
                        newSize: angular.copy(cb.size, {})
                    };

                    if (null !== $scope.tmpStyle.saveProportions) {
                        e.oldSaveProportions = $scope.tmpStyle.saveProportions;
                        e.newSaveProportions = s.saveProportions;
                    }

                    $scope.$broadcast('savingActionAddEvent', { event: e });
                    $scope.tmpStyle.styles = null;
                    $scope.tmpStyle.correctStyles = null;
                    $scope.tmpStyle.saveProportions = null;
                    $scope.tmpStyle.size = null;
                }, 450);
            }
        }, 0);
    };

    $scope.$on('controlPanelBlocksEvent', function(e, data) {
        var lbi = $scope.slideEditor.cBlock;
        if ('remove' === data.type) {
            if (null === $scope.slideEditor.cBlock || undefined === $scope.slideEditor.cBlock) {
                return;
            }

            $scope.$broadcast('editSlideEvent', {
                type: 'remove'
            });

            $scope.slideEditor.cBlock = null;
            if ($scope.slides[$scope.slideEditor.cSlide].backgroundBlock) {
                $scope.slides[$scope.slideEditor.cSlide].backgroundBlock = null;
            }
            $scope.toggleBlocks();
            $scope.$broadcast('slidePreviewUpdateEvent', {
                index: $scope.slideEditor.cSlide
            });
        } else if ('createNewBlock' === data.type) {
            var fi, cs = $scope.slides[$scope.slideEditor.cSlide],
                block = {};
                // angular.copy($scope.defBlock, block);
                // angular.copy($scope.defaults.blockOptions, block.options);
                block = angular.copy($scope.defBlock, {});
                block.options = angular.copy($scope.defaults.blockOptions, []);
                block.index = cs.blocks.length;

            switch (data.blockType) {
                case 'text':
                    block.type = 'text';
                    break;
                case 'button':
                    block.type = 'button';
                    block.content = '<p style="line-height:1;"><span style="font-size: 14px;">Button text..</span></p>';
                    block.link = true;
                    block.correctStyles['padding'] = 8;
                    block.correctStyles['bg-color'] = 'rgba(173,173,173,1)';
                    block.correctStyles['background-color'] = 'rgba(173,173,173,1)';
                    break;
                case 'shape':
                    block.type = 'shape';
                    block.correctStyles['top'] = '10%';
                    block.correctStyles['left'] = '10%';
                    block.correctStyles['bg-color'] = 'rgba(173,173,173,1)';
                    block.correctStyles['background-color'] = 'rgba(173,173,173,1)';
                    block.saveProportions = false;
                    break;
                case 'image':
                    block.type = 'image';
                    block.url = data.url;
                    block.base64 = data.base64;
                    block.imgName = data.name;
                    block.imgId = data.imgId;

                    if (data.full) {
                        block.isBackground = true;
                    }

                    // var img = angular.element('<img>');
                    // img.attr('src', data.base64 || data.url || $rootScope.defaultContent.img);
                    // cs.thumbnails.img.list.push(img[0]);
                    break;
                case 'video':
                    block.type = 'video';
                    block.video.videoType = data.videoType;
                    block.url = data.url;
                    fi = $scope.createFakeImg();
                    block.fakeImg = fi.img;
                    block.fakeImgStyles = fi.style;
                    block.isnocookie = data.isnocookie;

                    break;
            }
            cs.blockNumber += 1;
            block.title = block.type + cs.blockNumber;

            // $scope.slides[$scope.slideEditor.cSlide.index].blocks.push(block);
            $scope.$broadcast('editorEvent', {
                type: 'newBlock',
                index: $scope.slideEditor.cSlide,
                newBlock: block
            });
        }
    });

    $scope.$on('orderBlocksEvent', function(e, data) {
        var indexes = [];
        angular.forEach($scope.slides[$scope.slideEditor.cSlide].blocks, function(b) {
            indexes.push(b.styles['z-index']);
        });

        $scope.$broadcast('savingActionAddEvent', {
            event: {
                type: 'zIndex',
                slideIndex: $scope.slideEditor.cSlide,
                blockIndex: $scope.slideEditor.cBlock,
                oldIndexes: data.oldIndexes,
                newIndexes: indexes
            }
        });
    });

    // $scope.$on('customCssEvent', function(e, data) {
    //     var s = $scope.slides[$scope.slideEditor.cSlide],
    //         b = s.blocks[$scope.slideEditor.cBlock];
    //     if ('changeCss' === data.type) {
    //         angular.forEach(data.oldValue, function(value, key) {
    //             delete b.styles[key];
    //         });
    //         angular.forEach(data.newValue, function(value, key) {
    //             var allow = true;
    //             if ('' != key) {
    //                 angular.forEach($rootScope.dataCss, function(v) {
    //                     if (v === key) {
    //                         allow = false;
    //                     }
    //                 });
    //                 if (allow) {
    //                     b.styles[key] = value;
    //                 }
    //             }
    //         });
    //         if (!$scope.tmpStyle.customCss) {
    //             $scope.tmpStyle.customCss = angular.copy(data.oldValue, {});
    //             $scope.tmpStyle.styles = angular.copy(b.styles, {});
    //             $scope.tmpStyle.size = angular.copy(s.size, {});
    //         }
    //         $timeout.cancel($scope.tmpStyle.timer);
    //         $scope.tmpStyle.timer = $timeout(function() {
    //             $scope.tmpStyle.timer = null;
    //             $scope.$broadcast('savingActionAddEvent', {
    //                 event: {
    //                     type: 'setStyles',
    //                     customCss: true,
    //                     slideIndex: $scope.slideEditor.cSlide,
    //                     blockIndex: $scope.slideEditor.cBlock,
    //                     oldStyles: $scope.tmpStyle.styles,
    //                     newStyles: angular.copy(b.styles, {}),
    //                     oldCustomCss: $scope.tmpStyle.customCss,
    //                     newCustomCss: angular.copy(data.newValue, {}),
    //                     oldSize: $scope.tmpStyle.size,
    //                     newSize: angular.copy(s.size, {})
    //                 }
    //             });
    //             $scope.tmpStyle.styles = null;
    //             $scope.tmpStyle.customCss = null;
    //             $scope.tmpStyle.size = null;
    //         }, 450);
    //     }
    // });

    $scope.$on('slideMoveEvent', function(e, data) {
        var s, arr = [], oldSlides, oldActiveSlide;

        if ( null !== data.cIndex ) {
            if (data.cIndex !== $scope.slideEditor.cSlide) {
                $scope.activateSlide(data.cIndex);
            }
        } else {
            oldActiveSlide = $scope.slideEditor.cSlide;
            angular.forEach(data.elements, function(el, i) {
                s = $scope.slides[parseInt(angular.element(el.node).attr('index'))];

                if (s.focusClass === 'active') {
                    $scope.slideEditor.cSlide = i;
                }
                s.index = i;
                angular.forEach(s.blocks, function(b, j) {
                    if ('name' in b.ta && b.ta.name !== null && b.ta.name !== '') {
                        b.ta.name = 'slide' + i + 'text' + j;
                    }
                });
                arr.push(s);
            });

            $scope.$apply(function() {
                oldSlides = $scope.slides;
                $scope.slides = [];
            });

            $scope.$apply(function() {
                $scope.slides = arr;
                $scope.$broadcast('savingActionAddEvent', {
                    event: {
                        type: 'moveSlide',
                        newSlideIndex: $scope.slideEditor.cSlide,
                        oldSlideIndex: oldActiveSlide,
                        newSlides: arr,
                        oldSlides: oldSlides
                    }
                });
                $scope.toggleBlocks(null);
            });
        }

        $scope.$broadcast('slidePreviewUpdateEvent', {
            index: $scope.slideEditor.cSlide
        });
    });

    $scope.toggleBlocks = function(index) {
        $scope.slideEditor.cBlock = index;
        $scope.slides[$scope.slideEditor.cSlide].activeBlock = index;

        if (!$scope.$$phase) {
            $scope.$apply(function() {
                activeTab.currentTab.index = 0;
            });
        } else {
            activeTab.currentTab.index = 0;
        }

        if (null !== index && undefined !== index) {
            // $scope.slideEditor.title = $scope.slides[$scope.slideEditor.cSlide].blocks[$scope.slideEditor.cBlock].type;
            $scope.slideEditor.title = $scope.slides[$scope.slideEditor.cSlide].blocks[$scope.slideEditor.cBlock].title;
            $scope.slideEditor.flags.slide = false;
            $scope.slideEditor.flags.block = true;
        } else {
            $scope.slideEditor.title = 'Slide ' + ($scope.slideEditor.cSlide + 1) + '.';
            $scope.slideEditor.flags.slide = true;
            $scope.slideEditor.flags.block = false;
        }
    };

    $scope.outlineClick = function(e) {
        var b = angular.element(e.target);
        if (b[0].tagName.toLowerCase() !== 'i') {
            b = b.find('i');
        }

        if ($rootScope.outlineIsShow) {
            b.removeClass('flaticon-visibility-off');
            b.addClass('flaticon-eye-close-up');
        } else {
            b.removeClass('flaticon-eye-close-up');
            b.addClass('flaticon-visibility-off');
        }

        $rootScope.outlineIsShow = !$rootScope.outlineIsShow;
    }

    $scope.$on('toggleBlockEvent', function(e, data) {
        $scope.$broadcast('slidePreviewUpdateEvent', {
            index: $scope.slideEditor.cSlide
        });

        globalMenuAPI.close();

        if (data.newBlock) {
            $scope.$broadcast('savingActionAddEvent', {
                event: {
                    type: 'newBlock',
                    slideIndex: $scope.slideEditor.cSlide,
                    index: data.index,
                    options: data.options,
                    title: data.title,
                    blockType: data.blockType,
                    imgName: data.imgName,
                    base64: data.base64,
                    videoType: data.videoType,
                    url: data.url,
                    lastActiveBlock: $scope.slideEditor.cBlock
                }
            });
        }
        $scope.toggleBlocks(data.index);
    });

    // on remove
    $scope.$on('editorRmoveBlockEvent', function(e, data) {
        if (!data.noSaveAction) {
            $scope.$broadcast('savingActionAddEvent', {
                event: {
                    type: 'removeBlock',
                    slideIndex: $scope.slideEditor.cSlide,
                    blockIndex: $scope.slideEditor.cBlock,
                    block: data.node
                }
            });
        }
        $scope.$broadcast('slidePreviewUpdateEvent', {
            index: $scope.slideEditor.cSlide
        });
    });

    $scope.$on('removeSlideEvent', function(e, data) {
        var index = parseInt(data.index);
        $scope.removeSlide(index);
    });

    $scope.$on('savingActionToggle', function(e, data) {
        globalMenuAPI.close();
        if ('newSlide' === data.event.type) {
            /**
             * event: {
             *     type: newSlide ? 'newSlide' : 'activateSlide',
             *     index: index,
             *     slide: $scope.slides[index],
             *     lastActiveSlide: $scope.slideEditor.cSlide
             * }
             */
            if ('prev' === data.action) {
                $scope.slides[$scope.slideEditor.cSlide].focusClass = '';
                $scope.slideEditor.cSlide = data.event.slide.index;

                // angular.forEach($scope.slides[$scope.slideEditor.cSlide].blocks, function(b) {
                //     if ('text' === b.type && b.ta.isActive) {
                //         b.ta.isActive = false;
                //         b.node.innerHTML = b.content;
                //     }
                // });

                $scope.removeSlide(data.event.index, data.event.lastActiveSlide, true, data.deferred);
            } else {
                $scope.slides.push(data.event.slide);
                $scope.activateSlide(data.event.index, true, data.deferred);
            }
        } else if ('removeSlide' === data.event.type) {
            /**
             * event: {
             *     type: 'removeSlide',
             *     activeIndex: '',
             *     index: i,
             *     slide: s
             * }
             */
            if ('prev' === data.action) {
                var rewriteIndex = false, lastItem = data.event.index === $scope.slides.length, arr = [];
                angular.forEach($scope.slides, function(s, i) {
                    if (i === data.event.index) {
                        arr.push(data.event.slide);
                        rewriteIndex = true;
                    }

                    s.focusClass = '';
                    arr.push(s);
                    if (rewriteIndex) {
                        arr[arr.length - 1].index = arr.length - 1;
                    }
                });
                if (lastItem) {
                    arr.push(data.event.slide);
                }
                $scope.$apply(function() {
                    $scope.slides = arr;
                    $scope.activateSlide(data.event.activeIndex, true, data.deferred);
                });
            } else {
                $scope.slides[$scope.slideEditor.cSlide].focusClass = '';
                $scope.slideEditor.cSlide = data.event.activeIndex;
                $scope.removeSlide(data.event.index, undefined, true, data.deferred);
            }
        } else if ('moveSlide' === data.event.type) {
            /**
             *  event: {
             *      type: 'moveBlock',
             *      activeSlide: $scope.slideEditor.cSlide,
             *      oldActiveSlide: oldActiveSlide,
             *      newSlides: arr,
             *      oldSlides: oldSlides
             *  }
             */

            $scope.$apply(function() {
                $scope.slides = [];
            });
            $scope.$apply(function() {
                if ('prev' === data.action) {
                    $scope.slides = data.event.oldSlides;
                    $scope.slideEditor.cSlide = data.event.oldSlideIndex;
                    angular.forEach($scope.slides, function(s, i) {
                        s.index = i;
                        if (s.index !== data.event.oldSlideIndex) {
                            s.focusClass = '';
                        }
                    });
                    $scope.activateSlide(data.event.oldSlideIndex, true);
                    // $scope.slideEditor.cSlide = data.event.oldSlideIndex;
                } else {
                    $scope.slides = data.event.newSlides;
                    $scope.slideEditor.cSlide = data.event.newSlideIndex;
                    angular.forEach($scope.slides, function(s, i) {
                        s.index = i;
                        if (s.index !== data.event.newSlideIndex) {
                            s.focusClass = '';
                        }
                    });
                    $scope.activateSlide(data.event.newSlideIndex, true);
                    // $scope.slideEditor.cSlide = data.event.newSlideIndex;
                }
                $scope.toggleBlocks(null);
                data.deferred.resolve();
            });
        } else if ('newBlock' === data.event.type) {
            /**
             * event: {
             *     type: 'newBlock',
             *     slideIndex: $scope.slideEditor.cSlide,
             *     index: data.index,
             *     blockType: data.blockType,
             *     imgName: data.imgName,
             *     base64: data.base64,
             *     videoType: data.videoType,
             *     url: data.url,
             *     lastActiveBlock: $scope.slideEditor.cBlock
             * }
             */

            var action = function() {
                if ('prev' === data.action) {
                    $scope.$apply(function() {
                        $scope.$broadcast('editSlideEvent', {
                            type: 'remove',
                            lastActiveBlock: data.event.lastActiveBlock,
                            blockIndex: data.event.index,
                            noSaveAction: true,
                            cb: function() {
                                $scope.toggleBlocks(data.event.lastActiveBlock);
                                $scope.$broadcast('slidePreviewUpdateEvent', {
                                    index: $scope.slideEditor.cSlide,
                                    cb: function() {
                                        data.deferred.resolve();
                                    }
                                });
                            }
                        });
                    });
                } else {
                    $scope.$apply(function() {
                        var fi, cs = $scope.slides[$scope.slideEditor.cSlide],
                        block = {};
                        block = angular.copy($scope.defBlock, {});

                        if ('button' === data.event.blockType || 'shape' === data.event.blockType) {
                            block.correctStyles['bg-color'] = 'rgba(173,173,173,1)';
                            block.correctStyles['background-color'] = 'rgba(173,173,173,1)';

                            if ('button' === data.event.blockType) {
                                block.content = '<p style="line-height:1;"><span style="font-size: 14px;">Button text..</span></p>';
                                block.link = true;
                                block.correctStyles['padding'] = 8;
                            } else {
                                block.correctStyles['top'] = '10%';
                                block.correctStyles['left'] = '10%';
                                block.saveProportions = false;
                            }
                        }

                        // block.options = angular.copy($scope.defaults.blockOptions, []);
                        block.options = data.event.options;

                        block.index = cs.blocks.length;

                        block.title = data.event.title;


                        block.type = data.event.blockType;
                        block.url = data.event.url;
                        block.base64 = data.event.base64;
                        block.video.videoType = data.event.videoType;

                        fi = $scope.createFakeImg();
                        block.fakeImg = fi.img;
                        block.fakeImgStyles = fi.style;

                        $scope.$broadcast('editorEvent', {
                            type: 'newBlock',
                            noSaveAction: true,
                            index: $scope.slideEditor.cSlide,
                            newBlock: block,
                            cb: function() {
                                data.deferred.resolve();
                            }
                        });
                    });
                }
            };
            if ($scope.slideEditor.cSlide !== data.event.slideIndex) {
                $scope.$apply(function() {
                    $scope.activateSlide(data.event.slideIndex, true, false, function() {
                        action();
                    });
                });
            } else {
                action();
            }
        } else if ('removeBlock' === data.event.type) {
            /**
             * event: {
             *     type: 'removeBlock',
             *     slideIndex: $scope.slideEditor.cSlide,
             *     blockIndex: $scope.slideEditor.cBlock,
             *     block: data.node
             * }
             */

            var action = function() {
                if ('prev' === data.action) {
                    // add
                    $scope.$broadcast('editorEvent', {
                        type: 'newBlock',
                        noSaveAction: true,
                        inStore: true,
                        index: $scope.slideEditor.cSlide,
                        newBlock: data.event.block,
                        cb: function() {
                            $scope.toggleBlocks(data.event.blockIndex);
                            data.deferred.resolve();
                        }
                    });
                } else {
                    // remove
                    $scope.$broadcast('editSlideEvent', {
                        type: 'remove',
                        blockIndex: data.event.blockIndex,
                        lastActiveBlock: null,
                        noSaveAction: true,
                        cb: function() {
                            $scope.toggleBlocks(data.event.lastActiveBlock);
                            data.deferred.resolve();
                        }
                    });
                }
            };
            if ($scope.slideEditor.cSlide !== data.event.slideIndex) {
                $scope.$apply(function() {
                    $scope.activateSlide(data.event.slideIndex, true, false, function() {
                        action();
                    });
                });
            } else {
                action();
            }
        } else if ('setStyles' === data.event.type) {
            /**
             * event: {
             *     type: 'setStyles',
             *     slideIndex: $scope.slideEditor.cSlide,
             *     blockIndex: $scope.slideEditor.cBlock,
             *     oldStyles: $scope.tmpStyle.oldStyles,
             *     newStyles: angular.copy(s.styles, {}),
             *     oldCorrectStyles: $scope.tmpStyle.oldCorrectStyles,
             *     newCorrectStyles: angular.copy(s.correctStyles, {}),
             *     oldPanelStyles: $scope.tmpStyle.panelStyles,
             *     newPanelStyles: angular.copy(p.styles, {})
             *     oldSize: $scope.tmpStyle.size,
             *     newSize: angular.copy(s.size, {},
             *     oldFakeImg = $scope.tmpStyle.fakeImg,
             *     newFakeImg = angular.copy(b.fakeImgStyles, {}),
             *     oldContent: $scope.tmpStyle.content,
             *     newContent: angular.copy(b.content, {}),
             *     oldCustomCss: $scope.tmpStyle.customCss,
             *     newCustomCss: data.newValue,
             * }
             */

            $rootScope.dontsave = true;
            var s = $scope.slides[data.event.slideIndex],
                b = s.blocks[data.event.blockIndex],
                action = function() {
                    $scope.toggleBlocks(data.event.blockIndex);
                    $scope.$broadcast('activeBlockEvent', {
                        index: data.event.blockIndex,
                        cb: function() {
                            if ('prev' === data.action) {
                                $scope.$apply(function() {
                                    data.event.oldStyles && (b.styles = angular.copy(data.event.oldStyles, {}));
                                    data.event.oldCorrectStyles && (b.correctStyles = angular.copy(data.event.oldCorrectStyles, {}));
                                    data.event.oldPanelStyles && (s.panel.styles = angular.copy(data.event.oldPanelStyles, {}));
                                    data.event.oldSize && (b.size = angular.copy(data.event.oldSize, {}));
                                    data.event.oldFakeImg && (b.fakeImgStyles = angular.copy(data.event.oldFakeImg, {}));
                                    data.event.oldContent && (b.content = data.event.oldContent);

                                    if (undefined !== data.event.oldSaveProportions) {
                                        b.saveProportions = data.event.oldSaveProportions;
                                    }
                                    data.deferred.resolve();
                                });
                                if (data.event.oldCustomCss) {
                                    $scope.$apply(function() {
                                        b.customCss = angular.copy(data.event.oldCustomCss, {});
                                    });
                                }
                                // if (data.event.oldContent) {
                                //     b.node.innerHTML = data.event.oldContent;
                                //     $compile(angular.element(b.node).contents())($scope);
                                // }
                            } else {
                                $scope.$apply(function() {
                                    data.event.newStyles && (b.styles = angular.copy(data.event.newStyles, {}));
                                    data.event.newCorrectStyles && (b.correctStyles = angular.copy(data.event.newCorrectStyles, {}));
                                    data.event.newPanelStyles && (s.panel.styles = angular.copy(data.event.newPanelStyles, {}));
                                    data.event.newSize && (b.size = angular.copy(data.event.newSize, {}));
                                    data.event.newFakeImg && (b.fakeImgStyles = angular.copy(data.event.newFakeImg, {}));
                                    data.event.newContent && (b.content = data.event.newContent);
                                    if (undefined !== data.event.newSaveProportions) {
                                        b.saveProportions = data.event.newSaveProportions;
                                    }
                                    data.deferred.resolve();
                                });
                                if (data.event.newCustomCss) {
                                    $scope.$apply(function() {
                                        b.customCss = angular.copy(data.event.newCustomCss, {});
                                    });
                                }
                                // if (data.event.newContent) {
                                //     b.node.innerHTML = data.event.newContent;
                                //     $compile(angular.element(b.node).contents())($scope);
                                // }
                            }
                        }
                    });
                };

            if ($scope.slideEditor.cSlide !== data.event.slideIndex) {
                $scope.$apply(function() {
                    $scope.activateSlide(data.event.slideIndex, true, false, function() {
                        action();
                    });
                });
            } else {
                action();
            }

            // if (data.event.customCss) {
            //     $scope.$broadcast('customCssUpdateEvent');
            // }
        } else if ('canvasResize' === data.event.type) {
            /**
             * event: {
             *     type: 'canvasResize',
             *     slideIndex: cs.index,
             *     blockIndex: cb.index,
             *     oldSise: {},
             *     newSize: {}
             * }
             */

            var b = $scope.slides[data.event.slideIndex].blocks[data.event.blockIndex],
                setBlockIndex = function() {
                    if (null !== data.event.blockIndex && $scope.slideEditor.cBlock !== data.event.blockIndex) {
                        $scope.toggleBlocks(data.event.blockIndex);
                        $scope.$broadcast('activeBlockEvent', {
                            index: data.event.blockIndex,
                            cb: function() {
                                action();
                            }
                        });
                    } else {
                        action();
                    }
                },
                action = function() {
                    var w, h, p;
                    if ('prev' === data.action) {
                        w = parseInt(data.event.oldSize.width);
                        h = parseInt(data.event.oldSize.height);
                        p = data.event.oldProportions;
                    } else {
                        w = parseInt(data.event.newSize.width);
                        h = parseInt(data.event.newSize.height);
                        p = data.event.newProportions;
                    }

                    $timeout.cancel($scope.globalMenuTimer);

                    $scope.$broadcast('edtorZoomEvent', {type: 'resize', param: {
                        width: w,
                        height: h,
                        callback: function() {
                            $timeout(function() {
                                $scope.proportionsIsSet = p;
                                angular.forEach($scope.slides[data.event.slideIndex].blocks, function(b_) {
                                    var w_ = b_.node.offsetWidth + 'px',
                                        h_ = b_.node.offsetHeight + 'px';

                                    if (b_.isBackground) {
                                        angular.element(b_.outline).css({
                                            'top': (h - parseInt(h_)) / 2 + 'px',
                                            'left': (w - parseInt(w_)) / 2 + 'px',
                                        });
                                    }

                                    angular.element(b_.outline).css({
                                        'width': w_,
                                        'height': h_
                                    });
                                });
                            }, 0);
                        }
                    }});

                    $scope.$broadcast('slidePreviewSlideSizeEvent', { width: w, height: h, index: $scope.slideEditor.cSlide });
                    $scope.$$correctBlocksPosition();
                    null !== data.event.blockIndex && $scope.$broadcast('auxiliaryPanelUpdateSizeEvent');
                    data.deferred.resolve();
                };

            if ($scope.slideEditor.cSlide !== data.event.slideIndex) {
                $scope.$apply(function() {
                    $scope.activateSlide(data.event.slideIndex, true, false, function() {
                        setBlockIndex();
                    });
                });
            } else {
                setBlockIndex();
            }
        } else if ('zIndex' === data.event.type) {
            /**
             * event: {
             *    type: 'zIndex',
             *    slideIndex: $scope.slideEditor.cSlide,
             *    blockIndex: $scope.slideEditor.cBlock,
             *    oldIndexes: data.oldIndexes,
             *    newIndexes: indexes
             * }
             */

            var b = $scope.slides[data.event.slideIndex].blocks[data.event.blockIndex],
                setBlockIndex = function() {
                    if ($scope.slideEditor.cBlock !== data.event.blockIndex) {
                        $scope.toggleBlocks(data.event.blockIndex);
                        $scope.$broadcast('activeBlockEvent', {
                            index: data.event.blockIndex,
                            cb: function() {
                                action();
                            }
                        });
                    } else {
                        action();
                    }
                },
                action = function() {
                    angular.forEach($scope.slides[data.event.slideIndex].blocks, function(b, i) {
                        if ('prev' === data.action) {
                            b.styles['z-index'] = data.event.oldIndexes[i];
                        } else {
                            b.styles['z-index'] = data.event.newIndexes[i];
                        }
                    });
                    data.deferred.resolve();
                };

            if ($scope.slideEditor.cSlide !== data.event.slideIndex) {
                $scope.$apply(function() {
                    $scope.activateSlide(data.event.slideIndex, true, false, function() {
                        setBlockIndex();
                    });
                });
            } else {
                setBlockIndex();
            }
        } else if ('setBeckground' === data.event.type) {
            /**
             * event: {
             *     type: 'setBeckground',
             *     slideIndex: cs.index,
             *     blockIndex: cb.index,
             *     isBackground: cb.isBackground
             * }
             */

            var b = $scope.slides[data.event.slideIndex].blocks[data.event.blockIndex],
                setBlockIndex = function() {
                    if ($scope.slideEditor.cBlock !== data.event.blockIndex) {
                        $scope.toggleBlocks(data.event.blockIndex);
                        $scope.$broadcast('activeBlockEvent', {
                            index: data.event.blockIndex,
                            cb: function() {
                                action();
                            }
                        });
                    } else {
                        action();
                    }
                },
                action = function() {
                    b.backgroundOldStyle = data.event.backgroundOldStyle;
                    $scope.setAsBackground({ isBackground: 'prev' === data.action ? data.event.isBackground : !data.event.isBackground });
                    data.deferred.resolve();
                };

            if ($scope.slideEditor.cSlide !== data.event.slideIndex) {
                $scope.$apply(function() {
                    $scope.activateSlide(data.event.slideIndex, true, false, function() {
                        setBlockIndex();
                    });
                });
            } else {
                setBlockIndex();
            }
        }
    });

    $scope.$on('inputStyleEvent', function(ev, data) {
        var s = $scope.slides[$scope.slideEditor.cSlide],
            b = s.blocks[$scope.slideEditor.cBlock], e;
        if ('focus' === data.type) {
            // if (!$scope.tmpStyle.styles) {
            //     $scope.tmpStyle.styles = angular.copy(b.styles, {});
            // }
        } else if ('blur' === data.type) {
            if ($scope.tmpStyle.styles) {
                $scope.tmpStyle.timer = null;

                e = {
                    type: 'setStyles',
                    slideIndex: $scope.slideEditor.cSlide,
                    blockIndex: $scope.slideEditor.cBlock,
                    oldStyles: $scope.tmpStyle.styles,
                    newStyles: angular.copy(b.styles, {}),
                    oldPanelStyles: $scope.tmpStyle.panelStyles,
                    newPanelStyles: angular.copy(s.panel.styles, {}),
                    oldSize: $scope.tmpStyle.size,
                    newSize: angular.copy(s.size, {}),
                    oldFakeImg: $scope.tmpStyle.fakeImg,
                    newFakeImg: angular.copy(b.fakeImgStyles, {})
                };

                if (null !== $scope.tmpStyle.saveProportions) {
                    e.oldSaveProportions = $scope.tmpStyle.saveProportions;
                    e.newSaveProportions = b.saveProportions;
                }

                $scope.$broadcast('savingActionAddEvent', { event: e });
                $scope.tmpStyle.styles = null;
                $scope.tmpStyle.fakeImg = null;
                $scope.tmpStyle.panelStyles = null;
                $scope.tmpStyle.size = null;
                $scope.tmpStyle.saveProportions = null;
            }
        } else if ('change' === data.type) {
            if (!$scope.tmpStyle.styles) {
                $scope.tmpStyle.styles = angular.copy(b.styles, {});
                $scope.tmpStyle.styles[data.typeStyle] = data.oldValue;

                $scope.tmpStyle.panelStyles = angular.copy(s.panel.styles, {});
                $scope.tmpStyle.size = angular.copy(s.size, {});
                $scope.tmpStyle.fakeImg = angular.copy(b.fakeImgStyles, {});
            }
        }
    });

    $scope.$on('auxiliaryPanelMouseDownEvent', function(e, data) {
        var s = $scope.slides[$scope.slideEditor.cSlide],
            b = s.blocks[$scope.slideEditor.cBlock];

        if (!$scope.tmpStyle.styles) {
            $scope.tmpStyle.styles = angular.copy(b.styles, {});

            $scope.tmpStyle.panelStyles = angular.copy(s.panel.styles, {});
            $scope.tmpStyle.size = angular.copy(s.size, {});
            if (b.fakeImg) {
                $scope.tmpStyle.fakeImg = angular.copy(b.fakeImgStyles, {});
            }
        }
    });

    $scope.$on('auxiliaryPanelMouseUpEvent', function(e, data) {
        var s = $scope.slides[$scope.slideEditor.cSlide],
            b = s.blocks[$scope.slideEditor.cBlock], e;

        if ($scope.tmpStyle.styles) {
            $timeout.cancel($scope.tmpStyle.timer);
            if (data.move) {
                $scope.tmpStyle.timer = null;
                e = {
                    type: 'setStyles',
                    slideIndex: $scope.slideEditor.cSlide,
                    blockIndex: $scope.slideEditor.cBlock,
                    oldStyles: $scope.tmpStyle.styles,
                    newStyles: angular.copy(b.styles, {}),
                    oldPanelStyles: $scope.tmpStyle.panelStyles,
                    newPanelStyles: angular.copy(s.panel.styles, {}),
                    oldSize: $scope.tmpStyle.size,
                    newSize: angular.copy(s.size, {})
                };

                if (b.fakeImg) {
                    e.oldFakeImg = $scope.tmpStyle.fakeImg;
                    e.newFakeImg = angular.copy(b.fakeImgStyles, {});
                }

                if (null !== $scope.tmpStyle.saveProportions) {
                    e.oldSaveProportions = $scope.tmpStyle.saveProportions;
                    e.newSaveProportions = b.saveProportions;
                }


                $scope.$broadcast('savingActionAddEvent', {
                    event: e
                });
                $scope.tmpStyle.styles = null;
                $scope.tmpStyle.fakeImg = null;
                $scope.tmpStyle.panelStyles = null;
                $scope.tmpStyle.size = null;
                $scope.tmpStyle.saveProportions = null;
            } else {
                $scope.tmpStyle.styles = null;
                $scope.tmpStyle.fakeImg = null;
                $scope.tmpStyle.panelStyles = null;
                $scope.tmpStyle.size = null;
                $scope.tmpStyle.saveProportions = null;
            }
        }
    });

    $scope.$on('blockTextOldValueEvent', function(e, data) {
        // data.value
        var s = $scope.slides[$scope.slideEditor.cSlide],
            b = s.blocks[$scope.slideEditor.cBlock];

        if (!$scope.tmpStyle.content) {
            $scope.tmpStyle.content = data.value;

            $scope.tmpStyle.panelStyles = angular.copy(s.panel.styles, {});
            $scope.tmpStyle.size = angular.copy(s.size, {});
        }
    });

    $rootScope.$on('resizeAxiliaryPanel', function(e) {
        $scope.setStyles(undefined, undefined,  true);
    });

    $scope.$on('timelineSetActiveBlock', function(e, data) {
        $scope.$broadcast('slidePreviewUpdateEvent', {
            index: $scope.slideEditor.cSlide
        });

        $scope.$broadcast('activeBlockEvent', {
            index: data.index
        });

        if (data.index !== $scope.slideEditor.cBlock) {
            $scope.toggleBlocks(data.index);
        }

        if (data.bg) {
            $scope.setAsBackground();
        }
        data.callback && data.callback();
    });

    $scope.closeConstructor = function() {};

    angular.element(document).ready(function() {
        var i, timer, start = function(arr) {
            $scope.mainField = angular.element($window.document.getElementById('working-field'));
            $scope.$broadcast('edtorZoomEvent', { type: 'first-start' });

            if ('id' in $rootScope.idSlideshow) {} else { $scope.activateSlide(); }

            // timer = $timeout(function() {
            //     $rootScope.loader = true;
            // }, 300);

            angular.forEach(arr, function(s) {
                angular.forEach(s.blocks, function(b) {
                    b.content = b.content.replace(/&#39/g, '\'');
                    b.content = b.content.replace(/&#34/g, '\"');

                    if ("video" === b.type) {
                        b.fakeImg = ($scope.createFakeImg()).img;
                    }
                });
            });

            $scope.$$loadAllImg(function() {
                if (arr) {
                    $scope.slides = arr;
                }

                // $timeout.cancel(timer);
                // $rootScope.loader = false;
                if ($scope.slides.length > 0) {
                    $scope.activateSlide(0);
                    $timeout(function() {
                        $scope.allVisible = false;
                        if (arr) {
                            angular.forEach($scope.slides, function(slide, i) {
                                angular.forEach(slide.blocks, function(block, j) {
                                    if (block.isBackground) {
                                        $scope.setAsBackground(false, {slide: i, block: j});
                                    }
                                });
                            });

                            for (var i = 0; i < arr.length; i++) {
                                $scope.$broadcast('slidePreviewUpdateEvent', {
                                    index: i
                                });
                            }

                            $timeout(function() {
                                getHtmlSlideshow($scope, function(slideshowHTML) {
                                    $rootScope.oldSlideshow = JSON.stringify(slideshowHTML);
                                    $timeout.cancel(timer);
                                    $rootScope.$apply(function() {
                                        $rootScope.loader = false;
                                    });
                                    angular.element($window.document.getElementById('first-load')).remove();
                                });
                            }, 0);
                        } else {
                            $timeout.cancel(timer);
                            $rootScope.$apply(function() {
                                $rootScope.loader = false;
                            });
                            angular.element($window.document.getElementById('first-load')).remove();
                        }
                        if (!('id' in $rootScope.idSlideshow)) {
                            $scope.$broadcast('savingActionReset');
                        }
                    }, 0);
                } else {
                    $timeout.cancel(timer);
                    $rootScope.loader = false;
                    angular.element($window.document.getElementById('first-load')).remove();
                }
            }, arr);
        };

        $rootScope.loader = true;
        getResources([
            paths.json[0],
            paths.json[1],
            paths.json[2],
            paths.json[3]
        ], function(data) {
            var i, noready = false;
            if (data[0]) {
                $scope.defaults.slideshowOptions = data[0];
                $scope.slideshowOptions = angular.copy(data[0], []);
            }

            if (data[3]) {
                $scope.slideshowOptionsGroups = angular.copy(data[3], []);
            }

            $scope.defaults.slideOptions = data[1] && data[1];
            $scope.defaults.blockOptions = data[2] && data[2];

            for (i = 0; i < data.length; i++) {
                if (null === data[i]) {
                    noready = true;
                    break;
                }
            }

            $rootScope.idSlideshow = $location.search();

            if (!noready) {
                messages.ready();
                if (messages.status) {
                    $scope.closeConstructor = function(e) {
                        e.preventDefault();
                        e.stopPropagation();

                        var b = e.target, timer;

                        while ('button' !== b.tagName.toLowerCase()) {
                            b = b.parentNode;
                        }

                        b = angular.element(b);
                        b.attr('disabled', 'disabled');

                        timer = $timeout(function() {
                            b.addClass('loading');
                        }, 250);

                        getHtmlSlideshow($scope, function(slideshowHTML) {
                            var slideshow = JSON.stringify(slideshowHTML);

                            $timeout.cancel(timer);
                            b.removeClass('loading');
                            b.removeAttr('disabled');

                            function blockExist() {
                                var i, result = false;

                                if ($scope.slides.length) {
                                    for (i = 0; i < $scope.slides.length; i++) {
                                        if ($scope.slides[i].blocks.length) {
                                            result = true;
                                            break;
                                        }
                                    }
                                }

                                return result;
                            }

                            if (blockExist() && slideshow !== $rootScope.oldSlideshow) {
                                aModalWindowManager.show('Changes you made may not be saved.', {
                                    saveButtonCallBack: function() {
                                        saveSlideshow($scope, function(err) {
                                            messages.closeConstructor({id: $rootScope.idSlideshow.id});
                                            aModalWindowManager.hide();
                                        });
                                    },
                                    dSaveButtonCallBack: function() {
                                        messages.closeConstructor({id: $rootScope.idSlideshow.id});
                                        aModalWindowManager.hide();
                                    },
                                    cancelButtonCallBack: function() {
                                        aModalWindowManager.hide();
                                    }
                                });
                            } else {
                                messages.closeConstructor({id: $rootScope.idSlideshow.id});
                            }
                        });
                    };
                }
                if ('id' in $rootScope.idSlideshow && messages.status) {
                        messages.setCallbacks({
                            getSlideshowJSON: function(data) {
                                $scope.slideshowLoad(data, function(arr) {
                                    start(arr);
                                });
                            },
                            getSlideshowJSON_fail: function() {
                                $rootScope.idSlideshow = {};
                                start();
                            }
                        });
                        messages.getJSON({id: $rootScope.idSlideshow.id});
                } else {
                    $rootScope.idSlideshow = {};
                    start();
                }
            }
        });
    });

    $scope.slideshowLoad = function(data, callback) {
        var i, arr = [];
        // $scope.slideshowOptions = data[1];
        for (i = 0; i < data[1].length; i++) {
            $scope.slideshowOptions[lib.getOptionIndex($scope.slideshowOptions, data[1][i].name)].value = data[1][i].value;
        }

        angular.forEach($scope.slideshowOptions, function(o) {
            if ('values' in o) {
                o.value = o.value.toString();
                o.values[0] = o.values[0].toString();
                o.values[1] = o.values[1].toString();
            }
        });
        angular.forEach(data[0], function(slide, i) {
            slide.focusClass = '';
            // console.log(window.dataURLtoBlob && $window.URL.createObjectURL(window.dataURLtoBlob(slide.blocks[0].base64)));
            // slide.blocks[0] = window.dataURLtoBlob && $window.URL.createObjectURL(window.dataURLtoBlob(slide.blocks[0].base64));

            function removeTr(obj) {
                for (var i in obj) {
                    if ('$$hashKey' === i) {
                        delete obj[i];
                    } else if (angular.isObject(obj[i])) {
                        removeTr(obj[i]);
                    }
                }
            }
            removeTr(slide);

            angular.forEach(slide.blocks, function(b) {
                if (b.base64) {
                    b.url = b.base64;
                }
            });

            slide.panel.node = null;
            slide.node = angular.element('<div>')[0];

            arr.push(slide);
            // $scope.slides.push(slide);
        });
        callback(arr);
    };

    $rootScope.$watch('outlineIsShow', function(nv) {
        $scope.mainField || ($scope.mainField = angular.element($window.document.getElementById('working-field')));
        if (nv) {
            $scope.mainField.addClass('outline');
        } else {
            $scope.mainField.removeClass('outline');
        }
    });

    function setNewProportions(newValue, oldValue) {
        var cs, cb, i,
            old_w, old_h, new_w, new_h,
            bind;

        if ($rootScope.globalMenuIsOpen) {
            cs = $scope.slides[$scope.slideEditor.cSlide];
            if (cs) {
                cb = cs.blocks[$scope.slideEditor.cBlock];
                i = cb ? cb.index : null;
            } else {
                i = null;
            }

            old_w = oldValue[0] || newValue[0];
            old_h = oldValue[1] || newValue[1];
            new_w = newValue[0];
            new_h = newValue[1];
            bind = function(nv, ov, cs_, cb_) {
                $scope.$broadcast('edtorZoomEvent', { type: 'resize', param: {
                    width: nv[0],
                    height: nv[1],
                    callback: function() {
                        $timeout(function() {
                            angular.forEach(cs.blocks, function(b) {
                                var w_ = b.node.offsetWidth + 'px',
                                    h_ = b.node.offsetHeight + 'px';

                                angular.element(b.outline).css({
                                    'width': w_,
                                    'height': h_
                                });
                            });
                        }, 0);

                        $scope.$broadcast('savingActionAddEvent', {
                            event: {
                                type: 'canvasResize',
                                slideIndex: cs_.index,
                                blockIndex: i,
                                oldSize: { width: ov[0], height: ov[1] },
                                newSize: { width: nv[0], height: nv[1] }
                            }
                        });
                    }
                }});
            };
            $timeout.cancel($scope.globalMenuTimer);
            $scope.globalMenuTimer = $timeout(function() {
                bind([new_w, new_h], [old_w, old_h], cs, cb);
            }, 300);
        }
    }

    $scope.$watch('slideshowOptions[2].value', function(newValue, oldValue) {
        var other = lib.getOption($scope.slideshowOptions, 'base-height').value;
        setNewProportions([newValue, other], [oldValue, other]);
    });

    $scope.$watch('slideshowOptions[3].value', function(newValue, oldValue) {
        var other = lib.getOption($scope.slideshowOptions, 'base-width').value;
        setNewProportions([other, newValue], [other, oldValue]);
    });
}]);
constructorApp.service('slideshowAPI', ['$window', function($window) {
    var isStopSlideshow = false;
    return {
        stop: function() {
            if (!isStopSlideshow && $window.MagicSlideshow) {
                $window.MagicSlideshow.stop();
                isStopSlideshow = true;
            }
        },
        start: function() {
            if ($window.MagicSlideshow) {
                $window.MagicSlideshow.start();
                isStopSlideshow = false;
            }
        }
    };
}]);


constructorApp.service('parseSlide', [function() {
    var m = {
            trim: function(str) {
                return str.replace(/^\s+|\s+$/g, '');
            },

            copy: function(resource) {
                var o,
                    copyObj = function(object_) {
                        var i, obj = {};
                        for(i in object_) {
                            if (!object_.hasOwnProperty(i) || /^\$|^\$\$/.test(i)) continue;
                            if ('node' == i && '' !== object_[i] || 'wrapper' == i && '' !== object_[i]) {
                                obj[i] = object_[i].cloneNode(true);
                            } else if (object_[i] instanceof window.Object && !(object_[i] instanceof window.Function)) {
                                if (Array.isArray(object_[i])) {
                                    obj[i] = copyArray(object_[i]);
                                } else {
                                    obj[i] = copyObj(object_[i]);
                                }
                            } else {
                                obj[i] = object_[i];
                            }
                        }
                        return obj;
                    },
                    copyArray = function(array) {
                        var i, arr = [];
                        for (i = 0; i < array.length; i++) {
                            if (array[i] instanceof window.Object && !(array[i] instanceof window.Function)) {
                                if (Array.isArray(array[i])) {
                                    arr.push(copyArray(array[i]));
                                } else {
                                    arr.push(copyObj(array[i]));
                                }
                            } else {
                                arr.push(array[i]);
                            }
                        }
                        return arr;
                    };

                if (resource instanceof window.Object && !(resource instanceof window.Function)) {
                    o = Array.isArray(resource) ? copyArray(resource) : copyObj(resource);
                } else {
                    o = resource;
                }
                return o;
            },

            getImgName: function(src) {
                src = src.split('/');
                return src[src.length - 1];
            },

            refreshSlide: function(node, blocks) {
                var t = document.createElement('div');

                node.innerHTML = '';
                angular.forEach(blocks, function(b) {
                    node.appendChild(b.node);
                });
                t.appendChild(node);

                return t.innerHTML;
            }
        };
    return m;
}]);

constructorApp.service('loader', [function() {

    this.load = function(source /*string*/, callbacks /*obj*/, linking /*obj*/) {

        var _img = {
            node: document.createElement('img'),
            src: source
        },
        wrapper = document.createElement('div');

        angular.element(_img.node).css({
            'max-width': 'none',
            'max-height': 'none',
        });

        angular.element(_img.node).attr('src', _img.src);

        angular.element(wrapper).css({
            'position': 'absolute',
            'top': '-10000px',
            'left': '-10000px',
            'width': '10px',
            'height': '10px',
            'overflow': 'hidden'
        });

        callbacks || (callbacks = {});

        callbacks.onload || (callbacks.onload = function() {});
        callbacks.onerror || (callbacks.onerror = function() {});

        angular.element(_img.node).on('load', function(e) {
            angular.extend(e, {
                size: {
                    width: _img.node.offsetWidth,
                    height: _img.node.offsetHeight
                },
                img: _img.node,
                imgSourse: _img.src
            });
            angular.element(_img.node).off('load');
            angular.element(_img.node).off('error');
            callbacks.onload(e, linking);
            angular.element(wrapper).remove();
        });

        angular.element(_img.node).on('error', function(e) {
            callbacks.onerror(e, linking);
            angular.element(_img.node).off('load');
            angular.element(_img.node).off('error');
            angular.element(wrapper).remove();
        });

        angular.element(wrapper).append(_img.node)
        angular.element(document.body).append(wrapper);
    };
}]);

constructorApp.service('lib', ['parseSlide', '$rootScope', function(parseSlide, $rootScope) {
    var service = {
        checkArr: function(arr, value) {
            var r = false;
            angular.forEach(arr, function(v) {
                if (v === value) {
                    r = true;
                }
            });
            return r;
        },
        getDoc: function() {
            return (document.compatMode && 'backcompat' == document.compatMode.toLowerCase())
                ? document.body :
                document.documentElement;
        },

        getScroll: function() {
            return {'x': window.pageXOffset || service.getDoc().scrollLeft, 'y': window.pageYOffset || service.getDoc().scrollTop};
        },

        correctFraction: function(number) {
            number = parseFloat(number);
            number = parseInt(number * 10);
            number = number / 10;
            return number;
        },

        getOptionIndex: function(options, option) {
            for (var i = 0; i < options.length; i++) {
                if (option === options[i].name) {
                    return i;
                }
            }
            return false;
        },

        getOption: function(options, option) {
            var i = service.getOptionIndex(options, option);
            return false !== i ? options[i] : false;
        },

        getProportionsSize: function(block, style) {
            var side, prop, w, h, v,
                getProp = function() {
                    var res;
                    if ('image' === block.type) {
                        if ('width' === style) {
                            res = block.size.height / block.size.width;
                        } else {
                            res = block.size.width / block.size.height;
                        }
                    } else if ('video' === block.type) {
                        if ('width' === style) {
                            res = 9/16;
                        } else {
                            res = 16/9;
                        }
                    }
                    return res;
                };
            if ('width' === style || 'height' === style) {
                side = parseSlide.trim(block.styles[style]);
                v = parseFloat(side);
                if (isNaN(v) || !/^[0-9]+(\.{0,1}[0-9]+){0,1}\s*(px|%)$/.test(side)) { return; }

                w = $rootScope.slideSize.width / 100;
                h = $rootScope.slideSize.height / 100;

                if ('width' === style) {
                    if ('auto' !== block.styles.height) {
                        if (/%$/.test(side)) {
                            w *= v;
                            block.styles.height = service.correctFraction((w * getProp()) / h) + '%';
                        } else {
                            block.styles.height = service.correctFraction(v * getProp()) + 'px';
                        }
                    }
                } else {
                    if ('auto' !== block.styles.width) {
                        if (/%$/.test(side)) {
                            h *= v;
                            block.styles.width = service.correctFraction((h * getProp()) / w) + '%';
                        } else {
                            block.styles.width = service.correctFraction(v * getProp()) + 'px';
                        }
                    }
                }
            }
        },

        getPosition: function (el) {
            var l = 0, t = 0;

            if (!!document.documentElement.getBoundingClientRect) {
                var b = el.getBoundingClientRect(), docScroll = service.getScroll(), doc = service.getDoc();
                return {
                    'top':  b.top + docScroll.y - doc.clientTop,
                    'left': b.left + docScroll.x - doc.clientLeft
                };
            }

            do {
                l += el.offsetLeft || 0;
                t += el.offsetTop || 0;
                el = el.offsetParent;
            } while (el && !(/^(?:body|html)$/i).test(el.tagName));

            return { 'top': t, 'left': l };
        },
        camelize: function(str) {
            return str.replace(/-\D/g, function(m) {
                return m.charAt(1).toUpperCase();
            });
        },
        getBorder: function(node) {
            node = angular.element(node);
            var flag = 'none' === node.css('border-style');
            return {
                top: !flag ? (parseInt(node.css('border-top-width')) || 0) : 0,
                left: !flag ? (parseInt(node.css('border-left-width')) || 0) : 0,
                right: !flag ? (parseInt(node.css('border-right-width')) || 0) : 0,
                bottom: !flag ? (parseInt(node.css('border-bottom-width')) || 0) : 0
            };
        },
        getPadding: function(node) {
            node = angular.element(node);
            var flag = 'none' === node.css('padding');
            return {
                top: !flag ? (parseInt(node.css('padding-top')) || 0) : 0,
                left: !flag ? (parseInt(node.css('padding-left')) || 0) : 0,
                right: !flag ? (parseInt(node.css('padding-right')) || 0) : 0,
                bottom: !flag ? (parseInt(node.css('padding-bottom')) || 0) : 0
            };
        },
        obj: {
            positX: function(b) {
                var a, c;
                a = 0;
                c = b.getBoundingClientRect();
                b = document.body;
                a = document.documentElement;
                a = c.left + (a.scrollLeft || b && b.scrollLeft || 0) - (a.clientLeft || b.sclientLeft || 0);
                return Math.round(a);
            },
            positY: function(b) {
                var a, c;
                a = 0;
                c = b.getBoundingClientRect();
                b = document.body;
                a = document.documentElement;
                a = c.top + (a.scrollTop || b && b.scrollTop || 0) - (a.clientTop || b.sclientTop || 0);
                return Math.round(a);
            }
        },
        mouse: {
            pageX: function(b) {
                var a, c, d;
                d = b || event;
                return null == d.pageX && null != d.clientX ? (a = document.body, c = document.documentElement, b = c.scrollLeft || a && a.scrollLeft || 0, b = d.clientX + b - (c.clientLeft || a.clientLeft || 0)) : d.pageX;
            },
            pageY: function(b) {
                var a, c, d;
                d = b || event;
                return null == d.pageX && null != d.clientX ? (a = document.body, c = document.documentElement, b = c.scrollTop || a && a.scrollTop || 0, b = d.clientY + b - (c.clientTop || a.clientTop || 0)) : d.pageY;
            }
        },

        _getCssValue: (window.getComputedStyle) ?
        function(e, name){
            var css = window.getComputedStyle(e, null);

            return css ? css.getPropertyValue(name) || css[name] : null;
        }
        : function(e, name){
            var css = e.currentStyle,
                v = null;

            v = css ? css[ name ] : null;

            if ( null == v && e.style && e.style[ name ] ) {
                v = e.style[ name ];
            }

            return v;
        },

        getCss: function(el, p) {
            var v = null;

            v = service._getCssValue(el, p);

            if ( 'auto' === v ) {
                v = null;
            }

            if ( null !== v ) {
                if ('opacity' == p ) return $J.defined(v) ? parseFloat(v) : 1.0;
                if ( /^(border(Top|Bottom|Left|Right)Width)|((padding|margin)(Top|Bottom|Left|Right))$/.test(p) ) {
                    v = parseInt(v, 10) ? v : '0px';
                }
            }

            return v;
        }
    };
    return service;
}]);

constructorApp.service('convertFontSize', [function() {
    var ratio = {
        pt: 1 / 12,
        px: 1 / 20
    },
    check = function(number) {
        return 'string' === typeof number ? parseFloat(number) : number;
    },
    obj = {
        pxToEm: function(px) {
            var px_ = check(px);
            if (!isNaN(px_)) {
                return px_ * ratio.px + 'em';
            } else {
                return px;
            }
        },
        ptToEm: function(pt) {
            var pt_ = check(pt);
            if (!isNaN(pt_)) {
                return pt_ * ratio.pt + 'em';
            } else {
                return pt;
            }
        },
        convertToEm: function(number) {
            var result = number;
            if (/px/.test(number)) {
                result = obj.pxToEm(number);
            } else if (/pt/.test(number)) {
                result = obj.ptToEm(number);
            }
            return result;
        },
        convertInvestedEm: function(node) {
            var calcEm = function(n, lastEm) {
                n = angular.element(n);
                angular.forEach(n.children(), function(child) {
                    var fs, last = lastEm;
                    child = angular.element(child);
                    if ('span' === child[0].tagName.toLowerCase()) {
                        fs = child.css('font-size');
                        if ('' !== fs) {
                            fs = parseFloat(obj.convertToEm(fs));
                            child.css('font-size', (undefined !== lastEm ? (fs / lastEm) : fs) + 'em');
                            last = fs;
                        }
                    }
                    calcEm(child, last);
                });
            };
            calcEm(node);
        }
    };
    return obj;
}]);

constructorApp.service('messages', ['$window', function($window) {
    var iframe = ($window !== $window.top),
        _callbacks = {
            getSlideshowJSON: function() {},      // mssc-json
            getSlideshowJSON_fail: function() {}, // mssc-json-fail
            dataSaved: function() {},             // mssc-data-saved
            dataSaved_fail: function() {},        // mssc-data-saved-fail
            getImg: function() {},                // mssc-data-img
            getImg_fail: function() {},           // mssc-data-img-fail
            getVideo: function() {},              // mssc-data-video
            getVideo_fail: function() {}          // mssc-data-video-fail
        },
        post = function(_type, _data) {
            if (iframe) {
                parent.window.postMessage({
                    type: _type,
                    data: _data
                }, '*');
            }
        },

        msg = function(e) {
            var d = e.data || e.originalEvent.data;

            if ('mssConstructorMessage' in d) {
                switch(d.mssConstructorMessage) {
                    case 'mssc-json':
                        _callbacks.getSlideshowJSON(d.data);
                        break;
                    case 'mssc-json-fail':
                        _callbacks.getSlideshowJSON_fail(d.data);
                        break;
                    case 'mssc-data-saved':
                        _callbacks.dataSaved(d.data);
                        break;
                    case 'mssc-data-saved-fail':
                        _callbacks.dataSaved_fail(d.data);
                        break;
                    case 'mssc-data-img':
                        _callbacks.getImg(d.data);
                        break;
                    case 'mssc-data-img-fail':
                        _callbacks.getImg_fail(d.data);
                        break;
                    case 'mssc-data-video':
                        _callbacks.getVideo(d.data);
                        break;
                    case 'mssc-data-video-fail':
                        _callbacks.getVideo_fail(d.data);
                        break;
                }
            }
        };

    if (iframe) {
        angular.element($window).on('message', msg);
    }

    return {
        status: iframe,
        off: function() {
            angular.element($window).off('message', msg);
        },
        setCallbacks: function(callbacks) {
            angular.extend(_callbacks, callbacks || {});
        },
        save: function(data) {
            post('mssc-save', data);
        },
        getJSON: function(data) {
            post('mssc-get-json', data);
        },
        getImg: function() {
            post('mssc-get-img', {});
        },
        getVideo: function() {
            post('mssc-get-video', {});
        },
        ready: function() {
            post('mssc-ready', {});
        },
        closeConstructor: function(data) {
            post('mssc-close', data);
        }
    };
}]);
'use strict'

constructorApp.filter('blockTypes', [function() {
    return function(options, bg, type) {
        var opt = [],
            checkType = function(type_, types) {
                for (var i = 0; i < types.length; i++) {
                    if (type_ === types[i]) {
                        return true;
                    }
                }
                return false;
            },
            checkTypes = function(types) {
                var result = false;
                angular.forEach(types, function(v) {
                    if (checkType(type, types)) {
                        if ('image' === type) {
                            if (checkType('fullscreen', types)) {
                                if (bg) {
                                    result = true;
                                }
                            } else {
                                if (!bg) {
                                    result = true;
                                }
                            }
                        } else {
                            result = true;
                        }
                    }
                });
                return result;
            };

        if (options) {
            angular.forEach(options, function(v) {
                if (checkTypes(v.forTypes)) {
                    opt.push(v);
                }
            });
            return opt;
        }
    };
}]);

constructorApp.filter('timing', [function() {
    return function(blocks) {
        var bs = [];

        if (blocks && blocks.length > 0) {
            angular.forEach(blocks, function(block) {
                if ('fixed' !== block.options[3].value || 'fixed' !== block.options[9].value) {
                    bs.push(block);
                }
            });
            return bs;
        }
    };
}]);

constructorApp.filter('globalOptions', [function() {
    return function(options, isIframe) {
        var opt = [];
        if (options) {
            angular.forEach(options, function(v) {
                if ('width' !== v.name && 'height' !== v.name && "effect" !== v.name && "effect-speed" !== v.name && "effect-easing" !== v.name && "slide-duration" !== v.name) {
                    opt.push(v);
                }
            });
            return opt;
        }
    };
}]);

constructorApp.filter('globalOptionsByGroup', [function() {
    return function(options, group) {
        var opts = [];

        angular.forEach(options, function(option) {
            if (group === option.group) {
                opts.push(option);
            }
        });
        return opts;
    }
}]);

constructorApp.filter('globalOptionsByOrder', [function() {
    return function(options) {
        var i, n = options.length;
        for (i = 0; i < n; i++){
            var v = parseInt(options[i].order),
                el = options[i],
                j = i - 1;
            while (j >= 0 && parseInt(options[j].order) > v) {
               options[j + 1] = options[j];
               j--;
            }
            options[j + 1] = el;
        }
        return options;
    }
}]);
constructorApp.directive('stringToNumber', [function() {
    return {
        require: 'ngModel',
        link: function(scope, element, attrs, ngModel) {
            ngModel.$parsers.push(function(value) {
                return '' + value;
            });
            ngModel.$formatters.push(function(value) {
                return parseFloat(value, 10);
            });
        }
    };
}]);'use strict';

constructorApp.directive('slideshowOptions', ['$compile', function($compile) {
    var create = function(o) {
        var i, s = '', v,  el, selectOption = '';
        if ('input' === o.type) {
            if ('number' === o.valueType) {
                v = 'type="number" min="0" max="100000" string-to-number';
            } else {
                v = '';
            }

            el = '<input class="form-control"' + v + ' ng-model="slideshowOptions.value" option-input/>';
        } else {
            angular.forEach(o.values, function(v) {
                if (o.value === v) {
                    s = 'selected';
                }
                selectOption += '<option ' + s + ' name=' + v + '>' + v + '</option>';
                s = '';
            });

            el = '<select ng-model="slideshowOptions.value" class="e-select form-control" option-select name='+o.name+'>' + selectOption + '</select>'
        }
        return el;
    };

    return {
        restrict: 'A',
        scope: {
            slideshowOptions: '='
        },
        link: function(scope, element, attrs, ctrl, transclude) {
            scope.type = attrs.type;

            if (attrs.replace) {
                element.replaceWith($compile(create(scope.slideshowOptions))(scope));
            } else {
                element.html(create(scope.slideshowOptions));
                $compile(element.contents())(scope);
            }

            element.bind('$destroy', function() {
                scope.$destroy();
            });
        }
    };
}]);

constructorApp.directive('optionInput', ['$compile', function($compile) {
    return {
        restrict: 'A',
        link: function(scope, element, attrs) {
            var opt = scope.slideshowOptions,
                lastValue = 0;
            element.val(opt.value);

            element.bind('keyup', function(e) {
                var v = element.val(),
                    l = v.length;

                if (lastValue !== l) {
                    scope.$emit('blockOptionsEvent', {
                        type: scope.type,
                        name: opt.name,
                        value: v
                    });
                }
                lastValue = l;
            });
        }
    }
}]);

constructorApp.directive('optionSelect', ['$compile', function($compile) {
    return {
        restrict: 'A',
        link: function(scope, element, attrs) {
            var opt = scope.slideshowOptions;

            element.bind('change', function() {
                var v = element.val();
                scope.$emit('blockOptionsEvent', {
                    type: scope.type,
                    name: opt.name,
                    value: v
                });
            });
        }
    }
}]);
'use strict';

constructorApp.directive('setSlideshowSlides', ['$compile', 'slideshowAPI', '$window', function($compile, slideshowAPI, $window) {
    return {
        restrict: 'A',
        scope: {},
        link: function(scope, element, attrs) {
            var container = element.parent(),
                size = { width: 0, height: 0 },
                getSize = function() {
                    return {
                        width: container.parent()[0].offsetWidth,
                        height: container.parent()[0].offsetHeight
                    };
                },

                resize = function() {
                    size = getSize();
                },

                calcContainerSize = function() {
                    var width = parseInt(scope.$parent.slideshowOptions[2].value),
                        height = parseInt(scope.$parent.slideshowOptions[3].value),
                        value;

                    size = getSize();
                    value = size.width;

                    if (height / width * value > size.height) {
                        value = width / height * size.height;
                    }

                    container.css('max-width', value + 'px');
                };

            scope.$on('setSlideshowSlides_', function(e, data) {
                var opt = "";
                element[0].innerHTML = '';

                if (data.slides.length === 0 || data.blocksLength === 0) { return; }
                calcContainerSize();

                angular.forEach(data.slides, function(slide, i) {
                    element.append(slide);
                });

                angular.forEach(scope.$parent.slideshowOptions, function(o, i) {
                    if (scope.$parent.defaults.slideshowOptions[i].value !== o.value || scope.$parent.defaults.slideshowOptions[i].name === 'base-height') {
                        opt += (o.name + ': ' + o.value + '; ');
                    }
                });
                element.attr('data-options', opt);

                $compile(element.contents())(scope);
                slideshowAPI.start();
            });

            angular.element($window).bind('resize', resize);
            element.bind('$destroy', function() {
                angular.element($window).unbind('resize', resize);
                scope.$destroy();
            });
        }
    };
}]);'use strict';
constructorApp.factory('editSlideF', [function() {
    var scope = null;
    return {
        setScope: function(sc) {
            scope = sc;
        },
        blur: function(index) {
            scope.callEventAuxiliaryPanel(index);
        }
    };
}]);
constructorApp.directive('editSlide', [
    '$compile',
    'loader',
    '$timeout',
    '$window',
    '$rootScope',
    'parseSlide',
    'editSlideF',
    function($compile, loader, $timeout, $window, $rootScope, parseSlide, editSlideF) {

    return {
        restrict: 'A',
        scope: {
            editSlide: '=',
            globalHeight: '=',
            globalWidth: '='
        },

        controller: ['$scope', '$element', '$attrs', function($scope, $element, $attrs) {
            $scope.activeBlock = null;
            editSlideF.setScope($scope);
        }],

        link: function(scope, element, attrs) {
            var cs = scope.editSlide,
                watchers = [],

                newBlock = function(block, callback, load) {
                    var src;

                    switch (block.type) {
                        case 'text':
                            block.node = angular.element('<div ng-style="" data-mss-animation-block></div>')[0];
                            block.node.innerHTML = block.content;
                            if (!load) {
                                block.styles = angular.copy($rootScope.defCss, {});
                                block.styles['line-height'] = '1em';
                            }

                            block.saveProportions = false;

                            break;
                        case 'button':
                            block.node = angular.element('<a ng-style="" href="" data-mss-animation-block class="mss-slide-button"></a>')[0];
                            block.node.innerHTML = block.content;
                            if (!load) {
                                block.styles = angular.copy($rootScope.defCss, {});
                                block.styles['line-height'] = '1em';
                                block.styles['padding'] = block.correctStyles['padding'] + 'px';
                                block.styles['background-color'] = block.correctStyles['bg-color'];
                                block.styles['display'] = 'inline-block';
                            }

                            block.saveProportions = false;
                            break;
                        case 'shape':
                            block.node = angular.element('<div ng-style="" data-mss-animation-block ></div>')[0];
                            block.content = '';
                            if (!load) {
                                block.styles['top'] = '10%';
                                block.styles['left'] = '10%'
                                block.styles['width'] = '20%';
                                block.styles['height'] = '20%';
                                block.styles['background-color'] = block.correctStyles['bg-color'];
                                block.styles['display'] = 'inline-block';
                            }
                            break;
                        case 'image':
                            block.node = angular.element('<img ng-style="" ng-src="" data-mss-animation-block>')[0];

                            // tmp
                            if (block.url.length == 0) {
                                block.url = $rootScope.defaultContent.img;
                            }

                            !block.imgName && (block.imgName =  parseSlide.getImgName(block.url));

                            if (!load) {
                                block.styles = angular.copy($rootScope.defCss, {});
                                block.styles['width'] = '20%';
                            }
                            break;
                        case 'video':
                            // 'video-autoplay'
                            // 'video-fullsize'
                            if (!load) {
                                block.styles = angular.copy($rootScope.defCss, {});
                            }

                            if ('video' === block.video.videoType) {
                                if (block.url.length < 1) { // temp
                                    block.url = '../video/mov_bbb.mp4';
                                }
                                block.node = angular.element('<video src="' + block.url + '"  ng-style="" data-mss-animation-block controls></video>')[0];
                            } else if ('youtube' === block.video.videoType) {
                                src = "https://www.youtube" + (block.isnocookie ? "-nocookie" : "") + ".com/embed/";
                                if (block.url.length < 1) { // temp
                                    block.url = $rootScope.defaultContent.youtube;
                                }
                                block.node = angular.element('<iframe src="' + (src + block.url) + '"  ng-style="" data-mss-animation-block frameborder="0" allowfullscreen></iframe>')[0];
                            } else {
                                if (block.url.length < 1) { // temp
                                    block.url = $rootScope.defaultContent.vimeo;
                                }
                                src = "//player.vimeo.com/video/";
                                block.node = angular.element('<iframe src="' + (src + block.url) + '"  ng-style="" data-mss-animation-block frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>')[0];
                            }
                            break;
                    }
                    if (!load) {
                        block.styles['z-index'] = block.index + 1;
                    }

                    callback && callback(block);
                },

                el = function(block) {
                    var w = angular.element('<div>'),
                        o = angular.element('<div>');

                    w.addClass('block-wrapper')
                        .attr('block-wrapper', block.index);

                    if (block.isBackground) {
                        w.addClass('mss-centering-img');
                    }

                    o.addClass('outline-block')
                        .attr('outline-block', block.index);

                    block.wrapper = w[0];
                    block.outline = o[0];

                    block.wrapper.appendChild(block.node);
                    block.wrapper.appendChild(block.outline);

                    if (block.fakeImg) {
                        block.wrapper.appendChild(block.fakeImg[0]);
                    }

                    return block.wrapper;
                },

                refresh = function() {
                    if (cs.node) {
                        cs.node.innerHTML = '';
                        var pn = scope.editSlide.panel.node;
                        if (pn) {
                            if(cs.panel.scope) {
                                cs.panel.scopeDestroy.apply(cs.panel.scope);
                            }
                            pn.remove();
                        }

                        angular.element(scope.editSlide.node).attr('ng-style', '{"background-color": editSlide.styles["background-color"]}');

                        pn = angular.element('<div ng-show="editSlide.panel.show" ng-style="" class="auxiliary-panel" auxiliary-panel="editSlide"></div>');

                        pn.attr('ng-style', 'editSlide.panel.styles');
                        angular.element(cs.node).append(pn[0]);
                        scope.editSlide.panel.node = pn[0];

                        angular.forEach(cs.blocks, function(b, i) {
                            if (!b.node) {
                                newBlock(b, null, true);
                                angular.element(cs.node).append(el(b));
                                angular.element(b.wrapper).attr('slide-index', scope.editSlide.index);
                                // $compile(angular.element(b.wrapper))(scope);
                            } else {
                                angular.element(cs.node).append(el(b));
                            }
                            angular.element(b.wrapper).attr('block-node', 'editSlide.blocks['+i+']');
                            angular.element(b.wrapper).attr('ng-style', '{"z-index": editSlide.blocks['+i+'].styles["z-index"]}');

                            angular.element(b.wrapper).attr('slide-index', scope.editSlide.index);
                        });
                        element.append(cs.node);

                        $compile(element.contents())(scope);

                        // $rootScope.slideSize = {
                        //     width: cs.node.offsetWidth,
                        //     height: cs.node.offsetHeight
                        // };
                    }
                },

                pushBlock = function (b, isStore) {
                    var rewriteIndex = false, arr = [];
                    if (!isStore) {
                        scope.editSlide.blocks.push(b);
                    } else {
                        if (scope.editSlide.blocks.length > 0) {
                            angular.forEach(scope.editSlide.blocks, function(bl, i) {
                                if (b.index === i) {
                                    arr.push(b);
                                    rewriteIndex = true;
                                }
                                arr.push(bl);
                                if (rewriteIndex) {
                                    arr[arr.length - 1].index = arr.length - 1;
                                    angular.element(bl.wrapper).remove();
                                }
                            });

                            if (scope.editSlide.blocks.length === b.index) {
                                arr.push(b);
                            }
                        } else {
                            arr.push(b);
                        }

                        scope.editSlide.blocks = arr;
                    }
                },

                addBlock = function(b, timer, data) {
                    var handler,
                        cb = cs.blocks[cs.activeBlock];
                    b.load = true;

                    pushBlock(b, data.inStore);

                    angular.element(cs.node).append(el(b));
                    if (data.inStore) {
                        for (var i = b.index + 1; i < scope.editSlide.blocks.length; i++) {
                            angular.element(cs.node).append(scope.editSlide.blocks[i].wrapper);
                        }
                    }

                    if (data.noSaveAction) {
                        scope.editSlide.activeBlock = data.newBlock.index;
                    } else if (data.inStore) {
                        scope.editSlide.activeBlock = null;
                    } else {
                        scope.editSlide.activeBlock = scope.editSlide.blocks.length - 1;
                    }
                    angular.element(b.wrapper).attr('block-node', 'editSlide.blocks['+scope.editSlide.activeBlock+']');
                    angular.element(b.wrapper).attr('ng-style', '{"z-index": editSlide.blocks['+scope.editSlide.activeBlock+'].styles["z-index"]}');

                    angular.element(b.wrapper).attr('slide-index', scope.editSlide.index);
                    $compile(angular.element(b.wrapper))(scope);

                    $timeout.cancel(timer);
                    $rootScope.loader = false;

                    // scope.$emit('closeColorPickerEvent');
                    if (!data.inStore) {
                        scope.$emit('toggleBlockEvent', {
                            newBlock: !data.noSaveAction,
                            options: b.options,
                            blockType: b.type,
                            title: b.title,
                            imgName: b.imgName,
                            base64: b.base64,
                            url: b.url,
                            index: scope.editSlide.activeBlock
                        });
                    }
                };

            refresh();

            scope.$on('editorEvent', function(e, data) {
                var create;
                if ('newBlock' === data.type && scope.editSlide.index === data.index) {
                    create = function(nb, callback) {
                        var timer = $timeout(function() {
                            $rootScope.loader = true;
                        }, 300);
                        if ('image' === data.newBlock.type) {
                            loader.load(nb.url, {
                                onload: function (e) {
                                    nb.size = e.size;
                                    nb.styles.height = 'auto';

                                    nb.baseWidth = e.size.width;
                                    nb.baseHeight = e.size.height;

                                    addBlock(nb, timer, data);
                                    callback && callback();
                                    data.cb && data.cb();
                                    if (data.newBlock.isBackground) {
                                        scope.$parent.setAsBackground(true);
                                    }
                                }
                            });
                        } else {
                            addBlock(nb, timer, data);

                            if ('text' === nb.type) {
                                $timeout(function() {
                                    nb.size = {
                                        width: nb.node.offsetWidth,
                                        height: nb.node.offsetHeight
                                    };
                                    callback && callback();
                                    data.cb && data.cb();
                                }, 10);
                            } else {
                                callback && callback();
                                data.cb && data.cb();
                            }
                        }
                    };

                    if (undefined !== data.inStore) {
                        create(data.newBlock, function() {
                            // refresh();
                        });
                    } else {
                        newBlock(data.newBlock, create);
                        // if (data.newBlock.isBackground) {
                        //     scope.$parent.setAsBackground();
                        // }
                    }
                }
                // else if ('load' === data.type) {
                //     newBlock(data.block);
                //     angular.element(cs.node).append(el(data.block));

                //     // angular.element(data.block.wrapper).attr('block-node', 'editSlide.blocks['+scope.editSlide.activeBlock+']');
                //     // angular.element(data.block.wrapper).attr('ng-style', '{"z-index": editSlide.blocks['+scope.editSlide.activeBlock+'].styles["z-index"]}');

                //     angular.element(data.block.wrapper).attr('slide-index', scope.editSlide.index);
                //     $compile(angular.element(data.block.wrapper))(scope);
                // }
            });
            scope.$on('activeBlockEvent', function(e, data) {
                var edsc;
                var handler;
                var ocb = cs.blocks[scope.editSlide.activeBlock];

                scope.editSlide.activeBlock = data.index;
                data.cb && data.cb();
            });

            scope.callEventAuxiliaryPanel = function(index) {
                // if (scope.editSlide.activeBlock === index) {
                //     scope.$broadcast('auxiliaryPanelShowEvent');
                // }
            };

            scope.$on('editSlideEvent', function(e, data) {
                if ('remove' === data.type) {
                    var arr = [],
                        cs = scope.editSlide,
                        ci = undefined !== data.blockIndex ? data.blockIndex : cs.activeBlock,
                        cb = cs.blocks[ci];
                    if (undefined !== ci) {
                        cs.blocks[ci].wrapper.parentNode.removeChild(cs.blocks[ci].wrapper);
                        // $timeout(function() {
                            angular.forEach(cs.blocks, function(b, i) {
                                angular.element(b.wrapper).remove();
                                angular.element(b.node).removeClass('ng-scope');
                            });
                            // scope.$apply(function() {

                                cs.blocks.splice(ci, 1);

                                if (0 === cs.blocks.length) {
                                    cs.panel.show = false;
                                }

                                angular.forEach(cs.blocks, function(b, i) {
                                    angular.element(b.node).removeAttr('ng-src')
                                                            .removeAttr('ng-style');
                                    b.index = i;
                                });

                                if (null === data.lastActiveBlock || undefined === data.lastActiveBlock) {
                                    scope.editSlide.activeBlock = null;
                                    scope.editSlide.panel.show = false;
                                } else {
                                    scope.editSlide.activeBlock = data.lastActiveBlock;
                                }

                                refresh();

                                // only remove block
                                if (!data.noSaveAction) {
                                    scope.$emit('editorRmoveBlockEvent', {
                                        noSaveAction: data.prevBlock,
                                        index: ci,
                                        node: cb
                                    });
                                } else {
                                    data.cb && data.cb();
                                }
                            // });
                        // });
                    }
                }
            });

            watchers.push(scope.$watch('globalWidth', function(nv) {
                angular.forEach(scope.editSlide.blocks, function(_block) {
                    if ('text' === _block.type) {
                        angular.element(_block.node).css('max-width', nv + 'px');
                    }
                });
            }));

            watchers.push(scope.$watch('globalHeight', function(nv) {
                angular.forEach(scope.editSlide.blocks, function(_block) {
                    if ('text' === _block.type) {
                        angular.element(_block.node).css('max-height', nv + 'px');
                    }
                });
            }));

            element.bind('$destroy', function() {
                angular.forEach(watchers, function(watcher) {
                    watcher();
                });
                watchers = [];
                scope.$destroy();
            });
        }
    };
}]);

constructorApp.directive('blockNode', [
    '$compile',
    'editSlideF',
    'activeTab',
    function($compile, editSlideF, activeTab) {
    return {
        priority: 0,
        restrict: 'A',
        scope: {
            blockNode: '=',
            slideIndex: '='
        },
        link: function(scope, element, attrs) {
            var watch = scope.$watch('blockNode', function(nv) {
                    if (undefined !== nv) {
                        var block = nv;

                        angular.element(block.node).attr('index', block.index);
                        angular.element(block.node).attr('ng-style', 'blockNode.styles');
                        if (block.fakeImg) {
                            block.fakeImg.attr('ng-style', 'blockNode.fakeImgStyles');
                        }

                        // angular.element(block.wrapper).attr('ng-style', '{"z-index": blockNode.styles["z-index"]}');

                        if ('text' === block.type || 'button' === block.type) {
                            angular.element(block.node).attr('block-text', '');
                            angular.element(block.node).css({
                                'max-width': scope.$parent.globalWidth + 'px',
                                'max-height': scope.$parent.globalHeight + 'px'
                            });

                            if (block.link && 'text' === block.type) {
                                angular.element(block.node).attr('href', block.href);
                            }
                        } else if ('image' === block.type) {
                            angular.element(block.node).attr('ng-src', '{{blockNode.url}}');
                        }
                        element.bind('$destroy', function() {
                            scope.$destroy();
                        });

                        $compile(element.contents())(scope);
                    }
                });

            element.bind('$destroy', function() {
                watch();
                element.removeAttr('block-node');
                scope.$destroy();
            });
        }
    };
}]);

constructorApp.directive('blockText', ['$rootScope', '$timeout', function($rootScope, $timeout) {
    return {
        restrict: 'A',
        link: function(scope, element, attrs) {
            var watch = scope.$watch('blockNode.content', function(n, o) {
                    // if (parseInt(attrs.index) === scope.$parent.editSlide.activeBlock) {
                        element[0].innerHTML = n;
                        if (n && scope.$parent.editSlide && n !== o && !$rootScope.dontsave) {
                            scope.$emit('blockTextOldValueEvent', { value: o });
                            scope.$emit('blockTextReCalcEvent', { value: n });
                        }
                        $rootScope.dontsave = false;

                        // angular.element(scope.blockNode.outline).css({
                        //     'width': scope.blockNode.node.offsetWidth + 'px',
                        //     'height': scope.blockNode.node.offsetHeight + 'px'
                        // });
                    // }
                });

            // angular.element(scope.blockNode.node).bind('keydown', function() {
            //     $timeout(function() {
            //         angular.element(scope.blockNode.outline).css({
            //             'width': scope.blockNode.node.offsetWidth + 'px',
            //             'height': scope.blockNode.node.offsetHeight + 'px'
            //         });
            //     }, 0);
            // });

            element.bind('$destroy', function() {
                // angular.element(scope.blockNode.node).unbind('keydown');
                element.removeAttr('block-text');
                watch();
            });
        }
    };
}]);

constructorApp.directive('blockWrapper', [
    'editSlideF',
    '$rootScope',
    'acpManager',
    function(editSlideF, $rootScope, acpManager) {
    return {
        restrict: 'A',
        link: function(scope, element, attrs) {
            element.bind('click', function(e) {
                var newIndex, cb = scope.editSlide.blocks[scope.editSlide.activeBlock];
                e.preventDefault();
                // scope.$emit('closeColorPickerEvent');
                acpManager.close();

                newIndex = parseInt(element.children().attr('index'));

                scope.$apply(function() {
                    scope.editSlide.activeBlock = newIndex;
                });

                scope.$emit('toggleBlockEvent', {
                    index: scope.editSlide.activeBlock,
                    click: true
                });
            });

            element.bind('$destroy', function() {
                element.unbind('click');
            });
        }
    };
}]);

constructorApp.directive('outlineBlock', ['$timeout', '$rootScope', function($timeout, $rootScope) {
    return {
        restrict: 'A',
        link: function(scope, element, attrs) {
            var watchers = [];

            // watchers.push(scope.$watchGroup(['blockNode.styles.top', 'blockNode.styles.left', 'blockNode.styles.width', 'blockNode.styles.height'], function(nv) {
            watchers.push(scope.$watchGroup(['blockNode.styles.top', 'blockNode.styles.left', 'blockNode.styles.width', 'blockNode.styles.height', 'blockNode.styles.padding', 'blockNode.styles[\'border-width\']', 'blockNode.styles[\'border-style\']', 'blockNode.content'], function(nv) {
                $timeout(function() {
                    var tmp,
                        t = nv[0],
                        l = nv[1],
                        w = nv[2],
                        h = nv[3];

                    // if ('auto' === w || '' === w) {
                    if (w) {
                        w = scope.blockNode.node.offsetWidth + 'px';
                    }

                    // if ('auto' === h || '' === h) {
                    if (h) {
                        h = scope.blockNode.node.offsetHeight + 'px';
                    }

                    if (scope.blockNode && scope.blockNode.isBackground) {
                        if (/%/.test(h)) {
                            tmp = scope.blockNode.node.offsetHeight;
                            if (tmp) { h = tmp; }
                        }
                        t = ($rootScope.slideSize.height - parseInt(h)) / 2 + 'px';

                        if (/%/.test(w)) {
                            tmp = scope.blockNode.node.offsetWidth;
                            if (tmp) { w = tmp; }
                        }
                        l = ($rootScope.slideSize.width - parseInt(w)) / 2 + 'px';
                    }

                    if (!(/px$/.test(t)) && !(/%$/.test(t))) {
                        t = '0px';
                    }
                    if (!(/px$/.test(l)) && !(/%$/.test(l))) {
                        l = '0px';
                    }

                    element.css({
                        'top': t,
                        'left': l,
                        'width': w,
                        'height': h
                    });
                }, 0);
            }));


            // watchers.push(scope.$watch('blockNode.styles[\'z-index\']', function(nv, ov) {
            //     if (undefined !== nv) {
            //         element.css('z-index', nv);
            //     }
            // }));

            element.bind('$destroy', function() {
                angular.forEach(watchers, function(watcher) {
                    watcher();
                });
                watchers = [];
            });
        }
    };
}]);
'use strict';

constructorApp.directive('slideMove', ['$window', 'lib', 'globalMenuAPI', function($window, lib, globalMenuAPI) {
    var getMargin = function(node) {
            return {
                top: parseInt(lib.getCss(node, 'margin-top')) || 0,
                left: parseInt(lib.getCss(node, 'margin-left')) || 0,
                right: parseInt(lib.getCss(node, 'margin-right')) || 0,
                bottom: parseInt(lib.getCss(node, 'margin-bottom')) || 0
            };
        },
        getSize = function(node) {
            return {
                'width': node.offsetWidth,
                'height': node.offsetHeight
            };
        };
    return {
        restrict: 'A',
        link: function(scope, element, attrs) {
            var twin,
                twin2,
                els,
                removeFlag = false,
                removeButton = element.find('button'),
                currentIndex,
                currentArea,
                size = {},
                scroll = {},
                startPoint = {},
                parentPosition,
                lastTop, lastLeft,
                distanceHeight, distanceWidth,
                margin, currentTop, currentLeft,
                containerSize = {},
                container = element.parent()[0],

                getPosition = function(el) {
                    var p = lib.getPosition(el);
                    return {
                        top: p.top - parentPosition.top - scroll.top - margin.top,
                        left: p.left - parentPosition.left - scroll.left - margin.left
                    };
                },

                getAllElement = function() {
                    var i, arr = [],
                        nodes = container.childNodes;
                    for (var i = 0; i < nodes.length; i++) {
                        if (nodes[i].nodeType !== 3 && nodes[i].nodeType !== 8) {
                            arr.push({ node: nodes[i] });
                        }
                    }
                    return arr;
                },

                getAllPositions = function() {
                    var arr = getAllElement();

                    angular.forEach(arr, function(el, i) {
                        var p  = lib.getPosition(el.node);
                        if (element[0] === el.node) {
                            currentIndex = i;
                        }
                        el.pos = getPosition(el.node);
                    });

                    return arr;
                },

                prepare = function() {
                    els = getAllPositions();

                    twin = $window.document.createElement('div');
                    twin2 = $window.document.createElement('div');

                    angular.element(twin2).css({
                        'top': '0px',
                        'left': '0px',
                        'position': 'absolute',
                        'display': 'inline-block'
                    });

                    angular.element(twin).addClass('slide-min').css({
                        'width': size.width + 'px',
                        'height': size.height + 'px',
                        // 'display': 'inline-block',
                        // 'position': 'relative',
                        'border': 'none',
                        // 'margin': 'auto',
                        'margin-top': margin.top + 'px',
                        'margin-left': margin.left + 'px',
                        'margin-right': margin.right + 'px',
                        'margin-bottom': margin.bottom + 'px',
                        'vertical-aline':' top'
                    });
                    lastTop = els[currentIndex].pos.top;
                    currentTop = lastTop;
                    lastLeft = els[currentIndex].pos.left;
                    currentLeft = lastLeft;

                    element.css({
                        'top': lastTop + 'px',
                        'left': lastLeft + 'px',
                        'width': size.width + 'px',
                        'height': size.height + 'px',
                        'position': 'absolute',
                        'z-index': 10000000
                    });

                    element[0].parentNode.insertBefore(twin, element[0]);
                },

                area = function(curPos, otherPos) {
                    var result = false,
                        width = 0,
                        height = 0,
                        w = size.width - margin.left - margin.right,
                        h = size.height - margin.top - margin.bottom;

                    if (Math.abs(curPos.top - otherPos.top) < h) {
                        if (curPos.top > otherPos.top) {
                            height = otherPos.top + h - curPos.top;
                        } else {
                            height = curPos.top + h - otherPos.top;
                        }
                    }

                    if (Math.abs(curPos.left - otherPos.left) < w) {
                        if (curPos.left > otherPos.left) {
                            width = otherPos.left + w - curPos.left;
                        } else {
                            width = curPos.left + w - otherPos.left;
                        }
                    }

                    if (currentArea / 2 < width * height) {
                        result = true;
                    }
                    return result;
                },

                mousemove = function(e) {
                    e.preventDefault();

                    lastTop = lib.mouse.pageY(e) - startPoint.top - lib.obj.positY(container) - scroll.top - margin.top;
                    // lastLeft = lib.mouse.pageX(e) - startPoint.left - lib.obj.positX(container) - scroll.left - margin.left;

                    if (lastTop < 0 - margin.top) { lastTop = 0 - margin.top; }
                    // if (lastLeft < 0 - margin.left) { lastLeft = 0 - margin.left; }

                    if (lastTop + size.height > containerSize.height - margin.top) {
                        lastTop = containerSize.height - size.height - margin.top;
                    }


                    // off
                    // if (lastLeft + size.width > containerSize.width - margin.left) {
                    //     lastLeft = containerSize.width - size.width - margin.left;
                    // }

                    angular.forEach(els, function(el, i) {
                        if (i !== currentIndex) {
                            if (area({top: lastTop, left: lastLeft}, el.pos)) {
                                container.insertBefore(twin2, el.node);
                                container.insertBefore(el.node, twin);
                                container.insertBefore(twin, twin2);
                                container.removeChild(twin2);

                                el.pos = getPosition(el.node);
                            }
                        }
                    });


                    element.css({
                        'top': lastTop + 'px'
                        // 'left': lastLeft + 'px' // off
                    });
                },

                mouseup = function(e) {
                    if (1 === e.which) {
                        e.preventDefault();
                        angular.element($window.document).unbind('mousemove', mousemove);

                        element.css('cursore', '');
                        element.css({
                            'top': '',
                            'left': '',
                            'width': '',
                            'height': '',
                            'z-index': '',
                            'position': ''
                        });
                        container.insertBefore(element[0], twin);
                        angular.element(twin).remove();

                        var change = true, tmp = getAllElement(container);
                        angular.forEach(tmp, function(el, i) {
                            if (el.node === element[0] && i === currentIndex) {
                                change = false;
                            }
                        });

                        scope.$emit('slideMoveEvent', {
                            elements: tmp,
                            cIndex: change ? null : currentIndex
                        });

                        angular.element($window.document).unbind('mouseup');
                    }
                },

                removeMouseUp = function(e) {
                    var target;
                    if (1 === e.which) {
                        e.preventDefault();
                        removeFlag = false;
                        target = e.target;

                        while(target.tagName.toLowerCase() !== 'button') {
                            target = target.parentNode;
                        }

                        scope.$emit('removeSlideEvent', {
                            index: angular.element(target).attr('index')
                        });
                    }

                    removeButton.off('mouseup', removeMouseUp);
                };

            removeButton.on('mousedown', function(e) {
                if (1 === e.which) {
                    e.preventDefault();
                    removeFlag = true;
                    removeButton.on('mouseup', removeMouseUp);
                }
            });

            element.bind('mousedown', function(e) {
                if (1 === e.which && !removeFlag) {
                    e.preventDefault();
                    globalMenuAPI.close();

                    element.css('cursore', 'move');
                    size = getSize(element[0]);
                    containerSize = getSize(container);
                    margin = getMargin(element[0]);

                    currentArea = (size.width - margin.left - margin.right) * (size.height - margin.top - margin.bottom);

                    distanceHeight = (size.height / 2 + size.height / 8);
                    distanceWidth = (size.width / 2 + size.width / 8);

                    startPoint.top = lib.mouse.pageY(e) - lib.obj.positY(element[0]);
                    startPoint.left = lib.mouse.pageX(e) - lib.obj.positX(element[0]);

                    scroll.top = container.parentNode.scrollTop;
                    scroll.left = container.parentNode.scrollLeft;

                    parentPosition = lib.getPosition(container);

                    prepare();
                    angular.element($window.document).bind('mouseup', mouseup);
                    angular.element($window.document).bind('mousemove', mousemove);
                }
            });

            element.bind('$destroy', function() {
                removeButton.off('mousedown');
                element.unbind('mousedown');
            });
        }
    };
}]);
'use strict';

constructorApp.directive('section', [function() {
    return {
        restrict: 'A',
        scope: true,
        link: function(scope, element, attrs) {
            scope.open = false;
            var children = element.find('div');

            angular.element(children[1]).css('display', 'none');

            angular.element(children[0]).bind('mousedown', function(e) {
                if (1 === e.which) {
                    angular.element(children[0]).addClass('inversion');
                }
            });
            angular.element(children[0]).bind('mouseup', function(e) {
                if (1 === e.which) {
                    // angular.element(children[0]).removeClass('inversion');
                    if (scope.open) {
                        angular.element(children[0]).removeClass('inversion');
                        element.removeClass('open');
                        scope.open = false;
                        angular.element(children[1]).css('display', 'none');
                    } else {
                        element.addClass('open');
                        scope.open = true;
                        angular.element(children[1]).css('display', '');
                    }
                }
            });

            element.bind('$destroy', function() {
                var ch = angular.element(children[0]);
                ch.unbind('mousedown');
                ch.unbind('mouseup');
                scope.$destroy();
            });
        }
    };
}]);constructorApp.directive('colorPickerBlock', ['$compile', function($compile) {
    return {
        restrict: 'A',
        scope: true,
        require: '?ngModel',
        controller: ['$scope', '$element', '$attrs', function($scope, $element, $attrs) {
            var reg = new RegExp("\\s*r\\s*g\\s*b\\s*a\\s*\\(\\s*[0-9]\\s*[0-9]?\\s*[0-9]?\\s*,\\s*[0-9]\\s*[0-9]?\\s*[0-9]?\\s*,\\s*[0-9]\\s*[0-9]?\\s*[0-9]?\\s*,\\s*([0-1]|0\\s*\.\\s*[0-9]+)\\s*\\)\\s*");

            $scope.colors = { input: 'none', color: 'none' };

            $scope.getInputValue = function(value) {
                if (value) {
                    value = value.replace(/\s+/g, ' ');

                    if ('transparent' === value || 'none' === value || !reg.test(value)) {
                        // value = 'rgba(0,0,0,0)';
                        value = 'none';
                    } else {
                        var tmp = value.split('(')[1];
                        tmp = tmp.split(')')[0];
                        tmp = tmp.split(',');

                        for (var i = 0; i < 3; i++) {
                            if (parseInt(tmp[i]) > 255) {
                                tmp[i] = 255;
                            }
                        }
                        value = 'rgba(' + tmp.join(',') + ')';
                    }
                } else {
                    // value = 'rgba(0,0,0,0)';
                    value = 'none';
                }

                return value;
            };
        }],
        link: function(scope, element, attrs, ngModel) {
            var watchers = [],
                i = angular.element('<input class="form-control" ng-model="colors.input" input-mask>'),
                c = angular.element('<div text="transparent" ng-model="colors.color" ng-style="{\'background-color\': colors.color}" angular-color-picker="rgba" ></div>');

            if (!isNaN(ngModel.$viewValue)) {
                scope.colors = {
                    input: ngModel.$viewValue,
                    color: ngModel.$viewValue
                };
            }

            ngModel.$formatters.push(scope.getInputValue);

            watchers.push(scope.$watch(function () {
                return ngModel.$modelValue;
            }, function(newValue, oldValue) {
                if (newValue) {
                    scope.colors = {
                        input: ngModel.$viewValue,
                        color: ngModel.$viewValue
                    };
                }
            }));

            watchers.push(scope.$watch('colors.input', function(newValue, oldValue) {
                if (newValue !== oldValue) {
                    // scope.colors.color = scope.getInputValue(newValue);
                    scope.colors.color = newValue;
                    ngModel.$setViewValue(newValue);
                }
            }));

            watchers.push(scope.$watch('colors.color', function(newValue, oldValue) {
                if (newValue !== oldValue) {
                    scope.colors.input = newValue;
                    ngModel.$setViewValue(newValue);
                }
            }));

            element.append(c[0]);
            element.append(i[0]);
            $compile(element.contents())(scope);

            element.bind('$destroy', function() {
                angular.forEach(watchers, function(watcher) { watcher(); });
                scope.$destroy();
            });
        }
    };
}]);
'use strict';

constructorApp.directive('auxiliaryPanel', [
    '$compile',
    'lib',
    '$timeout',
    '$window',
    '$rootScope',
    'activeTab',
    'globalMenuAPI',
    'acpManager',
    function($compile, lib, $timeout, $window, $rootScope, activeTab, globalMenuAPI, acpManager) {
    var round = function(num, count) {
            var degree = Math.pow(10, count || 4);
            return Math.round(num * degree) / degree;
        },
        create = function(node) {
            return $window.document.createElement(node || 'div');
        },
        addClasses = function(el, arr) {
            if ('string' === typeof arr) {
                var t = [];
                t.push(arr);
                arr = t;
            }
            angular.forEach(arr, function(name) {
                angular.element(el).addClass(name);
            });
        },
        defined = function(v) {
            return undefined !== v;
        };
    return {
        restrict: 'A',
        scope: {
            auxiliaryPanel: '='
        },
        link: function(scope, element, attrs) {
            var cs = scope.auxiliaryPanel, proportion,
                parent = element.parent()[0],
                proportions, x, y, watch,
                elSize = {}, size = {},
                oldWidth, oldHeight,
                oldTop, oldLeft, cb = null, pos,
                elPos, customTop, customLeft,
                moveFlag = false,
                moveTop = false, moveLeft = false,
                dragFlag = false, ratio,
                // minHeight, minWidth,
                borderWidth = 0, borderHeight = 0,
                paddingWidth = 0, paddingHeight = 0,
                moveEv = false,
                topControl = create(),
                leftControl = create(),
                rightControl = create(),
                bottomControl = create(),
                topLeftControl = create(),
                topRightControl = create(),
                bottomLeftControl = create(),
                bottomRightControl = create(),
                // buttonEdit = create('button'),

                minWidth = 30,
                minHeight = 30,

                minWidthCorrect, minHeightCorrect,

                updateValues = function(values, save) {
                    var sign = 'px',
                        set = function() {
                            $timeout(function() {
                                var tmp;
                                if (defined(values.width)) {
                                    if ('string' === typeof values.width) {
                                        var sign2 = '';
                                        if ('video' === cb.type && 'auto' === values.width) {
                                            sign2 = 'px';
                                            values.width = cb.node.offsetWidth;
                                        }
                                        cb.styles.width = values.width + sign2;
                                        scope.auxiliaryPanel.panel.styles.width = cb.node.offsetWidth + sign;
                                    } else {
                                        tmp = round(values.width, 1);
                                        // cb.styles.width = tmp + sign;
                                        cb.styles.width = round(tmp - borderWidth - paddingWidth) + sign;


                                        // scope.auxiliaryPanel.panel.styles.width = tmp + borderWidth + paddingWidth + sign;
                                        scope.auxiliaryPanel.panel.styles.width = tmp + sign;
                                        // scope.auxiliaryPanel.panel.styles.width = cb.styles.width;
                                    }
                                } else {
                                    if (cb && 'text' === cb.type && 'auto' === cb.styles.width) {
                                        // scope.auxiliaryPanel.panel.styles.width = cb.node.offsetWidth + borderWidth + paddingWidth + 'px';
                                        scope.auxiliaryPanel.panel.styles.width = cb.node.offsetWidth + 'px';
                                    }
                                }
                                if (defined(values.height)) {
                                    if ('string' === typeof values.height) {
                                        var sign2 = '';
                                        if ('video' === cb.type && 'auto' === values.height) {
                                            sign2 = 'px';
                                            values.height = cb.node.offsetHeight;
                                        }
                                        cb.styles.height = values.height + sign2;
                                        scope.auxiliaryPanel.panel.styles.height = cb.node.offsetHeight + sign;
                                    } else {
                                        tmp = round(values.height, 1);
                                        // cb.styles.height = tmp + sign;
                                        cb.styles.height = round(tmp - borderHeight - paddingHeight) + sign;



                                        // scope.auxiliaryPanel.panel.styles.height = tmp + borderHeight + paddingHeight + sign;
                                        scope.auxiliaryPanel.panel.styles.height = tmp + sign;
                                        // scope.auxiliaryPanel.panel.styles.height = cb.styles.height;
                                    }
                                } else {
                                    if (cb && 'text' === cb.type && 'auto' === cb.styles.height) {
                                        // scope.auxiliaryPanel.panel.styles.height = cb.node.offsetHeight + borderHeight + paddingHeight + 'px';
                                        scope.auxiliaryPanel.panel.styles.height = cb.node.offsetHeight + 'px';
                                    }
                                }
                                if (defined(values.top)) {
                                    if ('string' === typeof values.top) {
                                        cb.styles.top = values.top;
                                    } else {
                                        cb.styles.top = round(values.top, 1) + sign;
                                    }

                                    if ('string' === typeof values.top) {
                                        scope.auxiliaryPanel.panel.styles.top = values.top;
                                    } else {
                                        scope.auxiliaryPanel.panel.styles.top = round(values.top, 1) + sign;
                                    }
                                }
                                if (defined(values.left)) {
                                    if ('string' === typeof values.left) {
                                        cb.styles.left = values.left;
                                    } else {
                                        cb.styles.left = round(values.left, 1) + sign;
                                    }

                                    if ('string' === typeof values.left) {
                                        scope.auxiliaryPanel.panel.styles.left = values.left;
                                    } else {
                                        scope.auxiliaryPanel.panel.styles.left = round(values.left, 1) + sign;
                                    }
                                }
                                if (cb.fakeImg) {
                                    var s = cb.styles;
                                    cb.fakeImgStyles.top = s.top;
                                    cb.fakeImgStyles.left = s.left;
                                    cb.fakeImgStyles.width = s.width;
                                    cb.fakeImgStyles.height = s.height;
                                }

                                if (save) { scope.$emit('auxiliaryPanelMouseUpEvent', { move: true }); }
                            }, 0);
                        };

                    if (!scope.$parent.$parent.$$phase) {
                        scope.$apply(function() {
                            set();
                        });
                    } else {
                        set();
                    }
                },

                false_ = function() {
                    return false;
                },

                correctSize = function() {
                    if (cb && 'auto' === cb.styles.width) {
                        updateValues({
                            // width : Math.round(element[0].offsetHeight * proportions.forWidth),
                            width : round(element[0].offsetHeight * (elSize.width / elSize.height), 1),
                            height: 'auto'
                        });
                    }
                },

                mouseUp = function(e, remove) {
                    e && e.preventDefault();
                    e && e.stopPropagation();
                    // correctSize();

                    angular.element($window.document.body).removeClass(proportion);

                    moveTop = false;
                    moveLeft = false;
                    moveFlag = false;
                    dragFlag = false;
                    proportion = false;
                    proportions = null;
                    element.css('cursor', '');

                    if (!remove) {
                        scope.$emit('auxiliaryPanelMouseUpEvent', {
                            move: moveEv
                        });
                    }

                    moveEv = false;

                    angular.element($window.document).unbind('mousemove', move);

                    angular.element($window.document).unbind('ondragstart', false_);
                    angular.element($window.document).unbind('onselectstart', false_);

                    angular.element($window.document).unbind('mouseup', mouseUp);
                },

                move = function(e) {
                    var t, l, correctTop, correctLeft, tmp,
                        currentWidth, currentHeight;

                    e.preventDefault();
                    e.stopPropagation();

                    if (!moveEv) {
                        moveEv = true;
                    }

                    t = e.clientY - pos.top - y;
                    l = e.clientX - pos.left - x;

                    t /= $rootScope.zoomIcon;
                    l /= $rootScope.zoomIcon;

                    if (dragFlag) {
                        if ('t' === proportion || 'l' === proportion || 'r' === proportion || 'b' === proportion) {
                            if ('l' === proportion || 'r' === proportion) {
                                if (cs.blocks[cs.activeBlock].saveProportions) {

                                    currentWidth = oldLeft - l;
                                    if ('r' === proportion) {
                                        currentWidth *= (-1);
                                    }
                                    currentWidth += oldWidth;
                                    currentHeight = proportions.forHeight * currentWidth;

                                    if ('r' === proportion) {
                                        moveLeft = false;
                                    }

                                    t = oldTop + ((oldHeight - currentHeight) / 2);


                                    if (currentWidth < minWidthCorrect) {
                                        if ('l' === proportion) {
                                            l -= (minWidthCorrect - currentWidth);
                                        } else {
                                            l += (minWidthCorrect - currentWidth);
                                        }

                                        currentWidth = minWidthCorrect;
                                        currentHeight = proportions.forHeight * currentWidth;

                                        if ('l' === proportion) {
                                            tmp = proportions.forHeight * (l - oldLeft);
                                        } else {
                                            tmp = proportions.forHeight * (oldLeft - l);
                                        }

                                        t = oldTop + tmp / 2;

                                        if (!tmp) { moveFlag = false; }
                                    } if (!moveFlag) {
                                        moveFlag = true;
                                    }
                                } else {
                                    t = null;
                                    moveTop = false;

                                    currentWidth = oldLeft - l;
                                    if ('r' === proportion) {
                                        moveFlag = false;
                                        currentWidth *= (-1);
                                    }
                                    currentWidth += oldWidth;

                                    if (currentWidth <= minWidth) {
                                        tmp = minWidth - currentWidth;
                                        if ('l' === proportion) {
                                            l -= tmp;
                                        } else {
                                            l += tmp;
                                        }
                                        currentWidth = minWidth;
                                    }
                                    currentHeight = elSize.height;
                                }
                            } else {
                                if (cs.blocks[cs.activeBlock].saveProportions) {
                                    currentHeight = oldTop - t;
                                    if ('b' === proportion) {
                                        currentHeight *= (-1);
                                    }
                                    currentHeight += oldHeight;
                                    currentWidth = proportions.forWidth * currentHeight;

                                    if ('b' === proportion) {
                                        moveTop = false;
                                    }
                                    l = oldLeft + ((oldWidth - currentWidth) / 2);

                                    if (currentHeight < minHeightCorrect) {
                                        if ('t' === proportion) {
                                            t -= (minHeightCorrect - currentHeight);
                                        } else {
                                            t += (minHeightCorrect - currentHeight);
                                        }

                                        currentHeight = minHeightCorrect;
                                        currentWidth = proportions.forWidth * currentHeight;

                                        if ('t' === proportion) {
                                            tmp = proportions.forWidth * (t - oldTop);
                                        } else {
                                            tmp = proportions.forWidth * (oldTop - t);
                                        }

                                        l = oldLeft + tmp / 2;

                                        if (!tmp) { moveFlag = false; }
                                    } else if (!moveFlag) {
                                        moveFlag = true;
                                    }
                                } else {
                                    l = null;
                                    moveLeft = false;
                                    currentHeight = oldTop - t;
                                    if ('b' === proportion) {
                                        moveFlag = false;
                                        currentHeight *= (-1);
                                    }
                                    currentHeight += oldHeight;

                                    if (currentHeight <= minHeight) {
                                        tmp = minHeight - currentHeight;
                                        if ('t' === proportion) {
                                            t -= tmp;
                                        } else {
                                            t += tmp;
                                        }
                                        currentHeight = minHeight;
                                    }
                                    currentWidth = elSize.width;
                                }
                            }
                        } else {
                            if ('bl' === proportion) {
                                t = null;

                                currentWidth = oldLeft - l + oldWidth;
                                // currentHeight = (e.clientY - pos.top) - (elPos.top - pos.top - document.body.scrollTop) - borderHeight - paddingHeight;
                                currentHeight = (e.clientY - pos.top) - (elPos.top - pos.top - document.body.scrollTop);
                                currentHeight /= $rootScope.zoomIcon;
                                if (cs.blocks[cs.activeBlock].saveProportions) {
                                    // if (elPos.top - pos.top + (proportions.forHeight * currentWidth) - document.body.scrollTop + borderHeight + paddingHeight < e.clientY - pos.top) {
                                    if (elPos.top - pos.top + (proportions.forHeight * currentWidth) - document.body.scrollTop < e.clientY - pos.top) {
                                        if (currentHeight <= minHeight && !ratio) {
                                            l -= (minWidth - currentWidth);
                                            currentHeight = minHeight;
                                        }

                                        currentWidth = proportions.forWidth * currentHeight;

                                        if (currentWidth <= minWidth && ratio) {
                                            l -= (minWidth - currentWidth);
                                            currentWidth = minWidth;
                                            currentHeight = proportions.forHeight * currentWidth;
                                        }

                                        customLeft = customLeft - (currentWidth - oldWidth);
                                        l = customLeft;
                                    } else {
                                        if (currentWidth <= minWidth && ratio) {
                                            l -= (minWidth - currentWidth);
                                            currentWidth = minWidth;
                                        }

                                        currentHeight = proportions.forHeight * currentWidth;

                                        if (currentHeight <= minHeight && !ratio) {
                                            correctLeft = (minHeight - currentHeight) * proportions.forWidth;
                                            currentHeight = minHeight;
                                            currentWidth = proportions.forWidth * currentHeight;
                                            l -= correctLeft;
                                        }
                                        customLeft = l;
                                    }
                                } else {
                                    if (currentWidth <= minWidth) {
                                        l -= (minWidth - currentWidth);
                                        currentWidth = minWidth;
                                    }
                                    if (currentHeight <= minHeight) {
                                        currentHeight = minHeight;
                                    }
                                }
                            } else if ('br' === proportion) {
                                t = null;
                                l = null;
                                // currentWidth = (e.clientX - pos.left) - (elPos.left - pos.left - document.body.scrollLeft) - borderWidth - paddingWidth;
                                // currentHeight = (e.clientY - pos.top) - (elPos.top - pos.top - document.body.scrollTop) - borderHeight - paddingHeight;
                                currentWidth = (e.clientX - pos.left) - (elPos.left - pos.left - document.body.scrollLeft);
                                currentHeight = (e.clientY - pos.top) - (elPos.top - pos.top - document.body.scrollTop);
                                currentWidth /= $rootScope.zoomIcon;
                                currentHeight /= $rootScope.zoomIcon;

                                if (cs.blocks[cs.activeBlock].saveProportions) {
                                    // if (elPos.top - pos.top + (proportions.forHeight * currentWidth) - document.body.scrollTop + borderHeight + paddingHeight < e.clientY - pos.top) {
                                    if (elPos.top - pos.top + (proportions.forHeight * currentWidth) - document.body.scrollTop < e.clientY - pos.top) {
                                        if (currentHeight <= minHeight && !ratio) {
                                            currentHeight = minHeight;
                                        }

                                        currentWidth = proportions.forWidth * currentHeight;

                                        if (currentWidth <= minWidth && ratio) {
                                            currentWidth = minWidth;
                                            currentHeight = proportions.forHeight * currentWidth;
                                        }
                                    } else {
                                        if (currentWidth <= minWidth && ratio) {
                                            currentWidth = minWidth;
                                        }
                                        currentHeight = proportions.forHeight * currentWidth;
                                        if (currentHeight <= minHeight && !ratio) {
                                            currentHeight = minHeight;
                                            currentWidth = proportions.forWidth * currentHeight;
                                        }
                                    }
                                } else {
                                    if (currentWidth <= minWidth) {
                                        currentWidth = minWidth;
                                    }
                                    if (currentHeight <= minHeight) {
                                        currentHeight = minHeight;
                                    }
                                }
                            } else if ('tr' === proportion) {
                                l = null;
                                currentHeight = oldTop - t + oldHeight;
                                // currentWidth = (e.clientX - pos.left) - (elPos.left - pos.left - document.body.scrollLeft) - borderWidth - paddingWidth;
                                currentWidth = (e.clientX - pos.left) - (elPos.left - pos.left - document.body.scrollLeft);
                                currentWidth /= $rootScope.zoomIcon;
                                if (cs.blocks[cs.activeBlock].saveProportions) {
                                    // if (elPos.left - pos.left + (proportions.forWidth * currentHeight) - document.body.scrollLeft + borderWidth + paddingWidth < e.clientX - pos.left) {
                                    if (elPos.left - pos.left + (proportions.forWidth * currentHeight) - document.body.scrollLeft < e.clientX - pos.left) {
                                        if (currentWidth <= minWidth && ratio) {
                                            t -= (minHeight - currentHeight);
                                            currentWidth = minWidth;
                                        }
                                        currentHeight = proportions.forHeight * currentWidth;

                                        if (currentHeight <= minHeight && !ratio) {
                                            t -= (minHeight - currentHeight);
                                            currentHeight = minHeight;
                                            currentWidth = proportions.forWidth * currentHeight;
                                        }

                                        customTop = customTop - (currentHeight - oldHeight);
                                        t = customTop;
                                    } else {
                                        if (currentHeight <= minHeight && !ratio) {
                                            t -= (minHeight - currentHeight);
                                            currentHeight = minHeight;
                                        }
                                        currentWidth = proportions.forWidth * currentHeight;

                                        if (currentWidth <= minWidth && ratio) {
                                            correctTop = (minWidth - currentWidth) * proportions.forHeight;
                                            currentWidth = minWidth;
                                            currentHeight = proportions.forHeight * currentWidth;
                                            t -= correctTop;
                                        }
                                        customTop = t;
                                    }
                                } else {
                                    if (currentWidth <= minWidth) {
                                        currentWidth = minWidth;
                                    }
                                    if (currentHeight <= minHeight) {
                                        t -= (minHeight - currentHeight);
                                        currentHeight = minHeight;
                                    }
                                }
                            } else {
                                currentHeight = oldTop - t + oldHeight;
                                currentWidth = oldLeft - l + oldWidth;
                                if (cs.blocks[cs.activeBlock].saveProportions) {
                                    if (customLeft - ((proportions.forWidth * currentHeight) - oldWidth) > e.clientX - pos.left) {
                                        if (currentWidth <= minWidth && ratio) {
                                            l -= (minWidth - currentWidth);
                                            currentWidth = minWidth;
                                        }

                                        currentHeight = proportions.forHeight * currentWidth;

                                        if (currentHeight <= minHeight && !ratio) {
                                            correctTop = (minWidth - currentWidth) * proportions.forHeight;
                                            currentHeight = minHeight;
                                            correctLeft = currentWidth;
                                            currentWidth = proportions.forWidth * currentHeight;
                                            t -= correctTop;
                                            l -= (currentWidth - correctLeft);
                                        }

                                        customTop = customTop - (currentHeight - oldHeight);
                                        t = customTop;
                                        customLeft = l;
                                    } else {
                                        if (currentHeight <= minHeight && !ratio) {
                                            t -= (minHeight - currentHeight);
                                            currentHeight = minHeight;
                                        }

                                        currentWidth = proportions.forWidth * currentHeight;

                                        if (currentWidth <= minWidth && ratio) {
                                            correctLeft = (minHeight - currentHeight) * proportions.forWidth;
                                            currentWidth = minWidth;
                                            correctTop = currentHeight;
                                            currentHeight = proportions.forHeight * currentWidth;
                                            l -= correctLeft;
                                            t -= (currentHeight - correctTop);
                                        }

                                        customLeft = customLeft - (currentWidth - oldWidth);
                                        l = customLeft;
                                        customTop = t;
                                    }
                                } else {
                                    if (currentWidth <= minWidth) {
                                        l -= (minWidth - currentWidth);
                                        currentWidth = minWidth;
                                    }
                                    if (currentHeight <= minHeight) {
                                        t -= (minHeight - currentHeight);
                                        currentHeight = minHeight;
                                    }
                                }
                            }
                        }

                        oldTop = t;
                        oldLeft = l;
                        oldWidth = currentWidth;
                        oldHeight = currentHeight;
                    }

                    updateValues({
                        top: (moveFlag && moveTop && t) ? Math.round(t, 1) : undefined,
                        left: (moveFlag && moveLeft && l) ? Math.round(l, 1) : undefined,
                        width: currentWidth,
                        height: currentHeight
                    });
                },

                resize = function(e) {
                    if (cb) {
                        $timeout(function() {
                            scope.auxiliaryPanel.panel.styles.top = cb.styles.top || (0 + 'px');
                            scope.auxiliaryPanel.panel.styles.left = cb.styles.left || (0 + 'px');
                            scope.auxiliaryPanel.panel.styles.width = (cb.node.offsetWidth || 0) + 'px';
                            scope.auxiliaryPanel.panel.styles.height = (cb.node.offsetHeight || 0) + 'px';
                        }, 0);
                    }

                    size.width = parent.offsetWidth;
                    size.height = parent.offsetHeight;
                };

            // angular.element(buttonEdit)
            //     .append('Edit')
            //     .addClass('mtb-button')
            //     .addClass('insert')
            //     .attr('text-editor-wysiwyg', 'cb')
            //     .css({
            //         'position': 'absolute',
            //         'top': '0',
            //         'right': '0',
            //         'transform': 'translateY(-125%)'
            //     });

            watch = scope.$watch('auxiliaryPanel.activeBlock', function(v, oldValue) {
                pos = lib.getPosition(parent);
                size.width = parent.offsetWidth;
                size.height = parent.offsetHeight;

                if (null !== v && undefined !== v && '' !== v) {
                    cb = cs.blocks[v];
                    scope.cb = cb;

                    $timeout(function() {
                        if ('button' === cb.type) {
                            angular.forEach([
                                topControl,
                                leftControl,
                                rightControl,
                                bottomControl,
                                topLeftControl,
                                topRightControl,
                                bottomLeftControl,
                                bottomRightControl
                            ], function(el) {
                                angular.element(el).css('display', 'none');
                            });
                        } else if ('text' === cb.type) {
                            // angular.element(topLeftControl).css('display', 'none');
                            // angular.element(topRightControl).css('display', 'none');
                            // angular.element(bottomLeftControl).css('display', 'none');
                            // angular.element(bottomRightControl).css('display', 'none');

                            angular.element(topControl).css('display', 'none');
                            angular.element(leftControl).css('display', 'none');
                            angular.element(rightControl).css('display', 'none');
                            angular.element(bottomControl).css('display', 'none');
                            // angular.element(buttonEdit).css('display', '');


                            angular.element(cb.node).addClass('transparent-select');
                        } else {
                            angular.element(topControl).css('display', '');
                            angular.element(leftControl).css('display', '');
                            angular.element(rightControl).css('display', '');
                            angular.element(bottomControl).css('display', '');
                            angular.element(topLeftControl).css('display', '');
                            angular.element(topRightControl).css('display', '');
                            angular.element(bottomLeftControl).css('display', '');
                            angular.element(bottomRightControl).css('display', '');
                            // angular.element(buttonEdit).css('display', 'none');
                        }

                        if (!cb.isBackground) {
                            updateValues({
                                top: /%$/.test(cb.styles.top) ? cb.styles.top : parseInt(cb.styles.top),
                                left: /%$/.test(cb.styles.left) ? cb.styles.left : parseInt(cb.styles.left),
                                width: cb.styles.width,
                                height: cb.styles.height
                            });
                            $timeout(function() {
                                scope.auxiliaryPanel.panel.show = true;
                            }, 0);
                        } else {
                            scope.auxiliaryPanel.panel.show = false;
                        }
                    }, 0);
                } else {
                    (oldValue || 0 === oldValue) && angular.element(cs.blocks[oldValue].node).removeClass('ta-border-shadow');
                    cb = null;
                    $timeout(function() {
                        scope.auxiliaryPanel.panel.show = false;
                    }, 0);
                }
            });

            scope.$on('auxiliaryPanelUpdateSizeEvent', function() {
                $timeout(function() {
                    var show = !cs.blocks[cs.activeBlock].isBackground;
                    pos = lib.getPosition(parent);
                    if (show && cb) {
                        updateValues({
                            top: /%$/.test(cb.styles.top) ? cb.styles.top : parseInt(cb.styles.top),
                            left: /%$/.test(cb.styles.left) ? cb.styles.left : parseInt(cb.styles.left),
                            width: cb.styles.width,
                            height: cb.styles.height
                        });
                    }
                    scope.auxiliaryPanel.panel.show = show;
                }, 0);
            });

            scope.$on('textEditorSaveText', function() { scope.$apply(); });

            scope.$on('auxiliaryPanelRestoreProportionsEvent', function() {
                var w, h, ch, save = false,
                    oldW, oldH;
                if ('text' !== cb.type && 'auto' !== cb.styles.height) {
                    oldW = parseInt(cb.styles.width);
                    oldH = parseInt(cb.styles.height);
                    scope.$emit('auxiliaryPanelMouseDownEvent');
                    if ('image' === cb.type) {
                        ch = cb.styles.width;
                        if (/%$/.test(ch)) {
                            w = ch = element[0].offsetWidth;
                        } else {
                            w = ch = parseInt(ch);
                        }
                        h = (cb.size.height / cb.size.width) * ch;
                        if (h < minHeight) {
                            h = minHeight;
                            w = (cb.size.width / cb.size.height) * h;
                        }
                    } else {
                        ch = cb.styles.width;
                        if (/%$/.test(ch)) {
                            w = element[0].offsetWidth;
                            h = 9 / 16 * w;
                        } else {
                            w = parseInt(ch);
                            h = 9 / 16 * w;
                        }

                        if (h < minHeight) {
                            h = minHeight;
                            w = (16 / 9) * h;
                        }
                    }
                    w = parseInt(w);
                    h = parseInt(h);

                    save = oldH !== h;

                    updateValues({
                        width: w,
                        height: h
                    }, save);
                }
            });

            element.bind('$destroy', function() {
                watch();
                mouseUp(null, true);
                angular.element(window).unbind('resize', resize);
                element.unbind('mousedown');
                scope.$destroy();
            });

            if (element[0].childNodes.length === 0) {
                addClasses(topControl, ['control', 'top']);
                addClasses(leftControl, ['control', 'left']);
                addClasses(rightControl, ['control', 'right']);
                addClasses(bottomControl, ['control', 'bottom']);

                addClasses(topLeftControl, ['control', 'top-left']);
                addClasses(topRightControl, ['control', 'top-right']);
                addClasses(bottomLeftControl, ['control', 'bottom-left']);
                addClasses(bottomRightControl, ['control', 'bottom-right']);


                element.append(topControl);
                element.append(leftControl);
                element.append(rightControl);
                element.append(bottomControl);
                element.append(topRightControl);
                element.append(bottomRightControl);
                element.append(bottomLeftControl);
                element.append(topLeftControl);
                // element.append(buttonEdit);

                // angular.element(buttonEdit).bind('mousedown', function(e) {
                //     scope.auxiliaryPanel.panel.show = false;
                //     scope.$emit('auxiliaryPanelClickEvent');
                // });

                scope.$on('auxiliaryPanelShowEvent', function() {
                    scope.auxiliaryPanel.panel.show = true;
                });
                // for remove
                cs.panel.scope = scope;
                cs.panel.scopeDestroy = scope.$destroy;
            } else {
                topControl = element[0].childNodes[0];
                leftControl = element[0].childNodes[1];
                rightControl = element[0].childNodes[2];
                bottomControl = element[0].childNodes[3];
                topRightControl = element[0].childNodes[4];
                bottomRightControl = element[0].childNodes[5];
                bottomLeftControl = element[0].childNodes[6];
                topLeftControl = element[0].childNodes[7];
                // buttonEdit = element[0].childNodes[8];
            }

            // element.unbind('mousedown');
            element.bind('mousedown', function(e) {
                if (1 === e.which) {
                    e.preventDefault();
                    e.stopPropagation();
                    globalMenuAPI.close();
                    acpManager.close();

                    pos = lib.getPosition(parent);

                    var border = lib.getBorder(cb.node),
                        padding = lib.getPadding(cb.node);

                    borderWidth = border.left + border.right;
                    borderHeight = border.top + border.bottom;

                    paddingWidth = padding.left + padding.right;
                    paddingHeight = padding.top + padding.bottom;

                    scope.$emit('auxiliaryPanelMouseDownEvent');

                    elPos = lib.getPosition(element[0]);
                    // elSize.width = element[0].offsetWidth - borderWidth - paddingWidth;
                    // elSize.height = element[0].offsetHeight - borderHeight - paddingHeight;
                    elSize.width = element[0].offsetWidth;
                    elSize.height = element[0].offsetHeight;
                    x = (e.clientX - pos.left) - (elPos.left - pos.left);
                    y = (e.clientY - pos.top) - (elPos.top - pos.top);

                    customLeft = e.clientX - pos.left - x;
                    customTop = e.clientY - pos.top - y;

                    customLeft /= $rootScope.zoomIcon;
                    customTop /= $rootScope.zoomIcon;

                    moveFlag = true;
                    moveTop = true;
                    moveLeft = true;

                    if (e.target !== element[0]) {
                        // minWidth = 30;
                        // minHeight = 30;

                        dragFlag = true;

                        oldWidth = elSize.width;
                        oldHeight = elSize.height;
                        oldTop = customTop;
                        oldLeft = customLeft;

                        proportions = {
                            forWidth: elSize.width / elSize.height,
                            forHeight: elSize.height / elSize.width
                        };

                        minWidthCorrect = proportions.forWidth >= 1 ?
                                            proportions.forWidth * minHeight : minHeight;

                        minHeightCorrect = proportions.forHeight >= 1 ?
                                            proportions.forHeight * minWidth : minWidth;

                        if (e.target === topControl) {
                            proportion = 't';
                        } else if (e.target === leftControl) {
                            proportion = 'l';
                        } else if (e.target === rightControl) {
                            proportion = 'r';
                        } else if (e.target === bottomControl) {
                            proportion = 'b';
                        } else {
                            ratio = proportions.forWidth < minWidth / minHeight;
                            if (e.target === topLeftControl) {
                                proportion = 'tl';
                            } else if (e.target === topRightControl) {
                                proportion = 'tr';
                            } else if (e.target === bottomLeftControl) {
                                proportion = 'bl';
                            } else if (e.target === bottomRightControl) {
                                proportion = 'br';
                            }
                        }
                        angular.element($window.document.body).addClass(proportion);
                    } else {
                        element.css('cursor', 'move');
                    }
                    angular.element($window.document).bind('mouseup', mouseUp);
                    angular.element($window.document).bind('mousemove', move);
                    angular.element($window.document).bind('ondragstart', false_);
                    angular.element($window.document).bind('onselectstart', false_);
                }
            });

            angular.element(window).unbind('resize', resize);
            angular.element(window).bind('resize', resize);

            $compile(element.contents())(scope);
        }
    }
}]);
'use strict';

constructorApp.directive('slidePreview', ['$compile', '$window', '$rootScope', 'convertFontSize', function($compile, $window, $rootScope, convertFontSize) {
    return {
        restrict: 'A',
        scope: {
            slidePreview: '='
        },
        link: function(scope, element, attrs) {
            var i, watch, slideshow, p, blocks,
                width, height, slide,
                setHeight =  function(proportions) {
                    angular.element(slideshow).css('height', slideshow.offsetWidth * proportions + 'px');
                },
                correctShadow = function(value, w, h, isBox) {
                    if (!value) { return value; }

                    value = value.split(' ');

                    value[0] = (parseInt(value[0]) * w) + 'px';
                    value[1] = (parseInt(value[1]) * h) + 'px';
                    value[2] = (parseInt(value[2]) * w) + 'px';
                    if (isBox) {
                        value[3] = (parseInt(value[3]) * w) + 'px';
                    }

                    return value.join(' ');
                },
                update = function(b) {
                    var style = {},
                        w = element[0].offsetWidth,
                        h = element[0].offsetHeight,
                        bWidth, bHeight, tmp,

                        correctPos = function(pos, num) {
                            var px = /px$/.test(pos);
                            pos = parseFloat(pos);
                            if (px) {
                                pos = (pos / num * 100);
                            }
                            return pos;
                        },
                        correctSize = function(s, num) {
                            var px;
                            if (typeof s === 'string') {
                                px = /px$/.test(s);
                            } else {
                                px = true;
                            }

                            s = parseFloat(s);
                            if (px) {
                                s = s / (num / 100);
                            }
                            return s;
                        };

                    b.styles['position'] = 'absolute';
                    if ('text' === b.type || 'button' === b.type || 'shape' === b.type) {
                        b.styles['font-size'] = (w / width * parseFloat(b.styles['font-size']));
                        if (b.styles['font-size'] < 1) {
                            b.styles['font-size'] = 1;
                        }
                        b.styles['font-size'] += 'px';

                        if ('button' === b.type) {
                            b.styles['padding'] = w / width * parseInt(b.styles['padding']) + 'px';
                        } else {
                            b.styles['padding'] = '0px';
                        }

                        b.styles['border-width'] = '1px';

                        if ('auto' !== b.styles['height']) {
                            b.styles['height'] = correctSize(b.styles['height'], height) + '%';
                        }

                        if ('auto' !== b.styles['width']) {
                            b.styles['width'] = correctSize(b.styles['width'], width) + '%';
                        }

                        b.styles['box-shadow'] = correctShadow(b.styles['box-shadow'], w / width, h / height, true);
                        b.styles['text-shadow'] = correctShadow(b.styles['text-shadow'], w / width, h / height);
                        convertFontSize.convertInvestedEm(b.node);
                    } else if ('image' === b.type) {
                        b.styles['padding'] = '0px';
                        b.styles['border-width'] = '1px';

                        if (b.isBackground) {
                            // b.styles['width'] = '100%';
                            // b.styles['height'] = '100%';

                            // if (width / height >= b.size.width / b.size.height) {
                            //     tmp = b.size.height >= h ? h : b.size.height;
                            //     bHeight = tmp;
                            //     bWidth = b.size.width / b.size.height * tmp;
                            // } else {
                            //     tmp = b.size.width >= w ? w : b.size.width;
                            //     bWidth = tmp;
                            //     bHeight = b.size.height / b.size.width * tmp;
                            // }
                            // b.styles['width'] = bWidth + 'px';
                            // b.styles['height'] = bHeight + 'px';

                            // b.styles['top'] = (h - bHeight) / 2 + 'px';
                            // b.styles['left'] = (w - bWidth) / 2 + 'px';
                        } else {
                            b.styles['width'] = correctSize(b.styles['width'], width) + '%';
                            if ('auto' !== b.styles['height']) {
                                b.styles['height'] = correctSize(b.styles['height'], height) + '%';
                            }
                        }
                        b.styles['box-shadow'] = correctShadow(b.styles['box-shadow'], w / width, h / height, true);
                    } else {

                        b.styles['width'] = correctSize(b.styles['width'], width) + '%';
                        b.styles['height'] = correctSize(b.styles['height'], height) + '%';
                    }

                    if (!b.isBackground) {
                        b.styles['top'] = correctPos(b.styles['top'], height) + '%';
                        b.styles['left'] = correctPos(b.styles['left'], width) + '%';
                    }
                    angular.element(b.node).css(b.styles);
                },
                getSize = function(forcibly) {
                    if (!width || forcibly) {
                        width = $rootScope.slideSize.width || scope.slidePreview.node.offsetWidth;
                    }
                    if (!height || forcibly) {
                        height = $rootScope.slideSize.height || scope.slidePreview.node.offsetHeight;
                    }
                },
                createSlide_ = function(index) {
                    var d = $window.document.createElement('div'), stl;

                    // width || (width = scope.slidePreview.node.offsetWidth);
                    // height || (height = scope.slidePreview.node.offsetHeight);

                    getSize();

                    element[0].innerHTML = '';
                    blocks = [];
                    slide = $window.document.createElement('div');
                    angular.element(slide).attr('ng-style', '{"background-color": slidePreview.styles["background-color"]}');
                    angular.element(slide).css('height', '100%');

                    angular.forEach(scope.slidePreview.blocks, function(b) {
                        var node;
                        if ('video' === b.type) {
                            // node = new Image();
                            // node.src = 'img/videos-icon-608x240.png';
                            node = angular.element('<div></div>')[0];
                            angular.element(node).css({ 'background-image': 'url(constructor/img/video-player.png)' }).addClass('video');
                        } else if ('text' === b.type) {
                            node = angular.element('<div></div>')[0];
                            node.innerHTML = b.content;
                            angular.element(node).css('word-wrap', 'break-word');
                        } else {
                            if (b.node) {
                                node = b.node.cloneNode(true);
                            } else {
                                node = new Image();
                                node.src = b.url;
                            }
                        }

                        blocks.push({
                            type: b.type,
                            node: node,
                            size: b.size,
                            styles: angular.copy(b.styles, {}),
                            isBackground: b.isBackground
                        });

                        if ('video' === b.type) {
                            stl = blocks[blocks.length - 1].styles;
                            if ('auto' === stl['width']) {
                                stl['width'] = b.node.offsetWidth + 'px';
                            }
                            if ('auto' === stl['height']) {
                                stl['height'] = b.node.offsetHeight + 'px';
                            }
                        } else if ('image' === b.type) {
                            blocks[blocks.length - 1].node.src = b.url;
                        } else if ('shape' !== b.type) {
                            if (!blocks[blocks.length - 1].node.firstChild) {
                                blocks[blocks.length - 1].node.innerHTML = 'Text...';
                            }
                        }

                        angular.element(blocks[blocks.length - 1].node)
                            .removeAttr('ng-style')
                            .removeAttr('ng-if')
                            .removeAttr('ng-src')
                            .removeAttr('block-text')
                            .removeAttr('ng-scope')
                            .removeAttr('index');

                        update(blocks[undefined === index ? index : blocks.length - 1]);

                        slide.appendChild(blocks[blocks.length - 1].node);

                        if (b.isBackground) {
                            angular.element(blocks[blocks.length - 1].node.parentNode).addClass('mss-centering-img');
                        }
                    });
                    d.appendChild(slide);
                    element.html(d.innerHTML);
                    $compile(element.contents())(scope);
                };
            slideshow = element[0];
            // createSlide_();
            setHeight(parseFloat(attrs.spHeight) / parseFloat(attrs.spWidth));

            scope.$on('slidePreviewUpdateEvent', function(e, data) {
                if (scope.slidePreview.index === data.index) {
                    createSlide_(data.index);
                    setHeight(parseFloat(attrs.spHeight) / parseFloat(attrs.spWidth));
                }
                data.cb && data.cb();
            });

            scope.$on('slidePreviewSlideSizeEvent', function(e, data) {
                width = data.width;
                height = data.height;
                setHeight(height / width);
                createSlide_(data.index);
            });

            for (i = 0; i < scope.slidePreview.blocks.length; i++) {
                createSlide_(i);
            }

            if (!element.children().length) {
                element.html('<div style="height: 100%;" ng-style="{\'background-color\': slidePreview.styles[\'background-color\']};"></div>');
                // $compile(element.contents())(scope);
            }
            $compile(element.contents())(scope);

            element.bind('$destroy', function() {
                scope.$destroy();
            });
        }
    };
}]);
'use strict';

constructorApp.directive('elseif', [ '$compile', function($compile) {
    return {
        restrict: 'A',
        scope: { elseif: '=' },
        link: function(scope, element, attrs) {
            var html = "<div class=\"col-sm-9\">";

            if (scope.elseif.units) {
                html += "\
                    <div class=\"input-group\">\
                        <div slideshow-options=\"elseif\" type=\"slideshow\" replace=\"true\"></div>\
                        <span class=\"input-group-addon\">{{elseif.units}}</span>\
                    </div>\
                ";
            } else {
                html += "<div slideshow-options=\"elseif\" type=\"slideshow\" replace=\"true\"></div>";
            }

            if (scope.elseif.description) {
                html += "<p class=\"help-block\" ng-bind-html=\"elseif.description\"></p>";
            }

            html += "</div>";

            element.replaceWith($compile(html)(scope));
            element.bind('$destroy', function() {
                scope.$destroy();
            });
        }
    };
}]);
'use strict';

constructorApp.service('imgToDataURL', [function() {
    return function(url, outputFormat, callback, quality) {
        var canvas = document.createElement('CANVAS'),
            ctx = canvas.getContext('2d'),
            img = new Image(), dataURL;

        img.onload = function() {
            canvas.height = img.height;
            canvas.width = img.width;
            try {
                ctx.drawImage(img, 0, 0);
                dataURL = canvas.toDataURL(outputFormat, quality);
                callback(null, dataURL);
            } catch (e) {
                callback(e, null);
            }
            canvas = img = null;
        };

        img.onerror = function(e) {
            callback(e, null);
        };

        img.src = url;
    };
}]);

constructorApp.factory('getHtmlSlideshow', ['$window', 'imgToDataURL', 'loader', 'messages', function($window, imgToDataURL, loader, messages) {
    var nameAndType = function(str) {
        var type;
        str = str.split('.');
        type = getMimeType(str.splice(str.length - 1, 1)[0]);
        str = str.join('');
        return {
            name: str,
            mimeType: type
        };
    },

    getCdata = function(id) {
        // return '<![cdata[' + id + ']]>';
        return '<![magicslideshow[' + id + ']]>';
    },

    getMimeType = function(type) {
        var result;
        switch (type) {
            case 'png':
            // case 'jpg':
            case 'gif': // сохранить может а конвертировать нет
            case 'bmp': // don't support
            case 'tiff':
            case 'x-icon':
            case 'svg+xml':
            case 'xxx':
                result = 'png';
                break;
            case 'gif':
                result = 'gif';
                break;
            case 'jpg':
                result = 'jpg';
                break;
            case 'jpeg':
                result = 'png';
                break;
            case 'webp':
                result = 'webp';
                break;
            default:
                result = 'png';
                break;
        }
        return result;
    },

    baseReplace = function(str) {
        return str ? str.replace(/^data:image\/(png|webp|jpeg);base64,/, '') : '';
    };

    return function(scope, callback_, spaces, zip) {
        var html,
            newline = '',
            size = {'base-width': 0, 'base-height': 0 },
            loadAllImg = function(callback) {
                var imgNames = [],
                    nextBlock = function(index, slide, cb) {
                        if (index < slide.blocks.length) {
                            var b = slide.blocks[index];

                            if ('image' === b.type) {
                                var i, name, mimeType, unique = true;

                                name = nameAndType(b.imgName);
                                mimeType = getMimeType(name.mimeType);
                                name = name.name;

                                for (i = 0; i < imgNames.length; i++) {
                                    if (imgNames[i] === name) {
                                        unique = false;
                                        break;
                                    }
                                }

                                if (unique) {
                                    imgNames.push(name);
                                    if (b.base64) {
                                        var data = b.base64;
                                        data = baseReplace(data);

                                        // images.file(name+'.'+mimeType, data, {base64: true});
                                        zip && zip.file(name+'.'+mimeType, data, {base64: true});
                                        nextBlock(++index, slide, cb);
                                    } else {
                                        loader.load(b.url, {
                                            onload: function (e) {
                                                imgToDataURL(b.url, 'image/' + mimeType, function(err, data) {
                                                    if (!err) {
                                                        data = baseReplace(data);

                                                        // images.file(name+'.'+mimeType, data, {base64: true});
                                                        zip && zip.file(name+'.'+mimeType, data, {base64: true});
                                                        nextBlock(++index, slide, cb);
                                                    } else {
                                                        b.otherDomain = true;
                                                        nextBlock(++index, slide, cb);
                                                    }
                                                }, 1);
                                            },
                                            error: function(e) {
                                                nextBlock(++index, slide, cb);
                                            }
                                        });
                                    }
                                } else {
                                    nextBlock(++index, slide, cb);
                                }
                            } else {
                                nextBlock(++index, slide, cb);
                            }
                        } else {
                            cb && cb();
                        }
                    },

                    nextSlide = function(slideIndex) {
                        if (slideIndex < scope.slides.length) {
                            nextBlock(0, scope.slides[slideIndex], function() {
                                nextSlide(++slideIndex);
                            });
                        } else {
                            callback && callback();
                        }
                    };
                nextSlide(0);
            },
            getSlide = function(slide, index) {
                var img, blocks = '', sld,
                    cloneSlide = scope.saveSlide(index),
                    children = cloneSlide.childNodes,
                    tag = '</div>',
                    wrapper = $window.document.createElement('div');

                angular.forEach(slide.blocks, function(b, i) {
                    var name, mimeType, url_,
                        w = $window.document.createElement('div');

                    if ('image' === b.type) {
                        img = children[i];

                        if (b.link) {
                            img.firstChild.removeAttribute('src');
                            img.firstChild.setAttribute('tempsrc', '');
                        } else {
                            img.removeAttribute('src');
                            img.setAttribute('tempsrc', '');
                        }

                        w.appendChild(img.cloneNode(true));
                        img = w.innerHTML;

                        if (!b.otherDomain && !messages.status) {
                            name = nameAndType(b.imgName);
                            mimeType = getMimeType(name.mimeType);
                            name = name.name;
                            img = img.replace(/tempsrc=""/, 'src="images/' + (name + '.' + mimeType) + '"');
                        } else {
                            if (messages.status && null !== b.imgId) {
                                url_ = getCdata(b.imgId);
                            } else {
                                url_ = b.url;
                            }
                            img = img.replace(/tempsrc=""/, 'src="' + url_ + '"');
                        }

                        img = img.replace(/ ng-scope/, '');

                        blocks += ((spaces ? '                ' : '') + img + newline);
                    } else {
                        w.appendChild(children[i].cloneNode(true));
                        blocks += ((spaces ? '                ' : '') + w.innerHTML + newline);
                    }
                });

                wrapper.appendChild(cloneSlide);
                cloneSlide.innerHTML = '{delimiter}';

                sld = wrapper.innerHTML.split('{delimiter}')[0];
                sld = sld.replace(/ng-scope/, '');
                sld += newline;
                sld += blocks;

                sld += ((spaces ? '            ' : '') + tag);
                return sld;
            };

        if (spaces) { newline = '\n'; }
        loadAllImg(function() {
            var v, dataOptions = '', slides = '';

            angular.forEach(scope.slides, function(s, i) {
                spaces && (slides += ('            <!-- slide ' + ( i + 1 ) + ' -->\n'));
                slides += ((spaces ? '            ' : '') + getSlide(s, i) + newline);
            });

            size['base-width'] = scope.mainField[0].offsetWidth;
            size['base-height'] = scope.mainField[0].offsetHeight;

            angular.forEach(scope.slideshowOptions, function(opt, i) {
                if (true === opt.value || false === opt.value) { opt.value += ''; }
                // if (scope.defaults.slideshowOptions[i].value !== opt.value || scope.defaults.slideshowOptions[i].name === 'base-height' || scope.defaults.slideshowOptions[i].name === 'base-width') {
                    // if ('base-width' === opt.name || 'base-height' === opt.name) {
                    //     v = size[opt.name];
                    // } else {
                        v = opt.value;
                    // }
                    dataOptions += (opt.name + ':' + v + ';');
                // }
            });

            html = (spaces ? '        ' : '') + '<div class="MagicSlideshow" data-options="' + dataOptions + '">' + newline + slides + (spaces ? '        ' : '') + '</div>' + newline;

            callback_ && callback_(html);
        });
    };
}]);

constructorApp.directive('gZip', ['$window', '$http', '$timeout', 'getHtmlSlideshow', 'imgToDataURL', 'aInfobarManager', 'paths', function($window, $http, $timeout, getHtmlSlideshow, imgToDataURL, aInfobarManager, paths) {
    var getComponent = function(url, callback) {
            $http.post(url, {})
            .success(function(data, state) {
                if (200 !== state) {
                    data = null;
                }
                callback(data);
            }).error(function(data) {
                callback();
            });
        },

        baseReplace = function(str) {
            return str ? str.replace(/^data:image\/(png|webp|jpeg);base64,/, '') : '';
        };
    return {
        restrict: 'A',
        // scope: false,
        link: function(scope, element, attrs) {
            var createZip = function() {
                var zip = new $window.JSZip(),
                    js, css, images, html,
                    dataOptions = '', content,
                    slides = '',

                    getComponents = function(callback) {
                        var result = {
                                js: null,
                                css: []
                            },
                            // count = 6,
                            count = 4,
                            allLoded = function() {
                                if (0 === count) {
                                    callback(result);
                                }
                            };

                        result.css.push({
                            img: true,
                            name: 'magicarrows.eot',
                            path: 'css/themes/fonts/',
                            data: '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'
                        });

                        result.css.push({
                            img: true,
                            name: 'magicarrows.svg',
                            path: 'css/themes/fonts/',
                            data: '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'
                        });

                        result.css.push({
                            img: true,
                            name: 'magicarrows.ttf',
                            path: 'css/themes/fonts/',
                            data: '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'
                        });


                        result.css.push({
                            img: true,
                            name: 'magicarrows.woff',
                            path: 'css/themes/fonts/',
                            data: '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'
                        });

                        getComponent(paths.zipMagicSLideshow + '/magicslideshow.js', function(data_) {
                            result.js = {
                                name: 'magicslideshow.js',
                                path: 'js/',
                                data: data_
                            };
                            count--;
                            allLoded();
                        });

                        getComponent(paths.zipMagicSLideshow + '/magicslideshow.css', function(data_) {
                            result.css.push({
                                name: 'magicslideshow.css',
                                path: 'css/',
                                data: data_
                            });
                            count--;
                            allLoded();
                        });

                        getComponent(paths.zipMagicSLideshow + '/themes/default/magicslideshow.defaults.css', function(data_) {
                            result.css.push({
                                name: 'magicslideshow.defaults.css',
                                path: 'css/themes/default/',
                                data: data_
                            });
                            count--;
                            allLoded();
                        });

                        // imgToDataURL(paths.zipMagicSLideshow + '/themes/default/graphics/buttons.png', 'image/png', function(err, data_) {
                        //     data_ = baseReplace(data_);
                        //     result.css.push({
                        //         img: true,
                        //         name: 'buttons.png',
                        //         path: 'css/themes/default/graphics/',
                        //         data: err ? null : data_
                        //     });
                        //     count--;
                        //     allLoded();
                        // });

                        // imgToDataURL(paths.zipMagicSLideshow + '/themes/default/graphics/buttons@2x.png', 'image/png', function(err, data_) {
                        //     data_ = baseReplace(data_);
                        //     result.css.push({
                        //         img: true,
                        //         name: 'buttons@2x.png',
                        //         path: 'css/themes/default/graphics/',
                        //         data: err ? null : data_
                        //     });
                        //     count--;
                        //     allLoded();
                        // });

                        imgToDataURL(paths.zipMagicSLideshow + '/themes/default/graphics/loader.gif', 'image/gif', function(err, data_) {
                            data_ = baseReplace(data_);
                            result.css.push({
                                img: true,
                                name: 'loader.gif',
                                path: 'css/themes/default/graphics/',
                                // data: err ? null : data_
                                data: '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'
                            });
                            count--;
                            allLoded();
                        });
                    };

                images = zip.folder("images");

                var timer = $timeout(function() {
                    element.addClass('loading');
                }, 200);

                getHtmlSlideshow(scope.$parent, function(slideshowHTML) {
                    var v, size = {'base-width': 0, 'base-height': 0},
                        jsSrc = 'http://www.magictoolbox.com/static/magicslideshow/magicslideshow.js',
                        cssSrc = 'http://www.magictoolbox.com/static/magicslideshow/magicslideshow.css';

                    getComponents(function(data) {
                        var create = true;
                        if (data.js.data) {
                            zip.file(data.js.path + data.js.name, data.js.data);
                            jsSrc = 'js/magicslideshow.js';
                        }

                        angular.forEach(data.css, function(f) {
                            if (!f.data) {
                                create = false;
                            }
                        });

                        if (create) {
                            cssSrc = 'css/magicslideshow.css';
                            angular.forEach(data.css, function(f) {
                                if (f.img) {
                                    zip.file(f.path + f.name, f.data, {base64: true});

                                } else {
                                    zip.file(f.path + f.name, f.data);
                                }
                            });
                        }


                        html =  '<!doctype html>\n' +
                                '<html>\n' +
                                '    <!-- magictoolbox.com -->\n' +
                                '    <head>\n' +
                                '        <title>Magic Slideshow</title>\n' +
                                '        \n' +
                                '        <!-- magicslideshow css -->\n' +
                                '        <link rel="stylesheet" href="' + cssSrc + '">\n' +
                                '        \n' +
                                '        <!-- magicslideshow js -->\n' +
                                '        <script src="' + jsSrc + '"></script>\n' +
                                '        \n' +
                                '    </head>\n' +
                                '    <body>\n' + slideshowHTML +
                                '    </body>\n' +
                                '</html>\n';

                        zip.file("index.html", html);

                        $timeout.cancel(timer);
                        element.removeClass('loading');
                        element.removeAttr('disabled');

                        content = zip.generate({type:"blob"});
                        $window.saveAs(content, "magicslideshow.zip");
                        aInfobarManager.showMessage('Slideshow loaded.');
                    });
                }, true, images);
            };



            element.bind('click', function(e) {
                element.addClass('loading');
                element.attr('disabled', 'disabled');
                createZip(e);
            });

            element.bind('$destroy', function() {
                element.bind('click');
            });
        }
    };
}]);
'use strict';

constructorApp.directive('hideField', [function() {
    return {
        restrict: 'A',
        scope: {
            hideField: '='
        },
        link: function(scope, element, attrs) {
            var watch = scope.$watch('hideField', function(nv) {
                if (nv) {
                    element.css('visibility', 'visible');
                } else {
                    element.css('visibility', 'hidden');
                }
            });
            element.bind('$destroy', function() {
                watch();
                scope.$destroy();
            });
        }
    };
}]);'use strict';

constructorApp.directive('savingAction', ['$compile', '$document', '$timeout', '$q', 'globalMenuAPI', '$rootScope', function($compile, $document, $timeout, $q, globalMenuAPI, $rootScope) {
    return {
        restrict: 'A',
        scope: true,
        controller: ['$scope', '$element', '$attrs', function($scope, $element, $attrs) {
            var MAX_SIZE = 15;
            $scope.stek = [];
            $scope.position = -1;
            $scope.prev = {
                node: null,
                disabled: true
            };

            $scope.next = {
                node: null,
                disabled: true
            };

            $scope.push = function(event) {
                $scope.clearHistory();
                if ($scope.stek.length === MAX_SIZE) {
                    $scope.stek.shift();
                } else {
                    $scope.position++;
                }
                $scope.stek.push(event);

                if (!$scope.next.disabled) {
                    $scope.next.disabled = true;
                }
                // if ($scope.prev.disabled && $scope.position > 0) {
                    $scope.prev.disabled = false;
                // }
            };

            $scope.clearHistory = function() {
                var i, arr = [];
                if ($scope.position < $scope.stek.length - 1) {
                    for (i = 0; i <= $scope.position; i++) {
                        arr.push($scope.stek[i]);
                    }
                    $scope.stek = arr;
                    if (!$scope.next.disabled) {
                        $scope.next.disabled = true;
                    }
                }
            };

            $scope.nextStep = function() {
                var l = $scope.stek.length;
                if ($scope.position < l - 1) {
                    $scope.position++;
                    $scope.$apply(function() {
                        if ($scope.position === l - 1) {
                            $scope.next.disabled = true;
                        }
                        if ($scope.prev.disabled) {
                            $scope.prev.disabled = false;
                        }
                    });
                    return $scope.stek[$scope.position];
                }
            };

            $scope.prevStep = function() {
                if ($scope.position >= 0) {
                    var s = $scope.stek[$scope.position];
                    $scope.position -= 1;
                    $scope.$apply(function() {
                        if ($scope.position === -1) {
                            $scope.prev.disabled = true;
                        }
                        if ($scope.next.disabled) {
                            $scope.next.disabled = false;
                        }
                    });
                    return s;
                }
            };
        }],

        link: function(scope, element, attrs) {
            var ctrl = false,
                shift = false,
                tmp,
                deferred,
                kd = function(e) {
                    if (ctrl || e.metaKey) {
                        if (90 === e.keyCode) { // ctrl + z
                            if (shift) {
                                nextClick(e);
                            } else {
                                prevClick(e);
                            }
                        } else if (89 === e.keyCode && !shift) { // ctrl + y
                            nextClick(e);
                        }
                    }
                    if (17 === e.keyCode) {
                        ctrl = true;
                    }
                    if (16 === e.keyCode) {
                        shift = true;
                    }
                },
                ku = function(e) {
                    if (17 === e.keyCode) {
                        ctrl = false;
                    }
                    if (16 === e.keyCode) {
                        shift = false;
                    }
                },
                prevClick = function(e) {
                    globalMenuAPI.close();
                    if (scope.position >= 0 && !deferred) {
                        deferred = $q.defer();
                        scope.$emit('savingActionToggle', {
                            action: 'prev',
                            deferred: deferred,
                            event: scope.prevStep()
                        });
                        deferred.promise.then(function() {
                            deferred = null;
                        });
                    }
                },
                nextClick = function(e) {
                    globalMenuAPI.close();
                    if (scope.position !== scope.stek.length - 1 && !deferred) {
                        deferred = $q.defer();
                        scope.$emit('savingActionToggle', {
                            action: 'next',
                            deferred: deferred,
                            event: scope.nextStep()
                        });
                        deferred.promise.then(function() {
                            deferred = null;
                        });
                    }
                };

            scope.prev.node = angular.element(document.querySelector('#control-button-prev'));
            scope.next.node = angular.element(document.querySelector('#control-button-next'));
            scope.prev.node.attr('ng-disabled', 'prev.disabled');
            scope.next.node.attr('ng-disabled', 'next.disabled');

            scope.$on('savingActionAddEvent', function(e, data) {
                if (!scope.$$phase) {
                    scope.$apply(function() {
                        scope.push(data.event);
                    });
                } else {
                    scope.push(data.event);
                }
            });

            scope.$on('savingActionReset', function(e, data) {
                scope.position = -1;
                scope.prev.disabled = true;
                scope.stek = [];
            });

            scope.prev.node.bind('click', prevClick);
            scope.next.node.bind('click', nextClick);

            $document.bind('keydown', kd);
            $document.bind('keyup', ku);

            element.bind('$destroy', function() {
                $document.unbind('keydown', kd);
                $document.unbind('keyup', ku);
                scope.$destroy();
            });

            $compile(element.contents())(scope);
        }
    };
}]);
'use strict';

constructorApp.directive('inputStyle', [function() {
    return {
        restrict: 'A',
        scope: {
            inputStyle: '='
        },
        link: function(scope, element, attrs) {
            var focusFlag = false,
                ts = attrs.typeStyle,
                watch = scope.$watch('inputStyle', function(nv, ov) {
                    if (focusFlag) {
                        scope.$emit('inputStyleEvent', {
                            type: 'change',
                            typeStyle: ts,
                            oldValue: ov,
                            newValue: nv
                        });
                    }
                }),

                focus = function(e) {
                    focusFlag = true;
                    scope.$emit('inputStyleEvent', {
                        type: 'focus'
                    });
                },

                blur = function(e) {
                    focusFlag = false;
                    scope.$emit('inputStyleEvent', {
                        type: 'blur'
                    });
                };

            element.bind('focus', focus);
            element.bind('blur', blur);
            element.bind('$destroy', function() {
                watch();
                element.unbind('focus', focus);
                element.unbind('blur', blur);
                scope.$destroy();
            });
        }
    };
}]);'use strict';

constructorApp.directive('buttonCheckbox', ['$compile', function($compile) {
    return {
        restrict: 'A',
        scope: {
            buttonCheckbox: '='
        },
        link: function(scope, element, attrs) {
            var lastButton, watch,
                buttons = [],
                ae = angular.element,
                set = function(node) {
                    ae(node).attr('disabled', 'disabled');
                    ae(node).addClass('disabled');

                    if (lastButton) {
                        ae(lastButton).removeAttr('disabled');
                        ae(lastButton).removeClass('disabled');    
                    }
                };

            watch = scope.$watch('buttonCheckbox', function(newValue) {
                if (newValue) {
                    angular.forEach(buttons, function(b) {
                        if (newValue === b.attr) {
                            set(b.node);
                            lastButton = b.node;
                        }
                    });    
                }
            });

            angular.forEach(element.find('button'), function(b, i) {
                buttons.push({
                    node: b,
                    attr: ae(b).attr('bcb')
                });

                ae(b).bind('mousedown', function(e) {
                    scope.$emit('buttonCheckboxEvent', {
                        target: ae(e.target).attr('bcb')
                    });
                });
            });

            element.bind('$destroy', function() {
                watch();
                scope.$destroy();
            });
        }
    };
}]);'use strict';

constructorApp.service('activeTab', [function() {
    this.currentTab = {
        index: 0
    };
}]);

constructorApp.directive('tabs', ['$compile', 'activeTab', 'globalMenuAPI', '$timeout', function($compile, activeTab, globalMenuAPI, $timeout) {
    return {
        restrict: 'A',
        scope: true,
        link: function(scope, element, attrs, ctrl) {
            var lastTab,
                watchers = [],
                cl = 'active',
                children = element[0].children[0].children[0].children,
                buttons = [],
                containerTabs = angular.element('<div class="container-tabs"></div>'),
                animationLine = angular.element('<div class="tabs-animation-line"></div>'),
                indicatorLine = angular.element('<div class="tabs-indicator-line"></div>'),

                createTab = function(name, index) {
                    var button = angular.element('<button index="' + index + '" id="tab-' + name + '">' + (name.charAt(0).toUpperCase() + name.substr(1)) +'</button>');
                    button.bind('click', function(e) {
                        var tab, index, v;
                        e.preventDefault();
                        e.stopPropagation();

                        tab = angular.element(e.target);
                        index = tab.attr('index');

                        if (lastTab.attr('index') !== index) {
                            scope.$apply(function() {
                                scope.currentTab.index = parseInt(index);
                            });
                        }
                        globalMenuAPI.close();
                    });
                    buttons.push(button);
                    return button;
                },

                getValues = function(node) {
                    return {
                        width: node[0].offsetWidth,
                        left: node[0].offsetLeft
                    }
                },

                setValues = function(node) {
                    var v = getValues(node);
                    if (v.width > 0) {
                        indicatorLine.css({
                            'width': v.width + 'px',
                            'left': v.left + 'px'
                        });
                    }
                };

            scope.currentTab = activeTab.currentTab;
            scope.currentTab.index = parseInt(attrs.tabs);

            if (isNaN(scope.currentTab.index) || scope.currentTab.index >= children.length) {
                scope.currentTab.index = 0;
            }

            angular.forEach(children, function(ch, i) {
                var ach = angular.element(ch),
                    tab = createTab(ach.attr('tab'), i);

                ach.attr('ng-show', i + ' == currentTab');

                ach.addClass('content');

                if (i === scope.currentTab.index) {
                    tab.addClass('active');
                    lastTab = tab;
                }
                containerTabs.append(tab[0]);
            });

            indicatorLine.css({ 'width': '0px', 'left': '0px' });

            animationLine.append(indicatorLine[0]);
            containerTabs.append(animationLine[0]);

            containerTabs.attr('count', children.length);
            element[0].insertBefore(containerTabs[0], element[0].firstChild);
            // element.append(containerTabs[0]);
            // element.append(scroll[0]);
            setValues(lastTab);
            watchers.push(scope.$watch('currentTab.index', function(nv, ov) {
                var tab, v;
                if (undefined !== nv && nv !== ov) {
                    tab = buttons[nv];
                    if (tab && lastTab.attr('index') !== nv && tab !== lastTab) {
                        tab.addClass(cl);
                        lastTab.removeClass(cl);
                        lastTab = tab;
                    }
                }
                $timeout(function() {
                    setValues(lastTab);
                }, 0);
            }));

            watchers.push(scope.$parent.$parent.$watch('slideEditor.flags.slide', function() {
                $timeout(function() {
                    setValues(lastTab);
                }, 0);
            }));

            element.bind('$destroy', function() {
                angular.forEach(watchers, function(watcher) { watcher(); });
                scope.$destroy();
            });

        }
    };
}]);
'use strict';

constructorApp.directive('resizeField', ['$window', '$timeout', function($window, $timeout) {
    return {
        restrict: 'A',
        link: function(scope, element, attrs) {
            var timer;
            angular.element($window).bind('resize', function(e) {
                // $timeout.cancel(timer);
                // timer = $timeout(function() {
                //     scope.calcCanvasSize();
                //     scope.$$correctBlocksPosition();
                // }, 200);
            });

            element.bind('$destroy', function() {
                angular.element($window).unbind('resize');
            });
        }
    };
}]);'use strict';

constructorApp.directive('keepColor', ['$timeout', function($timeout) {
    return {
        restrict: 'A',
        require: '?ngModel',
        link: function(scope, element, attrs, ngModel) {
            var s = attrs.keepColor,
                watch;
            watch = scope.$watch(function () {
                return ngModel.$modelValue;
            }, function(newValue, oldValue) {
                if (newValue) {
                    scope.$emit('keepColorEvent', {
                        oldValue: oldValue,
                        style: s
                    });
                }
            });

            element.bind('$destroy', function() {
                watch();
                scope.$destroy();
            });
        }
    };
}]);'use strict';

constructorApp.directive('controlLine', ['lib', '$document','$window', 'globalMenuAPI', function(lib, $document, $window, globalMenuAPI) {
    return {
        restrict: 'A',
        scope: true,
        link: function(scope, element, attrs) {
            var minTopHeight = 250,
                minBottomHeight = 20,
                containerPositionY,
                containerHeight,
                correctSize,

                bottomContent = element.parent(),
                container = bottomContent.parent(),
                topContent = angular.element(container.children()[0]),

                move = function(e) {
                    var t, b;
                    if (1 === e.which) {
                        e.stopPropagation();
                        e.preventDefault();
                        t = e.pageY - containerPositionY - correctSize;
                        if (t < minTopHeight) {
                            t = minTopHeight;
                        }

                        b = containerHeight - t;
                        if (b < minBottomHeight) {
                            b = minBottomHeight;
                            t = containerHeight - b;
                        }

                        scope.$emit('controlLineEventResize');

                        setCss(t, b);
                    }
                },

                mouseDown = function(e) {
                    if (1 === e.which) {
                        e.stopPropagation();
                        e.preventDefault();
                        !containerHeight && (containerHeight = container[0].offsetHeight);
                        correctSize = e.pageY - lib.obj.positY(element[0]);
                        containerPositionY = lib.obj.positY(container[0]);

                        globalMenuAPI.close();

                        container.addClass('move');
                        $document.bind('mousemove', move);
                        $document.bind('mouseup', mouseUp);
                    }
                },

                mouseUp = function(e) {
                    if (1 === e.which) {
                        e.stopPropagation();
                        e.preventDefault();
                        container.removeClass('move');
                        $document.unbind('mousemove', move);
                        $document.unbind('mouseup', mouseUp);
                    }
                },

                resize = function() {
                    var top, bottom,
                        oldContainerHeight = containerHeight;
                    containerHeight = container[0].offsetHeight;

                    bottom = bottomContent[0].offsetHeight / oldContainerHeight * containerHeight;
                    top = containerHeight - bottom;

                    scope.$emit('controlLineEventResize');
                    setCss(top, bottom);
                },

                setCss = function(top, bottom) {
                    topContent.css('height', top + 'px');
                    bottomContent.css('height', bottom + 'px');
                };

            element.bind('mousedown', mouseDown);
            angular.element($window).bind('resize', resize);

            element.bind('$destroy', function() {
                element.unbind('mousedown', mouseDown);
                angular.element($window).unbind('resize', resize);
                scope.$destroy();
            });

            element.append('<span class="cl-title">Animation timeline</span>');
            element.append('<span class="cl-control"></span>');
        }
    };
}]);'use strict';

constructorApp.factory('tl', [function() {
    var f = { maxScale: { value: 0 }, width: { value: 0}, activeBlock: { value: null } };
    return f;
}]);

constructorApp.directive('timeline', ['$compile', 'tl', '$timeout', 'globalMenuAPI', function($compile, tl, $timeout, globalMenuAPI) {
    return {
        restrict: 'A',
        scope: {
            timeline: '=',
            activeBlock: '='
        },
        template:   '<div class="tl-time-scale" time-scale="timeline.slideOptions[3].value"></div>' +
                    '<div class="tl-container">' +
                        '<div class="tl-wrapper">' +
                            '<div class="tl-wrapper-without-scroll">' +
                                '<div class="tl-content" timeline-content="timeline"></div>' +
                            '</div>' +
                        '</div>' +
                    '</div>',
        link: function(scope, element, attrs) {
            var el = false,
                lastScale,
                watchers = [],
                calcMaxScale = function(index, calc) {
                    var last = 0,
                        scale = parseInt(scope.timeline.slideOptions[3].value),
                        calcBlock = function(b) {
                            var tmp = 0,
                                leftD = 0,
                                leftS = 0,
                                rightD = 0,
                                rightS = 0;

                            if ('fixed' !== b.options[3].value) {
                                leftD = parseInt(b.options[6].value);
                                leftS = parseInt(b.options[4].value);
                            }
                            if ('fixed' !== b.options[9].value) {
                                rightD = parseInt(b.options[15].value);
                                rightS = parseInt(b.options[10].value);
                            }

                            tmp += leftD;
                            tmp += leftS;

                            if (tmp < rightD) {
                                if (rightD) {
                                    tmp = rightD;
                                }
                            }

                            tmp += rightS;

                            if (last < tmp) last = tmp;
                        };

                    if (undefined === index) {
                        angular.forEach(scope.timeline.blocks, function(b) {
                            calcBlock(b);
                        });
                    } else {
                        calcBlock(scope.timeline.blocks[index]);
                        if (scale < lastScale) {
                            scale = lastScale;
                        }
                    }

                    if (last > scale) {
                        scale = last;
                    }

                    lastScale = scale;
                    tl.maxScale.value = scale;
                    
                    scope.$broadcast('drawCanvas', {scale: lastScale});
                };

            watchers.push(scope.$watch('timeline.index', function(nv) {
                if (undefined !== nv) {
                    el = true;
                    lastScale && (lastScale = parseInt(scope.timeline.slideOptions[3].value));
                    tl.maxScale.value && (tl.maxScale.value = parseInt(scope.timeline.slideOptions[3].value));

                    $timeout(function() {
                        scope.$broadcast('drawCanvas', {scale: lastScale});
                    }, 0);
                }
            }));

            watchers.push(scope.$on('tlRecalcCanvas', function(e) {
                e.stopPropagation();
                if (el) {
                    calcMaxScale();
                    scope.$broadcast('tlRecalcAll');
                }
            }));

            watchers.push(scope.$watch('timeline.slideOptions[3].value', function(nv, ov) {
                if (undefined !== nv && el && nv !== ov) {
                    calcMaxScale(undefined, true);
                    scope.$broadcast('tlRecalcAll');
                }
            }));

            watchers.push(scope.$watch('activeBlock', function(nv, ov) {
                tl.activeBlock.value = nv;
            }));

            element.bind('mousedown', function() {
                globalMenuAPI.close();
            });

            element.bind('$destroy', function() {
                element.unbind('mousedown');
                angular.forEach(watchers, function(watcher) {
                    watcher();
                });
                watchers = [];
                scope.$destroy();
            });
        }
    };
}]);

constructorApp.directive('timeScale', ['tl', function(tl) {
    var getStep = function(allScale /* ms */, containerWidth, font) {
        var i, s, result, step, lastStep,
            steps = [100, 200, 500],
            coefficient = 1,
            textWidth, text = "00000",
            canvas = angular.element('<canvas>'),
            context = canvas[0].getContext('2d');

        if (!allScale || !containerWidth) return 100;

        context.font = font || "10px Arial";
        context.textAlign = 'center';
        context.fillStyle = 'back';
        context.fillText(text, canvas[0].width / 2, canvas[0].height / 2);

        textWidth = context.measureText(text).width;
        lastStep = steps[0];

        while (!result) {
            for (i = 0; i < steps.length; i++) {
                step = steps[i] * coefficient;
                s = allScale / step;
                s *= textWidth;

                if (s <= containerWidth) {
                    result = step;
                    break;
                }
                lastStep = step;
            }
            coefficient *= 10;
        }

        return result;
    };
    return {
        restrict: 'A',
        scope: {
            timeScale: '='
        },
        link: function(scope, element, attrs) {
            var slideId = attrs.slideId,
                font = "10px Arial",
                watchers = [],
                leftPadding = 5,
                canvas = angular.element('<canvas>'),
                context = canvas[0].getContext('2d'),
                draw = function(ts) {
                    var lineSize, step, p, pos, ms, stepPos,
                        sts = parseInt(scope.timeScale),
                        sum = ts || sts, tmp,

                        // width = scope.width.value || element[0].offsetWidth,
                        width = element[0].offsetWidth,
                        height = element[0].offsetHeight,

                        scaleWidth = scope.width.value + leftPadding,

                        round = function(value) {
                            value = value / 10;
                            value = Math.round(value);
                            value /= 100;
                            return value;
                        };

                    canvas[0].width = width;
                    canvas[0].height = height;

                    context.clearRect(0, 0, canvas.width, canvas.height);

                    step = getStep(ts, scaleWidth - leftPadding, font);

                    if (ts > sts) {
                        context.fillStyle = '#bebebe';
                        tmp = sts / ts * (scaleWidth - leftPadding);
                        context.fillRect(tmp + leftPadding, 0, width - tmp, height);
                        context.fillStyle = 'black';
                    }

                    stepPos = step / sum * (scaleWidth - leftPadding);
                    pos = leftPadding;
                    ms = 0;

                    context.beginPath();
                    context.moveTo(0, height);
                    context.lineTo(width, height);
                    context.stroke();
                    context.closePath();

                    while(pos < scaleWidth) {
                        if (ms &&  ms % 1000 === 0 ) {
                            lineSize = 8;
                        } else {
                            lineSize = 5;
                        }

                        p = Math.floor(pos) + 0.5;

                        context.beginPath();
                        context.moveTo(p, height);
                        context.lineTo(p, height - lineSize);
                        context.stroke();
                        context.closePath();

                        
                        context.font = font;
                        context.lineWidth = 1;

                        context.textAlign = "center";

                        context.fillText(round(ms) + 's', p , height - 12);

                        pos += stepPos;
                        ms += step;


                        if (pos >= scaleWidth && pos - scaleWidth <= 0.5) {
                            pos = scaleWidth - 0.5;
                        }
                    }
                };

            scope.width = tl.width;

            watchers.push(scope.$on('drawCanvas', function(e, data) {
                draw(data.scale);
            }));

            element.bind('$destroy', function() {
                angular.forEach(watchers, function(watcher) {
                    watcher();
                });
                watchers = [];
                scope.$destroy();
            });

            element.append(canvas[0]);
        }
    };
}]);

constructorApp.directive('timelineContent', ['$compile', 'tl', '$window', '$timeout', function($compile, tl, $window, $timeout) {
    return {
        restrict: 'A',
        scope: {
            timelineContent: '='
        },
        link: function(scope, element, attrs) {
            var timer = null,
                line = angular.element('<div class="tl-line" ng-repeat="block in timelineContent.blocks | timing" timeline-item="block"></div>'),
                resize = function() {
                    $timeout.cancel(timer);
                    $timeout(function() {
                        tl.width.value = element[0].offsetWidth;
                        scope.$emit('tlRecalcCanvas');
                    }, 100);
                };

            element.append(line[0]);
            tl.width.value = element[0].offsetWidth;

            angular.element($window).bind('resize', resize);

            element.bind('$destroy', function() {
                angular.element($window).unbind('resize', resize);
                scope.$destroy();
            });
            
            $compile(element.contents())(scope);
        }
    };
}]);

constructorApp.directive('timelineItem', ['$compile', 'tl', 'globalMenuAPI', function($compile, tl, globalMenuAPI) {
    return {
        restrict: 'A',
        scope: {
            timelineItem: '='
        },
        link: function(scope, element, attrs) {
            var minSpeed = 50,
                stock = 3,
                watchers = [],
                line = angular.element('<div class="tl-line-scale"></div>'),

                leftLine = angular.element('<div class="tl-control-line tl-control-line-left" ' +
                                                'ng-show="leftIsShow" ' +
                                                'min="0" ' +
                                                'max="max" ' +
                                                'delay="timelineItem.options[6].value" ' +
                                                'speed="timelineItem.options[4].value" ' +
                                                'is-mouse-doown="isMouseDown" ' +
                                                'tl-control-line="left"></div>'),

                centerLine = angular.element('<div ng-show="centerIsShow" class="tl-control-line tl-center-line"></div>'),

                rightLine = angular.element('<div class="tl-control-line tl-control-line-right" ' +
                                                'ng-show="rightIsShow" ' +
                                                'min="min" ' +
                                                'max="slideSpeed.value" ' +
                                                'delay="timelineItem.options[15].value" ' +
                                                'speed="timelineItem.options[10].value" ' +
                                                'is-mouse-doown="isMouseDown" ' +
                                                'tl-control-line="right"></div>'),

                calcMinMax = function() {
                    var leftd = parseInt(scope.timelineItem.options[6].value),
                        lefts = parseInt(scope.timelineItem.options[4].value),
                        rightd = parseInt(scope.timelineItem.options[15].value);

                    scope.min = scope.leftIsShow ? (leftd + lefts) : 0;

                    if (scope.rightIsShow) {
                        scope.max = (leftd + lefts > rightd) ? leftd + lefts : rightd;
                    } else {
                        scope.max = tl.maxScale.value;
                    }
                },

                getMinMax = function() {
                    return {
                        left: {
                            min: 0,
                            max: scope.max
                        },
                        right: {
                            min: scope.min,
                            max: tl.maxScale.value
                        }
                    };
                },

                calcWidthCenterLine = function() {
                    var width, l, w;
                    if (scope.leftIsShow && scope.rightIsShow) {
                        width = element[0].offsetWidth;

                        w = (scope.max - scope.min) / tl.maxScale.value * width;
                        w += (stock*2);
                        l = scope.min / tl.maxScale.value * width;
                        l -= stock;
                        centerLine.css({ 'left': l + 'px', 'width': w + 'px' });
                    }
                },

                mouseDown = function(e) {
                    var ind = scope.timelineItem.index;
                    scope.$apply(function() { tl.activeBlock.value = ind; });
                    scope.$emit('timelineSetActiveBlock', { index: ind });
                };

            scope.leftIsShow = false;
            scope.rightIsShow = false;
            scope.centerIsShow = false;
            scope.isMouseDown = false;
            scope.activeBlock = tl.activeBlock;
            scope.slideSpeed = tl.maxScale;

            calcMinMax();

            line.append(leftLine[0]);
            line.append(centerLine[0]);
            line.append(rightLine[0]);
            
            element.append(line[0]);


            watchers.push(scope.$watch('timelineItem.options[3].value', function(nv) {
                scope.leftIsShow = 'fixed' !== nv;
                if (scope.rightIsShow) {
                    calcMinMax();
                    if (parseInt(scope.timelineItem.options[15].value) < parseInt(scope.timelineItem.options[6].value) + parseInt(scope.timelineItem.options[4].value)) {
                        scope.$emit('tlRecalcCanvas');
                    } else {
                        scope.$broadcast('tlRecalcLines', getMinMax());
                    }
                }
                scope.centerIsShow = scope.leftIsShow && scope.rightIsShow;
            }));

            watchers.push(scope.$watch('timelineItem.options[9].value', function(nv) {
                scope.rightIsShow = 'fixed' !== nv;
                if (scope.rightIsShow) {
                    calcMinMax();
                    if (scope.leftIsShow && scope.min + parseInt(scope.timelineItem.options[10].value) > tl.maxScale.value) {
                        scope.$emit('tlRecalcCanvas');
                    } else {
                        scope.$broadcast('tlRecalcLines', getMinMax());
                    }
                }
                scope.centerIsShow = scope.leftIsShow && scope.rightIsShow;
            }));

            watchers.push(scope.$watch('timelineItem.options[15].value', function(nv) {
                if (scope.rightIsShow) {
                    if (!scope.isMouseDown) {
                        scope.$emit('tlRecalcCanvas');
                    } else {
                        calcMinMax();
                        calcWidthCenterLine();
                        scope.$broadcast('tlRecalcMinMax', getMinMax());
                    }
                }
            }));

            watchers.push(scope.$watch('timelineItem.options[10].value', function(nv) {
                if (scope.rightIsShow) {
                    if (!scope.isMouseDown) {
                        scope.$emit('tlRecalcCanvas');
                    }
                }
            }));

            watchers.push(scope.$watchGroup(['timelineItem.options[6].value', 'timelineItem.options[4].value'], function(nv) {
                if (scope.leftIsShow) {
                    if (!scope.isMouseDown) {
                        scope.$emit('tlRecalcCanvas');
                    } else {
                        calcMinMax();
                        calcWidthCenterLine();
                        scope.$broadcast('tlRecalcMinMax', getMinMax());
                    }
                }
                calcWidthCenterLine();
            }));

            watchers.push(scope.$on('tlRecalcAll', function(e, data) {
                if (scope.leftIsShow && scope.rightIsShow) {
                    var ld = parseInt(scope.timelineItem.options[6].value),
                        ls = parseInt(scope.timelineItem.options[4].value),
                        rd = parseInt(scope.timelineItem.options[15].value);

                    if (ld + ls > rd) {
                        scope.timelineItem.options[15].value = ld + ls;
                    }
                }

                calcMinMax();
                calcWidthCenterLine();
                scope.$broadcast('tlRecalcLines', getMinMax());
            }));


            watchers.push(scope.$watch(scope.leftIsShow, function(nv) {
                if (undefined !== nv) calcMinMax();
            }));

            watchers.push(scope.$watch(scope.rightIsShow, function(nv) {
                if (undefined !== nv) calcMinMax();
            }));

            element.bind('mousedown', mouseDown);
            watchers.push(scope.$on('timelineMouseDown', function(e) {
                e.stopPropagation();
                mouseDown();
                globalMenuAPI.close();
            }));

            watchers.push(scope.$watch('activeBlock.value', function(nv, ov) {
                if (scope.timelineItem.index === nv) {
                    element.addClass('active');
                } else {
                    element.removeClass('active');
                }
            }));

            element.bind('$destroy', function() {
                angular.forEach(watchers, function(watcher) {
                    watcher();
                });
                element.unbind('mousedown', mouseDown);
                watchers = [];
                scope.$destroy();
            });

            $compile(element.contents())(scope);
        }
    };
}]);

constructorApp.directive('tlControlLine', ['lib', '$document', 'tl',  function(lib, $document, tl) {
    return {
        restrict: 'A',
        scope: {
            delay: '=',
            speed: '=',
            min: '=',
            max: '=',
            isMouseDoown: '='
        },
        link: function(scope, element, attrs) {
            var wrapper = angular.element('<div class="tl-control-line-wrapper"></div>'),
                leftControl = angular.element('<div class="tl-mouse-control-left"></div>'),
                rightControl = angular.element('<div class="tl-mouse-control-right"></div>'),
                events = [],

                mainContainer = element.parent().parent().parent().parent().parent().parent().parent().parent().parent(),

                left, right, width, elPos, elCorrect, min, max,
                minWidth,
                containerWidth = element.parent()[0].offsetWidth,
                containerPos = 0,

                curentEvent = '',
                moves = {
                    elementMove: function(e) {
                        if (1 === e.which) {
                            e.stopPropagation();
                          
                            left = (e.pageX - containerPos) - elPos;

                            if (left < min) {
                                left = min;
                            } else if (left + width > max) {
                                left = max - width;
                            }

                            right = left + width;

                            setCss(left, width);
                            calcDS(true);
                        }
                    },
                    leftControlMove: function(e) {
                        if (1 === e.which) {
                            var oldLeft = left;
                            e.stopPropagation();

                            left = (e.pageX - containerPos) - elPos;

                            if (left < min) {
                                left = min;
                            }

                            width += (oldLeft - left);

                            if (minWidth > width) {
                                width = minWidth;
                                left = right - minWidth;
                            }
                            
                            setCss(left, width);
                            calcDS(true);
                        }
                    },
                    rightControlMove: function(e) {
                        if (1 === e.which) {
                            e.stopPropagation();
                            var pos = (e.pageX - containerPos) + elCorrect;
                            width = pos - left;

                            if (width < minWidth) {
                                width = minWidth;
                            } else if (left + width > max) {
                                width = max - left;
                            }

                            right = left + width;

                            setCss(left, width);
                            calcDS(true);
                            scope.$apply();
                        }
                    }
                },

                mouseUp = function(e) {
                    if (1 === e.which) {
                        e.stopPropagation();

                        $document.unbind('mousemove', moves[curentEvent]);
                        $document.unbind('mouseup', mouseUp);
                        mainContainer.removeClass('col-move');
                        element.removeClass('col-move');
                        scope.$apply(function() {
                            scope.isMouseDoown = false;
                        });
                    }
                },

                setCss = function(l, w) {
                    element.css({ 'left': l + 'px', 'width': w  + 'px'});
                },

                calcDS = function(apply) {
                    var f = function() {
                        scope.delay = Math.round(left / containerWidth * tl.maxScale.value);
                        scope.speed = Math.round(width / containerWidth * tl.maxScale.value);
                    };

                    // console.log(scope.$$phase);
                    // console.log(scope.$parent.$parent.$parent.$parent.$parent.$$phase);
                    // console.log(scope.$parent.$parent.$parent.$parent.$parent.$parent.$$phase);

                    if (!scope.$$phase && apply) {
                        scope.$apply(function() { f(); });
                    } else {
                        f();
                    }
                },

                calcLeft = function() {
                    return scope.delay / tl.maxScale.value * containerWidth;
                },

                calcWidth = function() {
                    return scope.speed / tl.maxScale.value * containerWidth;
                },

                calcMin = function() { // ms to px
                    var result = 0;
                    if (scope.min) {
                        result = scope.min / tl.maxScale.value * containerWidth;
                    }
                    return result;
                },

                calcMax = function() { // ms to px
                    var result;
                    if (scope.max) {
                        result = scope.max / tl.maxScale.value * containerWidth;
                    } else {
                        result = containerWidth;
                    }
                    return result;
                },

                calcMinWidth = function() {
                    var minMs = 50;
                    minWidth = minMs / tl.maxScale.value * containerWidth;
                },

                recalc = function() {
                    if (!scope.isMouseDown) {
                        containerWidth = element.parent()[0].offsetWidth,
                        min = calcMin();
                        max = calcMax();

                        left = calcLeft();
                        width = calcWidth();

                        if (left < min) {
                            left = min;
                        }

                        if (left + width > max) {
                            width = Math.abs(max - left);
                        }

                        right = left + width;

                        // calcDS();
                        setCss(left, width);
                    }
                },

                elMouseDown = function(e) {
                    if (1 === e.which) {
                        defaultEvents(e);
                        element.addClass('col-move');
                        curentEvent = 'elementMove';
                        containerPos = lib.obj.positX(element.parent()[0]);
                        elPos = e.pageX - lib.obj.positX(element[0]);
                        addingEvents();
                    }
                },

                lMouseDown = function(e) {
                    if (1 === e.which) {
                        defaultEvents(e);
                        curentEvent = 'leftControlMove';
                        containerPos = lib.obj.positX(element.parent()[0]);
                        elPos = e.pageX - lib.obj.positX(element[0]);
                        addingEvents();
                    }
                },

                rMouseDown = function(e) {
                    var halfSize;
                    if (1 === e.which) {
                        defaultEvents(e);
                        curentEvent = 'rightControlMove';

                        containerPos = lib.obj.positX(element.parent()[0]);
                        halfSize = rightControl[0].offsetWidth / 2;
                        elCorrect = e.offsetX;

                        if (e.offsetX > halfSize) {
                            elCorrect = halfSize - e.offsetX;
                            elCorrect -= 1;
                        } else {
                            elCorrect = halfSize - e.offsetX;
                        }

                        addingEvents();
                    }
                },

                defaultEvents = function(e) {
                    e.stopPropagation();
                    scope.isMouseDoown = true;
                    mainContainer.addClass('col-move');
                    scope.$emit('timelineMouseDown');
                },

                addingEvents = function() {
                    $document.bind('mousemove', moves[curentEvent]);
                    $document.bind('mouseup', mouseUp);
                };

            calcMinWidth();

            left = calcLeft();
            width = calcWidth();
            right = left + width;

            setCss(left, width);

            element.bind('mousedown', elMouseDown);
            leftControl.bind('mousedown', lMouseDown);
            rightControl.bind('mousedown', rMouseDown);

            events.push(scope.$on('tlRecalcMinMax', function(e, data) {
                scope.min = data[attrs.tlControlLine].min;
                scope.max = data[attrs.tlControlLine].max;
                min = calcMin();
                max = calcMax();
            }));

            events.push(scope.$on('tlRecalcLines', function(e, data) {
                scope.min = data[attrs.tlControlLine].min;
                scope.max = data[attrs.tlControlLine].max;
                recalc();
            }));

            events.push(scope.$watchGroup(['delay', 'speed'], function(nv) {
                recalc();
            }));

            wrapper.append(leftControl[0]);
            wrapper.append(angular.element('<div class="tl-stick-left"></div>')[0]);
            wrapper.append(angular.element('<div class="tl-stick-right"></div>')[0]);
            wrapper.append(rightControl[0]);
            element.append(wrapper[0]);

            element.bind('$destroy', function() {
                angular.forEach(events, function(ev) {
                    ev();
                });
                element.unbind('mousedown', elMouseDown);
                leftControl.unbind('mousedown', lMouseDown);
                rightControl.unbind('mousedown', rMouseDown);
                events = [];
                scope.$destroy();
            });
        }
    };
}]);
'use strict';

constructorApp.directive('lbOneBlock', ['$compile', function($compile) {
    return {
        restrict: 'A',
        scope: {
            lbOneBlock: '='
        },
        link: function(scope, element, attrs) {
            element.bind('click', function(e) {
                e.preventDefault();
                scope.$emit('timelineSetActiveBlock', { index: scope.lbOneBlock.index });
            });

            element.bind('mouseover', function(e) {
                e.preventDefault();
                angular.element(scope.lbOneBlock.node).addClass('over');
                angular.element(scope.lbOneBlock.outline).addClass('over');
            });

            element.bind('mouseout', function(e) {
                e.preventDefault();
                angular.element(scope.lbOneBlock.node).removeClass('over');
                angular.element(scope.lbOneBlock.outline).removeClass('over');
            });
            
            element.bind('$destroy', function() {
                element.unbind('click');
                element.unbind('mouseover');
                element.unbind('mouseout');
                scope.$destroy();
            });
        }
    };
}]);'use strict';

constructorApp.directive('controlPanelBlocks', ['$compile', '$document', '$rootScope', function($compile, $document, $rootScope) {
    return {
        restrict: 'A',
        scope: {
            controlPanelBlocks: '='
        },
        link: function(scope, element, attrs) {
            var kd = function(e) {
                    // 8 === e.keyCode - backspace; we need to remove text from text editor
                    if (46 === e.keyCode && !$rootScope.globalMenuIsOpen && !$rootScope.colorPickerOpened && !$rootScope.newItemWindowIsOpened &&
                        !($document[0].activeElement && $document[0].activeElement.tagName && 'input' === $document[0].activeElement.tagName.toLowerCase())) {
                        e.preventDefault();
                        e.stopPropagation();
                        if (scope.controlPanelBlocks.blocks.length > 0) {
                            scope.$emit('controlPanelBlocksEvent', { type: 'remove' });
                        }
                    }
                },

                imgButton = angular.element(document.querySelector('#control-button-add-new-image')),
                videoButton = angular.element(document.querySelector('#control-button-add-new-video')),
                textButton = angular.element(document.querySelector('#control-button-add-new-text')),
                buttonButton = angular.element(document.querySelector('#control-button-add-new-button')),
                shapeButton = angular.element(document.querySelector('#control-button-add-new-shape')),
                removeButton = angular.element(document.querySelector('#control-button-remove-block'));

            imgButton.attr('block-type', 'img');
            imgButton.attr('new-item', '');

            videoButton.attr('block-type', 'video');
            videoButton.attr('new-item', '');

            textButton.bind('click', function(e) {
                scope.$emit('controlPanelBlocksEvent', { type: 'createNewBlock', blockType: 'text' });
            });

            buttonButton.bind('click', function(e) {
                scope.$emit('controlPanelBlocksEvent', { type: 'createNewBlock', blockType: 'button' });
            });

            shapeButton.bind('click', function(e) {
                scope.$emit('controlPanelBlocksEvent', { type: 'createNewBlock', blockType: 'shape' });
            });

            removeButton.bind('click', function() {
                if (scope.controlPanelBlocks.blocks.length > 0) {
                    scope.$emit('controlPanelBlocksEvent', { type: 'remove' });
                }
            });

            $document.bind('keydown', kd);

            $compile(element.contents())(scope);
            element.bind('$destroy', function() {
                $document.unbind('keydown', kd);
                textButton.unbind('click');
                buttonButton.unbind('click');
                shapeButton.unbind('click');
                removeButton.unbind('click');
                scope.$destroy();
            });
        }
    };
}]);

constructorApp.directive('newItem', ['$document', '$compile', '$timeout', '$window', 'parseSlide', '$rootScope', 'messages', function($document, $compile, $timeout, $window, parseSlide, $rootScope, messages) {
    return {
        restrict: 'A',
        scope: {},
        link: function(scope, element, attrs) {
            var bg,
                watchers = [],
                bgField,

                addImg = function(url, base64, name) {
                    var _imgId = null;
                    if (angular.isObject(url)) {
                        _imgId = url.imgId;
                        url = url.url;
                    }
                    scope.$emit('controlPanelBlocksEvent', {
                        type: 'createNewBlock',
                        blockType: 'image',
                        url: url,
                        imgId: _imgId,
                        name: name,
                        base64: base64,
                        full: bg
                    });
                },

                addVideo = function(videoType, url, isnocookie) {
                    scope.$emit('controlPanelBlocksEvent', {
                        type: 'createNewBlock',
                        blockType: 'video',
                        videoType: videoType,
                        isnocookie: isnocookie,
                        url: url
                    });
                };

            if (messages.status) {
                messages.setCallbacks({
                    getImg: function(data) {
                        $rootScope.newItemWindowIsOpened = false;
                        addImg(data, null);
                    },
                    getImg_fail: function(data) {
                        $rootScope.newItemWindowIsOpened = false;
                    },
                    getVideo: function(data) {},
                    getVideo_fail: function(data) {}
                });
            }

            element.bind('click', function(e) {
                var activeClass = 'active',
                    lastTabButton, tabs,
                    field, content, title,
                    firstTab, secondTab,
                    img, inp, drop, insert, transform,
                    videoContainer,
                    regexpYoutube = /(?:(youtube|youtube-nocookie)\.com\/(?:[^\/]+\/.+\/|(?:v|e(?:mbed)?)\/|.*[?&]v=)|youtu\.be\/)([^"&?\/ ]{11})/i,
                    regexpVimeo = /vimeo.com\/(.+)/;

                bg = !!angular.element(e.target).attr('bg');
                $rootScope.newItemWindowIsOpened = true;

                if (messages.status && attrs.blockType === 'img') {
                    messages.getImg();
                    return;
                }

                if (attrs.blockType === 'img') {

                    firstTab = 'Uploading';
                    secondTab = 'Insert URL';
                    title = 'Insert image';

                    content =   '<div class="c-content-img">' +
                                    '<div id="c-drop" class="c-upload" ng-show="0==tabIndex">' +
                                        '<span class="c-drop-container">' +
                                            'Drag and drop image upload<br>' +
                                            'or<br>' +
                                            '<button id="c-upload-button" class="btn btn-primary">Chose image for upload</button>' +
                                        '</span>' +
                                        '<input id="c-upload-input" type="file" accept="image/jpg,image/jpeg,image/png,image/gif" multiple="false">' +
                                    '</div>' +
                                    '<div class="c-insertUrl" ng-show="1==tabIndex">' +
                                        '<div class="c-display-url">' +
                                            '<form class="form-horizontal">' +
                                                '<div class="form-group">' +
                                                    '<label for="c-img-url" class="col-sm-3 control-label">Insert a link to the image</label>' +
                                                    '<div class="col-sm-7">' +
                                                        '<input class="form-control" ng-model="imgUrl" id="c-img-url" type="text">' +
                                                    '</div>' +
                                                    '<div class="col-sm-2">' +
                                                        '<div ng-show="loaderIsShow" class="loader spinner">' +
                                                            '<div class="rect rect1"></div>' +
                                                            '<div class="rect rect2"></div>' +
                                                            '<div class="rect rect3"></div>' +
                                                            '<div class="rect rect4"></div>' +
                                                        '</div>' +
                                                    '</div>' +
                                                '</div>' +
                                            '</form>' +
                                        '</div>' +
                                        '<div class="c-display-img">' +
                                            '<image ng-show="imgIsShow" id="c-img" ng-src="{{imgUrl}}">' +
                                            '<span  ng-show="!imgIsShow">Сan not upload the image</span>' +
                                        '</div>' +
                                    '</div>' +
                                '</div>';
                } else {
                    firstTab = 'YouTube';
                    secondTab = 'Vimeo';
                    title = 'Insert video';

                    content =   '<div class="c-content-video">' +
                                    '<div class="c-insertUrl">' +
                                        '<div class="c-display-url">' +
                                            '<form class="form-horizontal">' +
                                                '<div class="form-group">' +
                                                    '<label for="c-video-url" class="col-sm-3 control-label">Insert a link to the {{name}} video</label>' +
                                                    '<div class="col-sm-7">' +
                                                        // '<input class="form-control" ng-model="videoUrl" id="c-video-url" type="text" placeholder="html or url or ID">' +
                                                        '<input class="form-control" ng-model="videoUrl" id="c-video-url" type="text">' +
                                                    '</div>' +
                                                    '<div class="col-sm-2">' +
                                                        '<div ng-show="loaderIsShow" class="loader spinner">' +
                                                            '<div class="rect rect1"></div>' +
                                                            '<div class="rect rect2"></div>' +
                                                            '<div class="rect rect3"></div>' +
                                                            '<div class="rect rect4"></div>' +
                                                        '</div>' +
                                                    '</div>' +
                                                '</div>' +
                                            '</form>' +
                                        '</div>' +
                                        '<div id="c-display-video" class="c-display-video">' +
                                            // '<image ng-show="imgIsShow" id="c-video" ng-src="{{imgUrl}}">' +
                                            // '<span  ng-show="!imgIsShow">Сan not upload the image</span>' +
                                        '</div>' +
                                    '</div>' +
                                '</div>';
                }

                scope.disableOk = false;
                scope.tabIndex = 0;
                scope.imgUrl = '';
                scope.loaderIsShow = false;
                scope.imgIsShow = true;
                scope.videoTitle = 'youtube';
                scope.name = 'YouTube';
                scope.videoUrl = '';
                scope.iframe = '';
                scope.videoID = '';

                field = angular.element(
                    '<div class="c-main-field">' +
                        '<div class="c-background-field"></div>' +
                        '<div class="c-working-field">' +
                            '<div id="c-top-field">' +
                                '<span class="c-title">' + title + '</span>' +
                                '<div id="c-tabs">' +
                                    '<button id="c-firstTab" class="active"><span>' + firstTab + '</span></button>' +
                                    '<button id="c-secondTab"><span>' + secondTab + '</span></button>' +
                                '</div>' +
                            '</div>' +
                            '<div id="c-center-field">' + content + '</div>' +
                            '<div id="c-bottom-field">' +
                                '<div class="c-controls">' +
                                    '<button id="c-ok" ng-disabled="!disableOk" class="btn btn-primary" ng-click="ok()">OK</button>' +
                                    '<button class="btn btn-default" ng-click="cansel()">Cancel</button>' +
                                '</div>' +
                            '</div>' +
                        '</div>' +
                    '</div>'
                );

                bgField = angular.element(field.children()[0])

                scope.cansel = function() {
                    $rootScope.newItemWindowIsOpened = false;
                    field.remove();
                };

                bgField.on('mousedown', function() {
                    scope.cansel();
                    return false;
                });

                scope.ok = function() {
                    if (attrs.blockType === 'img') {
                        addImg(scope.imgUrl, null);
                    } else {
                        addVideo(scope.videoTitle, scope.videoID, scope.isnocookie);
                    }
                    scope.cansel();
                };

                angular.element($document[0].body).append(field);
                $compile(field.contents())(scope);

                tabs = angular.element($document[0].getElementById('c-tabs')).find('button');
                lastTabButton = tabs[0];

                angular.forEach(tabs, function(b, i) {
                    angular.element(b).bind('click', function(e) {
                        var target = e.target;

                        while('button' !== target.tagName.toLowerCase()) {
                            target = target.parentNode;
                        }

                        if (lastTabButton !== target) {
                            angular.element(lastTabButton).removeClass(activeClass);
                            lastTabButton = target;
                            angular.element(lastTabButton).addClass(activeClass);

                            scope.$apply(function() {
                                scope.tabIndex = i;
                            });
                        }
                    });
                });

                if (attrs.blockType === 'img') {
                    img = angular.element($document[0].getElementById('c-img'));
                    img[0].onload = img[0].onerror = function(e) {
                        scope.$apply(function() {
                            scope.loaderIsShow = false;
                            scope.disableOk = e.type === 'load';
                            scope.imgIsShow = e.type === 'load';
                        });
                    };

                    watchers.push(scope.$watch('imgUrl', function(newValue) {
                        if (newValue && '' !== newValue) {
                            scope.loaderIsShow = true;
                            scope.imgIsShow = true;
                            scope.disableOk = false;
                        } else {
                            scope.loaderIsShow = false;
                            scope.imgIsShow = '' === newValue;
                            scope.disableOk = false;
                        }
                    }));


                    transform = function(file) {
                        // addImg(file.name, $window.URL.createObjectURL(file));

                        var reader = new $window.FileReader();
                        reader.onloadend = function(e) {
                            // addImg(file.name, e.target.result);
                            addImg($window.URL.createObjectURL(file), e.target.result, file.name);
                            scope.cansel();
                        };
                        reader.readAsDataURL(file);
                    };

                    inp = angular.element($document[0].getElementById('c-upload-input'));

                    inp.bind('change', function() {
                        if (inp[0].files[0]) {
                            transform(inp[0].files[0]);
                        }
                    });

                    angular.element($document[0].getElementById('c-upload-button')).bind('click', function(e) {
                        inp[0].click();
                        e.target.blur();
                    });

                    drop = angular.element($document[0].getElementById('c-drop'));

                    if ($window.File && $window.FileReader && $window.FileList && $window.Blob) {
                        drop.bind("dragenter", function(e) {
                            e.stopPropagation();
                            e.preventDefault();
                        });

                        drop.bind("dragover", function(e) {
                            e.stopPropagation();
                            e.preventDefault();
                        });

                        drop.bind('drop', function(e) {
                            if(!e.dataTransfer.files) {
                                return;
                            } else {
                                e.stopPropagation();
                                e.preventDefault();
                                transform(e.dataTransfer.files[0]);
                            }
                        });
                    }
                } else {
                    watchers.push(scope.$watch('tabIndex', function(v) {
                        scope.videoTitle = v ? 'vimeo' : 'youtube';
                        scope.name = v ? 'Vimeo' : 'YouTube';
                        scope.videoUrl = '';
                        scope.loaderIsShow = false;
                    }));

                    videoContainer = angular.element($document[0].getElementById('c-display-video'));

                    watchers.push(scope.$watch('videoUrl', function(newValue) {
                        var video, regexp, videoId = '', ev;
                        if (newValue && '' !== newValue) {
                            ev = function(e) {
                                scope.$apply(function() {
                                    scope.loaderIsShow = false;
                                    scope.disableOk = e.type === 'load';
                                });
                            };
                            scope.loaderIsShow = true;
                            scope.disableOk = false;
                            regexp = ('youtube' === scope.videoTitle) ? regexpYoutube : regexpVimeo;

                            newValue = parseSlide.trim(newValue);

                            videoId = regexp.exec(newValue + '') || ['', 'youtube' === scope.videoTitle ? newValue : ('video/' + newValue)];

                            var isNocookie = false;
                            if (videoId.length > 0) {
                                if (!/<iframe.+iframe>/.test(newValue)) {
                                    if ('youtube' === scope.videoTitle) {
                                        isNocookie = videoId[1] === "youtube-nocookie";
                                        videoId = videoId[2];
                                        newValue = '<iframe width="560" height="315" src="https://www.youtube' + (isNocookie ? '-nocookie' : '') +'.com/embed/' + videoId + '" frameborder="0" allowfullscreen></iframe>';
                                    } else {
                                        videoId = videoId[1];
                                        if (!/video/.test(videoId)) {
                                            videoId = 'video/' + videoId;
                                        }
                                        newValue = '<iframe src="https://player.vimeo.com/' + videoId + '" width="500" height="281" frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>';
                                    }
                                }

                                video = angular.element(newValue);
                                video.bind('load', ev);
                                video.bind('error', ev);

                                videoContainer[0].innerHTML = '';
                                videoContainer.append(video[0]);

                                if ('vimeo' === scope.videoTitle) {
                                    // videoId = /\/(\d+[\/]*)$/.exec(videoId)[1];
                                    // videoId = /\/([0-9]+)/.exec(videoId)[1];
                                    videoId = /\/([0-9]+)/.exec(videoId);
                                    if (videoId && videoId.length) {
                                        videoId = videoId[1];
                                    }
                                }

                                scope.videoID = videoId;
                                scope.isnocookie = isNocookie;
                            }
                        } else {
                            scope.loaderIsShow = false;
                            scope.disableOk = false;
                            videoContainer[0].innerHTML = '';
                            scope.videoID = '';
                            scope.isnocookie =  false;
                        }
                    }));

                    watchers.push(scope.$watch('iframe', function(newValue) {
                        if (newValue && '' !== newValue) {
                            videoContainer[0].innerHTML = scope.iframe;
                        }
                    }));
                }

                $timeout(function() {
                    scope.$apply();
                }, 0);
            });
            element.bind('$destroy', function() {
                angular.forEach(watchers, function(ev) {
                    ev();
                });
                watchers = [];
                bgField.off('mousedown');
                element.unbind('click');
                scope.$destroy();
            });
        }
    };
}]);
'use strict';

constructorApp.service('orderBlocksApi', [function() {
    var api = {
        getBlockIndex: function(desiredZIndex, allBlocks) {
            var i, b;
            for(i = 0; i < allBlocks.length; i++) {
                b = allBlocks[i];
                if (b.styles['z-index'] === desiredZIndex) {
                    return b;
                }
            }
            return null;
        },

        change: function(nextBlock, currentBlock) {
            var zIndex = currentBlock.styles['z-index'];
            currentBlock.styles['z-index'] = nextBlock.styles['z-index'];
            nextBlock.styles['z-index'] = zIndex;
        },

        sorting: function(arr, reverse) {
            var i, j, tmp;
            for (i = 0; i < arr.length; i++) {
                for (j = 1; j < arr.length; j++) {
                    if (arr[i].styles['z-index'] > arr[i].styles['z-index']) {
                        tmp = arr[i];
                        arr[i] = arr[j];
                        arr[j] = tmp;
                    }
                }
            }

            reverse && (arr = arr.reverse());

            return arr;
        },

        setDesiredZIndex: function(desiredZIndex, currentBlock, allBlocks) {
            var i, b, ci = currentBlock.styles['z-index'];

            if (ci !== desiredZIndex) {
                for (i = ci + 1; i <= desiredZIndex; i++) {
                    b = api.getBlockIndex(i, allBlocks);
                    b && api.change(b, currentBlock);
                }
            }
        },

        setFirstZIndex: function(currentBlock, allBlocks) {
            var i, b, ci = currentBlock.styles['z-index'];

            if (1 !== ci) {
                for (i = ci - 1; i > 0; i--) {
                    b = api.getBlockIndex(i, allBlocks);
                    b && api.change(b, currentBlock);
                }
            }
        }
    };
    return api;
}]);

constructorApp.directive('orderBlocks', ['$compile', 'orderBlocksApi', function($compile, orderBlocksApi) {
    return {
        restrict: 'A',
        scope: {
            orderBlocks: '=',
            currentBlock: '=',
            currentIndex: '='
        },
        link: function(scope, element, attrs) {
            var buttons = element.find('button'),
                oldIndexes_, watch,

                getBlocks = function(max) {
                    var i, j, b = [],
                        min = 0,
                        zIndex = scope.currentBlock.styles['z-index'];

                    if (scope.orderBlocks.backgroundBlock) {
                        min = 1;
                    }

                    oldIndexes_ = [];
                    angular.forEach(scope.orderBlocks.blocks, function(block, i) {
                        var zi = block.styles['z-index'];
                        oldIndexes_.push(zi);
                        if (scope.currentBlock.index !== block.index) {
                            if (max) {
                                if (zIndex < zi) {
                                    b.push(block);
                                }
                            } else {
                                if (zIndex > zi && zi > min) {
                                    b.push(block);
                                }
                            }
                        }
                    });

                    return orderBlocksApi.sorting(b, !max);
                },

                saveingAction = function() {
                    scope.$emit('orderBlocksEvent', { oldIndexes: oldIndexes_ });
                },

                oneStep = function(side /* forward, backward */, noSaveAction) {
                    var top = 'forward' === side,
                        bs = getBlocks(top),
                        l = bs.length,
                        dd = l < 2;

                    if (l == 0) return;

                    scope.$apply(function() {
                        orderBlocksApi.change(bs[0], scope.currentBlock);

                        scope.forwarDisabled = (dd && top);
                        scope.frontDisabled = (dd && top);
                        scope.backwarDisabled = (dd && !top);
                        scope.backDisabled = (dd && !top);
                        !noSaveAction && saveingAction();
                    });
                },

                stepToTheEnd = function(side /* forward, backward */, noSaveAction) {
                    var top = 'forward' === side;
                    angular.forEach(getBlocks(top), function(b) {
                        orderBlocksApi.change(b, scope.currentBlock);
                    });

                    scope.forwarDisabled  = top;
                    scope.frontDisabled = top;
                    scope.backwarDisabled = !top;
                    scope.backDisabled = !top;

                    (!scope.$$phase && !scope.$parent.$$phase) && scope.$apply();
                    !noSaveAction && saveingAction();
                },

                checkButtons = function() {
                    var bks = getBlocks(true);

                    if (bks.length < 1 && !scope.currentBlock.isBackground) {
                        scope.forwarDisabled  = true;
                        scope.frontDisabled = true;
                    } else {
                        scope.forwarDisabled  = false;
                        scope.frontDisabled = false;
                    }

                    bks = getBlocks();

                    if (bks.length < 1 && !scope.currentBlock.isBackground) {
                        scope.backwarDisabled = true;
                        scope.backDisabled = true;
                    } else {
                        scope.backwarDisabled = false;
                        scope.backDisabled = false;
                    }
                };

            scope.forwarDisabled = false;
            scope.backwarDisabled = false;
            scope.frontDisabled = false;
            scope.backDisabled = false;

            watch = scope.$watch('currentIndex', function(nv, ov) {
                checkButtons();
            });

            scope.$on('checkButtonsEvent', function() {
                checkButtons();
            });

            angular.forEach(buttons, function(b, i) {
                b = angular.element(b);
                switch(i) {
                    case 0: // forward
                        b.attr('ng-disabled', 'forwarDisabled');
                        b.bind('click', function(e) { oneStep('forward'); });
                        break;
                    case 1: // backward
                        b.attr('ng-disabled', 'backwarDisabled');
                        b.bind('click', function(e) { oneStep('backward'); });
                        break;
                    case 2: // front
                        b.attr('ng-disabled', 'frontDisabled');
                        b.bind('click', function(e) { stepToTheEnd('forward'); });
                        break;
                    case 3: // back
                        b.attr('ng-disabled', 'backDisabled');
                        b.bind('click', function(e) { stepToTheEnd('backward'); });
                        break;
                };
            });

            $compile(element.contents())(scope);
            element.bind('$destroy', function() {
                watch();
                angular.forEach(buttons, function(b) {
                    angular.element(b).unbind('click');
                });
                scope.$destroy();
            });
        }
    };
}]);'use strict';

constructorApp.factory('globalMenuAPI', ['$rootScope', function($rootScope) {
    var open = false,
        element;
    return {
        open: function() {
            if (!open) {
                $rootScope.globalMenuIsOpen = true;
                open = true;
            }
        },
        close: function() {
            if (open) {
                $rootScope.globalMenuIsOpen = false;
                open = false;
            }
        },
        _set: function(el) {
            element = el;
        }
    };
}]);

constructorApp.directive('globalMenu', ['$rootScope', 'globalMenuAPI', function($rootScope, globalMenuAPI) {
    return {
        restrict: 'A',
        link: function(scope, element, attrs) {
            var open = false;
            scope.$on('openGlobalMenu', function() {
                if (!open) {
                    open = true;
                }
            });

            globalMenuAPI._set(element);

            scope.globalMenuClose = function() {
                globalMenuAPI.close();
            };

            element.bind('$destroy', function() {
                scope.$off('openGlobalMenu');
                scope.$off('closeGlobalMenu');
            });
        }
    };
}]);
'use strict';

constructorApp.directive('slideBgImage', ['$compile', function($compile) {
    return {
        restrict: 'A',
        scope: {
            slideBgImage: '='
        },
        template:   '<img src="">' +
                    '<figcaption>' +
                        '<div class="btn-group">' +
                            '<button class="btn btn-default" ng-disabled="setdd" new-item block-type="img" bg="true">Set</button>' +
                            '<button class="btn btn-default" ng-disabled="cleandd" ng-click="clean()">Сlean</button>' +
                        '</div>' +
                    '</figcaption>',
        link: function(scope, element, attrs) {
            var watch, img = element.find('img');

            scope.emptyImg = 'constructor/img/transparent2.jpg';
            scope.setdd = false;
            scope.cleandd = false;

            scope.clean = function() {
                scope.slideBgImage.backgroundBlock.isBackground = false;
                scope.$emit('timelineSetActiveBlock', {
                    index: scope.slideBgImage.backgroundBlock.index,
                    bg: true
                });
            };

            watch = scope.$watch('slideBgImage.backgroundBlock', function(nv) {
                if (nv) {
                    scope.cleandd = false;
                    scope.setdd = true;
                    img.attr('ng-src', '{{slideBgImage.backgroundBlock.url}}');
                    img.attr('title', 'Background-image');
                } else {
                    scope.cleandd = true;
                    scope.setdd = false;
                    img.attr('ng-src', '{{emptyImg}}');
                    img.attr('title', 'Empty');
                }
                $compile(img)(scope);
            });
            
            element.bind('$destroy', function() {
                watch();
                scope.$destroy();
            });
        }
    };
}]);'use strict';

constructorApp.directive('slideshowPreview', ['$compile', '$document', 'slideshowAPI', 'activeTab', '$rootScope', function($compile, $document, slideshowAPI, activeTab, $rootScope) {
    return {
        restrict: 'A',
        link: function(scope, element, attrs) {
            var container = angular.element($document[0].getElementById('slideshow-preview')),
                bClose = angular.element($document[0].getElementById('sp-close')),
                slideshow = angular.element($document[0].getElementById('slideshow')),
                events = ['-webkit-transitionend', 'transitionend'],
                firstStart = false,

                resizeContainer = slideshow.parent(),
                size = { width: 0, height: 0 },

                getSize = function() {
                    return {
                        width: resizeContainer.parent()[0].offsetWidth,
                        height: resizeContainer.parent()[0].offsetHeight
                    };
                },

                trEnd = function(e) {
                    container.unbind(e.type);
                    bClose.css('display', '');
                    slideshow.css('display', '');
                    if (scope.slides.length === 0 || scope.slides.length === 1 && scope.slides[0].blocks.length === 0) { return; }
                    setSlideshow();
                },

                getOptions = function() {
                    var i, opt = {};
                    for (i = 0; i < scope.slideshowOptions.length; i++) {
                        opt[scope.slideshowOptions[i].name] = scope.slideshowOptions[i].value;
                    }
                    return opt;
                },

                calcContainerSize = function() {
                    var width = parseInt(scope.slideshowOptions[2].value),
                        height = parseInt(scope.slideshowOptions[3].value),
                        opt = getOptions(),
                        value;

                    size = getSize();
                    value = size.width;

                    if (height / width * value > size.height) {
                        value = width / height * size.height;
                    }

                    if ('none' !== opt['selectors']) {
                        if ('thumbnails' === opt['selectors-style']) {
                            value = value - (width / height * (parseInt(opt['selectors-size']) + 16));
                        } else {
                            value -= (width / height *30);
                        }
                    }

                    resizeContainer.css('max-width', value + 'px');
                },

                getSlides = function() {
                    var arr = [],
                        slides = scope.slides,
                        oldSlideIndex = scope.slideEditor.cSlide;

                    angular.forEach(slides, function(s, i) {
                        arr.push(scope.saveSlide(i));
                    });

                    scope.slideEditor.cSlide = oldSlideIndex;
                    return arr;
                },

                setSlideshow = function() {
                    var opt = "", size = {'base-width': 0, 'base-height': 0}, v,
                        slides = getSlides();

                    // TODO
                    if (!firstStart) {
                        firstStart = true;
                        slideshowAPI.stop();
                    }

                    slideshow[0].innerHTML = '';

                    calcContainerSize();
                    angular.forEach(slides, function(slide, i) {
                        slideshow.append(slide);
                    });

                    size['base-width'] = scope.mainField[0].offsetWidth;
                    size['base-height'] = scope.mainField[0].offsetHeight;

                    angular.forEach(scope.slideshowOptions, function(o, i) {
                        // if (scope.defaults.slideshowOptions[i].value !== o.value || scope.defaults.slideshowOptions[i].name === 'base-width' || scope.defaults.slideshowOptions[i].name === 'base-height') {
                        //     if ('base-width' === o.name || 'base-height' === o.name) {
                        //         v = size[o.name];
                        //     } else {
                        //         v = o.value;
                        //     }
                        //
                        //     opt += (o.name + ': ' + v + '; ');
                        // }
                        opt += (o.name + ': ' + o.value + '; ');
                    });

                    slideshow.attr('data-options', opt);
                    slideshowAPI.start();
                    slideshow.addClass('sp-border');
                };

            bClose.css('display', 'none');
            slideshow.css('display', 'none');

            element.bind('click', function() {
                var cb = scope.slides[scope.slideEditor.cSlide].blocks[scope.slideEditor.cBlock];
                angular.forEach(events, function(ev) {
                    container.bind(ev, trEnd);
                });

                if (cb && 'text' === cb.type) {
                    angular.element(cb.node).addClass('transparent-select')
                        .removeClass('ta-border-shadow');

                    activeTab.currentTab.index = 0; // TODO
                }

                scope.$broadcast('activeBlockEvent', { index: null });
                scope.toggleBlocks(null);

                container.addClass('sp-show');
            });

            bClose.bind('click', function(e) {
                scope.activateSlide(0);
                bClose.css('display', 'none');
                slideshow.removeClass('sp-border');
                slideshowAPI.stop();
                slideshow.css('display', 'none');
                container.removeClass('sp-show');
            });

            element.bind('$destroy', function() {
                angular.forEach(events, function(ev) {
                    container.unbind(ev);
                });
                bClose.unbind('click');
                element.unbind('click');
            });
        }
    };
}]);
'use strict';

constructorApp.directive('mouseWheel', ['acpManager', 'globalMenuAPI', function(acpManager, globalMenuAPI) {
    return {
        restrict: 'A',
        scope: true,
        link: function(scope, element, attrs) {
            element.bind('wheel', function() {
                acpManager.close();
                globalMenuAPI.close();
            });

            element.bind('$destroy', function() {
                element.unbind('mousewheel');
                scope.$destroy();
            });
        }
    };
}]);'use strict';

constructorApp.directive('edtorZoom', ['lib', '$rootScope', '$timeout', '$window', function(lib, $rootScope, $timeout, $window) {
    var scaleRound = function(value, decimal) {
        var s = decimal || 4,
            num = 10 * s;
        value = value * num;
        value = Math.round(value);
        value /= num;
        return value;
    };
    return {
        restrict: 'A',
        scope: false,
        link: function(scope, element, attrs) {
            var inst = { scope: scope },
                firstStart = false,
                width, height,
                mainWidth, mainHeight,
                bWidthIndex, bHeightIndex,
                watchers = [],
                fitValue = null,
                zoomOut = angular.element(document.getElementById("control-button-lens-zoom-out")),
                zoomIn = angular.element(document.getElementById("control-button-lens-zoom-in")),

                setScale = function(scale) {
                    correctPosition(scale);
                    element.css({
                        '-webkit-transform': 'scale(' + scale + ')',
                        'transform': 'scale(' + scale + ')'
                    });
                },

                owerflow = function(auto) {
                    var el = angular.element($window.document.getElementById('working-field')),
                        value = auto ? '' : 'hidden';

                    el.css({'overflow': value});
                },

                setParentStyle = function(scale) {
                    var t = 0, l = 0,
                        w, h,
                        el = element.parent();

                    w = width * scale;
                    h = height * scale;

                    t = (mainHeight - h) / 2;
                    l = (mainWidth - w) / 2;
                    if (t < 0) {
                        t = 0;
                    }
                    if (l < 0) {
                        l = 0;
                    }

                    el.css({
                        'top': t + 'px',
                        'left': l + 'px',
                        'width': w + 'px',
                        'height': h + 'px'
                    });
                },

                newLabel = function(scale) {
                    var newArr = [], flag = false,
                        clearArr = JSON.parse(JSON.stringify(scope.$parent.zoomIconsDefault));

                    angular.forEach(clearArr, function(label) {
                        if (!flag && label.value >= scale) {
                            flag = true;
                            if (label.value !== scale) {
                                newArr.push({
                                    fit: true,
                                    value: scale,
                                    label: scaleRound(scale * 100, 1) + '% (Fit)'
                                });
                            } else {
                                label.fit = true;
                                label.label = label.label + ' (Fit)';
                            }
                        }

                        newArr.push(label);
                    });

                    if (!flag) {
                        newArr.push({
                            fit: true,
                            value: scale,
                            label: scaleRound(scale * 100, 1) + '% (Fit)'
                        });
                    }

                    scope.$parent.zoomIcons = newArr;

                    // scope.$parent.zoomIcons.unshift({});
                    // $timeout(function() {
                    //     scope.$parent.zoomIcons.shift();
                    // }, 0);
                },

                calcScale = function(dontInstall) {
                    var scale = 1;

                    if (mainWidth / mainHeight >= width / height) {
                        //h
                        scale = mainHeight / height;
                    } else {
                        //w
                        scale = mainWidth / width;
                    }

                    if (!dontInstall) {
                        fitValue = scale;
                        scope.$parent.zoomIcon = scale;
                        scope.zoomIcon = scale;
                        $rootScope.zoomIcon = scale;
                    }

                    newLabel(scale);

                    return scale;
                },

                getIndex = function(value) {
                    var i, result = 0,
                        icons = scope.$parent.zoomIcons;

                    for (i = 0; i < icons.length; i++) {
                        if (value === icons[i].value) {
                            result = i;
                            break;
                        }
                    }

                    return result;
                },

                correctPosition = function(scale) {
                    var top, left, el;

                    if (scale <= 1) {
                        scale -= 1;
                        top = height * scale / 2;
                        left = width * scale / 2;
                    } else {
                        top = (height * scale - height) / 2;
                        left = (width * scale - width) / 2;
                    }

                    scope.slideEditor.editorStyles['top'] = top + 'px';
                    scope.slideEditor.editorStyles['left'] = left + 'px';
                },

                setParameters = function(w, h) {
                    $rootScope.slideSize.width = w;
                    $rootScope.slideSize.height = h;

                    scope.slideEditor.editorStyles['width'] = w + 'px';
                    scope.slideEditor.editorStyles['height'] = h + 'px';

                    mainWidth = scope.mainField[0].offsetWidth;
                    mainHeight = scope.mainField[0].offsetHeight;
                },

                resize = function() {
                    var scale;
                    mainWidth = scope.mainField[0].offsetWidth;
                    mainHeight = scope.mainField[0].offsetHeight;
                    if (null === fitValue || fitValue === scope.$parent.zoomIcon) {
                        scale = calcScale();
                        scope.$parent.zoomIcon = scale;
                    } else {
                        fitValue = calcScale(true);
                        scale = scope.$parent.zoomIcon;
                    }
                    setParentStyle(scale);
                    setScale(scale);
                };

                zoomOut.on('click', function() {
                    var i, l = scope.$parent.zoomIcons.length;

                    for (i = 0; i < l; i++) {
                        if (scope.$parent.zoomIcons[i].value === scope.zoomIcon) {
                            if (i !== 0) {
                                var scale = scope.$parent.zoomIcons[i - 1].value;

                                scope.zoomIcon = scale;
                                $rootScope.zoomIcon = scale;
                                scope.$parent.zoomIcon = scale;

                                scope.$apply();
                            }
                            break;
                        }
                    }

                    return false;
                });

                zoomIn.on('click', function() {
                    var i, l = scope.$parent.zoomIcons.length;

                    for (i = 0; i < l; i++) {
                        if (scope.$parent.zoomIcons[i].value === scope.zoomIcon) {
                            if (i !== l - 1) {
                                var scale = scope.$parent.zoomIcons[i + 1].value;

                                scope.zoomIcon = scale;
                                $rootScope.zoomIcon = scale;
                                scope.$parent.zoomIcon = scale;

                                scope.$apply();
                            }
                            break;
                        }
                    }

                    return false;
                });

            scope.zoomOutDisable = false;
            scope.zoomInDisable = false;

            scope.$on('edtorZoomEvent', function(e, data) {
                var scale;

                if ('first-start' === data.type) {
                    firstStart = true;
                    bWidthIndex = lib.getOptionIndex(scope.slideshowOptions, 'base-width');
                    bHeightIndex = lib.getOptionIndex(scope.slideshowOptions, 'base-height');
                    width = parseFloat(scope.slideshowOptions[bWidthIndex].value);
                    height = parseFloat(scope.slideshowOptions[bHeightIndex].value);

                    setParameters(width, height);

                    scale = calcScale();
                    setParentStyle(scale);
                    setScale(scale);
                } else if ('resize' === data.type) {
                    // data.param
                    width = scope.slideshowOptions[bWidthIndex].value;
                    height = parseInt(data.param.height / data.param.width * width);

                    scope.slideshowOptions[bWidthIndex].value = width;
                    scope.slideshowOptions[bHeightIndex].value = height;

                    setParameters(width, height);

                    if (null === fitValue || fitValue === scope.$parent.zoomIcon) {
                        scale = calcScale();
                    } else {
                        calcScale(true);
                        scale = scope.$parent.zoomIcon;
                    }
                    setParentStyle(scale);
                    setScale(scale);

                    data.param.callback && data.param.callback();
                } else if ('control-line' === data.type) {
                    resize();
                }
            });

            watchers.push(scope.$watch('zoomIcon', function(newValue, oldValue) {
                var index;
                if (firstStart) {
                    newValue = parseFloat(newValue);
                    if (null === fitValue || fitValue === newValue) {
                        newValue = calcScale();
                        owerflow();
                    } else {
                        scope.$parent.zoomIcon = newValue;
                        $rootScope.zoomIcon = newValue;
                        owerflow('auto');
                    }

                    index = getIndex(newValue);
                    scope.zoomOutDisable = (index === 0);
                    scope.zoomInDisable = (index === scope.$parent.zoomIcons.length - 1);

                    setParentStyle(newValue);
                    setScale(newValue);
                }
            }));

            watchers.push(scope.$watch('zoomOutDisable', function(newValue, oldValue) {
                if (firstStart) {
                    if (newValue) {
                        zoomOut.attr('disabled', 'disable');
                    } else {
                        zoomOut.removeAttr('disabled', 'disable');
                    }
                }
            }));

            watchers.push(scope.$watch('zoomInDisable', function(newValue, oldValue) {
                if (firstStart) {
                    if (newValue) {
                        zoomIn.attr('disabled', 'disable');
                    } else {
                        zoomIn.removeAttr('disabled', 'disable');
                    }
                }
            }));

            angular.element($window).bind('resize', resize);

            element.bind('$destroy', function() {
                angular.element($window).unbind('resize', resize);
                angular.forEach(watchers, function(watcher) {
                    watcher();
                });
                zoomIn.off('click');
                zoomOut.off('click');
                watchers = [];
            });
        }
    };
}]);
'use strict';

constructorApp.service('saveSlideshow', ['$rootScope', 'messages', '$location', 'getHtmlSlideshow', function($rootScope, messages, $location, getHtmlSlideshow) {
    var cb;
    messages.setCallbacks({
        dataSaved: function(data) {
            if (null !== data.id && $rootScope.idSlideshow.id !== data.id) {
                $rootScope.idSlideshow.id = data.id;
                $location.path('/ss_l');
                $location.search({id: data.id});
            }
            cb(false);
        },
        dataSaved_fail: function() {
            cb(true);
        }
    });

    return function(scope, callback) {
        var params, ss = '', opt = '', id = '';
        ss = $rootScope.getSlideshowJSON();
        opt = ss.options || 'null';
        id = ss.id;
        ss = ss.slideshow || 'null';

        cb = callback;

        getHtmlSlideshow(scope, function(slideshowHTML) {
            var slideshow = JSON.stringify(slideshowHTML);
            $rootScope.oldSlideshow = slideshow;
            messages.save({
                id: id,
                data: {
                    json: '[' + ss + ',' + opt +']',
                    html: slideshow
                }
            });
        });
    }
}]);

constructorApp.directive('saveSlideshow', ['$location', '$rootScope', 'messages', 'getHtmlSlideshow', 'aInfobarManager', 'saveSlideshow', function($location, $rootScope, messages, getHtmlSlideshow, aInfobarManager, saveSlideshow) {
    return {
        restrict: 'A',
        scope: true,
        link: function(scope, element, attrs) {
            var url = $location.absUrl().replace(/index.php.*/, '');
            url = url.split($location.host() + '')[1];

            element.on('click', function() {
                element.addClass('loading');
                element.attr('disabled', 'disabled');

                saveSlideshow(scope, function(err) {
                    if (!err) {
                        aInfobarManager.showMessage('Slideshow saved.');
                    }

                    element.removeClass('loading');
                    element.removeAttr('disabled');
                });
            });

            element.on('$destroy', function() {
                element.off('click');
                scope.$destroy();
            });
        }
    };
}]);
/*  angular-summernote v0.8.1 | (c) 2016 JeongHoon Byun | MIT license */
/* global angular */
angular.module('summernote', []).controller('SummernoteController', ['$scope', '$attrs', '$timeout', function($scope, $attrs, $timeout) {
    'use strict';

    var currentElement,
        summernoteConfig = angular.copy($scope.summernoteConfig) || {};

    if (angular.isDefined($attrs.height))      { summernoteConfig.height = +$attrs.height;          }
    if (angular.isDefined($attrs.minHeight))   { summernoteConfig.minHeight = +$attrs.minHeight;    }
    if (angular.isDefined($attrs.maxHeight))   { summernoteConfig.maxHeight = +$attrs.maxHeight;    }
    if (angular.isDefined($attrs.placeholder)) { summernoteConfig.placeholder = $attrs.placeholder; }
    if (angular.isDefined($attrs.focus))       { summernoteConfig.focus = true;                     }
    if (angular.isDefined($attrs.airmode))     { summernoteConfig.airMode = true;                   }
    if (angular.isDefined($attrs.lang)) {
        if (!angular.isDefined($.summernote.lang[$attrs.lang])) {
            throw new Error('"' + $attrs.lang + '" lang file must be exist.');
        }
        summernoteConfig.lang = $attrs.lang;
    }

    summernoteConfig.callbacks = summernoteConfig.callbacks || {};

    if (angular.isDefined($attrs.onInit)) {
        summernoteConfig.callbacks.onInit = function(evt) {
            $scope.init({evt:evt});
        };
    }
    if (angular.isDefined($attrs.onEnter)) {
        summernoteConfig.callbacks.onEnter = function(evt) {
            $scope.enter({evt:evt});
        };
    }
    if (angular.isDefined($attrs.onFocus)) {
        summernoteConfig.callbacks.onFocus = function(evt) {
            $scope.focus({evt:evt});
        };
    }
    if (angular.isDefined($attrs.onPaste)) {
        summernoteConfig.callbacks.onPaste = function(evt) {
            $scope.paste({evt:evt});
        };
    }
    if (angular.isDefined($attrs.onKeyup)) {
        summernoteConfig.callbacks.onKeyup = function(evt) {
            $scope.keyup({evt:evt});
        };
    }
    if (angular.isDefined($attrs.onKeydown)) {
        summernoteConfig.callbacks.onKeydown = function(evt) {
            $scope.keydown({evt:evt});
        };
    }
    if (angular.isDefined($attrs.onImageUpload)) {
        summernoteConfig.callbacks.onImageUpload = function(files) {
            $scope.imageUpload({files:files, editable: $scope.editable});
        };
    }
    if (angular.isDefined($attrs.onMediaDelete)) {
        summernoteConfig.callbacks.onMediaDelete = function(target) {
            // make new object that has information of target to avoid error:isecdom
            var removedMedia = {attrs: {}};
            removedMedia.tagName = target[0].tagName;
            angular.forEach(target[0].attributes, function(attr) {
                removedMedia.attrs[attr.name] = attr.value;
            });
            $scope.mediaDelete({target: removedMedia});
        };
    }

    this.activate = function(scope, element, ngModel) {
        var updateNgModel = function() {
            var newValue = element.summernote('code');
            if (element.summernote('isEmpty')) { newValue = ''; }
            if (ngModel && ngModel.$viewValue !== newValue) {
                $timeout(function() {
                    ngModel.$setViewValue(newValue);
                }, 0);
            }
        };

        var originalOnChange = summernoteConfig.callbacks.onChange;
        summernoteConfig.callbacks.onChange = function (contents) {
            $timeout(function () {
                if (element.summernote('isEmpty')) {
                    contents = '';
                }
                updateNgModel();
            }, 0);
            if (angular.isDefined($attrs.onChange)) {
                $scope.change({contents: contents, editable: $scope.editable});
            } else if (angular.isFunction(originalOnChange)) {
                originalOnChange.apply(this, arguments);
            }
        };
        if (angular.isDefined($attrs.onBlur)) {
            summernoteConfig.callbacks.onBlur = function (evt) {
                (!summernoteConfig.airMode) && element.blur();
                $scope.blur({evt: evt});
            };
        }
        element.summernote(summernoteConfig);

        var editor$ = element.next('.note-editor'), unwatchNgModel;
        editor$.find('.note-toolbar').click(function() {
            updateNgModel();

            // sync ngModel in codeview mode
            if (editor$.hasClass('codeview')) {
                editor$.on('keyup', updateNgModel);
                if (ngModel) {
                    unwatchNgModel = scope.$watch(function () {
                        return ngModel.$modelValue;
                    }, function(newValue) {
                        editor$.find('.note-codable').val(newValue);
                    });
                }
            } else {
                editor$.off('keyup', updateNgModel);
                if (angular.isFunction(unwatchNgModel)) {
                    unwatchNgModel();
                }
            }
        });

        if (ngModel) {
            ngModel.$render = function() {
                if (ngModel.$viewValue) {
                    element.summernote('code', ngModel.$viewValue);
                } else {
                    element.summernote('empty');
                }
            };
        }

        // set editable to avoid error:isecdom since Angular v1.3
        if (angular.isDefined($attrs.editable)) {
            $scope.editable = editor$.find('.note-editable');
        }
        if (angular.isDefined($attrs.editor)) {
            $scope.editor = element;
        }

        currentElement = element;
        // use jquery Event binding instead $on('$destroy') to preserve options data of DOM
        element.on('$destroy', function() {
            element.summernote('destroy');
            $scope.summernoteDestroyed = true;
        });
    };

    $scope.$on('$destroy', function () {
        // when destroying scope directly
        if (!$scope.summernoteDestroyed) {
            currentElement.summernote('destroy');
        }
    });
}])
 .directive('summernote', [function() {
    'use strict';

    return {
        restrict: 'EA',
        transclude: 'element',
        replace: true,
        require: ['summernote', '?ngModel'],
        controller: 'SummernoteController',
        scope: {
            summernoteConfig: '=config',
            editable: '=',
            editor: '=',
            init: '&onInit',
            enter: '&onEnter',
            focus: '&onFocus',
            blur: '&onBlur',
            paste: '&onPaste',
            keyup: '&onKeyup',
            keydown: '&onKeydown',
            change: '&onChange',
            imageUpload: '&onImageUpload',
            mediaDelete: '&onMediaDelete'
        },
        template: '<div class="summernote"></div>',
        link: function(scope, element, attrs, ctrls, transclude) {
            var summernoteController = ctrls[0],
                ngModel = ctrls[1];

            if (!ngModel) {
                transclude(scope, function(clone, scope) {
                    // to prevent binding to angular scope (It require `tranclude: 'element'`)
                    element.append(clone.html());
                });
                summernoteController.activate(scope, element, ngModel);
            } else {
                var clearWatch = scope.$watch(function() { return ngModel.$viewValue; }, function(value) {
                    clearWatch();
                    element.append(value);
                    summernoteController.activate(scope, element, ngModel);
                }, true);
            }
        }
    };
}]);
(function() {
    'use strict';
var acp = angular.module('angularColorPicker', []),

    ae = angular.element,
    each = angular.forEach;

acp.value('acpOptions', {
    // set the path to the bgGradient.png
    'imgPath': '../img/bgGradient.png',
    'imgPathLine': '../img/transparent-mini.png',
    'startPosition': {
        'x': 'center', // %, px, center, root
        'y': 'center' // %, px, center, root
    },
    'topPanel': true,
    'singleton': true
});
acp.service('acpLib', [function() {
    var api =  {
        pareseRgb: function(rgb) {
            var result = [];
            if ('none' !== rgb && 'transparent' !== rgb) {
                rgb = rgb.split('(')[1];
                rgb = rgb.split(')')[0];
                rgb = rgb.split(',');
                angular.forEach(rgb, function(v) {
                    result.push(parseFloat(v));
                });
                return result;
            } else {
                return rgb;
            }
        },
        pareseRgba: function(value) {
            var rgb, alpha;
            if ('none' !== value && 'transparent' !== value) {
                rgb = api.pareseRgb(value);
                alpha = parseFloat(rgb[3]);
                rgb = [rgb[0], rgb[1], rgb[2]];
            } else {
                alpha = 1;
                rgb = value;
            }

            return {
                rgb: rgb,
                alpha: alpha
            };
        },
        pareseHex: function(hex) {
            var result = [], l, count = 2, step = 2, pos = 0;
            if ('none' !== hex && 'transparent' !== hex) {
                hex = hex.replace('#', '');
                l = hex.length;
                if (6 === l || 3 === l) {
                    if (3 === l) {
                        count = 1;
                        step = 1;
                    }
                    while(l !== pos) {
                        result.push(parseInt(hex.substr(pos, count), 16));
                        pos += step;
                    }
                } else {
                    result = [255, 255, 255];
                }
                return result;
            } else {
                return hex;
            }
        },
        cleanString: function(str) {
            return str.replace(/\s+/g, '');
        },
        obj: {
            positX: function(b) {
                var a, c;
                a = 0;
                c = b.getBoundingClientRect();
                b = document.body;
                a = document.documentElement;
                a = c.left + (a.scrollLeft || b && b.scrollLeft || 0) - (a.clientLeft || b.sclientLeft || 0);
                return Math.round(a);
            },
            positY: function(b) {
                var a, c;
                a = 0;
                c = b.getBoundingClientRect();
                b = document.body;
                a = document.documentElement;
                a = c.top + (a.scrollTop || b && b.scrollTop || 0) - (a.clientTop || b.sclientTop || 0);
                return Math.round(a);
            }
        },
        mouse: {
            pageX: function(b) {
                var a, c, d;
                d = b || event;
                return null == d.pageX && null != d.clientX ? (a = document.body, c = document.documentElement, b = c.scrollLeft || a && a.scrollLeft || 0, b = d.clientX + b - (c.clientLeft || a.clientLeft || 0)) : d.pageX;
            },
            pageY: function(b) {
                var a, c, d;
                d = b || event;
                return null == d.pageX && null != d.clientX ? (a = document.body, c = document.documentElement, b = c.scrollTop || a && a.scrollTop || 0, b = d.clientY + b - (c.clientTop || a.clientTop || 0)) : d.pageY;
            }
        },
        convertRgbToHex: function(rgb) {
            return  ('0' + parseInt(rgb[0],10).toString(16)).slice(-2) +
                    ('0' + parseInt(rgb[1],10).toString(16)).slice(-2) +
                    ('0' + parseInt(rgb[2],10).toString(16)).slice(-2);
        },
        hsv_rgb: function (H,S,V){
            var f , p, q , t, lH;
            var R, G, B;

            S /= 100;
            V /= 100;

            lH = Math.floor(H / 60);

            f = H / 60 - lH;
            p = V * (1 - S);
            q = V * (1 - S * f);
            t = V * (1 - (1 - f) * S);

            switch (lH) {
                case 0: R = V; G = t; B = p; break;
                case 1: R = q; G = V; B = p; break;
                case 2: R = p; G = V; B = t; break;
                case 3: R = p; G = q; B = V; break;
                case 4: R = t; G = p; B = V; break;
                case 5: R = V; G = p; B = q; break;
            }

            return [parseInt(R * 255), parseInt(G * 255), parseInt(B * 255)];
        },
        rgb_hsv: function(rgb) {
            var hsv = [],
                h, s, v, min,
                cr, cg, cb;
            if (rgb && rgb.length > 0) {
                v = Math.max(rgb[0], rgb[1], rgb[2]);
                min = Math.min(rgb[0], rgb[1], rgb[2]);

                if (0 === v) {
                    s = 0;
                } else {
                    s = (v - min) / v;
                }

                if (0 === s) {
                    // uncertainty
                    h = 359;
                } else {
                    cr = (v - rgb[0]) / (v - min);
                    cg = (v - rgb[1]) / (v - min);
                    cb = (v - rgb[2]) / (v - min);

                    if (rgb[0] === v) {
                        h = cb - cg;
                    }

                    if (rgb[1] === v) {
                        h = 2 + cr - cb;
                    }
                    if (rgb[2] === v) {
                        h = 4 + cg - cr;
                    }
                    h = h * 60;

                    // leading to positive
                    if (h < 0) {
                        h = h + 360;
                    }
                }
                hsv.push(h);
                hsv.push(s);
                hsv.push(v);
            }
            return hsv;
        }
    };
    return api;
}]);
acp.service('acpManager', ['acpModel', '$rootScope', function(acpModel, $rootScope) {
    var api = {
        close: function() {
            if ($rootScope.colorPickerOpened) {
                try {
                    var instance = acpModel.getInstance($rootScope.colorPickerOpened);
                    instance.scope.close();
                } catch(e) {}
            }
        }
    };
    return api;
}]);
acp.factory('acpModel', [function() {
    var colorPickers = {},

    api = {
        checkInstance: function(name) {
            return (name && colorPickers[name]) ? true : false;
        },
        getInstance: function(name) {
            return colorPickers[name];
        },
        removeInstance: function(name) {
            if (api.checkInstance(name)) {
                delete colorPickers[name];
            }
        },
        newInstance: function(name) {
            api.removeInstance(name);
            return colorPickers[name] = {
                blockBGColor: 'red',
                rgb: 'rgb(255,255,255)',
                tmpRgb: [255,255,255],
                rgba: 'rgba(255,255,255,0)',
                hex: '#ffffff',
                hue: 0,
                none: false,
                text: 'none', // none, default
                alpha: 0,
                noneFlag: false,
                transparent: false,
                transparentFlag: false,
                picker: {
                    V: 100,
                    S: 100
                }
            };
        }
    };
    return api;
}]);
acp.directive('angularColorPicker', ['$compile', '$document', 'acpModel', 'acpLib', '$rootScope', 'acpManager', '$timeout', 'acpOptions',
    function($compile, $document, acpModel, acpLib, $rootScope, acpManager, $timeout, acpOptions) {
    return {
        restrict: 'A',
        scope: {},
        require: '?ngModel',
        link: function(scope, element, attrs, ngModel) {
            var id,
                instance, ngModelFlag = false,
                container,
                type,

                click = function(e) {
                    var value, rgb, alpha = 1;
                    e.stopPropagation();
                    e.preventDefault();
                    acpOptions.singleton && acpManager.close();
                    scope.firstStart = false;

                    type = acpLib.cleanString(attrs.angularColorPicker);

                    if ('rgb' !== type && 'rgba' !== type && 'hex' !== type) {
                        type = 'rgb';
                    }

                    $rootScope.angularColorPickerElement = element;
                    id = attrs.id || 'angular-color-picker-' + Date.now(),

                    instance = acpModel.newInstance(id);

                    if (undefined !== attrs.text) {
                        instance.text = 'default';
                        if ('none' === attrs.text) {
                            instance.noneFlag = true;
                        } else {
                            instance.transparentFlag = true;
                        }
                    }

                    container = ae('<div>');
                    container.addClass('color-picker');
                    container.attr('acp-window', '');
                    container.attr('name', id);

                    instance.scope = scope;

                    ae($document[0].body).append(container[0]);

                    if (attrs.ngModel && ngModel.$valid && (value = acpLib.cleanString(ngModel.$viewValue))) {
                        if (/rgba/.test(value)) {
                            rgb = acpLib.pareseRgba(value);
                            alpha = rgb.alpha;
                            rgb = rgb.rgb;
                            instance.rgba = value;
                            instance.rgb = 'rgb(' + rgb + ')';
                        } else if (/rgb/.test(value)) {
                            rgb = acpLib.pareseRgb(value);
                            instance.rgb = value;
                            instance.rgba = 'rgba(' + rgb + ',' + instance.alpha + ')';
                            alpha = 1;
                        } else {
                            rgb = acpLib.pareseHex(value);
                            instance.rgb = 'rgb(' + rgb + ')';
                            instance.rgba = 'rgba(' + rgb + ',' + instance.alpha + ')';
                            alpha = 1;
                        }

                        instance.tmpRgb = rgb;
                        // $timeout(function() {
                            if ('none' === rgb || 'transparent' === rgb) {
                                scope.firstStart = true;

                                instance.rgb = 'rgb(0,0,0)';
                                instance.tmpRgb = [0,0,0];
                                instance.rgba = 'rgba(0,0,0,0)';
                                instance.hex = '#000';
                                instance.hsv = 'none' === rgb ? 'none' : 'transparent';
                                instance.hue = 0;
                                instance.alpha = 0;
                                // instance.picker.V = 100;
                                // instance.picker.S = 100;
                                instance.picker.V = 0;
                                instance.picker.S = 0;
                                instance.blockBGColor = 'red';
                                instance.none = 'none' === rgb;
                                instance.transparent = 'transparent' === rgb;
                            } else {
                                instance.hex = '#' + acpLib.convertRgbToHex(rgb);
                                instance.hsv = acpLib.rgb_hsv(rgb);
                                instance.alpha = alpha;
                                instance.none = false;
                                instance.transparent = false;
                            }
                            instance.lastAlpha = instance.alpha;
                        // }, 0);
                        ngModelFlag = true;
                    }

                    $document.bind('mousedown', mouseDown);
                    $compile(container)(scope);
                    $rootScope.colorPickerOpened = id;
                },

                mouseDown = function(e) {
                    var target = e.target;
                    e.stopPropagation();
                    e.preventDefault();
                    while (target && target !== container[0]) {
                        target = target.parentNode;
                    }
                    if (target === container[0]) {
                        return;
                    }
                    scope.close();
                };

            scope.close = function() {
                if ($rootScope.colorPickerOpened) {
                    $rootScope.colorPickerOpened = false;
                    acpModel.removeInstance(id);
                    ngModelFlag = false;
                    container.remove();
                    $document.unbind('mousedown', mouseDown);
                }
            },

            type = acpLib.cleanString(attrs.angularColorPicker);

            if ('rgb' !== type && 'rgba' !== type && 'hex' !== type) {
                type = 'rgb';
            }

            scope.$on('acpEvent', function(e, data) {
                e.stopPropagation();
                // instance.rgb
                // instance.cleanRgb TODO
                // instance.hex

                if (ngModelFlag) {
                    // ngModel.$setViewValue('' !== instance[type] ? instance[type] : (instance.noneFlag ? 'none' : 'transparent'));
                    if (data.none) {
                        ngModel.$setViewValue(instance.noneFlag ? 'none' : 'transparent');
                    } else {
                        ngModel.$setViewValue(instance[type]);
                    }
                }
            });
            scope.$on('closeAcp', function(e) {
                e.stopPropagation();
                scope.close();
            });

            element.unbind('click', click);
            element.bind('click', click);
        }
    };
}]);
acp.directive('acpWindow', ['acpLib', 'acpModel', 'acpOptions', '$window', '$rootScope', function(acpLib, acpModel, acpOptions, $window, $rootScope) {
    return {
        restrict: 'A',
        scope: true,
        template:   '<div ng-show="isTopPanelShow" class="control-panel" acp-control-panel></div>' +
                    '<div class="main-panel" acp-main-panel></div>',
        link: function(scope, element, attrs) {
            var _x, _y,
                x = acpOptions.startPosition.x,
                y = acpOptions.startPosition.y;

            scope.cpSize = {
                width: element[0].offsetWidth,
                height: element[0].offsetHeight
            };

            scope.lastInstance = {};

            scope.clientSize = {
                width: $window.document.documentElement.clientWidth,
                height: $window.document.documentElement.clientHeight,
            };

            scope.instance = acpModel.getInstance(attrs.name);
            scope.isTopPanelShow = acpOptions.topPanel;

            scope.checkboxChange = function() {
                var inst = scope.instance, n = true;

                if (inst.none || inst.transparent) {
                    inst.lastAlpha = inst.alpha;
                    inst.alpha = 0;
                } else {
                    inst.alpha = inst.lastAlpha || 1;
                    n = false;
                }
                scope.setAlphaPosition();
                scope.$emit('acpEvent', { none: n });
            };

            if ('root' === x) {
                x = acpLib.obj.positX($rootScope.angularColorPickerElement[0]);

                x += ($rootScope.angularColorPickerElement[0].offsetWidth / 2 - scope.cpSize.width / 2);

                if (x < 0) {
                    x = 10;
                } else if (x + scope.cpSize.width > scope.clientSize.width - 10) {
                    x = scope.clientSize.width - scope.cpSize.width - 10;
                }

                x += 'px';
            } else if (x !== 'center') {
                _x = parseFloat(x);
                if (isNaN(_x) || undefined === _x) {
                    x = 'center';
                }
            }

            if ('root' === y) {
                y = acpLib.obj.positY($rootScope.angularColorPickerElement[0]);

                if (y - scope.cpSize.height - $rootScope.angularColorPickerElement[0].offsetHeight / 2 - 10 > 0) {
                    y = y - scope.cpSize.height - $rootScope.angularColorPickerElement[0].offsetHeight / 2 - 10;
                } else {
                    y += (10 + $rootScope.angularColorPickerElement[0].offsetHeight);
                }

                y += 'px';
            } else if (y !== 'center') {
                _y = parseFloat(y);
                if (isNaN(_y) || undefined === _y) {
                    y = 'center';
                }
            }

            element.css({
                'top': (y === 'center') ? (scope.clientSize.height / 2 - scope.cpSize.height / 2) + 'px' : y,
                'left': (x === 'center') ? (scope.clientSize.width / 2 - scope.cpSize.width / 2) + 'px' : x
            });

            scope.$apply();
            element.bind('$destroy', function() {
                scope.$destroy();
            });
        }
    };
}]);

acp.directive('acpControlPanel', ['$window', 'acpLib', 'acpOptions', function($window, acpLib, acpOptions) {
    return {
        restrict: 'A',
        template: '<button class="close-button"></button>',
        link: function(scope, element, attrs) {
            var button = element[0].childNodes[0],
                startPointX = 0,
                startPointY = 0,

                move = function(e) {
                    var top, left;

                    top = acpLib.mouse.pageY(e) - startPointY;
                    left = acpLib.mouse.pageX(e) - startPointX;

                    top < 0 && (top = 0);
                    left < 0 && (left = 0);

                    if (left + scope.cpSize.width > scope.clientSize.width) {
                        left = scope.clientSize.width - scope.cpSize.width;
                    }

                    if (top + scope.cpSize.height > scope.clientSize.height) {
                        top = scope.clientSize.height - scope.cpSize.height;
                    }

                    element.parent().css({
                        'top': top + 'px',
                        'left': left + 'px'
                    });
                },

                mouseUp = function(e) {
                    if (1 === e.which) {
                        element.css('cursor', '');
                        ae($window.document).unbind('mousemove', move);
                        ae($window.document).unbind('mouseup', mouseUp);
                    }
                };

            acpOptions.topPanel && element.addClass('show');

            element.bind('mousedown', function(e) {
                if (1 === e.which && e.target !== button) {
                    e.preventDefault();
                    element.css('cursor', 'move');
                    startPointX = acpLib.mouse.pageX(e) - acpLib.obj.positX(element[0]);
                    startPointY = acpLib.mouse.pageY(e) - acpLib.obj.positY(element[0]);
                    ae($window.document).bind('mouseup', mouseUp);
                    ae($window.document).bind('mousemove', move);
                }
            });
            ae(button).bind('click', function(e) {
                scope.$emit('closeAcp');
            });

            element.bind('$destroy', function() {
                element.unbind('mousedown');
                ae(button).unbind('click');
            });
        }
    };
}]);
acp.directive('acpMainPanel', ['$compile', function($compile) {
    return {
        restrict: 'A',
        template:   '<div class="block-picker" acp-block="blockBGColor"></div>' +
                    '<div class="controls-wrapper-picker">' +
                        '<div class="out-color-wrapper">' +
                            '<div class="out-color" acp-out></div>' +
                        '</div>' +
                        '<div class="lines-picker">' +
                            '<div class="line-wrapper">' +
                                '<div class="line-piker" acp-line></div>' +
                            '</div>'+
                            '<div class="line-wrapper">' +
                                '<div class="alpha-piker" acp-alpha></div>' +
                            '</div>'+
                        '</div>' +
                    '</div>',
                    // '<div class="text" ng-show="{{instance.noneFlag || instance.transparentFlag}}">' +
                    //     '<label ng-show="instance.noneFlag"><input ng-model="instance.none" type="checkbox" ng-change="checkboxChange()"><span> {{instance.text}}</span></label>' +
                    //     '<label ng-show="instance.transparentFlag"><input ng-model="instance.transparent" type="checkbox" ng-change="checkboxChange()"><span> transparent</span></label>' +
                    // '</div>',
        link: function(scope, element, attrs) {
            var watch, t = angular.element('<div class="text">' +
                        '<label ng-show="instance.noneFlag"><input ng-model="instance.none" type="checkbox" ng-change="checkboxChange()"><span> {{instance.text}}</span></label>' +
                        '<label ng-show="instance.transparentFlag"><input ng-model="instance.transparent" type="checkbox" ng-change="checkboxChange()"><span> transparent</span></label>' +
                    '</div>');

            watch = scope.$watch('instance', function(nv) {
                if (nv) {
                    if (scope.instance.noneFlag || scope.instance.transparentFlag) {
                        element.append(t[0]);
                        $compile(t)(scope);
                    }
                }
            });

            element.bind('mousedown', function(e) {
                e.preventDefault();
                e.stopPropagation();
            });

            element.bind('$destroy', function() {
                watch();
                element.unbind('mousedown');
            });
        }
    };
}]);

acp.directive('acpAlpha', ['$compile', 'acpOptions', 'acpLib', '$window', function($compile, acpOptions, acpLib, $window) {
    var round = function(value) {
        value = value * 100;
        value = Math.round(value);
        value /= 100;
        return value;
    };
    return {
        restrict: 'A',
        template:   '<div class="circle-control"></div>' +
                    '<div class="cAlpha">' +
                        '<img src="' + acpOptions.imgPathLine + '">' +
                        '<div></div>' +
                    '</div>',
        link: function(scope, element, attrs) {
            var pos, tmp = 0,
                watchers = [],
                arrows = element[0].childNodes[0],
                line = {
                    width: 165,
                    height: 14,
                    node: element[0].childNodes[1],
                    gradient: element[0].childNodes[1].childNodes[1]
                },

                rgba_ = function() {
                    scope.instance.rgba = 'rgba(' + scope.instance.tmpRgb + ',' + scope.instance.alpha + ')';
                },

                getAlpha = function (e) {
                    var left;

                    left = acpLib.mouse.pageX(e) - pos;
                    left = (left < 0 )? 0 : left;
                    left = (left > line.width) ? line.width : left;

                    arrows.style.left = left + 'px';

                    scope.$apply(function() {
                        scope.instance.alpha = round(left / (line.width / 100) / 100);
                        line.gradient.style.background = 'linear-gradient(to right, transparent, ' + scope.instance.rgb + ')';
                        rgba_();
                        scope.$emit('acpEvent', {});
                    });
                },
                setPosition = function(al) {
                    var left = line.width / 100 * (al * 100);
                    arrows.style.left = left + 'px';
                },

                move = function(e) {
                    getAlpha(e);
                },
                mouseUp = function(e) {
                    e.preventDefault();
                    ae($window.document).unbind('mousemove', move);
                    ae($window.document).unbind('mouseup', mouseUp);
                };

            // scope.instance && setPosition(scope.instance.alpha);

            scope.setAlphaPosition = function() {
                if (scope.instance) {
                    setPosition(scope.instance.alpha);
                    rgba_();
                }
            };

            scope.setAlphaPosition();

            ae(arrows).bind('mousedown', function(e) {
                if (1 === e.which) {
                    e.preventDefault();
                    scope.instance.none = false;
                    scope.instance.transparent = false;
                    if (scope.firstStart) {
                        scope.firstStart = false;
                    }
                    pos = acpLib.obj.positX(line.node);
                    move(e);
                    ae($window.document).bind('mouseup', mouseUp);
                    ae($window.document).bind('mousemove', move);
                }
            });

            ae(arrows.node).bind('click', getAlpha);

            ae(line.node).bind('click', function(e) {
                if (1 === e.which) {
                    scope.instance.none = false;
                    scope.instance.transparent = false;
                    if (scope.firstStart) {
                        scope.firstStart = false;
                    }
                    pos = acpLib.obj.positX(line.node);
                    move(e);
                }
            });

            ae(line.node).bind('mousedown', function(e) {
                if (1 === e.which) {
                    e.preventDefault();
                    e.stopPropagation();
                    pos = acpLib.obj.positX(line.node);
                    ae($window.document).bind('mouseup', mouseUp);
                    ae($window.document).bind('mousemove', move);
                }
            });

            watchers.push(scope.$watch('instance', function(v) {
                if (undefined !== v) {
                    setPosition(scope.instance.alpha);
                }
            }));

            watchers.push(scope.$watch('instance.rgb', function(v) {
                if (undefined !== v) {
                    line.gradient.style.background = 'linear-gradient(to right, transparent, ' + v + ')';
                }
            }));

            watchers.push(scope.$watch('firstStart', function (nv, ov) {
                if (undefined !== nv && false === nv && true === ov) {
                    setPosition(scope.instance.alpha);
                }
            }));

            element.bind('$destroy', function() {
                angular.forEach(watchers, function(watcher) {
                    watcher();
                });
                watchers = [];
                ae(arrows.node).unbind('click');
                ae(line.node).unbind('click');
                ae(arrows).unbind('mousedown');
                ae(line.node).unbind('mousedown');
            });
        }
    };
}]);

acp.directive('acpLine', ['$compile', '$window', 'acpLib', function($compile, $window, acpLib) {
    var rgb_ = function (canvas, h, w) {
            var gradient, hue, color, canvas, gradient, i;

            canvas = canvas.getContext("2d");

            // gradient = canvas.createLinearGradient( w / 2, h, w / 2, 0);
            gradient = canvas.createLinearGradient( w, h / 2, 0, h / 2);

            hue = [
                [255,0,0],
                [255,255,0],
                [0,255,0],
                [0,255,255],
                [0,0,255],
                [255,0,255],
                [255,0,0]
            ];

            for (i = 0; i <= 6; i++) {
                color = 'rgb('+hue[i][0]+','+hue[i][1]+','+hue[i][2]+')';
                gradient.addColorStop(i*1/6, color);
            }
            canvas.fillStyle = gradient;
            canvas.fillRect(0, 0, w, h);
        };

    return {
        restrict: 'A',
        template:   '<div class="circle-control"></div>' +
                    '<canvas width="165" height="14" class="cLine"></canvas>',

        link: function(scope, element, attrs) {
            var pos, tmp = 0,
                watchers = [],
                arrows = element[0].childNodes[0],
                line = {
                    width: 165,
                    height: 14,
                    node: element[0].childNodes[1]
                },
                getColor = function (e) {
                    var left, rgb;

                    left = acpLib.mouse.pageX(e) - pos;
                    left = (left < 0) ? 0 : left;
                    left = (left > line.width) ? line.width : left;

                    arrows.style.left = left + 'px';
                    tmp =  Math.round(left / ( line.width / 360 ));
                    tmp = Math.abs(tmp - 360);
                    tmp = (tmp == 360) ? 0 : tmp;

                    scope.instance.hue = tmp;

                    rgb = acpLib.hsv_rgb(tmp, scope.instance.picker.S, scope.instance.picker.V);
                    scope.$apply(function() {
                        scope.instance.blockBGColor = 'rgb(' + acpLib.hsv_rgb(tmp, 100, 100) + ')';
                        scope.instance.rgb = 'rgb(' + rgb + ')';
                        scope.instance.rgba = 'rgba(' + rgb + ',' + scope.instance.alpha +')';
                        scope.instance.hex = '#' + acpLib.convertRgbToHex(rgb);
                        scope.instance.tmpRgb = rgb;
                        scope.$emit('acpEvent', {});
                    });
                },
                setPosition = function(h) {
                    var left = 165 - 165 / (360 / h);

                    arrows.style.left = left + 'px';
                    scope.instance.hue = h;
                    scope.instance.blockBGColor = 'rgb(' + acpLib.hsv_rgb(h, 100, 100) + ')';
                },
                move = function(e) {
                    getColor(e);
                },
                mouseUp = function(e) {
                    e.preventDefault();
                    ae($window.document).unbind('mousemove', move);
                    ae($window.document).unbind('mouseup', mouseUp);
                };

            line.node.width = line.width;
            line.node.height = line.height;

            rgb_(line.node, line.height, line.width);

            ae(arrows).bind('mousedown', function(e) {
                if (1 === e.which) {
                    e.preventDefault();
                    e.stopPropagation();
                    scope.instance.none = false;
                    scope.instance.transparent = false;
                    if (scope.firstStart) {
                        scope.firstStart = false;
                        scope.instance.alpha = 1;
                    }
                    pos = acpLib.obj.positX(line.node);
                    ae($window.document).bind('mouseup', mouseUp);
                    ae($window.document).bind('mousemove', move);
                }
            });

            ae(arrows.node).bind('click', getColor);

            ae(line.node).bind('click', function(e) {
                scope.instance.none = false;
                scope.instance.transparent = false;
                getColor(e);
            });

            ae(line.node).bind('mousedown', function(e) {
                if (1 === e.which) {
                    e.preventDefault();
                    e.stopPropagation();
                    pos = acpLib.obj.positX(line.node);
                    ae($window.document).bind('mouseup', mouseUp);
                    ae($window.document).bind('mousemove', move);
                }
            });

            watchers.push(scope.$watch('instance.hsv', function(v) {
                if (v && v.length > 0) {
                    if ('none' === v || 'transparent' === v) {
                        v = [359, 0, 0];
                    }
                    setPosition(v[0]);
                }
            }));

            element.bind('$destroy', function() {
                angular.forEach(watchers, function(watcher) {
                    watcher();
                });
                watchers = [];
                ae(arrows.node).unbind('click');
                ae(line.node).unbind('click');
                ae(arrows).unbind('mousedown');
                ae(line.node).unbind('mousedown');
            });
        }
    };
}]);
acp.directive('acpBlock', ['$compile', '$window', 'acpLib', 'acpOptions', function($compile, $window, acpLib, acpOptions) {
    return {
        restrict: 'A',
        template: '<img src="' + acpOptions.imgPath + '">' +
                    '<div class="circle"></div>',
        link: function(scope, element, attrs) {
            var watchers = [],
                block = element[0],
                circle = block.childNodes[1],
                bPstX, bPstY, bWi, bHe, cW, cH, pxY, pxX,
                getColor = function (e) {
                    var rgb, top, left, S, V;

                    element.bind('dragstart', function() {
                        return false;
                    });

                    element.bind('onselectstart', function() {
                        return false;
                    });

                    left = acpLib.mouse.pageX(e) - bPstX - cW/2;
                    left = (left < 0) ? 0 : left;
                    left = (left > bWi) ? bWi  : left;

                    ae(circle).css('left', left + 'px');

                    S = Math.ceil(left / pxX);

                    top = acpLib.mouse.pageY(e) - bPstY - cH/2;
                    top = (top > bHe) ? bHe : top;
                    top = (top < 0) ? 0 : top;

                    ae(circle).css('top', top + 'px');

                    V = Math.ceil(Math.abs(top / pxY - 100));

                    // ae(circle).css('border-color', V < 50 ? '#fff' : '#000');

                    scope.instance.picker.S = S;
                    scope.instance.picker.V = V;

                    rgb = acpLib.hsv_rgb(scope.instance.hue, S, V);
                    scope.$apply(function() {
                        scope.instance.rgb = 'rgb(' + rgb + ')';
                        scope.instance.rgba = 'rgba(' + rgb + ',' + scope.instance.alpha +')';
                        scope.instance.tmpRgb = rgb;
                        scope.instance.hex = '#' + acpLib.convertRgbToHex(rgb);
                        scope.$emit('acpEvent', {});
                    });
                },
                setPosition = function(hsv) {
                    var top = bHe - bHe / (255 / hsv[2]),
                        left = bWi / (1 / hsv[1]);

                    scope.instance.picker.S = Math.ceil(left / pxX);
                    scope.instance.picker.V = Math.ceil(Math.abs(top / pxY - 100));

                    ae(circle).css({
                        'top': top + 'px',
                        'left': left + 'px'
                    });
                },
                move = function(e) {
                    bPstX = acpLib.obj.positX(block);
                    bPstY = acpLib.obj.positY(block);
                    getColor(e);
                },
                mouseUp = function(e) {
                    e.preventDefault();
                    ae($window.document).unbind('mousemove', move);
                    ae($window.document).unbind('mouseup', mouseUp);
                };

            watchers.push(scope.$watch('instance.blockBGColor', function(v) {
                element.css('background-color', v);
            }));

            cW = circle.offsetWidth;
            cH = circle.offsetHeight;
            bWi = block.offsetWidth - cW;
            bHe = block.offsetHeight - cH;
            pxY = bHe / 100;
            pxX = bWi / 100;

            element.bind('click', function(e) {
                getColor(e);
            });

            element.bind('mousedown', function(e) {
                if (1 === e.which) {
                    e.preventDefault();
                    e.stopPropagation();
                    scope.instance.none = false;
                    scope.instance.transparent = false;
                    if (scope.firstStart) {
                        scope.firstStart = false;
                        scope.instance.alpha = 1;
                    }
                    move(e);
                    ae($window.document).bind('mouseup', mouseUp);
                    ae($window.document).bind('mousemove', move);
                }
            });

            watchers.push(scope.$watch('instance.hsv', function(v) {
                if (v && v.length > 0) {
                    if ('none' === v || 'transparent' === v) {
                        v = [359, 0, 0];
                    }
                    setPosition(v);
                }
            }));

            element.bind('$destroy', function() {
                angular.forEach(watchers, function(watcher) {
                    watcher();
                });
                watchers = [];
                element.unbind('click');
                element.unbind('mousedown');
            });
        }
    };
}]);

acp.directive('acpOut', ['$compile', 'acpOptions', function($compile, acpOptions) {
    return {
        restrict: 'A',
        scope: false,
        template: '<div class="bg-img"></div><div></div>',
        link: function(scope, element, attrs) {
            var watch, ch = element.children();

            ae(ch[0]).css('background-image', 'url(' + acpOptions.imgPathLine + ')');

            watch = scope.$watch('instance.rgba', function(v) {
                ch.css('background-color', v);
            });

            element.bind('$destroy', function() {
                watch();
            });
        }
    };
}]);
})();
(function() {
    'use strict';

    var aInfobar = angular.module('angularInfobar', []);

    aInfobar.value('aInfobarOptions', {
        'showTime': 2000,
        'enterTime': 500,
        'exitTime': 1000
    });

    aInfobar.service('aInfobarManager', ['aInfobarModel', function(aInfobarModel) {
        return {
            showMessage: function(innerHTML) {
                aInfobarModel.newInstance(innerHTML);
            },
            hideMessage: function(id) {
                aInfobarModel.removeInstance(id);
            }
        };
    }]);

    aInfobar.service('aInfobarModel', ['$compile', '$document', function($compile, $document) {
        var instances = {},
            create = function(innerHTML) {
                var id = 'aInfobar-' + (new Date().getTime()),
                    node = angular.element('<div>'),
                    content = angular.element('<div>');

                node.addClass('aInfobar');
                node.attr('a-infobar', '');
                node.attr('id', id);

                content.addClass('aInfobar-content');
                content[0].innerHTML = innerHTML;

                node.append(content[0]);

                return {
                    id: id,
                    node: node,
                    content: content,
                    message: innerHTML
                };
            };

        return {
            newInstance: function(innerHTML) {
                var instance = create(innerHTML);
                instances[instance.id] = instance;

                angular.element($document[0].body).append(instance.node[0]);

                $compile(instance.node[0]) (angular.element($document[0].body).scope().$new(true));

                return instance.id;
            },

            removeInstance: function(id) {
                instances[id].node.remove();
                delete instances[id];
            }
        };
    }]);

    aInfobar.directive('aInfobar', ['aInfobarModel', 'aInfobarOptions', '$document', function(aInfobarModel, aInfobarOptions, $document) {
        return {
            restrict: 'A',
            link: function(scope, element, attrs) {
                var button = angular.element('<button>'),
                    first = false,
                    exit = function() {
                        element.on('transitionend', function(e) {
                            element.off(e.type);
                            aInfobarModel.removeInstance(attrs.id);
                        });
                        
                        element.css({
                            'opacity': '0',
                            '-webkit-transition': 'opacity ' + aInfobarOptions.enterTime + 'ms ease-out ' + aInfobarOptions.showTime + 'ms',
                            'transition': 'opacity ' + aInfobarOptions.enterTime + 'ms ease-out ' + aInfobarOptions.showTime + 'ms'
                        });
                    };

                button.addClass('aInfobar-control btn btn-default glyphicon glyphicon-remove');
                button.on('click', function() {
                    aInfobarModel.removeInstance(attrs.id);
                });

                element.append(button[0]);

                element.on('transitionend', function(e) {
                    element.off(e.type);
                    first = true;
                    exit();
                });

                element.on('mouseover mouseout', function(e) {
                    var related = e.relatedTarget;
                    while (related && related !== element[0]) {
                        related = related.parentNode;
                    }
                    if (related == element[0]) {
                        return;
                    }

                    if (first) {
                        if ('mouseover' === e.type) {
                            element.off('transitionend');
                            element.css({
                                'opacity': '1',
                                '-webkit-transition': 'none',
                                'transition': 'none'
                            });
                        } else {
                            exit();
                        }
                    }
                });

                element[0].offsetHeight; // render

                element.css({
                    'top': '25px',
                    '-webkit-transition': 'top ' + aInfobarOptions.enterTime + 'ms ease-out 100ms',
                    'transition': 'top ' + aInfobarOptions.enterTime + 'ms ease-out 100ms'
                });

                element.on('$destroy', function() {
                    button.off('click');
                    element.off('mouseover mouseout');
                    element.off('transitionend');
                    scope.$destroy();
                });
            }
        };
    }]);
})();(function() {
    'use strict';

    var mw = angular.module('aModalWindow', []);

    mw.value('aModalWindowOptions', {
        saveButtonText: 'Save & Close',
        dSaveButtonText: 'Don\'t save',
        cancelButtonText: 'Cancel'
    });

    mw.service('aModalWindowManager', ['aModalWindowModel', function(aModalWindowModel) {
        // return function(text, callbacks) {
        //     aModalWindowModel.show(text, callbacks);
        // };

        return {
            show: function(text, callbacks) {
                aModalWindowModel.show(text, callbacks);
            },
            hide: function() {
                aModalWindowModel.hide();
            }
        };
    }]);

    mw.service('aModalWindowModel', [function() {
        var instance = {
            currentWindow: null,
            textNode: null,
            saveB: null,
            dSaveB: null,
            cancelB: null,
            callbacks: {
                saveButtonCallBack: function() {},
                dSaveButtonCallBack: function() {},
                cancelButtonCallBack: function() {}
            }
        },

        obj = {
            setWindow: function(node, tNode, saveB, dSaveB, cancelB) {
                instance.currentWindow = node;
                instance.textNode      = tNode;
                instance.saveB         = saveB,
                instance.dSaveB        = dSaveB,
                instance.cancelB       = cancelB;
            },

            setCallbacks: function(callbacks) {
                if (callbacks) {
                    if (callbacks.saveButtonCallBack)
                        instance.callbacks.saveButtonCallBack = callbacks.saveButtonCallBack;
                    if (callbacks.dSaveButtonCallBack)
                        instance.callbacks.dSaveButtonCallBack = callbacks.dSaveButtonCallBack;
                    if (callbacks.cancelButtonCallBack)
                        instance.callbacks.cancelButtonCallBack = callbacks.cancelButtonCallBack;
                } else {
                    instance.callbacks = {
                        saveButtonCallBack: function() {},
                        dSaveButtonCallBack: function() {},
                        cancelButtonCallBack: function() {}
                    };
                }
            },

            show: function(text, callbacks) {
                if(text) {
                    instance.textNode[0].innerHTML = text;
                }

                obj.setCallbacks(callbacks);

                instance.saveB.on('click', function(e) {
                    e.preventDefault();
                    e.stopPropagation();
                    instance.saveB.css({'position': 'relative'});
                    instance.saveB.addClass('loading');
                    instance.callbacks.saveButtonCallBack()
                });

                instance.dSaveB.on('click', function(e) {
                    e.preventDefault();
                    e.stopPropagation();
                    instance.callbacks.dSaveButtonCallBack();
                });

                instance.cancelB.on('click', function(e) {
                    e.preventDefault();
                    e.stopPropagation();
                    instance.callbacks.cancelButtonCallBack();
                });

                instance.currentWindow.addClass('show');
            },

            hide: function() {
                obj.setCallbacks();
                instance.saveB.css({'position': ''});
                instance.saveB.removeClass('loading');
                instance.saveB.off('click');
                instance.dSaveB.off('click');
                instance.cancelB.off('click');
                instance.currentWindow.removeClass('show');
            }
        };

        return obj;
    }]);

    mw.directive('aModalWindow', ['aModalWindowOptions', 'aModalWindowModel', function(aModalWindowOptions, aModalWindowModel) {
        return {
            restrict: 'A',
            link: function(scope, element, attrs) {
                element.addClass('a-modal-window');
                var node = angular.element('<div>'),
                    textNode = angular.element('<div>'),
                    controllsWrapper = angular.element('<div>'),
                    saveButtonText = angular.element('<button>'),
                    dSaveButtonText = angular.element('<button>'),
                    cancelButtonText = angular.element('<button>');

                node.addClass('view-wrapper');
                textNode.addClass('text-container');
                controllsWrapper.addClass('controlls-wrapper');
                saveButtonText.addClass('save-button mtb-button insert');
                dSaveButtonText.addClass('d-save-button mtb-button');
                cancelButtonText.addClass('cancel-button mtb-button');


                saveButtonText[0].innerHTML = aModalWindowOptions.saveButtonText;
                dSaveButtonText[0].innerHTML = aModalWindowOptions.dSaveButtonText;
                cancelButtonText[0].innerHTML = aModalWindowOptions.cancelButtonText;

                node.append(textNode);
                controllsWrapper.append(cancelButtonText);
                controllsWrapper.append(dSaveButtonText);
                controllsWrapper.append(saveButtonText);

                node.append(controllsWrapper);

                aModalWindowModel.setWindow(element, textNode, saveButtonText, dSaveButtonText, cancelButtonText);
                element.append(node);

                element.on('$destroy', function() {
                    element.removeClass('show');
                    element.removeClass('a-modal-window');

                    saveButtonText.off('click');
                    dSaveButtonText.off('click');
                    cancelButtonText.off('click');

                    element[0].innerHTML = '';

                    scope.$destroy();
                });
            }
        };
    }]);
})();
})();