{**
* 2005-2025 Magic Toolbox
*
* NOTICE OF LICENSE
*
* This file is licenced under the Software License Agreement.
* With the purchase or the installation of the software in your application
* you accept the licence agreement.
*
* You must not modify, adapt or create derivative works of this source code
*
*  @author    Magic Toolbox <support@magictoolbox.com>
*  @copyright Copyright (c) 2025 Magic Toolbox <support@magictoolbox.com>. All rights reserved
*  @license   https://www.magictoolbox.com/license/
*}

<!-- MagicZoom -->
{if $legacy_template}
<style>
#magiczoom-template {
    display: none;
}
.magiczoom-settings {
    width: 100%;
}
.magiczoom-settings td {
    text-align: center;
}
.magiczoom-settings .error {
    text-align: left;
}
.magiczoom-settings fieldset {
    border: none;
}
.magiczoom-settings textarea {
    margin: 0;
    width: 99% !important;
}
.magiczoom-settings p {
    text-align: left;
}
</style>
<div id="magiczoom-template">
    <table class="magiczoom-settings" cellpadding="5">
        {if isset($magiczoom_invalid_urls)}
        <tr>
            <td>
                <div class="error">
                    <img src="../img/admin/error2.png" />
                    {l s='"Product Videos" value contains incorrect urls:' mod='magiczoom'}
                    <ol>
                        {foreach from=$magiczoom_invalid_urls item=url}
                            <li>{$url|escape:'html':'UTF-8'}</li>
                        {/foreach}
                    </ol>
                </div>
            </td>
        </tr>
        {/if}
        <tr>
            <td>
                <fieldset>
                    <legend>Product Videos</legend>
                    <textarea name="magiczoom_video" rows="10" cols="45">{if isset($magiczoom_textarea)}{$magiczoom_textarea|escape:'html':'UTF-8'}{/if}</textarea>
                    <p>{l s='Provide links to video separated by a space or new line' mod='magiczoom'}</p>
                </fieldset>
            </td>
        </tr>
        <tr>
            <td>
                <input type="submit" value="{l s='Save' mod='magiczoom'}" name="submitAddproduct" class="button" />&nbsp;
                <input type="submit" value="{l s='Save and stay' mod='magiczoom'}" name="submitAddproductAndStay" class="button" />
            </td>
        </tr>
    </table>
</div>
<script type="text/javascript">
//<![CDATA[
    var mtTabNumber = $('.tab-page').length + 1;
    $('.tab-page:last').after(
        '<div class="tab-page" id="step'+mtTabNumber+'"><h4 class="tab">'+mtTabNumber+'. MagicZoom</h4>'+
        $('#magiczoom-template').html()+
        '</div>'
    );
//]]>
</script>
{else}
<style>
.magiczoom-settings .error {
    overflow: hidden;
}
.magiczoom-settings fieldset {
    border: none;
}
.magiczoom-settings textarea {
    margin: 0;
    width: 99% !important;
    resize: vertical;
}
</style>
<div class="magiczoom-settings panel product-tab">
    <input type="hidden" name="submitted_tabs[]" value="magiczoom" />
    {if $p16x_template}
    <h3>{l s='Product Videos' mod='magiczoom'}</h3>
    {else}
    <h4>{l s='Product Videos' mod='magiczoom'}</h4>
    {/if}
    <div class="separation"></div>
    {if isset($magiczoom_invalid_urls)}
    {if $p16x_template}
    <div class="bootstrap">
        <div class="module_error alert alert-danger" >
            <button type="button" class="close" data-dismiss="alert">&times;</button>
            {l s='"Product Videos" value contains incorrect urls:' mod='magiczoom'}
            <ul>
                {foreach from=$magiczoom_invalid_urls item=url}
                    <li>{$url|escape:'html':'UTF-8'}</li>
                {/foreach}
            </ul>
        </div>
    </div>
    {else}
    <div class="error">
        <span style="float:right">
            <a id="hideError" href="#"><img alt="X" src="../img/admin/close.png" /></a>
        </span>
        {l s='"Product Videos" value contains incorrect urls:' mod='magiczoom'}
        <br/>
        <ol>
            {foreach from=$magiczoom_invalid_urls item=url}
                <li>{$url|escape:'html':'UTF-8'}</li>
            {/foreach}
        </ol>
    </div>
    {/if}
    {/if}
    <fieldset>
        <textarea name="magiczoom_video" rows="10">{if isset($magiczoom_textarea)}{$magiczoom_textarea|escape:'html':'UTF-8'}{/if}</textarea>
        <p class="{if $p16x_template}help-block{else}preference_description{/if}">{l s='Provide links to video separated by a space or new line' mod='magiczoom'}</p>
    </fieldset>
    {if $p16x_template}
    <div class="panel-footer">
        <button type="submit" name="submitAddproduct" class="btn btn-default pull-right" disabled="disabled"><i class="process-icon-loading"></i> {l s='Save' mod='magiczoom'}</button>
        <button type="submit" name="submitAddproductAndStay" class="btn btn-default pull-right" disabled="disabled"><i class="process-icon-loading"></i> {l s='Save and stay' mod='magiczoom'}</button>
    </div>
    {/if}
</div>
<div class="clear">&nbsp;</div>
{/if}
<!-- /MagicZoom -->
