<?php

/**
 * Admin MagicZoomPlus Settings manager.
 * Admin Menu: Master Settings -> Magic Zoom Plus Settings.
 * @package magiczoomplus
 */
class MagicZoomPlus extends oxAdminView {

    protected $sModuleDir = null;
    protected $oTool = null;
    protected $sMessage = null;
    protected $sCurrentTabs = '';
    protected $bRegistryClassExists = false;//NOTE: 'oxRegistry' class exists since version 4.7.0

    public function __construct() {

        parent::__construct();

        $this->bRegistryClassExists = class_exists('oxRegistry');

        $this->sModuleDir = getShopBasePath().'modules/magiczoomplus';
        $sCoreFile = $this->sModuleDir.'/classes/magiczoomplus.module.core.class.php';
        if(file_exists($sCoreFile)) {

            $oDb = oxDb::getDb();

            if($this->bRegistryClassExists) {
                $bReset = oxRegistry::getConfig()->getRequestParameter('reset', false);
            } else {
                //NOTE: for OXID versions < 4.7.0
                $bReset = oxConfig::getParameter('reset');
            }
            $bReset = ($bReset == 'true' ? true : false);


            require_once($sCoreFile);
            $this->oTool = new MagicZoomPlusModuleCoreClass();
            $aRezult = $oDb->getAll("SELECT `BLOCK`, `NAME`, `VALUE` FROM `magiczoomplus_config` WHERE `ENABLED`=1");

            //NOTE: create or reset settings
            if(!$aRezult || $bReset) {
                if(!class_exists('MagicZoomPlusEvents')) {
                    include getShopBasePath().'modules/magiczoomplus/magiczoomplusevents.php';
                }
                MagicZoomPlusEvents::onActivate();
                $aRezult = $oDb->getAll("SELECT `BLOCK`, `NAME`, `VALUE` FROM `magiczoomplus_config` WHERE `ENABLED`=1");
            }

            foreach($aRezult as $aRow) {
                $this->oTool->params->setValue($aRow[1], $aRow[2], $aRow[0]);
            }
            //NOTE: change subtype for some params to display them like radio
            foreach($this->oTool->params->getParams() as $sParamId => $aParam) {
               if($this->oTool->params->getSubType($sParamId) == 'select' && count($this->oTool->params->getValues($sParamId)) < 6)
                   $this->oTool->params->setSubType($sParamId, 'radio');
            }

        } else {
            $this->sMessage = "Error: file {$sCoreFile} does not exists!";
        }

    }

    public function render() {

        parent::render();

        $oAuthUser = oxNew('oxuser');
        $oAuthUser->loadAdminUser();
        if($oAuthUser->oxuser__oxrights->value == 'malladmin') {
            if($this->sMessage === null) {
                $sTemplateFile = $this->sModuleDir.'/magiczoomplussettings.php';
                if(!file_exists($sTemplateFile)) {
                    $this->sMessage = "Error: file {$sTemplateFile} does not exists!";
                }
            }

            //$oSmarty = oxUtilsView::getInstance()->getSmarty();
            if($this->bRegistryClassExists) {
                $oSmarty = oxRegistry::get('oxUtilsView')->getSmarty();
            } else {
                //NOTE: for OXID versions < 4.9.0
                $oSmarty = oxUtilsView::getInstance()->getSmarty();
            }

            $oSmarty->assign('oViewConf', $this->_aViewData['oViewConf']);
            $oSmarty->assign('shop', $this->_aViewData['shop']);
            if($this->sMessage === null) {
                $oTool = &$this->oTool;
                //$shopUrl = $this->_aViewData['oViewConf']->getConfig()->getShopUrl();
                $sImageUrl = $this->getConfig()->getImageUrl($this->isAdmin());
                $sResourceUrl = $this->getConfig()->getResourceUrl('', $this->isAdmin());
                ob_start();
                require $sTemplateFile;
                $sSettingsTemplateContents = ob_get_contents();
                ob_end_clean();
                $oSmarty->assign('sSettingsContents', $sSettingsTemplateContents);
            } else {
                $oSmarty->assign('sSettingsContents', $this->sMessage);
            }
            echo $oSmarty->fetch('magiczoomplus.tpl');
            if(method_exists('oxUtils', 'getInstance')) {
                //NOTE: for OXID versions < 4.9.0
                oxUtils::getInstance()->showMessageAndExit('');
            } else {
                oxRegistry::getUtils()->showMessageAndExit('');
            }
        } else {
            return oxUtils::getInstance()->showMessageAndExit('Access denied!');
        }

    }

    public function saveSettings() {

        $oAuthUser = oxNew('oxuser');
        $oAuthUser->loadAdminUser();
        if($oAuthUser->oxuser__oxrights->value === 'malladmin' && $_SERVER['REQUEST_METHOD'] == 'POST') {

            if($this->bRegistryClassExists) {
                $bReset = oxRegistry::getConfig()->getRequestParameter('reset', false);
            } else {
                //NOTE: for OXID versions < 4.7.0
                $bReset = oxConfig::getParameter('reset');
            }
            $bReset = ($bReset == 'true' ? true : false);
            if($bReset) {
                return;
            }

            if(isset($_POST['magic_tabs_current'])) {
                $this->sCurrentTabs = $_POST['magic_tabs_current'];
            }

            $oDb = oxDb::getDb();

            foreach($this->getParamsMap() as $sBlockId => $aGroups) {
                foreach($aGroups as $aGroup) {
                    foreach($aGroup as $sParam) {
                        if(isset($_POST[$sBlockId.'-'.$sParam])) {
                            $sValue = trim($_POST[$sBlockId.'-'.$sParam]);
                            switch($this->oTool->params->getType($sParam)) {
                                case "num":
                                    $sValue = intval($sValue);
                                    break;
                                case "array":
                                    if(!in_array($sValue, $this->oTool->params->getValues($sParam))) $sValue = $this->oTool->params->getDefaultValue($sParam);
                                    break;
                                case "text":
                                    $sValue = addslashes($sValue);
                                    break;
                            }
                            $oDb->execute("UPDATE `magiczoomplus_config` SET `VALUE`='{$sValue}', `ENABLED`=1 WHERE `BLOCK`='{$sBlockId}' AND `NAME`='{$sParam}'");
                            $this->oTool->params->setValue($sParam, $sValue, $sBlockId);
                        } else {
                            $oDb->execute("UPDATE `magiczoomplus_config` SET `ENABLED`=0 WHERE `BLOCK`='{$sBlockId}' AND `NAME`='{$sParam}'");
                            if($this->oTool->params->paramExists($sParam, $sBlockId)) {
                                $this->oTool->params->removeParam($sParam, $sBlockId);
                            };
                        }
                    }
                }
            }

        }

    }


    public function getParamsBlocks() {
        return array(
			'default' => 'General',
			'product' => 'Product page',
			'category' => 'Category page',
		);
    }

    public function getParamsMap() {
        return array(
			'default' => array(
				'Positioning and Geometry' => array(
					'thumb-max-width',
					'thumb-max-height',
					'zoomWidth',
					'zoomHeight',
					'zoomPosition',
					'zoomDistance',
					'square-images',
				),
				'Miscellaneous' => array(
					'lazyZoom',
					'rightClick',
					'cssClass',
					'link-to-product-page',
					'show-message',
					'message',
					'resize-images',
					'imagemagick',
					'image-quality',
				),
				'Zoom mode' => array(
					'zoomMode',
					'zoomOn',
					'upscale',
					'smoothing',
					'variableZoom',
					'zoomCaption',
				),
				'Expand mode' => array(
					'expand',
					'expandZoomMode',
					'expandZoomOn',
					'expandCaption',
					'closeOnClickOutside',
				),
				'Watermark' => array(
					'watermark',
					'watermark-max-width',
					'watermark-max-height',
					'watermark-opacity',
					'watermark-position',
					'watermark-offset-x',
					'watermark-offset-y',
				),
				'Hint' => array(
					'hint',
					'textHoverZoomHint',
					'textClickZoomHint',
					'textExpandHint',
					'textBtnClose',
					'textBtnNext',
					'textBtnPrev',
				),
				'Mobile' => array(
					'zoomModeForMobile',
					'textHoverZoomHintForMobile',
					'textClickZoomHintForMobile',
					'textExpandHintForMobile',
				),
			),
			'product' => array(
				'General' => array(
					'enable-effect',
					'template',
					'magicscroll',
				),
				'Positioning and Geometry' => array(
					'thumb-max-width',
					'thumb-max-height',
					'zoomWidth',
					'zoomHeight',
					'zoomPosition',
					'zoomDistance',
				),
				'Multiple images' => array(
					'selectorTrigger',
					'selector-max-width',
					'selector-max-height',
					'transitionEffect',
				),
				'Miscellaneous' => array(
					'lazyZoom',
					'rightClick',
					'cssClass',
					'show-message',
					'message',
				),
				'Zoom mode' => array(
					'zoomMode',
					'zoomOn',
					'upscale',
					'smoothing',
					'variableZoom',
					'zoomCaption',
				),
				'Expand mode' => array(
					'expand',
					'expandZoomMode',
					'expandZoomOn',
					'expandCaption',
					'closeOnClickOutside',
				),
				'Hint' => array(
					'hint',
					'textHoverZoomHint',
					'textClickZoomHint',
					'textExpandHint',
					'textBtnClose',
					'textBtnNext',
					'textBtnPrev',
				),
				'Mobile' => array(
					'zoomModeForMobile',
					'textHoverZoomHintForMobile',
					'textClickZoomHintForMobile',
					'textExpandHintForMobile',
				),
				'Scroll' => array(
					'width',
					'height',
					'mode',
					'items',
					'speed',
					'autoplay',
					'loop',
					'step',
					'arrows',
					'pagination',
					'easing',
					'scrollOnWheel',
					'lazy-load',
					'scroll-extra-styles',
					'show-image-title',
				),
			),
			'category' => array(
				'General' => array(
					'enable-effect',
				),
				'Positioning and Geometry' => array(
					'thumb-max-width',
					'thumb-max-height',
					'zoomWidth',
					'zoomHeight',
					'zoomPosition',
					'zoomDistance',
				),
				'Miscellaneous' => array(
					'lazyZoom',
					'rightClick',
					'cssClass',
					'link-to-product-page',
					'show-message',
					'message',
				),
				'Zoom mode' => array(
					'zoomMode',
					'zoomOn',
					'upscale',
					'smoothing',
					'variableZoom',
					'zoomCaption',
				),
				'Expand mode' => array(
					'expand',
					'expandZoomMode',
					'expandZoomOn',
					'expandCaption',
					'closeOnClickOutside',
				),
				'Hint' => array(
					'hint',
					'textHoverZoomHint',
					'textClickZoomHint',
					'textExpandHint',
					'textBtnClose',
					'textBtnNext',
					'textBtnPrev',
				),
				'Mobile' => array(
					'zoomModeForMobile',
					'textHoverZoomHintForMobile',
					'textClickZoomHintForMobile',
					'textExpandHintForMobile',
				),
			),
		);
    }


}

?>
