<?php

/**
 * Metadata version
 */
$sMetadataVersion = '1.1';

/**
 * Module information
 */
$aModule = array(
    'id'           => 'magiczoom',
    'title'        => 'Magic Zoom',
    'description'  => "Zoom into images when you hover over an image. A beautiful effect.",
    //'thumbnail'    => 'magiczoom.png',
    'version'      => '4.3.18',
    'author'       => 'Magic Toolbox',
    'email'        => 'support@magictoolbox.com',
    'url'          => 'http://www.magictoolbox.com',
    'extend'       => array(
        'oxoutput' => 'magiczoom/magiczoomoutput',
    ),
    'files' => array(
        'magiczoomevents' => 'magiczoom/magiczoomevents.php',
        'magiczoom' => '../admin/magiczoom.php',
    ),
    'events'       => array(
        'onActivate'   => 'magiczoomevents::onActivate',
        'onDeactivate' => 'magiczoomevents::onDeactivate',
    ),

);

if(class_exists('oxRegistry')) {
    $myConfig = oxRegistry::getConfig();
} else {
    //NOTE: for OXID versions < 4.7.0
    $myConfig = oxConfig::getInstance();
}
$aDisabledModules = $myConfig->getConfigParam('aDisabledModules');
if(!is_array($aDisabledModules)) $aDisabledModules = array();
if(in_array('magiczoom', $myConfig->getConfigParam('aDisabledModules'))) {
    $aModule['description'] .= "<br /><br /><span style=\"color: red;\">Please activate the module and refresh the page (if need it) to access the settings.</span>";
} else {
    $aModule['description'] .= "<br /><br /><span style=\"color: green;\">Change the settings as you wish via the <b>Master Settings</b> -> <b>Magic Zoom Settings</b> menu.</span>";
}
