<?php

//class MagicZoomOutput extends oxOutput {
class MagicZoomOutput extends MagicZoomOutput_parent {

    public $aSavedViewData = null;

    public $aProcessedBlocks = array();

    public $aMagicZoomClassNamesMapping = array(
        'details' => 'product',
        'alist' => 'category',
    );

    public $blIsAJAX = false;

    public $blMixedMode = false;
    public $s360HTML = '';

    public function __construct() {
        parent::__construct();
        if($this->blMixedMode == false && method_exists($this, 'getMagic360Tool')) {
            $oTool = $this->getMagicZoomTool();
            $o360Tool = $this->getMagic360Tool();
            if(!$oTool->params->checkValue('enable-effect', 'No', 'product') && $o360Tool->params->checkValue('enable-effect', 'Yes', 'product')) {
                $this->blMixedMode = true;
            }
        }
        $this->blIsAJAX = isset($_SERVER['HTTP_X_REQUESTED_WITH']) && ($_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest');
        if($this->blIsAJAX) {
            //NOTE: for product variants (when refreshing product images via ajax) (~ OXID 4.8.3)
            $this->aMagicZoomClassNamesMapping['oxwarticledetails'] = 'product';
        }

    }

    public function process($sOutput, $sClassName) {

        if(!isset($this->aMagicZoomClassNamesMapping[$sClassName])) return parent::process($sOutput, $sClassName);

        $sPage = $this->aMagicZoomClassNamesMapping[$sClassName];

        $oTool = $this->getMagicZoomTool();

        if(!$oTool->params->profileExists($sPage) || $oTool->params->checkValue('enable-effect', 'No', $sPage)) {
            return parent::process($sOutput, $sClassName);
        }
        $oTool->params->setProfile($sPage);

        $sOutput = parent::process($sOutput, $sClassName);


        //NOTE: after parent process
        if($this->aSavedViewData === null) return $sOutput;

        //NOTE: if the block has been processed by another MagicToolbox module
        if(isset($this->aProcessedBlocks[$sPage])) return $sOutput;

        $aViewData = &$this->aSavedViewData;

        $blOutputHeaders = false;
        $blProductHasVariants = false;
        $blProductHasParent = false;//NOTE: variant of product

        $oMyConfig = $this->getConfig();

        $sBaseShopUrl = $oMyConfig->getShopUrl();
        $sBaseImagePath = getShopBasePath().$oMyConfig->getOutDir(false).$oMyConfig->getConfigParam('_sPictureDir').'/';
        $sBaseImageUrl = $oMyConfig->getOutUrl()./*'/'.*/$oMyConfig->getConfigParam('_sPictureDir').'/';

        //NOTE: check for external images enabled
        $blExternalImages = isset($oMyConfig->sAltImageDir) ? true : false;
        if($blExternalImages) {
            $sBaseImageUrl = preg_replace('/\/$/', '', $oMyConfig->sAltImageDir).'/';
        }

        $sOxidVersion = $oMyConfig->getVersion();
        //NOTE: Image handling changes since 4.5.1
        //http://wiki.oxidforge.org/Tutorials/image_handling_changes
        $newImageHandling = version_compare($sOxidVersion, '4.5.1', '>=');
        $blResize = $oTool->params->checkValue('resize-images', 'Yes');

        switch($sPage) {
            case 'product':

                $oProduct = (isset($aViewData['product']) && $aViewData['product']) ? $aViewData['product'] : $aViewData['oView']->getProduct();

                //NOTICE: oxarticles__oxartnum may not be unique and contain not desirable symbols
                //    but oxarticles__oxid, on the other hand, can contains strange value like this "be642cad637adf214.28850610"
                //$sOXID = $sProductId = isset($oProduct->oxarticles__oxartnum->value) ? $oProduct->oxarticles__oxartnum->value : null;
                $sOXID = isset($oProduct->oxarticles__oxid->value) ? $oProduct->oxarticles__oxid->value : null;

                //$varselid = oxConfig::getParameter('varselid');//array
                            //oxRegistry::getConfig()->getConfigParam('varselid');
                if(class_exists('oxRegistry')) {
                    $varselid = oxRegistry::getConfig()->getRequestParameter('varselid', false);
                } else {
                    //NOTE: for OXID versions < 4.7.0
                    $varselid = oxConfig::getParameter('varselid');//array
                }

                $blProductHasParent = method_exists($oProduct, 'getParentId') ? ($oProduct->getParentId() ? true : false) : false;

                //NOTE: for product variants (when refreshing product images via ajax)
                if(isset($_POST['renderPartial']) || $this->blIsAJAX/* ~ OXID 4.8.3 */ || $varselid/* ~ OXID 4.8.7 */) {
                    $aVariantSelections = $oProduct->getVariantSelections($varselid);

                    if($aVariantSelections && isset($aVariantSelections['oActiveVariant'])) {
                        $oProduct = $aVariantSelections['oActiveVariant'];
                        $sOXID = isset($oProduct->oxarticles__oxid->value) ? $oProduct->oxarticles__oxid->value : null;
                    }

                    //NOTE: include script to turn on tool before ajax refresh
                    $sOutput .= '
<script type="text/javascript">
    setTimeout(function() {
        if(typeof(MagicZoom) == "udefined") return;
        var mtOXID = "'.$sOXID.'";
        var mainEl = document.getElementById("MagicZoomImageProduct"+mtOXID);
        var magic360El = document.getElementById("productMagic360");
        if(magic360El) {
            Magic360.start(magic360El);
        }
        if(!mainEl) return;
        MagicZoom.start(mainEl);
        if(typeof(MagicScroll) !== "undefined") {
            var selectors = document.getElementById("MagicToolboxSelectors"+mtOXID);
            if(selectors) {
                if(selectors.className.match(new RegExp(\'(?:\\\\s|^)MagicScroll(?:\\\\s|$)\'))) {
                    MagicScroll.start(selectors);
                }
            }
        }
    }, 500);
    if(typeof(MagicZoom) !== "udefined") {
        magictoolboxBindProductForm("'.$sOXID.'");
        magic360Container = document.getElementById("magic360Container")
        mainImageContainer = document.getElementById("mainImageContainer");
        if(magic360Container) {
            magictoolboxBindSelectors("'.$sOXID.'");
        }
    }
</script>';
                } else if(method_exists($aViewData['oView'], 'getVariantSelections') && $aViewData['oView']->getVariantSelections()) {
                    //NOTE: always include headers if product has variants
                    $blProductHasVariants = true;
                }

                $iPicCount = $oMyConfig->getConfigParam('iPicCount');
                //$iZoomPicCount = $oMyConfig->getConfigParam('iZoomPicCount');
                //$iZoomPicCount = ($iPicCount > $iZoomPicCount) ? $iPicCount : $iZoomPicCount;
                if($blResize && !$blExternalImages) {
                    $aGallery = array();
                    for($iIndex = 1; $iIndex <= $iPicCount; $iIndex++) {
                        $sKey = 'oxarticles__oxpic'.$iIndex;
                        $sImagePath = $oProduct->$sKey->value;
                        if(!empty($sImagePath) && !preg_match('/(?:^|\/)nopic(?:_ico)?.jpg$/is', $sImagePath)) {
                            $sImagePath = basename($sImagePath);//NOTE: in case if it is not just name ("/name") (because of issue in OXID)
                            $sImagePath = $newImageHandling ? "master/product/{$iIndex}/{$sImagePath}" : "master/{$iIndex}/{$sImagePath}";
                            if(file_exists($sBaseImagePath.$sImagePath)) {
                                $aGallery[$iIndex] = $sImagePath;
                            }
                        }
                    }
                } else {
                    //NOTE: picture galery of current article
                    $aPictureGallery = $aViewData['oView']->getPictureGallery();
                    $aGallery = &$aPictureGallery['Pics'];
                }
                $iImagesCount = count($aGallery);
                if(!$iImagesCount) break;

                if($blExternalImages || !$blResize) {
                    $aDetailImageSizes = $oMyConfig->getConfigParam('aDetailImageSizes');
                    $aMainImageSize = explode('*', $aDetailImageSizes['oxpic1']);
                    //$sZoomImageSize = $oMyConfig->getConfigParam('sZoomImageSize');
                    $oTool->params->setValue('thumb-max-width', $aMainImageSize[0]);
                    $oTool->params->setValue('thumb-max-height', $aMainImageSize[1]);
                    $sIconSize = $oMyConfig->getConfigParam('sIconsize');
                    $aIconSize = explode('*', $sIconSize);
                    $oTool->params->setValue('selector-max-width', $aIconSize[0]);
                    $oTool->params->setValue('selector-max-height', $aIconSize[1]);
                }

                $sMainImageHTML = '';
                $aSelectorsHTML = array();

                $i = 1;

                foreach($aGallery as $iIndex => $sImagePath) {

                    if($blResize && !$blExternalImages) {
                        //NOTE: resize images with MagicToolboxImageHelperClass
                        $sImg = $sBaseShopUrl.$this->createMagicZoomThumb($sImagePath, 'original', $sOXID);
                        $sMedium = $sBaseShopUrl.$this->createMagicZoomThumb($sImagePath, 'thumb', $sOXID);
                        $sThumb = $sBaseShopUrl.$this->createMagicZoomThumb($sImagePath, 'selector', $sOXID);
                    } else {
                        if(isset($aPictureGallery['ZoomPics'][$i])) {
                            $sImg = $aPictureGallery['ZoomPics'][$i]['file'];
                        } else {
                            $sImg = $sImagePath;
                        }
                        $sMedium = $sImagePath;
                        $sThumb = $aPictureGallery['Icons'][$iIndex];
                    }

                    if(!$sMainImageHTML) {
                        $sMainImageHTML = $oTool->getMainTemplate(array(
                            'id' => 'Product'.$sOXID,
                            'img' => $sImg,
                            'thumb' => $sMedium,
                            'title' => $oProduct->oxarticles__oxtitle->value,
                            'shortDescription' => $oProduct->oxarticles__oxshortdesc->value,
                            'description' => $oProduct->oxarticles__oxlongdesc->value,
                        ));
                    }
                    $sSelectorHTML = $oTool->getSelectorTemplate(array(
                        'id' => 'Product'.$sOXID,
                        'group' => 'productPage',
                        'img' => $sImg,
                        'medium' => $sMedium,
                        'thumb' => $sThumb,
                        'title' => $oProduct->oxarticles__oxtitle->value,
                    ));
                    $aSelectorsHTML[] = $sSelectorHTML;

                    $i++;

                }

                if($this->blMixedMode) {
                    $o360Tool = $this->getMagic360Tool();
                    $oDb = oxDb::getDb();
                    $aRezult = $oDb->getAll("SELECT `GALLERY`, `COLUMNS` FROM `magic360_images` WHERE `OXID`='{$sOXID}'");
                    if(!empty($aRezult)) {
                        $a360Gallery = empty($aRezult[0][0]) ? array() : explode(';', $aRezult[0][0]);
                        if(count($a360Gallery)) {
                            //NOTE: 'default' profile is not suitable for product variants
                            $o360Tool->params->setProfile('product');
                            $o360Tool->params->setValue('columns', $aRezult[0][1]);
                            $a360Data = array();
                            foreach($a360Gallery as $iIndex => $sImagePath) {
                                $a360Data[] = array(
                                    'img' => $sBaseShopUrl.$this->createMagic360Thumb($sImagePath, 'original', $sOXID),
                                    'medium' => $sBaseShopUrl.$this->createMagic360Thumb($sImagePath, 'thumb', $sOXID)
                                );
                            }
                            $this->s360HTML = $o360Tool->getMainTemplate($a360Data, array("id" => "productMagic360"));
                            foreach($aSelectorsHTML as &$sSelectorHTML) {
                                if(preg_match('#(<a\b[^>]*?\bclass=")([^"]*+")#i', $sSelectorHTML, $aMatch)) {
                                    $sSelectorHTML = str_replace($aMatch[0], $aMatch[1].'zoom-with-360 '.$aMatch[2], $sSelectorHTML);
                                } else {
                                    $sSelectorHTML = str_replace('<a ', '<a class="zoom-with-360" ', $sSelectorHTML);
                                }
                            }
                            $s360IconPath = $o360Tool->params->getValue('icon', 'product');
                            if($s360IconPath && file_exists($sBaseImagePath.$s360IconPath)) {
                                $s360Selector = '<a class="m360-selector" title="360" href="#" onclick="return false;">'.
                                                    '<img src="'.$sBaseShopUrl.$this->createMagicZoomThumb($s360IconPath, 'selector', $sOXID).'" alt="360" />'.
                                                '</a>';
                                $s360Selector = preg_replace('#<a\b[^>]+?class="#i', '$0zoom-with-360 active-selector ', $s360Selector);
                                array_unshift($aSelectorsHTML, $s360Selector);
                                //NOTE: display selectors id product has one image
                                $iImagesCount++;
                            }
                            $sMainImageHTML = '<div id="mainImageContainer" style="position: absolute; left: -5000px; height: 100%;">'.
                                                $sMainImageHTML.
                                              '</div>'.
                                              '<div id="magic360Container">'.
                                                $this->s360HTML.
                                              '</div>';
                        }
                    }
                }

                if($iImagesCount > 1) {
                    $sPattern = '(<div\b[^>]*?\bclass\s*+=\s*+"[^"]*?\b(?:morepics|otherPictures)\b[^"]*+"[^>]*+>)'.
                                '('.
                                '(?:'.
                                    '[^<]++'.
                                    '|'.
                                    '<(?!/?div\b|!--)'.
                                    '|'.
                                    '<!--.*?-->'.
                                    '|'.
                                    '<div\b[^>]*+>'.
                                        '(?2)'.
                                    '</div\s*+>'.
                                ')*+'.
                                ')'.
                                '</div\s*+>';
                    if($oTool->params->checkValue('template', 'original')) {
                        //NOTE: replace original selectors
                        $aMatches = array();
                        if(preg_match('#'.$sPattern.'#is', $sOutput, $aMatches)) {
                            $sShadowLineMatch = array();
                            $sShadowLinePattern =   '<div\b[^>]*?\bclass\s*+=\s*+"[^"]*?\bshadowLine\b[^"]*+"[^>]*+>'.
                                                    '('.
                                                    '(?:'.
                                                        '[^<]++'.
                                                        '|'.
                                                        '<(?!/?div\b|!--)'.
                                                        '|'.
                                                        '<!--.*?-->'.
                                                        '|'.
                                                        '<div\b[^>]*+>'.
                                                            '(?1)'.
                                                        '</div\s*+>'.
                                                    ')*+'.
                                                    ')'.
                                                    '</div\s*+>';
                            if(preg_match('#'.$sShadowLinePattern.'#is', $sOutput, $sShadowLineMatch)) {
                                $sShadowLineMatch = $sShadowLineMatch[0];
                            } else {
                                $sShadowLineMatch = '';
                            }
                            $sOutput = str_replace($aMatches[0], $aMatches[1].$sShadowLineMatch.implode($aSelectorsHTML).'</div>', $sOutput);
                        }
                    } else {
                        //NOTE: cut original selectors
                        $sOutput = preg_replace('#'.$sPattern.'#is', '', $sOutput);
                    }
                }
                else {
                    //NOTE: not display selector id product has one image
                    $aSelectorsHTML = array();
                }

                if($oTool->params->checkValue('template', 'original')) {
                    $sReplace = $sMainImageHTML;
                    $sReplace = '<div class="MagicToolboxContainer minWidth">'.$sReplace.'</div>';
                } else {
                    $oScrollTool = $this->getMagicZoomTool(true);
                    $sReplace = MagicToolboxTemplateHelperClass::render(array(
                        'main' => $sMainImageHTML,
                        'thumbs' => $aSelectorsHTML,
                        'magicscrollOptions' => $oScrollTool ? $oScrollTool->params->serialize(false, '', 'product-magicscroll-options') : '',
                        'pid' => $sOXID,
                    ));
                }

                //NOTE: insert main template HTML
                $sPattern = '<img\b[^>]*?src="[^"]*?/'.preg_quote(basename(reset($aGallery))).'"[^>]*+>';
                $sPattern = '(?:<a\b[^>]*+>[^<]*+'.$sPattern.'[^<]*+</a>|'.$sPattern.')';
                $sContainerPattern = '(<div\b[^>]+?class="[^"]*?picture[^"]*+"[^>]*+>)[^<]*+'.$sPattern.'[^<]*+(</div>)';
                $aMatches = array();
                if(preg_match('#'.$sContainerPattern.'#is', $sOutput, $aMatches)) {
                    //NOTE: fix height for 'original' template too, because '.MagicToolboxMessage' text is displayed below the '.shadowLine' line
                    //if(!$oTool->params->checkValue('template', 'original')) {
                        //NOTE: set auto heigth for selectors to be visible
                        $aMatches[1] = preg_replace('#class="([^"]*+)"#is', 'class="$1 autoHeight"', $aMatches[1]);
                    //}
                    $sOutput = str_replace($aMatches[0], $aMatches[1].$sReplace.$aMatches[2], $sOutput);
                } else {
                    $sOutput = preg_replace('#'.$sPattern.'#is', $sReplace, $sOutput, 1);
                }

                //NOTE: remove some extra elements
                //NOTE: zoom link
                $sOutput = preg_replace('#<a\b[^>]*?id="(?:zoomTrigger|test_zoom)"[^>]*+>.*?</a>#is', '', $sOutput);
                //NOTE: modal zoom
                $zoomModalPattern = '<div\b[^>]*?\bid\s*+=\s*+"(?:zoomModal|zoom)"[^>]*+>'.
                                    '('.
                                    '(?:'.
                                        '[^<]++'.
                                        '|'.
                                        '<(?!/?div\b|!--)'.
                                        '|'.
                                        '<!--.*?-->'.
                                        '|'.
                                        '<div\b[^>]*+>'.
                                            '(?1)'.
                                        '</div\s*+>'.
                                    ')*+'.
                                    ')'.
                                    '</div\s*+>';
                $sOutput = preg_replace('#'.$zoomModalPattern.'#is', '', $sOutput);

                //NOTE: include headers
                $blOutputHeaders = true;

                $this->aProcessedBlocks[$sPage] = 'magiczoom';

            break;
            case 'category':

                $aArticleList = $aViewData['oView']->getArticleList();
                if(!$aArticleList) break;

                if($blExternalImages || !$blResize) {
                    $sThumbnailSize = $oMyConfig->getConfigParam('sThumbnailsize');
                    $aThumbnailSize = explode('*', $sThumbnailSize);
                    $oTool->params->setValue('thumb-max-width', $aThumbnailSize[0]);
                    $oTool->params->setValue('thumb-max-height', $aThumbnailSize[1]);
                }

                $blUseLink = $oTool->params->checkValue('link-to-product-page', 'Yes');

                $oDb = oxDb::getDb();

                foreach($aArticleList as $oArticle) {

                    //NOTICE: sometimes oxarticles__oxid contains strange value like this "be642cad637adf214.28850610"
                    //$sArticleId = $oArticle->oxarticles__oxartnum->value;
                    $sArticleId = $oArticle->oxarticles__oxid->value;

                    $sImagePath = $oArticle->oxarticles__oxthumb->value;
                    $sImageDir = 'thumb';
                    if(empty($sImagePath)) {
                        $sImagePath = $oArticle->oxarticles__oxpic1->value;
                        $sImageDir = '1';
                        if(empty($sImagePath)) {
                            $sImagePath = $oDb->getOne("SELECT OXPIC1 FROM oxarticles WHERE `OXID`='{$sArticleId}'");
                        }
                    }
                    if(empty($sImagePath) || preg_match('/(?:^|\/)nopic(?:_ico)?.jpg$/is', $sImagePath)) {
                        continue;
                    }
                    $sImagePath = basename($sImagePath);
                    $sImagePath = $newImageHandling ? "master/product/{$sImageDir}/{$sImagePath}" : "0/{$sImagePath}";
                    if(!$blExternalImages && !file_exists($sBaseImagePath.$sImagePath)) {
                        continue;
                    }

                    if($blExternalImages || !$blResize) {
                        //NOTE: to get first picture URL $oArticle->getPictureUrl(1)
                        $sImg = $sBaseImageUrl.$sImagePath;
                        $sMedium = $oArticle->getThumbnailUrl();
                    } else {
                        $sImg = $sBaseShopUrl.$this->createMagicZoomThumb($sImagePath, 'original', $sArticleId);
                        $sMedium = $sBaseShopUrl.$this->createMagicZoomThumb($sImagePath, 'thumb', $sArticleId);
                    }

                    if(isset($oArticle->oxarticles__oxshortdesc->value)) {
                        $sShortDescr = $oArticle->oxarticles__oxshortdesc->value;
                    }/* else {
                        $sShortDescr = $oDb->getOne("SELECT OXSHORTDESC FROM oxarticles WHERE `OXID`='{$sArticleId}'");
                    }*/
                    $sDescr = $oDb->getOne("SELECT OXLONGDESC FROM oxartextends WHERE `OXID`='{$sArticleId}'");

                    $sHTML = $oTool->getMainTemplate(array(
                        'id' => 'Category'.$sArticleId,
                        'img' => $sImg,
                        'thumb' => $sMedium,
                        'title' => $oArticle->oxarticles__oxtitle->value,
                        'link' => $blUseLink ? $oArticle->_aSeoUrls[0][0] : '',
                    ));

                    //NOTE: insert images into HTML

                    $sImagePattern = '<img\b[^>]*?src="[^"]*?/'.preg_quote(basename($sImagePath)).'[^"]*+"[^>]*+>';


                    //Basic theme

                    //4.5.x
                    //out/basic/tpl/inc/product.tpl
                    //a.picture > img

                    //Azure theme

                    //Double grid view
                    //4.5.x
                    //out/azure/tpl/widget/product/listitem_infogrid.tpl
                    //a.gridPicture > img
                    //4.9.3
                    //application/views/azure/tpl/widget/product/listitem_infogrid.tpl
                    //div.pictureBox.gridPicture > img

                    //NOTE: Grid view
                    //4.5.0
                    //out/azure/tpl/widget/product/listitem_grid.tpl
                    //a.titleBlock.title > div.gridPicture > img
                    //4.9.3
                    //application/views/azure/tpl/widget/product/listitem_grid.tpl
                    //a.titleBlock.title > div.gridPicture > img

                    //NOTE: Line view
                    //4.5.0
                    //out/azure/tpl/widget/product/listitem_line.tpl
                    //div.pictureBox > a.title > img
                    //4.9.3
                    //application/views/azure/tpl/widget/product/listitem_line.tpl
                    //div.pictureBox > img

                    $sPattern = '<(div|a)\b[^>]*?\bclass\s*+=\s*+"([^"]*?\b(?:gridPicture|pictureBox|picture)\b[^"]*+)"[^>]*+>'.
                                '('.
                                '(?:'.
                                    '[^<]++'.
                                    '|'.
                                    '<(?!/?\1\b|!--)'.
                                    '|'.
                                    '<!--.*?-->'.
                                    '|'.
                                    '<\1\b[^>]*+>'.
                                        '(?3)'.
                                    '</\1\s*+>'.
                                ')*?'.
                                ')'.
                                '(<a\b[^>]*+>[^<]*+)?'.
                                    $sImagePattern.'[^<]*+'.
                                '(?(4)</a>[^<]*+)'.
                                '</\1\s*+>'.
                                '([^<]*+</a>)?';//closed A tag in Grid view
                    //$aMatches = array();
                    //preg_match_all('#'.$sPattern.'#is', $sOutput, $aMatches, PREG_SET_ORDER);
                    //debug_log($aMatches);
                    //continue;

                    $sHTML = '$5<div class="MagicToolboxContainer $2">'.$sHTML.'</div>';
                    $sOutput = preg_replace('#'.$sPattern.'#is', $sHTML, $sOutput, 1, $iReplaced);


                }

                //NOTE: include headers
                $blOutputHeaders = true;

                $this->aProcessedBlocks[$sPage] = 'magiczoom';

            break;

        }

        //NOTE: if this is a variant of product, we need to display headers for parent product or another variant of product
        if(!$blOutputHeaders && !$blProductHasVariants && !$blProductHasParent) return $sOutput;

        $oTool->params->resetProfile();

        $aHeaders = array();
        $aHeaders[] = $oTool->getHeadersTemplate($sBaseShopUrl.'modules/magiczoom/resources');
        if($sPage == 'product') {
            if($this->blMixedMode && $iImagesCount) {
                $o360Tool->params->resetProfile();
                array_unshift($aHeaders, $o360Tool->getHeadersTemplate($sBaseShopUrl.'modules/magic360/resources'));
            }
            if($oTool->params->checkValue('magicscroll', 'Yes', 'product')) {
                $oScrollTool = $this->getMagicZoomTool(true);
                $oScrollTool->params->resetProfile();
                $aHeaders[] = $oScrollTool->getHeadersTemplate($sBaseShopUrl.'modules/magiczoom/resources', null, false);
            }
            if($this->blMixedMode) {
                $mouseEvent = $oTool->params->getValue('selectorTrigger', 'product');
                if($mouseEvent == 'hover') $mouseEvent = 'mouseover';
                $aHeaders[] = '
<script type="text/javascript">
    var mtSwitchEvent = "'.$mouseEvent.'";
    var mtToolMainId = "MagicZoomImageProduct'.$sOXID.'";
    var mtSelectorsContainer = null;
    var mtSwitchFunction = function(e) {
        //NOTE: in order to magiczoom(plus) was not switching selector
        e.stopQueue();
        var objThis = e.target || e.srcElement;
        if(objThis.tagName.toLowerCase() == "img") {
            objThis = objThis.parentNode;
        }
        var isMagic360Visible = magic360Container.style.display != "none";
        var isThisMagic360Selector = objThis.className.match(new RegExp("(?:\\\\\\s|^)m360-selector(?:\\\\\\s|$)"));
        if(isThisMagic360Selector && !isMagic360Visible) {
            mainImageContainer.style.display = "none";
            magic360Container.style.display = "block";
        } else if(isMagic360Visible && !isThisMagic360Selector) {
            //NOTE: only on page load (first time)
            if(mainImageContainer.style.position == "absolute") {
                mainImageContainer.style.position = "static";
                mainImageContainer.style.left = 0;
            }
            magic360Container.style.display = "none";
            mainImageContainer.style.display = "block";
            //NOTE: hide image to skip magiczoom(plus) switching effect
            if(!$mjs(objThis).jHasClass(\'mz-thumb-selected\')) {
                document.querySelector(\'#\'+mtToolMainId+\' .mz-figure > img\').style.visibility = \'hidden\';
            }
        }
        //NOTE: switch image
        MagicZoom.switchTo(mtToolMainId, objThis);
        //NOTE: to highlight magic360 selector when switching thumbnails
        var selectors = $mjs(mtSelectorsContainer).byTag("a");
        for(var k = 0; k < selectors.length; k++) {
            $mjs(selectors[k]).jRemoveClass(\'active-selector\');
        }
        $mjs(objThis).jAddClass(\'active-selector\');
        return false;
    };

    function magictoolboxBindSelectors(id) {
        if(!magic360Container) return;
        mtSelectorsContainer = document.getElementById("morePicsContainer");
        if(!mtSelectorsContainer) {
            mtSelectorsContainer = document.getElementById("MagicToolboxSelectors"+id);
            if(!mtSelectorsContainer) {
                mtSelectorsContainer = $mjs(document).byClass("otherPictures");
                if(mtSelectorsContainer.length) {
                    mtSelectorsContainer = mtSelectorsContainer[0];
                } else {
                    mtSelectorsContainer = $mjs(document).byClass("morepics");
                    if(mtSelectorsContainer.length) {
                        mtSelectorsContainer = mtSelectorsContainer[0];
                    } else {
                        return;
                    }
                }
            }
        }
        mjsAddEventMethod = \'je1\';
        if(typeof(magicJS.Doc.je1) == \'undefined\') mjsAddEventMethod = \'jAddEvent\';
        mtSwitchEvent = (mtSwitchEvent == \'click\' ? \'btnclick\' : mtSwitchEvent);
        mtToolMainId = "MagicZoomImageProduct"+id;
        var selectors = $mjs(mtSelectorsContainer).byTag("a");
        for(var j = 0; j < selectors.length; j++) {
            $mjs(selectors[j])[mjsAddEventMethod](mtSwitchEvent+\' tap\', mtSwitchFunction, 1);
        }
    }

    mjsAddEventMethod = \'je1\';
    if(typeof(magicJS.Doc.je1) == \'undefined\') mjsAddEventMethod = \'jAddEvent\';
    $mjs(window)[mjsAddEventMethod]("load", function() {
        magic360Container = document.getElementById("magic360Container")
        mainImageContainer = document.getElementById("mainImageContainer");
        magictoolboxBindSelectors("'.$sOXID.'");
    });
</script>
';
            }
        }

        if($sPage == 'product') {
            //NOTE: include script to turn off tool before ajax refresh
            $aHeaders[] = '
<script type="text/javascript">
    function magictoolboxBindProductForm(id) {
        if(typeof($) == "undefined") return;
        $(".oxProductForm, .js-oxProductForm, .js-oxWidgetReload").submit(function() {
            if(typeof(MagicScroll) !== "undefined") {
                var selectors = document.getElementById("MagicToolboxSelectors"+id);
                if(selectors) {
                    MagicScroll.stop(selectors);
                }
            }
            var mainEl = document.getElementById("MagicZoomImageProduct"+id);
            if(!mainEl) return;
            MagicZoom.stop(mainEl);
        });
    }

    mjsAddEventMethod = \'je1\';
    if(typeof(magicJS.Doc.je1) == \'undefined\') mjsAddEventMethod = \'jAddEvent\';
    $mjs(window)[mjsAddEventMethod]("load", function() {
        if(typeof(MagicZoom) == "udefined") return;
        magictoolboxBindProductForm("'.$sOXID.'");
    });
</script>
';
        }

        $sOutput = preg_replace('#</head>#is', implode($aHeaders).'</head>', $sOutput, 1);

        return $sOutput;
    }

    public function processViewArray($aViewData, $sClassName) {
        if(isset($this->aMagicZoomClassNamesMapping[$sClassName]) && $this->aSavedViewData === null) {
            $this->aSavedViewData = $aViewData;
        }
        return parent::processViewArray($aViewData, $sClassName);
    }

    public function &getMagicZoomTool($blGetScrollTool = false) {
        static $oTool = null;
        static $oScrollTool = null;
        if($oTool === null) {
            require_once(dirname(__FILE__).'/classes/magiczoom.module.core.class.php');
            $oTool = new MagicZoomModuleCoreClass();
            $oDb = oxDb::getDb();
            $aRezult = $oDb->getAll("SELECT `BLOCK`, `NAME`, `VALUE` FROM `magiczoom_config` WHERE `ENABLED`=1");

            //NOTE: create settings if it does not exists
            if(!$aRezult) {
                if(!class_exists('MagicZoomEvents')) {
                    include getShopBasePath().'modules/magiczoom/magiczoomevents.php';
                }
                MagicZoomEvents::onActivate();
                $aRezult = $oDb->getAll("SELECT `BLOCK`, `NAME`, `VALUE` FROM `magiczoom_config` WHERE `ENABLED`=1");
            }

            foreach($aRezult as $aRow) {
                $oTool->params->setValue($aRow[1], $aRow[2], $aRow[0]);
            }

            if($oTool->params->checkValue('magicscroll', 'Yes', 'product')) {
                require_once(dirname(__FILE__).'/classes/magicscroll.module.core.class.php');
                $oScrollTool = new MagicScrollModuleCoreClass(false);
                //NOTE: load params in a separate profile, in order not to overwrite the options of MagicScroll module
                //$oScrollTool->params->appendParams($oTool->params->getParams('product'), 'product-magicscroll-options');
                $oScrollTool->params->resetProfile();//NOTE: need to reset to get all options with 'getParams' method
                foreach($oScrollTool->params->getParams() as $sId => $aParam) {
                    $sValue = $oTool->params->getValue($sId, 'product');
                    if($sValue !== null) {
                        $oScrollTool->params->setValue($sId, $sValue, 'product-magicscroll-options');
                    }
                }
                $oScrollTool->params->setValue('orientation', ($oTool->params->checkValue('template', array('left', 'right'), 'product') ? 'vertical' : 'horizontal'), 'product-magicscroll-options');
                //NOTE: if Magic Scroll module installed we need to load settings before displaying custom options
                if(method_exists($this, 'getMagicScrollTool')) {
                    $this->getMagicScrollTool();
                }
            }
            require_once(dirname(__FILE__).'/classes/magictoolbox.templatehelper.class.php');
            MagicToolboxTemplateHelperClass::setPath(dirname(__FILE__).DIRECTORY_SEPARATOR.'templates');
            MagicToolboxTemplateHelperClass::setOptions($oTool->params);
        }
        return $blGetScrollTool ? $oScrollTool : $oTool;
    }

    public function getMagicZoomBlocks() {
        return array(
			'default' => 'General',
			'product' => 'Product page',
			'category' => 'Category page',
		);
    }

    public function createMagicZoomThumb($sSrc, $sType, $sProductId = null) {
        static $oImageHelper = null;
        if($oImageHelper === null) {
            $oMyConfig = $this->getConfig();
            //$sCacheDirRel = str_replace(getShopBasePath(), '/', $myConfig->getConfigParam('sCompileDir')).'magictoolbox_cache';
            $sCacheDirRel = '/'.$oMyConfig->getOutDir(false).$oMyConfig->getConfigParam('_sPictureDir').'/magictoolbox_cache';

            //NOTE: we can't reproduce this issue, but it appear on most customers sites. So this is a fix
            //NOTE: maybe we don't need it any more
            //$sPref = substr($sCacheDirRel, 0, 5);
            //if($sPref == '/home') {
            //    $sCacheDirRel = substr($sCacheDirRel, 5);
            //} else {
            //    $sPref = '';
            //}

            $oTool = $this->getMagicZoomTool();
            require_once(dirname(__FILE__).'/classes/magictoolbox.imagehelper.class.php');
            $oImageHelper = new MagicToolboxImageHelperClass(/*$sPref.*/getShopBasePath(), $sCacheDirRel, $oTool->params);
        }
        return preg_replace('/^\//is', '', $oImageHelper->create('/out/pictures/'.$sSrc, $sType, $sProductId));
    }

}

?>
