<?php

class MagicZoomEvents {

    public static function onActivate() {

        $oDb = oxDb::getDb();

        $table = $oDb->getOne("SHOW TABLES LIKE 'magiczoom_config'");
        if($table) {
            $version = $oDb->getOne("SELECT `VALUE` FROM `magiczoom_config` WHERE `BLOCK`='default' AND `NAME`='version'");
            $upgradeVersion = '4.3';
            if(version_compare($version, $upgradeVersion, '<') || $version == 'working') {
                $oDb->execute("DROP TABLE IF EXISTS `magiczoom_config_backup`");
                $oDb->execute("RENAME TABLE `magiczoom_config` TO `magiczoom_config_backup`");
            } else {
                return;
            }
        }

        //DROP TABLE IF EXISTS `magiczoom_config`;
        $sSQL = <<<SQL
CREATE TABLE IF NOT EXISTS `magiczoom_config` (
 `ID` int(11) NOT NULL AUTO_INCREMENT,
 `BLOCK` char(32) NOT NULL,
 `NAME` char(32) NOT NULL,
 `VALUE` text,
 `ENABLED` tinyint(1) UNSIGNED NOT NULL default '0',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
SQL;
        $oDb->execute($sSQL);

        $sSQL = <<<SQL
INSERT INTO `magiczoom_config` (`BLOCK`, `NAME`, `VALUE`, `ENABLED`) VALUES
 ('default', 'thumb-max-width', '450', 1),
 ('default', 'thumb-max-height', '450', 1),
 ('default', 'zoomWidth', 'auto', 1),
 ('default', 'zoomHeight', 'auto', 1),
 ('default', 'zoomPosition', 'right', 1),
 ('default', 'zoomDistance', '15', 1),
 ('default', 'square-images', 'disable', 1),
 ('default', 'lazyZoom', 'No', 1),
 ('default', 'rightClick', 'No', 1),
 ('default', 'cssClass', '', 1),
 ('default', 'link-to-product-page', 'Yes', 1),
 ('default', 'show-message', 'No', 1),
 ('default', 'message', 'Move your mouse over image', 1),
 ('default', 'resize-images', 'Yes', 1),
 ('default', 'imagemagick', 'off', 1),
 ('default', 'image-quality', '75', 1),
 ('default', 'zoomMode', 'zoom', 1),
 ('default', 'zoomOn', 'hover', 1),
 ('default', 'upscale', 'Yes', 1),
 ('default', 'smoothing', 'Yes', 1),
 ('default', 'variableZoom', 'No', 1),
 ('default', 'zoomCaption', 'off', 1),
 ('default', 'watermark', '', 1),
 ('default', 'watermark-max-width', '30%', 1),
 ('default', 'watermark-max-height', '30%', 1),
 ('default', 'watermark-opacity', '50', 1),
 ('default', 'watermark-position', 'center', 1),
 ('default', 'watermark-offset-x', '0', 1),
 ('default', 'watermark-offset-y', '0', 1),
 ('default', 'hint', 'once', 1),
 ('default', 'textHoverZoomHint', 'Hover to zoom', 1),
 ('default', 'textClickZoomHint', 'Click to zoom', 1),
 ('default', 'zoomModeForMobile', 'off', 1),
 ('default', 'textHoverZoomHintForMobile', 'Touch to zoom', 1),
 ('default', 'textClickZoomHintForMobile', 'Double tap or pinch to zoom', 1),
 ('product', 'enable-effect', 'Yes', 1),
 ('product', 'template', 'original', 0),
 ('product', 'magicscroll', 'No', 0),
 ('product', 'thumb-max-width', '250', 1),
 ('product', 'thumb-max-height', '200', 1),
 ('product', 'zoomWidth', 'auto', 0),
 ('product', 'zoomHeight', 'auto', 0),
 ('product', 'zoomPosition', 'right', 0),
 ('product', 'zoomDistance', '15', 0),
 ('product', 'selectorTrigger', 'click', 0),
 ('product', 'selector-max-width', '50', 0),
 ('product', 'selector-max-height', '50', 0),
 ('product', 'transitionEffect', 'Yes', 0),
 ('product', 'lazyZoom', 'No', 0),
 ('product', 'rightClick', 'No', 0),
 ('product', 'cssClass', '', 0),
 ('product', 'show-message', 'No', 0),
 ('product', 'message', 'Move your mouse over image', 0),
 ('product', 'zoomMode', 'zoom', 0),
 ('product', 'zoomOn', 'hover', 0),
 ('product', 'upscale', 'Yes', 0),
 ('product', 'smoothing', 'Yes', 0),
 ('product', 'variableZoom', 'No', 0),
 ('product', 'zoomCaption', 'off', 0),
 ('product', 'hint', 'once', 0),
 ('product', 'textHoverZoomHint', 'Hover to zoom', 0),
 ('product', 'textClickZoomHint', 'Click to zoom', 0),
 ('product', 'zoomModeForMobile', 'off', 0),
 ('product', 'textHoverZoomHintForMobile', 'Touch to zoom', 0),
 ('product', 'textClickZoomHintForMobile', 'Double tap or pinch to zoom', 0),
 ('product', 'width', 'auto', 0),
 ('product', 'height', 'auto', 0),
 ('product', 'mode', 'scroll', 0),
 ('product', 'items', '3', 0),
 ('product', 'speed', '600', 0),
 ('product', 'autoplay', '0', 0),
 ('product', 'loop', 'infinite', 0),
 ('product', 'step', 'auto', 0),
 ('product', 'arrows', 'inside', 0),
 ('product', 'pagination', 'No', 0),
 ('product', 'easing', 'cubic-bezier(.8, 0, .5, 1)', 0),
 ('product', 'scrollOnWheel', 'auto', 0),
 ('product', 'lazy-load', 'No', 0),
 ('product', 'scroll-extra-styles', '', 0),
 ('product', 'show-image-title', 'No', 0),
 ('category', 'enable-effect', 'No', 1),
 ('category', 'thumb-max-width', '150', 1),
 ('category', 'thumb-max-height', '150', 1),
 ('category', 'zoomWidth', 'auto', 0),
 ('category', 'zoomHeight', 'auto', 0),
 ('category', 'zoomPosition', 'right', 0),
 ('category', 'zoomDistance', '15', 0),
 ('category', 'lazyZoom', 'No', 0),
 ('category', 'rightClick', 'No', 0),
 ('category', 'cssClass', '', 0),
 ('category', 'link-to-product-page', 'Yes', 0),
 ('category', 'show-message', 'No', 1),
 ('category', 'message', 'Move your mouse over image', 0),
 ('category', 'zoomMode', 'zoom', 0),
 ('category', 'zoomOn', 'hover', 0),
 ('category', 'upscale', 'Yes', 0),
 ('category', 'smoothing', 'Yes', 0),
 ('category', 'variableZoom', 'No', 0),
 ('category', 'zoomCaption', 'off', 0),
 ('category', 'hint', 'once', 0),
 ('category', 'textHoverZoomHint', 'Hover to zoom', 0),
 ('category', 'textClickZoomHint', 'Click to zoom', 0),
 ('category', 'zoomModeForMobile', 'off', 0),
 ('category', 'textHoverZoomHintForMobile', 'Touch to zoom', 0),
 ('category', 'textClickZoomHintForMobile', 'Double tap or pinch to zoom', 0),
 ('default', 'version', '4.3.18', 1);
SQL;
        $oDb->execute($sSQL);

        if(class_exists('oxRegistry')) {
            $oMyConfig = oxRegistry::getConfig();
        } else {
            //NOTE: for OXID versions < 4.7.0
            $oMyConfig = oxConfig::getInstance();
        }

        //$sOxidVersion = $oMyConfig->getVersion();
        $sTheme = $oMyConfig->getConfigParam('sTheme');
        if($sTheme != 'azure') return;
        $oDb->execute("UPDATE `magiczoom_config` SET `VALUE`='380' WHERE `BLOCK`='product' AND `NAME`='thumb-max-width'");
        $oDb->execute("UPDATE `magiczoom_config` SET `VALUE`='340' WHERE `BLOCK`='product' AND `NAME`='thumb-max-height'");
        $oDb->execute("UPDATE `magiczoom_config` SET `VALUE`='80' WHERE `BLOCK`='product' AND `NAME`='selector-max-width'");
        $oDb->execute("UPDATE `magiczoom_config` SET `VALUE`='80' WHERE `BLOCK`='product' AND `NAME`='selector-max-height'");
        $oDb->execute("UPDATE `magiczoom_config` SET `VALUE`='150' WHERE `BLOCK`='category' AND `NAME`='thumb-max-width'");
        $oDb->execute("UPDATE `magiczoom_config` SET `VALUE`='150' WHERE `BLOCK`='category' AND `NAME`='thumb-max-height'");

    }

    public static function onDeactivate() {

    }

}

?>