<?php

/**
 * Metadata version
 */
$sMetadataVersion = '1.1';

/**
 * Module information
 */
$aModule = array(
    'id'           => 'magicthumb',
    'title'        => 'Magic Thumb',
    'description'  => "Enlarge your small images to full screen upon click with this popular tool.",
    //'thumbnail'    => 'magicthumb.png',
    'version'      => '4.3.18',
    'author'       => 'Magic Toolbox',
    'email'        => 'support@magictoolbox.com',
    'url'          => 'http://www.magictoolbox.com',
    'extend'       => array(
        'oxoutput' => 'magicthumb/magicthumboutput',
    ),
    'files' => array(
        'magicthumbevents' => 'magicthumb/magicthumbevents.php',
        'magicthumb' => '../admin/magicthumb.php',
    ),
    'events'       => array(
        'onActivate'   => 'magicthumbevents::onActivate',
        'onDeactivate' => 'magicthumbevents::onDeactivate',
    ),

);

if(class_exists('oxRegistry')) {
    $myConfig = oxRegistry::getConfig();
} else {
    //NOTE: for OXID versions < 4.7.0
    $myConfig = oxConfig::getInstance();
}
$aDisabledModules = $myConfig->getConfigParam('aDisabledModules');
if(!is_array($aDisabledModules)) $aDisabledModules = array();
if(in_array('magicthumb', $myConfig->getConfigParam('aDisabledModules'))) {
    $aModule['description'] .= "<br /><br /><span style=\"color: red;\">Please activate the module and refresh the page (if need it) to access the settings.</span>";
} else {
    $aModule['description'] .= "<br /><br /><span style=\"color: green;\">Change the settings as you wish via the <b>Master Settings</b> -> <b>Magic Thumb Settings</b> menu.</span>";
}
