<?php

class MagicThumbEvents {

    public static function onActivate() {

        $oDb = oxDb::getDb();

        $table = $oDb->getOne("SHOW TABLES LIKE 'magicthumb_config'");
        if($table) {
            $version = $oDb->getOne("SELECT `VALUE` FROM `magicthumb_config` WHERE `BLOCK`='default' AND `NAME`='version'");
            $upgradeVersion = '4.3';
            if(version_compare($version, $upgradeVersion, '<') || $version == 'working') {
                $oDb->execute("DROP TABLE IF EXISTS `magicthumb_config_backup`");
                $oDb->execute("RENAME TABLE `magicthumb_config` TO `magicthumb_config_backup`");
            } else {
                return;
            }
        }

        //DROP TABLE IF EXISTS `magicthumb_config`;
        $sSQL = <<<SQL
CREATE TABLE IF NOT EXISTS `magicthumb_config` (
 `ID` int(11) NOT NULL AUTO_INCREMENT,
 `BLOCK` char(32) NOT NULL,
 `NAME` char(32) NOT NULL,
 `VALUE` text,
 `ENABLED` tinyint(1) UNSIGNED NOT NULL default '0',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
SQL;
        $oDb->execute($sSQL);

        $sSQL = <<<SQL
INSERT INTO `magicthumb_config` (`BLOCK`, `NAME`, `VALUE`, `ENABLED`) VALUES
 ('default', 'thumb-max-width', '450', 1),
 ('default', 'thumb-max-height', '450', 1),
 ('default', 'square-images', 'disable', 1),
 ('default', 'expandEffect', 'expand', 1),
 ('default', 'expandSpeed', '350', 1),
 ('default', 'expandImageSize', 'fit-screen', 1),
 ('default', 'expandTrigger', 'click', 1),
 ('default', 'expandAlign', 'screen', 1),
 ('default', 'expandEasing', 'ease-in-out', 1),
 ('default', 'gallerySpeed', '250', 1),
 ('default', 'show-caption', 'Yes', 1),
 ('default', 'captionPosition', 'bottom', 1),
 ('default', 'link-to-product-page', 'Yes', 1),
 ('default', 'keyboard', 'Yes', 1),
 ('default', 'cssClass', '', 1),
 ('default', 'rightClick', 'Yes', 1),
 ('default', 'lazyLoad', 'No', 1),
 ('default', 'autostart', 'Yes', 1),
 ('default', 'resize-images', 'Yes', 1),
 ('default', 'imagemagick', 'off', 1),
 ('default', 'image-quality', '75', 1),
 ('default', 'buttons', 'auto', 1),
 ('default', 'textBtnClose', 'Close', 1),
 ('default', 'textBtnNext', 'Next', 1),
 ('default', 'textBtnPrev', 'Previous', 1),
 ('default', 'watermark', '', 1),
 ('default', 'watermark-max-width', '30%', 1),
 ('default', 'watermark-max-height', '30%', 1),
 ('default', 'watermark-opacity', '50', 1),
 ('default', 'watermark-position', 'center', 1),
 ('default', 'watermark-offset-x', '0', 1),
 ('default', 'watermark-offset-y', '0', 1),
 ('default', 'hint', 'once', 1),
 ('default', 'textClickHint', 'Click to expand', 1),
 ('default', 'textHoverHint', 'Hover to expand', 1),
 ('default', 'slideMobileEffect', 'rotate', 1),
 ('default', 'textClickHintForMobile', 'Tap to expand', 1),
 ('product', 'enable-effect', 'Yes', 1),
 ('product', 'template', 'original', 0),
 ('product', 'magicscroll', 'No', 0),
 ('product', 'thumb-max-width', '250', 1),
 ('product', 'thumb-max-height', '200', 1),
 ('product', 'expandEffect', 'expand', 0),
 ('product', 'expandSpeed', '350', 0),
 ('product', 'expandImageSize', 'fit-screen', 0),
 ('product', 'expandTrigger', 'click', 0),
 ('product', 'expandAlign', 'screen', 0),
 ('product', 'expandEasing', 'ease-in-out', 0),
 ('product', 'gallerySpeed', '250', 0),
 ('product', 'selector-max-width', '50', 0),
 ('product', 'selector-max-height', '50', 0),
 ('product', 'selectorTrigger', 'click', 0),
 ('product', 'selectorEffect', 'switch', 0),
 ('product', 'show-caption', 'Yes', 0),
 ('product', 'captionPosition', 'bottom', 0),
 ('product', 'keyboard', 'Yes', 0),
 ('product', 'cssClass', '', 0),
 ('product', 'rightClick', 'Yes', 0),
 ('product', 'lazyLoad', 'No', 0),
 ('product', 'autostart', 'Yes', 0),
 ('product', 'buttons', 'auto', 0),
 ('product', 'textBtnClose', 'Close', 0),
 ('product', 'textBtnNext', 'Next', 0),
 ('product', 'textBtnPrev', 'Previous', 0),
 ('product', 'hint', 'once', 0),
 ('product', 'textClickHint', 'Click to expand', 0),
 ('product', 'textHoverHint', 'Hover to expand', 0),
 ('product', 'slideMobileEffect', 'rotate', 0),
 ('product', 'textClickHintForMobile', 'Tap to expand', 0),
 ('product', 'width', 'auto', 0),
 ('product', 'height', 'auto', 0),
 ('product', 'mode', 'scroll', 0),
 ('product', 'items', '3', 0),
 ('product', 'speed', '600', 0),
 ('product', 'autoplay', '0', 0),
 ('product', 'loop', 'infinite', 0),
 ('product', 'step', 'auto', 0),
 ('product', 'arrows', 'inside', 0),
 ('product', 'pagination', 'No', 0),
 ('product', 'easing', 'cubic-bezier(.8, 0, .5, 1)', 0),
 ('product', 'scrollOnWheel', 'auto', 0),
 ('product', 'lazy-load', 'No', 0),
 ('product', 'scroll-extra-styles', '', 0),
 ('product', 'show-image-title', 'No', 0),
 ('category', 'enable-effect', 'No', 1),
 ('category', 'thumb-max-width', '150', 1),
 ('category', 'thumb-max-height', '150', 1),
 ('category', 'expandEffect', 'expand', 0),
 ('category', 'expandSpeed', '350', 0),
 ('category', 'expandImageSize', 'fit-screen', 0),
 ('category', 'expandTrigger', 'click', 0),
 ('category', 'expandAlign', 'screen', 0),
 ('category', 'expandEasing', 'ease-in-out', 0),
 ('category', 'gallerySpeed', '250', 0),
 ('category', 'show-caption', 'Yes', 0),
 ('category', 'captionPosition', 'bottom', 0),
 ('category', 'link-to-product-page', 'Yes', 0),
 ('category', 'keyboard', 'Yes', 0),
 ('category', 'cssClass', '', 0),
 ('category', 'rightClick', 'Yes', 0),
 ('category', 'lazyLoad', 'No', 0),
 ('category', 'autostart', 'Yes', 0),
 ('category', 'buttons', 'auto', 0),
 ('category', 'textBtnClose', 'Close', 0),
 ('category', 'textBtnNext', 'Next', 0),
 ('category', 'textBtnPrev', 'Previous', 0),
 ('category', 'hint', 'once', 0),
 ('category', 'textClickHint', 'Click to expand', 0),
 ('category', 'textHoverHint', 'Hover to expand', 0),
 ('category', 'slideMobileEffect', 'rotate', 0),
 ('category', 'textClickHintForMobile', 'Tap to expand', 0),
 ('default', 'version', '4.3.18', 1);
SQL;
        $oDb->execute($sSQL);

        if(class_exists('oxRegistry')) {
            $oMyConfig = oxRegistry::getConfig();
        } else {
            //NOTE: for OXID versions < 4.7.0
            $oMyConfig = oxConfig::getInstance();
        }

        //$sOxidVersion = $oMyConfig->getVersion();
        $sTheme = $oMyConfig->getConfigParam('sTheme');
        if($sTheme != 'azure') return;
        $oDb->execute("UPDATE `magicthumb_config` SET `VALUE`='380' WHERE `BLOCK`='product' AND `NAME`='thumb-max-width'");
        $oDb->execute("UPDATE `magicthumb_config` SET `VALUE`='340' WHERE `BLOCK`='product' AND `NAME`='thumb-max-height'");
        $oDb->execute("UPDATE `magicthumb_config` SET `VALUE`='80' WHERE `BLOCK`='product' AND `NAME`='selector-max-width'");
        $oDb->execute("UPDATE `magicthumb_config` SET `VALUE`='80' WHERE `BLOCK`='product' AND `NAME`='selector-max-height'");
        $oDb->execute("UPDATE `magicthumb_config` SET `VALUE`='150' WHERE `BLOCK`='category' AND `NAME`='thumb-max-width'");
        $oDb->execute("UPDATE `magicthumb_config` SET `VALUE`='150' WHERE `BLOCK`='category' AND `NAME`='thumb-max-height'");

    }

    public static function onDeactivate() {

    }

}

?>