<?php
    /**
     *  OXID eShop module installer class
     */

    require_once(dirname(__FILE__).'/magictoolbox.installer.core.class.php');

    //NOTE: wrapper for OXID config variables
    class ConfigClass {
        function __construct($path) {
            //NOTE: load OXID config
            require($path);
        }
    }

    class MagicToolboxOxidModuleInstallerClass extends MagicToolboxCoreInstallerClass {

        var $platformVersion = '';
        var $applicationFolder = '';
        var $oxConfig = null;
        var $oldModuleInstalled = false;

        function __construct() {
            $this->dir = dirname(dirname(__FILE__));
            $this->modDir = dirname(__FILE__).'/module';
            $this->resDir = preg_replace('/^(.*?\/)[^\/]+\/[^\/]+$/is', '$1', $_SERVER['SCRIPT_NAME']).'modules/magicthumb/resources';
            $this->oxConfig = new ConfigClass($this->dir.'/config.inc.php');
            $this->oldModuleInstalled = file_exists($this->dir.'/module/modules/magicthumb/core/magictoolbox.php') &&
                                        !file_exists($this->dir.'/module/modules/magicthumb/magicthumboutput.php');
            $this->platformVersion = $this->getPlatformVersion();
            $this->applicationFolder = version_compare($this->platformVersion, '6.0.0', '>=')?'Application':'application';
        }

        function isModuleInstalled() {
            $this->setStatus('check', 'module');
            if(file_exists($this->dir.'/modules/magicthumb')) {
                return true;
            }
            return false;
        }

        function checkPlace() {
            $this->setStatus('check', 'place');
            if((!is_dir($this->dir.'/core') && version_compare($this->platformVersion, '6.0.0', '<')) ||
               !is_dir($this->dir.'/views') && !is_dir($this->dir.'/'.$this->applicationFolder.'/views') ||
               !file_exists($this->dir.'/oxid.php') && (!file_exists($this->dir.'/core/oxid.php') && version_compare($this->platformVersion, '6.0.0', '<'))) {
                $this->setError('Wrong location: please upload the files from the ZIP archive to the OXID eShop store directory.');
                return false;
            }
            return true;
        }

        function checkPerm() {
            $this->setStatus('check', 'perm');
            $files = array(
                '/admin',
                '/modules',
                //'/tmp',
                //'/tmp/oxpec_menu_en_xml.txt'
            );

            $version = $this->getPlatformVersion();
            if(!empty($version) && version_compare($version, '4.7.0', '>=')) {
                $files[] = '/'.$this->applicationFolder.'/views/admin';
                $files[] = '/'.$this->applicationFolder.'/views/admin/de';
                $files[] = '/'.$this->applicationFolder.'/views/admin/en';
                $files[] = '/'.$this->applicationFolder.'/views/admin/tpl';
                $files[] = '/out/admin/img';
                $files[] = '/out/admin/src';
                if($this->oldModuleInstalled && version_compare($this->platformVersion, '6.0.0', '<')) {
                    $files[] = '/core';
                    $files[] = '/core/oxshopcontrol.php';
                }
            } else {
                $files[] = '/out/admin/de';
                $files[] = '/out/admin/en';
                $files[] = '/out/admin/img';
                $files[] = '/out/admin/src';
                $files[] = '/out/admin/tpl';
                if($this->oldModuleInstalled) {
                    $files[] = '/views';
                    $files[] = '/views/oxshopcontrol.php';
                }
            }

            list($result, $wrang) = $this->checkFilesPerm($files);
            if(!$result) {
                $this->setError('This installer need to modify some OXID eShop store files.');
                $this->setError('Please check write access for following files of your OXID eShop store:');
                $this->setError($wrang, '&nbsp;&nbsp;&nbsp;-&nbsp;');
                return false;
            }
            return true;
        }

        function backupFiles() {
            $this->setStatus('backup', 'files');
            return true;
        }

        function restoreStep_backupFiles() {
            if($this->oldModuleInstalled && version_compare($this->platformVersion, '6.0.0', '<')) {
                $version = $this->getPlatformVersion();
                if(!empty($version) && version_compare($version, '4.7.0', '>=')) {
                    $this->removeBackups(array(
                        '/core/oxshopcontrol.php',
                    ));
                } else {
                    $this->removeBackups(array(
                        '/views/oxshopcontrol.php',
                    ));
                }
            }
            return true;
        }

        function installFiles() {
            $this->setStatus('install', 'files');

            $version = $this->getPlatformVersion();

            $this->copyDir($this->modDir.'/admin', $this->dir.'/admin');
            $this->copyDir($this->modDir.'/modules', $this->dir.'/modules');

            if(!empty($version) && version_compare($version, '4.7.0', '>=')) {
                $this->copyDir($this->modDir.'/'.$this->applicationFolder, $this->dir.'/'.$this->applicationFolder);
                $this->copyDir($this->modDir.'/out_4.7.x', $this->dir.'/out');
            } else {
                $this->copyDir($this->modDir.'/out', $this->dir.'/out');
            }

            //clear cache files
            if(is_dir($this->dir.'/tmp')) {
                @unlink($this->dir.'/tmp/oxpec_menu_en_xml.txt');
                @unlink($this->dir.'/tmp/oxpec_langcache_1_0_oxbaseshop_basic.txt');
                @unlink($this->dir.'/tmp/oxpec_langcache_1_0_oxbaseshop_azure_default.txt');
                $this->log('CACHE CLEANUP '.$this->dir.'/tmp/oxpec_menu_en_xml.txt');
            }
            return true;
        }

        function restoreStep_installFiles() {

            $version = $this->getPlatformVersion();

            if(!empty($version) && version_compare($version, '4.7.0', '>=')) {
                if($this->oldModuleInstalled) {
                    $this->restoreFromBackups(array(
                        '/core/oxshopcontrol.php',
                    ));
                }
                @unlink($this->dir.'/'.$this->applicationFolder.'/views/admin/de/magiczoomplus_de_lang.php');
                @unlink($this->dir.'/'.$this->applicationFolder.'/views/admin/en/magiczoomplus_en_lang.php');
                @unlink($this->dir.'/'.$this->applicationFolder.'/views/admin/tpl/magiczoomplus.tpl');
            } else {
                if($this->oldModuleInstalled) {
                    $this->restoreFromBackups(array(
                        '/views/oxshopcontrol.php',
                    ));
                }
                @unlink($this->dir.'/out/admin/de/magicthumb_de_lang.php');
                @unlink($this->dir.'/out/admin/en/magicthumb_en_lang.php');
                @unlink($this->dir.'/out/admin/tpl/magicthumb.tpl');
            }

            if(file_exists($this->dir.'/out/admin/img/magicthumb')) {
                $this->removeDir($this->dir.'/out/admin/img/magicthumb');
            }
            $this->removeDir($this->dir.'/out/admin/src/magicthumb');

            @unlink($this->dir.'/admin/magicthumb.php');
            @unlink($this->dir.'/admin/magicthumb_images.php');

            $this->removeDir($this->dir.'/modules/magicthumb');

            //NOTE: for very old modules
            if(file_exists($this->dir.'/modules/magictoolbox')) {
                $this->removeDir($this->dir.'/modules/magictoolbox');
            }

            //clear cache files
            if(is_dir($this->dir.'/tmp')) {
                @unlink($this->dir.'/tmp/oxpec_menu_en_xml.txt');
            }

            return true;
        }

        function installDB() {
            $this->patch_DB();
            return true;
        }

        function restoreStep_installDB() {
            $this->patch_DB(true);
            return true;
        }

        function patch_DB($restore = false) {
            $version = $this->getPlatformVersion();
            if(!empty($version) && version_compare($version, '4.6.0', '<')) {
                $oxConfig = new ConfigClass($this->dir.'/core/oxconfk.php');
                if($dblink = mysqli_connect($this->oxConfig->dbHost, $this->oxConfig->dbUser, $this->oxConfig->dbPwd, $this->oxConfig->dbName)) {
                    $result = mysqli_query($dblink, "select oxid, DECODE(oxvarvalue, '{$oxConfig->sConfigKey}') as oxvarvalue from oxconfig where oxvarname='aModules' and oxshopid = 'oxbaseshop'");
                    if(mysqli_num_rows($result)) {
                        $row = mysqli_fetch_array($result);
                        $modules = unserialize($row['oxvarvalue']);
                        if($restore) {
                            if(isset($modules['oxoutput'])) {
                                $modules['oxoutput'] = preg_replace('/&magicthumb\/magicthumboutput|magicthumb\/magicthumboutput&?/is', '', $modules['oxoutput']);
                                $modules['oxoutput'] = trim($modules['oxoutput']);
                                if(empty($modules['oxoutput'])) unset($modules['oxoutput']);
                            }
                        } else if(isset($modules['oxoutput'])) {
                            $modules['oxoutput'] = 'magicthumb/magicthumboutput&'.$modules['oxoutput'];
                        } else {
                            $modules['oxoutput'] = 'magicthumb/magicthumboutput';
                        }
                        $modules = serialize($modules);
                        mysqli_query("update oxconfig set oxvarvalue=ENCODE('{$modules}', '{$oxConfig->sConfigKey}') where oxid='{$row['oxid']}'");
                    }
                    mysqli_free_result($result);
                    mysqli_close($dblink);
                }
            }
        }

        function upgrade($files) {
            $path = $this->dir.'/modules/magicthumb/resources/';
            foreach($files as $name => $file) {
                if(file_exists($path.$name)) {
                    unlink($path.$name);
                }
                file_put_contents($path.$name, $file);
                chmod($path.$name, 0755);
            }
            return true;
        }

        function getPlatformVersion() {
            if(empty($this->platformVersion))
            if($dblink = mysqli_connect($this->oxConfig->dbHost, $this->oxConfig->dbUser, $this->oxConfig->dbPwd, $this->oxConfig->dbName)) {
                $res = mysqli_query($dblink, 'SELECT oxversion FROM oxshops LIMIT 1');
                $row = mysqli_fetch_array($res);
                mysqli_free_result($res);
                mysqli_close($dblink);
                $this->platformVersion = $row['oxversion'];
            }
            return $this->platformVersion;
        }


    }
