<?php

/**
 * Metadata version
 */
$sMetadataVersion = '1.1';

/**
 * Module information
 */
$aModule = array(
    'id'           => 'magicslideshow',
    'title'        => 'Magic Slideshow',
    'description'  => "Display one image after another. Fade or slide, fast or slow, text or just images. It's your choice!",
    //'thumbnail'    => 'magicslideshow.png',
    'version'      => '4.3.18',
    'author'       => 'Magic Toolbox',
    'email'        => 'support@magictoolbox.com',
    'url'          => 'http://www.magictoolbox.com',
    'extend'       => array(
        'oxoutput' => 'magicslideshow/magicslideshowoutput',
    ),
    'files' => array(
        'magicslideshowevents' => 'magicslideshow/magicslideshowevents.php',
        'magicslideshow' => '../admin/magicslideshow.php',
    ),
    'events'       => array(
        'onActivate'   => 'magicslideshowevents::onActivate',
        'onDeactivate' => 'magicslideshowevents::onDeactivate',
    ),

);

if(class_exists('oxRegistry')) {
    $myConfig = oxRegistry::getConfig();
} else {
    //NOTE: for OXID versions < 4.7.0
    $myConfig = oxConfig::getInstance();
}
$aDisabledModules = $myConfig->getConfigParam('aDisabledModules');
if(!is_array($aDisabledModules)) $aDisabledModules = array();
if(in_array('magicslideshow', $myConfig->getConfigParam('aDisabledModules'))) {
    $aModule['description'] .= "<br /><br /><span style=\"color: red;\">Please activate the module and refresh the page (if need it) to access the settings.</span>";
} else {
    $aModule['description'] .= "<br /><br /><span style=\"color: green;\">Change the settings as you wish via the <b>Master Settings</b> -> <b>Magic Slideshow Settings</b> menu.</span>";
}
