<?php

//class MagicSlideshowOutput extends oxOutput {
class MagicSlideshowOutput extends MagicSlideshowOutput_parent {

    public $aSavedViewData = null;

    public $aProcessedBlocks = array();

    public $aMagicSlideshowClassNamesMapping = array(
        'details' => 'product',
        'start' => 'homeslideshow',
    );

    public $blIsAJAX = false;


    public function __construct() {
        parent::__construct();
        $this->blIsAJAX = isset($_SERVER['HTTP_X_REQUESTED_WITH']) && ($_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest');
        if($this->blIsAJAX) {
            //NOTE: for product variants (when refreshing product images via ajax) (~ OXID 4.8.3)
            $this->aMagicSlideshowClassNamesMapping['oxwarticledetails'] = 'product';
        }

    }

    public function process($sOutput, $sClassName) {

        if(!isset($this->aMagicSlideshowClassNamesMapping[$sClassName])) return parent::process($sOutput, $sClassName);

        $sPage = $this->aMagicSlideshowClassNamesMapping[$sClassName];

        $oTool = $this->getMagicSlideshowTool();

        if(!$oTool->params->profileExists($sPage) || $oTool->params->checkValue('enable-effect', 'No', $sPage)) {
            return parent::process($sOutput, $sClassName);
        }
        $oTool->params->setProfile($sPage);

        $sOutput = parent::process($sOutput, $sClassName);


        //NOTE: after parent process
        if($this->aSavedViewData === null) return $sOutput;

        //NOTE: if the block has been processed by another MagicToolbox module
        if(isset($this->aProcessedBlocks[$sPage])) return $sOutput;

        $aViewData = &$this->aSavedViewData;

        $blOutputHeaders = false;
        $blProductHasVariants = false;
        $blProductHasParent = false;//NOTE: variant of product

        $oMyConfig = $this->getConfig();

        $sBaseShopUrl = $oMyConfig->getShopUrl();
        $sBaseImagePath = getShopBasePath().$oMyConfig->getOutDir(false).$oMyConfig->getConfigParam('_sPictureDir').'/';
        $sBaseImageUrl = $oMyConfig->getOutUrl()./*'/'.*/$oMyConfig->getConfigParam('_sPictureDir').'/';

        //NOTE: check for external images enabled
        $blExternalImages = isset($oMyConfig->sAltImageDir) ? true : false;
        if($blExternalImages) {
            $sBaseImageUrl = preg_replace('/\/$/', '', $oMyConfig->sAltImageDir).'/';
        }

        $sOxidVersion = $oMyConfig->getVersion();
        //NOTE: Image handling changes since 4.5.1
        //http://wiki.oxidforge.org/Tutorials/image_handling_changes
        $newImageHandling = version_compare($sOxidVersion, '4.5.1', '>=');
        $blResize = $oTool->params->checkValue('resize-images', 'Yes');

        switch($sPage) {
            case 'product':

                $oProduct = (isset($aViewData['product']) && $aViewData['product']) ? $aViewData['product'] : $aViewData['oView']->getProduct();

                //NOTICE: oxarticles__oxartnum may not be unique and contain not desirable symbols
                //    but oxarticles__oxid, on the other hand, can contains strange value like this "be642cad637adf214.28850610"
                //$sOXID = $sProductId = isset($oProduct->oxarticles__oxartnum->value) ? $oProduct->oxarticles__oxartnum->value : null;
                $sOXID = isset($oProduct->oxarticles__oxid->value) ? $oProduct->oxarticles__oxid->value : null;

                //$varselid = oxConfig::getParameter('varselid');//array
                            //oxRegistry::getConfig()->getConfigParam('varselid');
                if(class_exists('oxRegistry')) {
                    $varselid = oxRegistry::getConfig()->getRequestParameter('varselid', false);
                } else {
                    //NOTE: for OXID versions < 4.7.0
                    $varselid = oxConfig::getParameter('varselid');//array
                }

                $blProductHasParent = method_exists($oProduct, 'getParentId') ? ($oProduct->getParentId() ? true : false) : false;

                //NOTE: for product variants (when refreshing product images via ajax)
                if(isset($_POST['renderPartial']) || $this->blIsAJAX/* ~ OXID 4.8.3 */ || $varselid/* ~ OXID 4.8.7 */) {
                    $aVariantSelections = $oProduct->getVariantSelections($varselid);

                    if($aVariantSelections && isset($aVariantSelections['oActiveVariant'])) {
                        $oProduct = $aVariantSelections['oActiveVariant'];
                        $sOXID = isset($oProduct->oxarticles__oxid->value) ? $oProduct->oxarticles__oxid->value : null;
                    }

                    //NOTE: include script to turn on tool before ajax refresh
                    $sOutput .= '
<script type="text/javascript">
    setTimeout(function() {
        if(typeof(MagicSlideshow) == "udefined") return;
        var mtOXID = "'.$sOXID.'";
        var mainEl = document.getElementById("productMagicSlideshow");
        if(!mainEl) return;
        MagicSlideshow.start(mainEl);
    }, 500);
    if(typeof(MagicSlideshow) !== "udefined") {
        magictoolboxBindProductForm("'.$sOXID.'");
    }
</script>';
                } else if(method_exists($aViewData['oView'], 'getVariantSelections') && $aViewData['oView']->getVariantSelections()) {
                    //NOTE: always include headers if product has variants
                    $blProductHasVariants = true;
                }

                $iPicCount = $oMyConfig->getConfigParam('iPicCount');
                //$iZoomPicCount = $oMyConfig->getConfigParam('iZoomPicCount');
                //$iZoomPicCount = ($iPicCount > $iZoomPicCount) ? $iPicCount : $iZoomPicCount;
                if($blResize && !$blExternalImages) {
                    $aGallery = array();
                    for($iIndex = 1; $iIndex <= $iPicCount; $iIndex++) {
                        $sKey = 'oxarticles__oxpic'.$iIndex;
                        $sImagePath = $oProduct->$sKey->value;
                        if(!empty($sImagePath) && !preg_match('/(?:^|\/)nopic(?:_ico)?.jpg$/is', $sImagePath)) {
                            $sImagePath = basename($sImagePath);//NOTE: in case if it is not just name ("/name") (because of issue in OXID)
                            $sImagePath = $newImageHandling ? "master/product/{$iIndex}/{$sImagePath}" : "master/{$iIndex}/{$sImagePath}";
                            if(file_exists($sBaseImagePath.$sImagePath)) {
                                $aGallery[$iIndex] = $sImagePath;
                            }
                        }
                    }
                } else {
                    //NOTE: picture galery of current article
                    $aPictureGallery = $aViewData['oView']->getPictureGallery();
                    $aGallery = &$aPictureGallery['Pics'];
                }
                $iImagesCount = count($aGallery);
                if(!$iImagesCount) break;

                if($blExternalImages || !$blResize) {
                    $aDetailImageSizes = $oMyConfig->getConfigParam('aDetailImageSizes');
                    $aMainImageSize = explode('*', $aDetailImageSizes['oxpic1']);
                    //$sZoomImageSize = $oMyConfig->getConfigParam('sZoomImageSize');
                    $oTool->params->setValue('thumb-max-width', $aMainImageSize[0]);
                    $oTool->params->setValue('thumb-max-height', $aMainImageSize[1]);
                    $sIconSize = $oMyConfig->getConfigParam('sIconsize');
                    $aIconSize = explode('*', $sIconSize);
                    $oTool->params->setValue('selector-max-width', $aIconSize[0]);
                    $oTool->params->setValue('selector-max-height', $aIconSize[1]);
                }

                $aMagicSlideshowData = array();

                $i = 1;

                foreach($aGallery as $iIndex => $sImagePath) {

                    if($blResize && !$blExternalImages) {
                        //NOTE: resize images with MagicToolboxImageHelperClass
                        $sImg = $sBaseShopUrl.$this->createMagicSlideshowThumb($sImagePath, 'original', $sOXID);
                        $sMedium = $sBaseShopUrl.$this->createMagicSlideshowThumb($sImagePath, 'thumb', $sOXID);
                        $sThumb = $sBaseShopUrl.$this->createMagicSlideshowThumb($sImagePath, 'selector', $sOXID);
                    } else {
                        if(isset($aPictureGallery['ZoomPics'][$i])) {
                            $sImg = $aPictureGallery['ZoomPics'][$i]['file'];
                        } else {
                            $sImg = $sImagePath;
                        }
                        $sMedium = $sImagePath;
                        $sThumb = $aPictureGallery['Icons'][$iIndex];
                    }

                    $aMagicSlideshowData[] = array(
                        'title' => $oProduct->oxarticles__oxtitle->value,
                        'alt' => $oProduct->oxarticles__oxtitle->value,
                        'img' => $sMedium,
                        'thumb' => $sThumb,
                        'fullscreen' => $sImg,
                    );

                    $i++;

                }


                if($iImagesCount > 1) {
                    $sPattern = '(<div\b[^>]*?\bclass\s*+=\s*+"[^"]*?\b(?:morepics|otherPictures)\b[^"]*+"[^>]*+>)'.
                                '('.
                                '(?:'.
                                    '[^<]++'.
                                    '|'.
                                    '<(?!/?div\b|!--)'.
                                    '|'.
                                    '<!--.*?-->'.
                                    '|'.
                                    '<div\b[^>]*+>'.
                                        '(?2)'.
                                    '</div\s*+>'.
                                ')*+'.
                                ')'.
                                '</div\s*+>';
                    //NOTE: cut selectors
                    $sOutput = preg_replace('#'.$sPattern.'#is', '', $sOutput);
                }

                $sReplace = $oTool->getMainTemplate($aMagicSlideshowData, array("id" => "productMagicSlideshow"));
                $sReplace = '<div class="MagicToolboxContainer minWidth">'.$sReplace.'</div>';

                //NOTE: insert main template HTML
                $sPattern = '<img\b[^>]*?src="[^"]*?/'.preg_quote(basename(reset($aGallery))).'"[^>]*+>';
                $sPattern = '(?:<a\b[^>]*+>[^<]*+'.$sPattern.'[^<]*+</a>|'.$sPattern.')';
                $sContainerPattern = '(<div\b[^>]+?class="[^"]*?picture[^"]*+"[^>]*+>)[^<]*+'.$sPattern.'[^<]*+(</div>)';
                $aMatches = array();
                if(preg_match('#'.$sContainerPattern.'#is', $sOutput, $aMatches)) {
                    //NOTE: fix line-height
                    $aMatches[1] = preg_replace('#class="([^"]*+)"#is', 'class="$1 pictureLineHeight"', $aMatches[1]);
                    $sOutput = str_replace($aMatches[0], $aMatches[1].$sReplace.$aMatches[2], $sOutput);
                } else {
                    $sOutput = preg_replace('#'.$sPattern.'#is', $sReplace, $sOutput, 1);
                }

                //NOTE: remove some extra elements
                //NOTE: zoom link
                $sOutput = preg_replace('#<a\b[^>]*?id="(?:zoomTrigger|test_zoom)"[^>]*+>.*?</a>#is', '', $sOutput);
                //NOTE: modal zoom
                $zoomModalPattern = '<div\b[^>]*?\bid\s*+=\s*+"(?:zoomModal|zoom)"[^>]*+>'.
                                    '('.
                                    '(?:'.
                                        '[^<]++'.
                                        '|'.
                                        '<(?!/?div\b|!--)'.
                                        '|'.
                                        '<!--.*?-->'.
                                        '|'.
                                        '<div\b[^>]*+>'.
                                            '(?1)'.
                                        '</div\s*+>'.
                                    ')*+'.
                                    ')'.
                                    '</div\s*+>';
                $sOutput = preg_replace('#'.$zoomModalPattern.'#is', '', $sOutput);

                //NOTE: include headers
                $blOutputHeaders = true;

                $this->aProcessedBlocks[$sPage] = 'magicslideshow';

            break;
            case 'homeslideshow':

                $oDb = oxDb::getDb();
                $aImagesData = array();
                $aRecords = $oDb->getAll("SELECT * FROM `magicslideshow_images` ORDER BY `ORDER`");
                if(empty($aRecords)) break;
                foreach($aRecords as $aRecord) {
                    $aImagesData[] = array(
                        'id' => $aRecord[0],
                        'name' => $aRecord[1],
                        'title' => $aRecord[2],
                        'description' => $aRecord[3],
                        'link' => $aRecord[4],
                        'order' => $aRecord[5],
                        'exclude' => $aRecord[6],
                    );
                }
                $aItems = array();
                foreach($aImagesData as $aImageData) {
                    if($aImageData['exclude']) continue;
                    $sImagePath = "master/magicslideshow/{$aImageData['name']}";
                    $aItems[] = array(
                        'title' => $aImageData['title'],
                        'alt' => $aImageData['title'],
                        'img' => $sBaseShopUrl.$this->createMagicSlideshowThumb($sImagePath, 'thumb'),
                        'thumb' => $sBaseShopUrl.$this->createMagicSlideshowThumb($sImagePath, 'selector'),
                        'fullscreen' => $sBaseShopUrl.$this->createMagicSlideshowThumb($sImagePath, 'original'),
                        'description' => $aImageData['description'],
                        'link' => empty($aImageData['link']) ? false : $aImageData['link'],
                    );
                }
                if(empty($aItems)) break;
                $sHtml = $oTool->getMainTemplate($aItems, array('id' => 'HomeMagicSlideshow'));
                $sHtml = '<div class="MagicToolboxContainer">'.$sHtml.'</div>';

                $sPattern = '<div\b[^>]*?\bid\s*+=\s*+"header"[^>]*+>'.
                            '('.
                            '(?:'.
                                '[^<]++'.
                                '|'.
                                '<(?!/?div\b|!--)'.
                                '|'.
                                '<!--.*?-->'.
                                '|'.
                                '<div\b[^>]*+>'.
                                    '(?1)'.
                                '</div\s*+>'.
                            ')*+'.
                            ')'.
                            '</div\s*+>';
                //$sPattern = '(<div\b[^>]*?id="(?:body|content)"[^>]*>)';
                //preg_match_all('%'.$sPattern.'%is', $sOutput, $aMatches, PREG_SET_ORDER);
                $sOutput = preg_replace('#'.$sPattern.'#is', '$0'.$sHtml, $sOutput, 1, $iReplaced);

                //NOTE: added support for OXID v4.10.2 template
                if(!$iReplaced) {
                    $sPattern = '<div\b[^>]*?\bclass\s*+=\s*+"[^"]*?underdog[^"]*+"[^>]*+>';
                    $sOutput = preg_replace('#'.$sPattern.'#is', '$0'.$sHtml, $sOutput, 1, $iReplaced);
                }

                //NOTE: added support for "Bantam - Zoxid Responsive Template" (#58394)
                if(!$iReplaced) {
                    $sPattern = '<div\b[^>]*?\bclass\s*+=\s*+"[^"]*?zoxid-content[^"]*+"[^>]*+>';
                    $sOutput = preg_replace('#'.$sPattern.'#is', '$0'.$sHtml, $sOutput, 1/*, $iReplaced*/);
                }

                //NOTE: include headers
                $blOutputHeaders = true;

                $this->aProcessedBlocks[$sPage] = 'magicslideshow';

            break;

        }

        //NOTE: if this is a variant of product, we need to display headers for parent product or another variant of product
        if(!$blOutputHeaders && !$blProductHasVariants && !$blProductHasParent) return $sOutput;

        $oTool->params->resetProfile();

        $aHeaders = array();
        $aHeaders[] = $oTool->getHeadersTemplate($sBaseShopUrl.'modules/magicslideshow/resources');

        if($sPage == 'product') {
            //NOTE: include script to turn off tool before ajax refresh
            $aHeaders[] = '
<script type="text/javascript">
    function magictoolboxBindProductForm(id) {
        if(typeof($) == "undefined") return;
        $(".oxProductForm, .js-oxProductForm, .js-oxWidgetReload").submit(function() {
            var mainEl = document.getElementById("productMagicSlideshow");
            if(!mainEl) return;
            MagicSlideshow.stop(mainEl);
        });
    }

    mjsAddEventMethod = \'je1\';
    if(typeof(magicJS.Doc.je1) == \'undefined\') mjsAddEventMethod = \'jAddEvent\';
    $mjs(window)[mjsAddEventMethod]("load", function() {
        if(typeof(MagicSlideshow) == "udefined") return;
        magictoolboxBindProductForm("'.$sOXID.'");
    });
</script>
';
        }

        $sOutput = preg_replace('#</head>#is', implode($aHeaders).'</head>', $sOutput, 1);

        return $sOutput;
    }

    public function processViewArray($aViewData, $sClassName) {
        if(isset($this->aMagicSlideshowClassNamesMapping[$sClassName]) && $this->aSavedViewData === null) {
            $this->aSavedViewData = $aViewData;
        }
        return parent::processViewArray($aViewData, $sClassName);
    }

    public function &getMagicSlideshowTool($blGetScrollTool = false) {
        static $oTool = null;
        static $oScrollTool = null;
        if($oTool === null) {
            require_once(dirname(__FILE__).'/classes/magicslideshow.module.core.class.php');
            $oTool = new MagicSlideshowModuleCoreClass();
            $oDb = oxDb::getDb();
            $aRezult = $oDb->getAll("SELECT `BLOCK`, `NAME`, `VALUE` FROM `magicslideshow_config` WHERE `ENABLED`=1");

            //NOTE: create settings if it does not exists
            if(!$aRezult) {
                if(!class_exists('MagicSlideshowEvents')) {
                    include getShopBasePath().'modules/magicslideshow/magicslideshowevents.php';
                }
                MagicSlideshowEvents::onActivate();
                $aRezult = $oDb->getAll("SELECT `BLOCK`, `NAME`, `VALUE` FROM `magicslideshow_config` WHERE `ENABLED`=1");
            }

            foreach($aRezult as $aRow) {
                $oTool->params->setValue($aRow[1], $aRow[2], $aRow[0]);
            }

        }
        return $blGetScrollTool ? $oScrollTool : $oTool;
    }

    public function getMagicSlideshowBlocks() {
        return array(
			'default' => 'General',
			'product' => 'Product page',
			'homeslideshow' => 'Home page Slideshow',
		);
    }

    public function createMagicSlideshowThumb($sSrc, $sType, $sProductId = null) {
        static $oImageHelper = null;
        if($oImageHelper === null) {
            $oMyConfig = $this->getConfig();
            //$sCacheDirRel = str_replace(getShopBasePath(), '/', $myConfig->getConfigParam('sCompileDir')).'magictoolbox_cache';
            $sCacheDirRel = '/'.$oMyConfig->getOutDir(false).$oMyConfig->getConfigParam('_sPictureDir').'/magictoolbox_cache';

            //NOTE: we can't reproduce this issue, but it appear on most customers sites. So this is a fix
            //NOTE: maybe we don't need it any more
            //$sPref = substr($sCacheDirRel, 0, 5);
            //if($sPref == '/home') {
            //    $sCacheDirRel = substr($sCacheDirRel, 5);
            //} else {
            //    $sPref = '';
            //}

            $oTool = $this->getMagicSlideshowTool();
            require_once(dirname(__FILE__).'/classes/magictoolbox.imagehelper.class.php');
            $oImageHelper = new MagicToolboxImageHelperClass(/*$sPref.*/getShopBasePath(), $sCacheDirRel, $oTool->params);
        }
        return preg_replace('/^\//is', '', $oImageHelper->create('/out/pictures/'.$sSrc, $sType, $sProductId));
    }

}

?>
