<?php

class MagicSlideshowEvents {

    public static function onActivate() {

        $oDb = oxDb::getDb();

        $sSQL = <<<SQL
CREATE TABLE IF NOT EXISTS `magicslideshow_images` (
 `ID` int UNSIGNED NOT NULL AUTO_INCREMENT,
 `NAME` varchar(64) NOT NULL,
 `TITLE` varchar(64) DEFAULT '',
 `DESCRIPTION` text,
 `LINK` varchar(256) DEFAULT '',
 `ORDER` int UNSIGNED DEFAULT 0,
 `EXCLUDE` int(2) UNSIGNED DEFAULT 0,
 PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
SQL;
        $oDb->execute($sSQL);

        $table = $oDb->getOne("SHOW TABLES LIKE 'magicslideshow_config'");
        if($table) {
            $version = $oDb->getOne("SELECT `VALUE` FROM `magicslideshow_config` WHERE `BLOCK`='default' AND `NAME`='version'");
            $upgradeVersion = '4.3';
            if(version_compare($version, $upgradeVersion, '<') || $version == 'working') {
                $oDb->execute("DROP TABLE IF EXISTS `magicslideshow_config_backup`");
                $oDb->execute("RENAME TABLE `magicslideshow_config` TO `magicslideshow_config_backup`");
            } else {
                return;
            }
        }

        //DROP TABLE IF EXISTS `magicslideshow_config`;
        $sSQL = <<<SQL
CREATE TABLE IF NOT EXISTS `magicslideshow_config` (
 `ID` int(11) NOT NULL AUTO_INCREMENT,
 `BLOCK` char(32) NOT NULL,
 `NAME` char(32) NOT NULL,
 `VALUE` text,
 `ENABLED` tinyint(1) UNSIGNED NOT NULL default '0',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
SQL;
        $oDb->execute($sSQL);

        $sSQL = <<<SQL
INSERT INTO `magicslideshow_config` (`BLOCK`, `NAME`, `VALUE`, `ENABLED`) VALUES
 ('default', 'thumb-max-width', '450', 1),
 ('default', 'thumb-max-height', '450', 1),
 ('default', 'selector-max-width', '50', 1),
 ('default', 'selector-max-height', '50', 1),
 ('default', 'square-images', 'disable', 1),
 ('default', 'width', 'auto', 1),
 ('default', 'height', 'auto', 1),
 ('default', 'orientation', 'horizontal', 1),
 ('default', 'arrows', 'No', 1),
 ('default', 'loop', 'Yes', 1),
 ('default', 'effect', 'slide', 1),
 ('default', 'effect-speed', '600', 1),
 ('default', 'effect-easing', 'ease', 1),
 ('default', 'autoplay', 'Yes', 1),
 ('default', 'slide-duration', '6000', 1),
 ('default', 'shuffle', 'No', 1),
 ('default', 'kenburns', 'No', 1),
 ('default', 'pause', 'Yes', 1),
 ('default', 'selectors-style', 'bullets', 1),
 ('default', 'selectors', 'none', 1),
 ('default', 'selectors-eye', 'Yes', 1),
 ('default', 'bullets-preview', 'top', 1),
 ('default', 'selectors-fill', 'No', 1),
 ('default', 'caption', 'Yes', 1),
 ('default', 'fullscreen', 'No', 1),
 ('default', 'preload', 'Yes', 1),
 ('default', 'keyboard', 'Yes', 1),
 ('default', 'show-loader', 'Yes', 1),
 ('default', 'link-to-product-page', 'Yes', 1),
 ('default', 'show-message', 'No', 1),
 ('default', 'message', '', 1),
 ('default', 'resize-images', 'Yes', 1),
 ('default', 'imagemagick', 'off', 1),
 ('default', 'image-quality', '75', 1),
 ('default', 'watermark', '', 1),
 ('default', 'watermark-max-width', '30%', 1),
 ('default', 'watermark-max-height', '30%', 1),
 ('default', 'watermark-opacity', '50', 1),
 ('default', 'watermark-position', 'center', 1),
 ('default', 'watermark-offset-x', '0', 1),
 ('default', 'watermark-offset-y', '0', 1),
 ('product', 'enable-effect', 'Yes', 1),
 ('product', 'thumb-max-width', '250', 1),
 ('product', 'thumb-max-height', '200', 1),
 ('product', 'selector-max-width', '50', 0),
 ('product', 'selector-max-height', '50', 0),
 ('product', 'width', 'auto', 0),
 ('product', 'height', 'auto', 0),
 ('product', 'orientation', 'horizontal', 0),
 ('product', 'arrows', 'Yes', 1),
 ('product', 'loop', 'Yes', 0),
 ('product', 'effect', 'slide', 0),
 ('product', 'effect-speed', '600', 0),
 ('product', 'effect-easing', 'ease', 0),
 ('product', 'autoplay', 'Yes', 0),
 ('product', 'slide-duration', '6000', 0),
 ('product', 'shuffle', 'No', 0),
 ('product', 'kenburns', 'No', 0),
 ('product', 'pause', 'Yes', 0),
 ('product', 'selectors-style', 'bullets', 0),
 ('product', 'selectors', 'none', 0),
 ('product', 'selectors-eye', 'Yes', 0),
 ('product', 'bullets-preview', 'top', 0),
 ('product', 'selectors-fill', 'No', 0),
 ('product', 'caption', 'Yes', 0),
 ('product', 'fullscreen', 'Yes', 1),
 ('product', 'preload', 'Yes', 0),
 ('product', 'keyboard', 'Yes', 0),
 ('product', 'show-loader', 'Yes', 0),
 ('product', 'show-message', 'No', 0),
 ('product', 'message', '', 0),
 ('homeslideshow', 'enable-effect', 'No', 1),
 ('homeslideshow', 'thumb-max-width', '0', 1),
 ('homeslideshow', 'thumb-max-height', '0', 1),
 ('homeslideshow', 'selector-max-width', '50', 0),
 ('homeslideshow', 'selector-max-height', '50', 0),
 ('homeslideshow', 'width', 'auto', 0),
 ('homeslideshow', 'height', 'auto', 0),
 ('homeslideshow', 'orientation', 'horizontal', 0),
 ('homeslideshow', 'arrows', 'Yes', 1),
 ('homeslideshow', 'loop', 'Yes', 0),
 ('homeslideshow', 'effect', 'slide', 0),
 ('homeslideshow', 'effect-speed', '600', 0),
 ('homeslideshow', 'effect-easing', 'ease', 0),
 ('homeslideshow', 'autoplay', 'Yes', 0),
 ('homeslideshow', 'slide-duration', '6000', 0),
 ('homeslideshow', 'shuffle', 'No', 0),
 ('homeslideshow', 'kenburns', 'No', 0),
 ('homeslideshow', 'pause', 'Yes', 0),
 ('homeslideshow', 'selectors-style', 'bullets', 0),
 ('homeslideshow', 'selectors', 'none', 0),
 ('homeslideshow', 'selectors-eye', 'Yes', 0),
 ('homeslideshow', 'bullets-preview', 'top', 0),
 ('homeslideshow', 'selectors-fill', 'No', 0),
 ('homeslideshow', 'caption', 'Yes', 1),
 ('homeslideshow', 'fullscreen', 'No', 0),
 ('homeslideshow', 'preload', 'Yes', 0),
 ('homeslideshow', 'keyboard', 'Yes', 0),
 ('homeslideshow', 'show-loader', 'Yes', 0),
 ('homeslideshow', 'link-to-product-page', 'Yes', 0),
 ('homeslideshow', 'show-message', 'No', 1),
 ('homeslideshow', 'message', '', 0),
 ('default', 'version', '4.3.18', 1);
SQL;
        $oDb->execute($sSQL);

        if(class_exists('oxRegistry')) {
            $oMyConfig = oxRegistry::getConfig();
        } else {
            //NOTE: for OXID versions < 4.7.0
            $oMyConfig = oxConfig::getInstance();
        }

        //$sOxidVersion = $oMyConfig->getVersion();
        $sTheme = $oMyConfig->getConfigParam('sTheme');
        if($sTheme != 'azure') return;
        $oDb->execute("UPDATE `magicslideshow_config` SET `VALUE`='380' WHERE `BLOCK`='product' AND `NAME`='thumb-max-width'");
        $oDb->execute("UPDATE `magicslideshow_config` SET `VALUE`='340' WHERE `BLOCK`='product' AND `NAME`='thumb-max-height'");
        //$oDb->execute("UPDATE `magicslideshow_config` SET `VALUE`='380' WHERE `BLOCK`='product' AND `NAME`='width'");
        $oDb->execute("UPDATE `magicslideshow_config` SET `VALUE`='80' WHERE `BLOCK`='product' AND `NAME`='selector-max-width'");
        $oDb->execute("UPDATE `magicslideshow_config` SET `VALUE`='80' WHERE `BLOCK`='product' AND `NAME`='selector-max-height'");
        $oDb->execute("UPDATE `magicslideshow_config` SET `VALUE`='150' WHERE `BLOCK`='category' AND `NAME`='thumb-max-width'");
        $oDb->execute("UPDATE `magicslideshow_config` SET `VALUE`='150' WHERE `BLOCK`='category' AND `NAME`='thumb-max-height'");

    }

    public static function onDeactivate() {

    }

}

?>