<?php

/**
 * Metadata version
 */
$sMetadataVersion = '1.1';

/**
 * Module information
 */
$aModule = array(
    'id'           => 'magicscroll',
    'title'        => 'Magic Scroll',
    'description'  => "Effortlessly scroll through images and/or text on your web pages.",
    //'thumbnail'    => 'magicscroll.png',
    'version'      => '4.3.18',
    'author'       => 'Magic Toolbox',
    'email'        => 'support@magictoolbox.com',
    'url'          => 'http://www.magictoolbox.com',
    'extend'       => array(
        'oxoutput' => 'magicscroll/magicscrolloutput',
    ),
    'files' => array(
        'magicscrollevents' => 'magicscroll/magicscrollevents.php',
        'magicscroll' => '../admin/magicscroll.php',
    ),
    'events'       => array(
        'onActivate'   => 'magicscrollevents::onActivate',
        'onDeactivate' => 'magicscrollevents::onDeactivate',
    ),

);

if(class_exists('oxRegistry')) {
    $myConfig = oxRegistry::getConfig();
} else {
    //NOTE: for OXID versions < 4.7.0
    $myConfig = oxConfig::getInstance();
}
$aDisabledModules = $myConfig->getConfigParam('aDisabledModules');
if(!is_array($aDisabledModules)) $aDisabledModules = array();
if(in_array('magicscroll', $myConfig->getConfigParam('aDisabledModules'))) {
    $aModule['description'] .= "<br /><br /><span style=\"color: red;\">Please activate the module and refresh the page (if need it) to access the settings.</span>";
} else {
    $aModule['description'] .= "<br /><br /><span style=\"color: green;\">Change the settings as you wish via the <b>Master Settings</b> -> <b>Magic Scroll Settings</b> menu.</span>";
}
