<style type="text/css">
* {
    font-family: Arial,Verdana,Helvetica,sans-serif;
}
#container {
    margin: 0 auto;
    text-align: left;
    width: 960px;
    background-color: #FFFFFF;
    color: #000000;
    font-size: 12px;
    border: 1px solid #CC9933;
    padding: 20px;
    border-radius: 5px;
}
h2 {
    color: #268CCD;
    font-size: 1.4em;
    margin: 0 0 0.83em;
}
fieldset {
    background: none repeat scroll 0 0 #FFFFF0;
    border: 1px solid #DFD5C3;
    font-size: 1.1em;
    margin: 0;
    padding: 1em;
    border-radius: 5px;
}
legend {
    font-family: Trebuchet,Arial,Helvetica,sans-serif;
    background: none repeat scroll 0 0 #FFF6D3;
    border: 1px solid #DFD5C3;
    font-weight: 700;
    margin: 0;
    padding: 0.2em 0.5em;
    text-align: left;
    border-radius: 5px;
}
label {
    float: left;
    font-weight: bold;
    padding: 0.2em 0.5em 0 0;
    /*padding: 0;*/
    text-align: right;
    width: 200px;
}
.margin-form {
    color: #7F7F7F;
    font-size: 0.85em;
    padding: 0 0 1em 210px;
}
.clear {
    clear: both;
}
.pspace {
    padding-top: 1em;
}
input[type="text"], input[type="password"], input[type="file"], textarea {
    border: 1px solid #E0D0B1;
}
input[type="text"], input[type="password"], input[type="file"], textarea, select, option {
    background-color: #FFFFFF;
}
input[type="text"], input[type="password"], input[type="file"], textarea {
    padding: 2px 4px;
}
input[type="radio"], input[type="checkbox"] {
    background-color: transparent;
}
input, textarea, option {
    color: #000000;
    font-size: 12px;
    margin: 0;
    padding: 0;
}
input {
    vertical-align: middle;
}
input[disabled] {
    color: #AFADAA;
}
select {
    border: 1px solid #E0D0B1;
    font-size: 12px;
}
label.t {
    clear: none;
    float: none;
    font-size: 12px;
    font-weight: bold;
    margin: 0;
    /*padding: 0;*/
    padding: 0 4px;
    /*padding:0.2em 0 0; */
    width: auto;
}
label img {
   vertical-align: bottom;
   padding: 0 4px 0 0;
}
.button {
    background-color: #FFF6D3;
    border-color: #FFF6D3 #DFD5AF #DFD5AF #FFF6D3;
    border-right: 1px solid #DFD5AF;
    border-style: solid;
    border-width: 1px;
    color: #268CCD;
    padding: 3px;
    border-radius: 5px;
    cursor: pointer;
}
div.buttons-container {
    text-align: center;
}
div.buttons-container input {
    padding: 5px;
    border-radius: 5px;
    margin: 5px 0;
}
div.buttons-container-fixed {
    background: none repeat scroll 0 0 #EFEFDE;
    border-bottom: 1px solid #988753;
    opacity: 0.85;
    position: fixed;
    left: 0;
    top: 0;
    width: 100%;
    z-index: 1000;
}
div.buttons-container-fixed input {
    margin: 5px 0;
}

.hint {
    background-color: #FFFFCC;
    border: 1px solid #CC9933;
    color: #7F7F7F;
    display: block;
    left: 0px;
    margin-bottom: 2px;
    margin-top: 4px;
    padding: 6px;
    position: relative;
    width: 501px;
}
#magicscroll_icon {
    float: left;
    margin: 0 5px 5px 0;
}
.margin-form a, .margin-form a:hover, .margin-form a:visited {
    color: #CC9933;
}

.magic_tabs { margin: 0; padding: 0; float: left; width: 132px; position: relative; z-index: 1; }
.magic_tabs li { list-style-type: none; margin: 0; padding: 0; }
.magic_tabs a { display: inline-block; width: 120px; margin-bottom: -1px; border: 1px solid #CC9933; color: #CC9933; font-weight: bold; line-height: 22px; margin-right: -1px; padding: 2px 5px; text-decoration: none; background: #f2f2f2; font-size: 12px; border-top-left-radius: 5px; border-bottom-left-radius: 5px; }
.magic_tabs a.tabactive { text-decoration: none; color: #000; font-weight: bold; background: #fff; border-right: none; width: 121px;}
.magic_tabs li a:hover { background: #CC9933; color: #fff; text-decoration: none; border-right: none; }
.magic_tabs li a.tabactive:hover { background: #fff; color: #000; }
.magic_tabCont { display: none; border: 1px solid #CC9933; padding: 10px; border-top-right-radius: 5px; border-bottom-right-radius: 5px; border-bottom-left-radius: 5px; }
.magic_tabContWrapper { float: left; width: 790px; clear: right; margin: 0; margin-left: -1px;}
.magic_tabCont.magic_active { display: block; }
.magic_tabCont div.margin-form label { padding: 0 4px; }
.magic_tabCont label { padding: 0; width: 200px; }
.magic_tabCont .margin-form label { padding: 0.2em 0 0; margin-right: 10px; width: auto; }
.magic_tabCont .margin-form { padding-top: 1px !important; padding-left: 210px !important; }
.magic_hint {
    display: block;
    position: relative;
    left: 0px;
    width: 396px;
    margin-top: 4px;
    margin-bottom: 2px;
    border: 1px solid #c93;
    padding: 6px;
    color: #7F7F7F;
    background-color: #ffc;
}
.margin-form input[type=text] {
    width: 400px;
}
.magic_tabCont fieldset { margin: 17px 0px; }
#magicscroll_icon {
    float: left;
    margin: 0 5px 5px 0;
}
div.upload-container {
    text-align: center;
    overflow: hidden;
    width: 112px;
    height: 24px;
    margin: 10px 0 0;
}
input.upload-button {
    width: 112px;
    height: 24px;
}
input.upload-file {
    margin-top: -24px;
    margin-left:-410px;
    -moz-opacity: 0;
    filter: alpha(opacity=0);
    opacity: 0;
    font-size: 150px;
    height: 100px;
    cursor: pointer;
}
#magicscroll_images {
    border: 1px solid #DFD5C3;
    border-bottom: none;
}
#magicscroll_images th {
    background: none repeat scroll 0 0 #F2F2F2;
    padding: 0 1px 0 1px;
    text-align: center;
    border-bottom: 1px solid #DFD5C3;
    border-right: 1px solid #DFD5C3;
}
#magicscroll_images th:last-child {
    border-right: none;
}
#magicscroll_images td {
    padding: 4px 1px;
    text-align: center;
    border-bottom: 1px solid #DFD5C3;
}
#magicscroll_images img {
    max-width: 60px;
    max-height: 60px;
}
#magicscroll_images input[type="text"], #magicscroll_images textarea {
    width: 160px;
}
#magicscroll_images textarea {
    min-width: 160px;
    max-width: 160px;
    min-height: 18px;
}
#magicscroll_images input[type="text"].input-order {
    width: 18px;
}
</style>
<div id="container">
<h2 id="title">Magic Scroll configuration</h2>
<div id="buttons-container-wrapper">
    <div id="buttons-container" class="buttons-container">
        <input class="button" type="submit" id="magic_submit" name="magic_submit" value="Save settings" />
        <input class="button" type="button" value="Reset settings" onclick="resetSettings()" />
    </div>
</div>
<ul class="magic_tabs">
<?php foreach($this->getParamsBlocks() as $sBlockId => $sBlockTitle) { ?>
<li><a id="<?php echo $sBlockId; ?>" onclick="return magic_changeTab(this);" <?php if($sBlockId == 'default') echo 'class="tabactive" '; ?>href="#"><?php echo $sBlockTitle; ?></a></li>
<?php } ?>
</ul>
<div class="magic_tabContWrapper">
<?php foreach($this->getParamsMap() as $sBlockId => $aGroups) {
    $oTool->params->setProfile($sBlockId);
?>
<div id="<?php echo $sBlockId; ?>_content" class="magic_tabCont<?php if($sBlockId == 'default') echo ' magic_active'; ?>">
    <?php foreach($aGroups as $sGroupTitle => $aParams) { ?>
    <fieldset>
    <legend><?php echo $sGroupTitle; ?></legend>
        <?php
            if($sBlockId == 'homeslideshow' && $sGroupTitle == 'Setup slideshow for home page') {
                if(!empty($aImagesData)) {
        ?>
                    <label style="float: none;">Slideshow images</label>
                    <div style="margin: 10px 0 10px 0;">
                    <table id="magicscroll_images" cellspacing="0" cellpadding="0" class="table">
                    <thead>
                    <tr>
                        <th>Image</th>
                        <th>Title</th>
                        <th>Description</th>
                        <th>Link</th>
                        <th>Order</th>
                        <th>Exclude</th>
                        <th>Remove</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php
                        foreach($aImagesData as $aImageData) {
                    ?>
                        <tr id="row-<?php echo $aImageData['id']; ?>">
                            <td><img src="<?php echo $sBaseImageUrl.$aImageData['name']; ?>" alt="<?php echo $aImageData['title']; ?>" title="<?php echo $aImageData['title']; ?>" /></td>
                            <td style="vertical-align: top;"><input type="text" name="images-data[<?php echo $aImageData['id']; ?>][title]" id="title-<?php echo $aImageData['id']; ?>" value="<?php echo $aImageData['title']; ?>" /></td>
                            <td style="vertical-align: top;"><textarea name="images-data[<?php echo $aImageData['id']; ?>][description]" id="description-<?php echo $aImageData['id']; ?>" ><?php echo $aImageData['description']; ?></textarea></td>
                            <td style="vertical-align: top;"><input type="text" name="images-data[<?php echo $aImageData['id']; ?>][link]" id="link-<?php echo $aImageData['id']; ?>" value="<?php echo $aImageData['link']; ?>" /></td>
                            <td style="vertical-align: top;"><input type="text" name="images-data[<?php echo $aImageData['id']; ?>][order]" id="order-<?php echo $aImageData['id']; ?>" value="<?php echo $aImageData['order']; ?>" class="input-order" /></td>
                            <td class="center"><input type="checkbox" name="images-data[<?php echo $aImageData['id']; ?>][exclude]" id="exclude-<?php echo $aImageData['id']; ?>" value="<?php echo $aImageData['exclude']; ?>" <?php echo intval($aImageData['exclude'])?'checked="checked" ':''; ?> /></td>
                            <td class="center"><input type="checkbox" name="images-data[<?php echo $aImageData['id']; ?>][delete]" id="delete-<?php echo $aImageData['id']; ?>" value="0" /></td>
                        </tr>
                    <?php
                        }
                    ?>
                    </tbody>
                    </table>
                    </div>
        <?php
                }
        ?>
                    <div class="upload-container">
                        <input class="upload-button button" type="button" value="Upload images" />
                        <input class="upload-file" type="file" name="magicscroll_image_files[]" id="upload-file" multiple="multiple" accept="image/*" size="1" onchange="document.myedit.magic_submit.click();"/>
                    </div>
        <?php
            }
        ?>
        <?php foreach($aParams as $sParamId) {
            $sParamValue = $oTool->params->getValue($sParamId);
            $blParamEnable = ($sBlockId == 'default'
                            || in_array($sParamId, array('enable-effect', 'template', 'magicscroll'))
                            || $oTool->type == 'standard' && in_array($sGroupTitle, array('Scroll', 'Scroll Arrows', 'Scroll Slider', 'Scroll effect', 'Multiple images'))
                            || $oTool->params->paramExists($sParamId));
        ?>
        <label for="<?php echo $sBlockId.'-'.$sParamId; ?>"><?php echo $oTool->params->getLabel($sParamId); ?></label>
        <div class="margin-form">
        <?php
        switch($oTool->params->getType($sParamId)) {
            case "array":
                if($oTool->params->getSubType($sParamId, $oTool->params->generalProfile) == 'radio') {
                    foreach($oTool->params->getValues($sParamId) as $sValue) {
                        ?><input type="radio" value="<?php echo $sValue; ?>"<?php echo (($sParamValue == $sValue)?' checked="checked"':''); ?><?php echo $blParamEnable ? '' : ' disabled="disabled"'; ?> name="<?php echo $sBlockId.'-'.$sParamId; ?>" id="<?php echo $sBlockId.'-'.$sParamId.'-'.$sValue; ?>" /><?php
                        ?><label class="t" for="<?php echo $sBlockId.'-'.$sParamId.'-'.$sValue; ?>"><?php
                        $sValueLower = strtolower($sValue);
                        if($sValueLower == "yes")
                            echo '<img src="'.$sImageUrl.'magicscroll/yes.gif" alt="Enabled" title="Enabled" />';
                        else if($sValueLower == "no")
                            echo '<img src="'.$sImageUrl.'magicscroll/no.gif" alt="Disabled" title="Disabled" />';
                        else if($sValueLower == "left")
                            echo '<img src="'.$sImageUrl.'magicscroll/left.gif" alt="Left" title="Left" />';
                        else if($sValueLower == "right")
                            echo '<img src="'.$sImageUrl.'magicscroll/right.gif" alt="Right" title="Right" />';
                        else if($sValueLower == "top")
                            echo '<img src="'.$sImageUrl.'magicscroll/top.gif" alt="Top" title="Top" />';
                        else if($sValueLower == "bottom")
                            echo '<img src="'.$sImageUrl.'magicscroll/bottom.gif" alt="Bottom" title="Bottom" />';
                        else echo $sValue;
                        ?></label><?php
                    }
                } else if($oTool->params->getSubType($sParamId, $oTool->params->generalProfile) == 'select') {
                    ?><select name="<?php echo $sBlockId.'-'.$sParamId; ?>" id="<?php echo $sBlockId.'-'.$sParamId; ?>"<?php echo $blParamEnable ? '' : ' disabled="disabled"'; ?>><?php
                    foreach($oTool->params->getValues($sParamId) as $sValue) {
                        ?><option value="<?php echo $sValue; ?>"<?php echo (($sParamValue==$sValue)?' selected="selected"':''); ?>><?php echo $sValue; ?></option><?php
                    }
                    ?></select><?php
                } else {
                    ?><input type="text" name="<?php echo $sBlockId.'-'.$sParamId; ?>" id="<?php echo $sBlockId.'-'.$sParamId; ?>" value="<?php echo $sParamValue; ?>"<?php echo $blParamEnable ? '' : ' disabled="disabled"'; ?> /><?php
                }
                break;
            case "num":
            case "text":
            default:
                ?><input type="text" name="<?php echo $sBlockId.'-'.$sParamId; ?>" id="<?php echo $sBlockId.'-'.$sParamId; ?>" value="<?php echo $sParamValue; ?>"<?php echo $blParamEnable ? '' : ' disabled="disabled"'; ?> /><?php
        }
        if($sBlockId != 'default'
          && !in_array($sParamId, array('enable-effect', 'template', 'magicscroll'))
          && !($oTool->type == 'standard' && in_array($sGroupTitle, array('Scroll', 'Scroll Arrows', 'Scroll Slider', 'Scroll effect', 'Multiple images')))) {
            if($blParamEnable) {
                echo '&nbsp;&nbsp;<a href="#" onclick="return useDefaultOption(this, \''.$sParamId.'\', \''.$sBlockId.'\');">use default option</a>';
            } else {
                echo '&nbsp;&nbsp;<a href="#" onclick="return useDefaultOption(this, \''.$sParamId.'\', \''.$sBlockId.'\');" class="optionDisabled">edit</a>';
            }
        }
        $sHint = '';
        if($oTool->params->getDescription($sParamId))
            $sHint = $oTool->params->getDescription($sParamId);
        if($oTool->params->getType($sParamId) != "array" && $oTool->params->valuesExists($sParamId, '', false)) {
            if($sHint != '') $sHint .= "<br />";
            $sHint .= "#allowed values: ".implode(", ",$oTool->params->getValues($sParamId));
        }
        if($sHint != '') {
            ?><p class="magic_hint clear"><?php echo $sHint; ?></p><?php
        }
        ?>
        </div>
        <div class="clear pspace"></div>
        <?php } ?>
    </fieldset>
    <?php } ?>
</div>
<?php } ?>
</div>
<div class="clear pspace"></div>
<input type="hidden" id="magic_tabs_current" name="magic_tabs_current" value="default" />
<script type="text/javascript">
//<![CDATA[

function resetSettings() {
    document.myedit.reset.value = 'true';
    document.myedit.magic_submit.click();
}

var magic_tabs_current = 'default';
function magic_changeTab(elm) {
    if(document.getElementById(magic_tabs_current)) {
        document.getElementById(magic_tabs_current).className = '';
        document.getElementById(magic_tabs_current+'_content').className = 'magic_tabCont';
    }
    magic_tabs_current = document.getElementById('magic_tabs_current').value = elm.id;
    document.getElementById(magic_tabs_current).className = 'tabactive';
    document.getElementById(magic_tabs_current+'_content').className = 'magic_tabCont magic_active';
    elm.blur();
    return false;
}
<?php if(!empty($this->sCurrentTabs)) { ?>
magic_changeTab(document.getElementById('<?php echo $this->sCurrentTabs; ?>'));
<?php } ?>
function scrollHandler() {
    var buttonsContainer = document.getElementById('buttons-container');
    var buttonsContainerWrapper = buttonsContainer.parentNode;
    if(typeof(buttonsContainerWrapper.getBoundingClientRect) == 'undefined') return;
    var buttonsContainerWrapperBox = buttonsContainerWrapper.getBoundingClientRect();
    if(buttonsContainerWrapperBox.top < 0) {
        magicToolboxAddClass(buttonsContainer, 'buttons-container-fixed');
        //buttonsContainer.style.width = buttonsContainerWrapperBox.width+'px';
        //buttonsContainer.style.left = buttonsContainerWrapperBox.left+'px';
    } else {
        magicToolboxRemoveClass(buttonsContainer, 'buttons-container-fixed');
    }
}
if(window.addEventListener) {
    window.addEventListener('scroll', scrollHandler, false);
    window.addEventListener('resize', scrollHandler, false);
} else {
    window.attachEvent('scroll', scrollHandler);
    window.attachEvent('resize', scrollHandler);
}
//]]>
</script>
<script type="text/javascript">
//<![CDATA[
var blocks = ["<?php echo implode('", "', array_keys($this->getParamsBlocks())); ?>"];
function magicToolboxHasClass(element, className) {
    return element.className.match(new RegExp('(\\s|^)'+className+'(\\s|$)'));
}
function magicToolboxAddClass(element, className) {
    if(!this.magicToolboxHasClass(element, className)) element.className += " "+className;
}
function magicToolboxRemoveClass(element, className) {
    if(magicToolboxHasClass(element, className)) {
        var reg = new RegExp('(\\s|^)'+className+'(\\s|$)');
        element.className = element.className.replace(reg, ' ');
    }
}
function useDefaultOption(anchorEl, optionId, blockId) {
    var elements = null;
    if(magicToolboxHasClass(anchorEl, 'optionDisabled')) {
        magicToolboxRemoveClass(anchorEl, 'optionDisabled');
        anchorEl.innerHTML = 'use default option';
        elements = anchorEl.parentNode.getElementsByTagName('select');
        for(var i = 0, l = elements.length; i < l; i++) {
            elements[i].removeAttribute('disabled');
        }
        elements = anchorEl.parentNode.getElementsByTagName('input');
        for(var i = 0, l = elements.length; i < l; i++) {
            elements[i].removeAttribute('disabled');
        }
    } else {
        magicToolboxAddClass(anchorEl, 'optionDisabled');
        anchorEl.innerHTML = 'edit';
        elements = anchorEl.parentNode.getElementsByTagName('select');
        for(var i = 0, l = elements.length; i < l; i++) {
            elements[i].setAttribute('disabled', true);
            var value = document.getElementById('default-'+optionId).value;
            for(var j = 0, ol = elements[i].options.length; j < ol; j++) {
                if(elements[i].options[j].value == value) {
                    elements[i].value = value;
                    elements[i].selectedIndex = j;
                    break;
                }
            }
        }
        elements = anchorEl.parentNode.getElementsByTagName('input');
        for(var i = 0, l = elements.length; i < l; i++) {
            if(elements[i].getAttribute('type') == 'text') {
                elements[i].setAttribute('disabled', true);
                elements[i].value = document.getElementById('default-'+optionId).value;
            } else if(elements[i].getAttribute('type') == 'radio') {
                elements[i].setAttribute('disabled', true);
                var radios = document.getElementsByName('default-'+optionId);
                var j = 0, rl;
                for(rl = radios.length; j < rl; j++) {
                    if(radios[j].checked) {
                        break;
                    }
                }
                if(j != rl) {
                    var id = radios[j].id.replace(/^default/, blockId);
                    radios = document.getElementsByName(elements[i].name);
                    for(j = 0, rl = radios.length; j < rl; j++) {
                        radios[j].checked = false;
                        radios[j].setAttribute('disabled', true);
                    }
                    document.getElementById(id).checked = true;
                }
                break;
            }
        }
    }
    return false;
}

var defaultContent = document.getElementById('default_content');
var elements = defaultContent.getElementsByTagName('select');
for(var i = 0, l = elements.length; i < l; i++) {
    elements[i].onchange = function() {
        var element = null;
        for(block in blocks) {
            if(blocks[block] == 'default') continue;
            element = document.getElementById(this.id.replace(/^default/, blocks[block]));
            if(element && element.disabled) {
                for(var j = 0, ol = element.options.length; j < ol; j++) {
                    if(element.options[j].value == this.value) {
                        element.value = this.value;
                        element.selectedIndex = j;
                        break;
                    }
                }
            }
        }
    }
}
elements = defaultContent.getElementsByTagName('input');
for(var i = 0, l = elements.length; i < l; i++) {
    if(elements[i].getAttribute('type') == 'text') {
        elements[i].onchange = function() {
            var element = null;
            for(block in blocks) {
                if(blocks[block] == 'default') continue;
                element = document.getElementById(this.id.replace(/^default/, blocks[block]));
                if(element && element.disabled) {
                    element.value = this.value
                }
            }
        }
    } else if(elements[i].getAttribute('type') == 'radio') {
        elements[i].onchange = function() {
            //console.log('this: ', this);
            var element = null, radios = null, rl = null;
            for(block in blocks) {
                if(blocks[block] == 'default') continue;
                radios = document.getElementsByName(this.name.replace(/^default/, blocks[block]));
                //console.log('radios: ', radios);
                rl = radios.length;
                if(rl && radios[0].disabled) {
                    for(var j = 0; j < rl; j++) {
                        //console.log('radios[j]: ', radios[j]);
                        radios[j].checked = false;
                    }
                    element = document.getElementById(this.id.replace(/^default/, blocks[block]));
                    //console.log('element: ', element);
                    if(element) {
                        element.checked = true;
                    }
                }
            }
        }
    }
}


//]]>
</script>
</div>
<br />
