<?php

class MagicScrollEvents {

    public static function onActivate() {

        $oDb = oxDb::getDb();

        $sSQL = <<<SQL
CREATE TABLE IF NOT EXISTS `magicscroll_images` (
 `ID` int UNSIGNED NOT NULL AUTO_INCREMENT,
 `NAME` varchar(64) NOT NULL,
 `TITLE` varchar(64) DEFAULT '',
 `DESCRIPTION` text,
 `LINK` varchar(256) DEFAULT '',
 `ORDER` int UNSIGNED DEFAULT 0,
 `EXCLUDE` int(2) UNSIGNED DEFAULT 0,
 PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
SQL;
        $oDb->execute($sSQL);

        $table = $oDb->getOne("SHOW TABLES LIKE 'magicscroll_config'");
        if($table) {
            $version = $oDb->getOne("SELECT `VALUE` FROM `magicscroll_config` WHERE `BLOCK`='default' AND `NAME`='version'");
            $upgradeVersion = '4.3';
            if(version_compare($version, $upgradeVersion, '<') || $version == 'working') {
                $oDb->execute("DROP TABLE IF EXISTS `magicscroll_config_backup`");
                $oDb->execute("RENAME TABLE `magicscroll_config` TO `magicscroll_config_backup`");
            } else {
                return;
            }
        }

        //DROP TABLE IF EXISTS `magicscroll_config`;
        $sSQL = <<<SQL
CREATE TABLE IF NOT EXISTS `magicscroll_config` (
 `ID` int(11) NOT NULL AUTO_INCREMENT,
 `BLOCK` char(32) NOT NULL,
 `NAME` char(32) NOT NULL,
 `VALUE` text,
 `ENABLED` tinyint(1) UNSIGNED NOT NULL default '0',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
SQL;
        $oDb->execute($sSQL);

        $sSQL = <<<SQL
INSERT INTO `magicscroll_config` (`BLOCK`, `NAME`, `VALUE`, `ENABLED`) VALUES
 ('default', 'thumb-max-width', '450', 1),
 ('default', 'thumb-max-height', '450', 1),
 ('default', 'square-images', 'disable', 1),
 ('default', 'width', 'auto', 1),
 ('default', 'height', 'auto', 1),
 ('default', 'orientation', 'horizontal', 1),
 ('default', 'mode', 'scroll', 1),
 ('default', 'items', '3', 1),
 ('default', 'speed', '600', 1),
 ('default', 'autoplay', '0', 1),
 ('default', 'loop', 'infinite', 1),
 ('default', 'step', 'auto', 1),
 ('default', 'arrows', 'inside', 1),
 ('default', 'pagination', 'No', 1),
 ('default', 'easing', 'cubic-bezier(.8, 0, .5, 1)', 1),
 ('default', 'scrollOnWheel', 'auto', 1),
 ('default', 'lazy-load', 'No', 1),
 ('default', 'scroll-extra-styles', '', 1),
 ('default', 'show-image-title', 'No', 1),
 ('default', 'link-to-product-page', 'Yes', 1),
 ('default', 'resize-images', 'Yes', 1),
 ('default', 'imagemagick', 'off', 1),
 ('default', 'image-quality', '75', 1),
 ('default', 'watermark', '', 1),
 ('default', 'watermark-max-width', '30%', 1),
 ('default', 'watermark-max-height', '30%', 1),
 ('default', 'watermark-opacity', '50', 1),
 ('default', 'watermark-position', 'center', 1),
 ('default', 'watermark-offset-x', '0', 1),
 ('default', 'watermark-offset-y', '0', 1),
 ('product', 'enable-effect', 'Yes', 1),
 ('product', 'thumb-max-width', '250', 1),
 ('product', 'thumb-max-height', '200', 1),
 ('product', 'width', 'auto', 0),
 ('product', 'height', 'auto', 0),
 ('product', 'orientation', 'horizontal', 0),
 ('product', 'mode', 'scroll', 0),
 ('product', 'items', '3', 0),
 ('product', 'speed', '600', 0),
 ('product', 'autoplay', '0', 0),
 ('product', 'loop', 'infinite', 0),
 ('product', 'step', 'auto', 0),
 ('product', 'arrows', 'inside', 1),
 ('product', 'pagination', 'No', 0),
 ('product', 'easing', 'cubic-bezier(.8, 0, .5, 1)', 0),
 ('product', 'scrollOnWheel', 'auto', 0),
 ('product', 'lazy-load', 'No', 0),
 ('product', 'scroll-extra-styles', '', 0),
 ('product', 'show-image-title', 'No', 0),
 ('homeslideshow', 'enable-effect', 'No', 1),
 ('homeslideshow', 'thumb-max-width', '0', 1),
 ('homeslideshow', 'thumb-max-height', '0', 1),
 ('homeslideshow', 'width', 'auto', 0),
 ('homeslideshow', 'height', 'auto', 0),
 ('homeslideshow', 'orientation', 'horizontal', 0),
 ('homeslideshow', 'mode', 'scroll', 0),
 ('homeslideshow', 'items', '3', 0),
 ('homeslideshow', 'speed', '600', 0),
 ('homeslideshow', 'autoplay', '0', 0),
 ('homeslideshow', 'loop', 'infinite', 0),
 ('homeslideshow', 'step', 'auto', 0),
 ('homeslideshow', 'arrows', 'inside', 0),
 ('homeslideshow', 'pagination', 'No', 0),
 ('homeslideshow', 'easing', 'cubic-bezier(.8, 0, .5, 1)', 0),
 ('homeslideshow', 'scrollOnWheel', 'auto', 0),
 ('homeslideshow', 'lazy-load', 'No', 0),
 ('homeslideshow', 'scroll-extra-styles', '', 0),
 ('homeslideshow', 'show-image-title', 'No', 0),
 ('homeslideshow', 'link-to-product-page', 'Yes', 0),
 ('default', 'version', '4.3.18', 1);
SQL;
        $oDb->execute($sSQL);

        if(class_exists('oxRegistry')) {
            $oMyConfig = oxRegistry::getConfig();
        } else {
            //NOTE: for OXID versions < 4.7.0
            $oMyConfig = oxConfig::getInstance();
        }

        //$sOxidVersion = $oMyConfig->getVersion();
        $sTheme = $oMyConfig->getConfigParam('sTheme');
        if($sTheme != 'azure') return;
        $oDb->execute("UPDATE `magicscroll_config` SET `VALUE`='380' WHERE `BLOCK`='product' AND `NAME`='thumb-max-width'");
        $oDb->execute("UPDATE `magicscroll_config` SET `VALUE`='340' WHERE `BLOCK`='product' AND `NAME`='thumb-max-height'");
        $oDb->execute("UPDATE `magicscroll_config` SET `VALUE`='80' WHERE `BLOCK`='product' AND `NAME`='selector-max-width'");
        $oDb->execute("UPDATE `magicscroll_config` SET `VALUE`='80' WHERE `BLOCK`='product' AND `NAME`='selector-max-height'");
        $oDb->execute("UPDATE `magicscroll_config` SET `VALUE`='150' WHERE `BLOCK`='category' AND `NAME`='thumb-max-width'");
        $oDb->execute("UPDATE `magicscroll_config` SET `VALUE`='150' WHERE `BLOCK`='category' AND `NAME`='thumb-max-height'");

    }

    public static function onDeactivate() {

    }

}

?>