<?php

/**
 * Admin MagicScroll Settings manager.
 * Admin Menu: Master Settings -> Magic Scroll Settings.
 * @package magicscroll
 */
class MagicScroll extends oxAdminView {

    protected $sModuleDir = null;
    protected $oTool = null;
    protected $sMessage = null;
    protected $sCurrentTabs = '';
    protected $aImagesData = array();
    protected $sBaseImagePath = '';
    protected $sBaseImageUrl = '';
    protected $bRegistryClassExists = false;//NOTE: 'oxRegistry' class exists since version 4.7.0

    public function __construct() {

        parent::__construct();

        $this->bRegistryClassExists = class_exists('oxRegistry');

        $this->sModuleDir = getShopBasePath().'modules/magicscroll';
        $sCoreFile = $this->sModuleDir.'/classes/magicscroll.module.core.class.php';
        if(file_exists($sCoreFile)) {

            $oDb = oxDb::getDb();

            if($this->bRegistryClassExists) {
                $bReset = oxRegistry::getConfig()->getRequestParameter('reset', false);
            } else {
                //NOTE: for OXID versions < 4.7.0
                $bReset = oxConfig::getParameter('reset');
            }
            $bReset = ($bReset == 'true' ? true : false);

            $oMyConfig = $this->getConfig();
            $this->sBaseImagePath = getShopBasePath().$oMyConfig->getOutDir(false).$oMyConfig->getConfigParam('_sPictureDir').'/master/magicscroll/';
            $this->sBaseImageUrl = $oMyConfig->getOutUrl().$oMyConfig->getConfigParam('_sPictureDir').'/master/magicscroll/';
            $tables = $oDb->getOne("SHOW TABLES LIKE 'magicscroll_images'");
            //NOTE: create table if it does not exists
            if(!$tables) {
                if(!class_exists('MagicScrollEvents')) {
                    include getShopBasePath().'modules/magicscroll/magicscrollevents.php';
                }
                MagicScrollEvents::onActivate();
            }
            $this->aImagesData = $this->getImagesData();

            require_once($sCoreFile);
            $this->oTool = new MagicScrollModuleCoreClass();
            $aRezult = $oDb->getAll("SELECT `BLOCK`, `NAME`, `VALUE` FROM `magicscroll_config` WHERE `ENABLED`=1");

            //NOTE: create or reset settings
            if(!$aRezult || $bReset) {
                if(!class_exists('MagicScrollEvents')) {
                    include getShopBasePath().'modules/magicscroll/magicscrollevents.php';
                }
                MagicScrollEvents::onActivate();
                $aRezult = $oDb->getAll("SELECT `BLOCK`, `NAME`, `VALUE` FROM `magicscroll_config` WHERE `ENABLED`=1");
            }

            foreach($aRezult as $aRow) {
                $this->oTool->params->setValue($aRow[1], $aRow[2], $aRow[0]);
            }
            //NOTE: change subtype for some params to display them like radio
            foreach($this->oTool->params->getParams() as $sParamId => $aParam) {
               if($this->oTool->params->getSubType($sParamId) == 'select' && count($this->oTool->params->getValues($sParamId)) < 6)
                   $this->oTool->params->setSubType($sParamId, 'radio');
            }

        } else {
            $this->sMessage = "Error: file {$sCoreFile} does not exists!";
        }

    }

    public function render() {

        parent::render();

        $oAuthUser = oxNew('oxuser');
        $oAuthUser->loadAdminUser();
        if($oAuthUser->oxuser__oxrights->value == 'malladmin') {
            if($this->sMessage === null) {
                $sTemplateFile = $this->sModuleDir.'/magicscrollsettings.php';
                if(!file_exists($sTemplateFile)) {
                    $this->sMessage = "Error: file {$sTemplateFile} does not exists!";
                }
            }

            //$oSmarty = oxUtilsView::getInstance()->getSmarty();
            if($this->bRegistryClassExists) {
                $oSmarty = oxRegistry::get('oxUtilsView')->getSmarty();
            } else {
                //NOTE: for OXID versions < 4.9.0
                $oSmarty = oxUtilsView::getInstance()->getSmarty();
            }

            $oSmarty->assign('oViewConf', $this->_aViewData['oViewConf']);
            $oSmarty->assign('shop', $this->_aViewData['shop']);
            if($this->sMessage === null) {
                $oTool = &$this->oTool;
                //$shopUrl = $this->_aViewData['oViewConf']->getConfig()->getShopUrl();
                $sImageUrl = $this->getConfig()->getImageUrl($this->isAdmin());
                $sResourceUrl = $this->getConfig()->getResourceUrl('', $this->isAdmin());
                $aImagesData = &$this->aImagesData;
                $sBaseImageUrl = &$this->sBaseImageUrl;
                ob_start();
                require $sTemplateFile;
                $sSettingsTemplateContents = ob_get_contents();
                ob_end_clean();
                $oSmarty->assign('sSettingsContents', $sSettingsTemplateContents);
            } else {
                $oSmarty->assign('sSettingsContents', $this->sMessage);
            }
            echo $oSmarty->fetch('magicscroll.tpl');
            if(method_exists('oxUtils', 'getInstance')) {
                //NOTE: for OXID versions < 4.9.0
                oxUtils::getInstance()->showMessageAndExit('');
            } else {
                oxRegistry::getUtils()->showMessageAndExit('');
            }
        } else {
            return oxUtils::getInstance()->showMessageAndExit('Access denied!');
        }

    }

    public function saveSettings() {

        $oAuthUser = oxNew('oxuser');
        $oAuthUser->loadAdminUser();
        if($oAuthUser->oxuser__oxrights->value === 'malladmin' && $_SERVER['REQUEST_METHOD'] == 'POST') {

            if($this->bRegistryClassExists) {
                $bReset = oxRegistry::getConfig()->getRequestParameter('reset', false);
            } else {
                //NOTE: for OXID versions < 4.7.0
                $bReset = oxConfig::getParameter('reset');
            }
            $bReset = ($bReset == 'true' ? true : false);
            if($bReset) {
                return;
            }

            if(isset($_POST['magic_tabs_current'])) {
                $this->sCurrentTabs = $_POST['magic_tabs_current'];
            }

            $oDb = oxDb::getDb();

            foreach($this->getParamsMap() as $sBlockId => $aGroups) {
                foreach($aGroups as $aGroup) {
                    foreach($aGroup as $sParam) {
                        if(isset($_POST[$sBlockId.'-'.$sParam])) {
                            $sValue = trim($_POST[$sBlockId.'-'.$sParam]);
                            switch($this->oTool->params->getType($sParam)) {
                                case "num":
                                    $sValue = intval($sValue);
                                    break;
                                case "array":
                                    if(!in_array($sValue, $this->oTool->params->getValues($sParam))) $sValue = $this->oTool->params->getDefaultValue($sParam);
                                    break;
                                case "text":
                                    $sValue = addslashes($sValue);
                                    break;
                            }
                            $oDb->execute("UPDATE `magicscroll_config` SET `VALUE`='{$sValue}', `ENABLED`=1 WHERE `BLOCK`='{$sBlockId}' AND `NAME`='{$sParam}'");
                            $this->oTool->params->setValue($sParam, $sValue, $sBlockId);
                        } else {
                            $oDb->execute("UPDATE `magicscroll_config` SET `ENABLED`=0 WHERE `BLOCK`='{$sBlockId}' AND `NAME`='{$sParam}'");
                            if($this->oTool->params->paramExists($sParam, $sBlockId)) {
                                $this->oTool->params->removeParam($sParam, $sBlockId);
                            };
                        }
                    }
                }
            }

            $aImagesData = empty($_POST['images-data']) ? array() : $_POST['images-data'];

            foreach($aImagesData as $iImageId => $aImageData) {
                if(isset($aImageData['delete'])) {
                    $sName = $oDb->getOne("SELECT `NAME` FROM `magicscroll_images` WHERE `ID`={$iImageId}");
                    if(!empty($sName)) {
                        @unlink($this->sBaseImagePath.$sName);
                        $oDb->execute("DELETE FROM `magicscroll_images` WHERE `ID`={$iImageId}");
                    }
                } else {
                    $aImageData['title'] = str_replace('"', '&quot;', $aImageData['title']);
                    $aImageData['title'] = $oDb->quote($aImageData['title']);
                    $aImageData['description'] = str_replace('"', '&quot;', $aImageData['description']);
                    $aImageData['description'] = $oDb->quote($aImageData['description']);
                    $aImageData['link'] = str_replace('"', '&quot;', $aImageData['link']);
                    $aImageData['link'] = $oDb->quote($aImageData['link']);
                    $aImageData['order'] = intval($aImageData['order']);
                    $aImageData['exclude'] = isset($aImageData['exclude']) ? 1 : 0;
                    $oDb->execute(
                        "UPDATE `magicscroll_images` SET ".
                        "`TITLE`={$aImageData['title']}, ".
                        "`DESCRIPTION`={$aImageData['description']}, ".
                        "`LINK`={$aImageData['link']}, ".
                        "`ORDER`={$aImageData['order']}, ".
                        "`EXCLUDE`={$aImageData['exclude']} ".
                        "WHERE `ID`={$iImageId}",
                        false
                    );
                }
            }

            if(!empty($_FILES['magicscroll_image_files']['tmp_name'])) {
                if(is_dir($this->sBaseImagePath) || mkdir($this->sBaseImagePath)) {
                    foreach($_FILES['magicscroll_image_files']['tmp_name'] as $key => $tempName) {
                        if(!empty($tempName) && file_exists($tempName)) {
                            $name = preg_replace('/[^a-zA-Z0-9()_\.-]/is', '', $_FILES['magicscroll_image_files']['name'][$key]);
                            $ext = substr($name, strrpos($name, '.'));
                            $name = substr($name, 0, -strlen($ext));
                            $index = 0;
                            $suffix = '';
                            while(file_exists($this->sBaseImagePath.$name.$suffix.$ext)) {
                                $suffix = "({$index})";
                                $index++;
                            }
                            if(!move_uploaded_file($tempName, $this->sBaseImagePath.$name.$suffix.$ext)) {
                                //An error occurred during the image upload.
                                break;
                            }
                            $oDb->execute("INSERT INTO `magicscroll_images` (`NAME`) VALUES ('{$name}{$suffix}{$ext}')");
                        }
                    }
                }
            }

            $this->aImagesData = $this->getImagesData();

        }

    }

    public function getImagesData() {
        $oDb = oxDb::getDb();
        $aImagesData = array();
        $aRecords = $oDb->getAll("SELECT * FROM `magicscroll_images` ORDER BY `ORDER`");
        foreach($aRecords as $aRecord) {
            $aImagesData[] = array(
                'id' => $aRecord[0],
                'name' => $aRecord[1],
                'title' => $aRecord[2],
                'description' => $aRecord[3],
                'link' => $aRecord[4],
                'order' => $aRecord[5],
                'exclude' => $aRecord[6],
            );
        }
        return $aImagesData;
    }

    public function getParamsBlocks() {
        return array(
			'default' => 'General',
			'product' => 'Product page',
			'homeslideshow' => 'Home page Slideshow',
		);
    }

    public function getParamsMap() {
        return array(
			'default' => array(
				'Positioning and Geometry' => array(
					'thumb-max-width',
					'thumb-max-height',
					'square-images',
				),
				'Scroll' => array(
					'width',
					'height',
					'orientation',
					'mode',
					'items',
					'speed',
					'autoplay',
					'loop',
					'step',
					'arrows',
					'pagination',
					'easing',
					'scrollOnWheel',
					'lazy-load',
					'scroll-extra-styles',
					'show-image-title',
				),
				'Miscellaneous' => array(
					'link-to-product-page',
					'resize-images',
					'imagemagick',
					'image-quality',
				),
				'Watermark' => array(
					'watermark',
					'watermark-max-width',
					'watermark-max-height',
					'watermark-opacity',
					'watermark-position',
					'watermark-offset-x',
					'watermark-offset-y',
				),
			),
			'product' => array(
				'General' => array(
					'enable-effect',
				),
				'Positioning and Geometry' => array(
					'thumb-max-width',
					'thumb-max-height',
				),
				'Scroll' => array(
					'width',
					'height',
					'orientation',
					'mode',
					'items',
					'speed',
					'autoplay',
					'loop',
					'step',
					'arrows',
					'pagination',
					'easing',
					'scrollOnWheel',
					'lazy-load',
					'scroll-extra-styles',
					'show-image-title',
				),
			),
			'homeslideshow' => array(
				'General' => array(
					'enable-effect',
				),
				'Setup slideshow for home page' => array(
				),
				'Positioning and Geometry' => array(
					'thumb-max-width',
					'thumb-max-height',
				),
				'Scroll' => array(
					'width',
					'height',
					'orientation',
					'mode',
					'items',
					'speed',
					'autoplay',
					'loop',
					'step',
					'arrows',
					'pagination',
					'easing',
					'scrollOnWheel',
					'lazy-load',
					'scroll-extra-styles',
					'show-image-title',
				),
				'Miscellaneous' => array(
					'link-to-product-page',
				),
			),
		);
    }


}

?>
