<?php

/**
 * Metadata version
 */
$sMetadataVersion = '1.1';

/**
 * Module information
 */
$aModule = array(
    'id'           => 'magic360',
    'title'        => 'Magic 360',
    'description'  => "Spin products round in 360 degrees and zoom them.",
    //'thumbnail'    => 'magic360.png',
    'version'      => '4.3.18',
    'author'       => 'Magic Toolbox',
    'email'        => 'support@magictoolbox.com',
    'url'          => 'http://www.magictoolbox.com',
    'extend'       => array(
        'oxoutput' => 'magic360/magic360output',
    ),
    'files' => array(
        'magic360events' => 'magic360/magic360events.php',
        'magic360' => '../admin/magic360.php',
        'magic360_images'=> '../admin/magic360_images.php',
    ),
    'events'       => array(
        'onActivate'   => 'magic360events::onActivate',
        'onDeactivate' => 'magic360events::onDeactivate',
    ),

);

if(class_exists('oxRegistry')) {
    $myConfig = oxRegistry::getConfig();
} else {
    //NOTE: for OXID versions < 4.7.0
    $myConfig = oxConfig::getInstance();
}
$aDisabledModules = $myConfig->getConfigParam('aDisabledModules');
if(!is_array($aDisabledModules)) $aDisabledModules = array();
if(in_array('magic360', $myConfig->getConfigParam('aDisabledModules'))) {
    $aModule['description'] .= "<br /><br /><span style=\"color: red;\">Please activate the module and refresh the page (if need it) to access the settings.</span>";
} else {
    $aModule['description'] .= "<br /><br /><span style=\"color: green;\">Change the settings as you wish via the <b>Master Settings</b> -> <b>Magic 360 Settings</b> menu.</span>";
}
