<style type="text/css">
* {
    font-family: Arial,Verdana,Helvetica,sans-serif;
}
#container {
    margin: 0 auto;
    text-align: left;
    width: 960px;
    background-color: #FFFFFF;
    color: #000000;
    font-size: 12px;
    border: 1px solid #CC9933;
    padding: 20px;
    border-radius: 5px;
}
h2 {
    color: #268CCD;
    font-size: 1.4em;
    margin: 0 0 0.83em;
}
fieldset {
    background: none repeat scroll 0 0 #FFFFF0;
    border: 1px solid #DFD5C3;
    font-size: 1.1em;
    margin: 0;
    padding: 1em;
    border-radius: 5px;
}
legend {
    font-family: Trebuchet,Arial,Helvetica,sans-serif;
    background: none repeat scroll 0 0 #FFF6D3;
    border: 1px solid #DFD5C3;
    font-weight: 700;
    margin: 0;
    padding: 0.2em 0.5em;
    text-align: left;
    border-radius: 5px;
}
label {
    float: left;
    font-weight: bold;
    padding: 0.2em 0.5em 0 0;
    /*padding: 0;*/
    text-align: right;
    width: 200px;
}
.margin-form {
    color: #7F7F7F;
    font-size: 0.85em;
    padding: 0 0 1em 210px;
}
.clear {
    clear: both;
}
.pspace {
    padding-top: 1em;
}
input[type="text"], input[type="password"], input[type="file"], textarea {
    border: 1px solid #E0D0B1;
}
input[type="text"], input[type="password"], input[type="file"], textarea, select, option {
    background-color: #FFFFFF;
}
input[type="text"], input[type="password"], input[type="file"], textarea {
    padding: 2px 4px;
}
input[type="radio"], input[type="checkbox"] {
    background-color: transparent;
}
input, textarea, option {
    color: #000000;
    font-size: 12px;
    margin: 0;
    padding: 0;
}
input {
    vertical-align: middle;
}
input[disabled] {
    color: #AFADAA;
}
select {
    border: 1px solid #E0D0B1;
    font-size: 12px;
}
label.t {
    clear: none;
    float: none;
    font-size: 12px;
    font-weight: bold;
    margin: 0;
    /*padding: 0;*/
    padding: 0 4px;
    /*padding:0.2em 0 0; */
    width: auto;
}
label img {
   vertical-align: bottom;
   padding: 0 4px 0 0;
}
.button {
    background-color: #FFF6D3;
    border-color: #FFF6D3 #DFD5AF #DFD5AF #FFF6D3;
    border-right: 1px solid #DFD5AF;
    border-style: solid;
    border-width: 1px;
    color: #268CCD;
    padding: 3px;
    border-radius: 5px;
    cursor: pointer;
}
div.buttons-container {
    text-align: center;
}
div.buttons-container input {
    padding: 5px;
    border-radius: 5px;
    margin: 5px 0;
}
div.buttons-container-fixed {
    background: none repeat scroll 0 0 #EFEFDE;
    border-bottom: 1px solid #988753;
    opacity: 0.85;
    position: fixed;
    left: 0;
    top: 0;
    width: 100%;
    z-index: 1000;
}
div.buttons-container-fixed input {
    margin: 5px 0;
}

.hint {
    background-color: #FFFFCC;
    border: 1px solid #CC9933;
    color: #7F7F7F;
    display: block;
    left: 0px;
    margin-bottom: 2px;
    margin-top: 4px;
    padding: 6px;
    position: relative;
    width: 501px;
}
#magicscroll_icon {
    float: left;
    margin: 0 5px 5px 0;
}
.margin-form a, .margin-form a:hover, .margin-form a:visited {
    color: #CC9933;
}

.magic_tabs { margin: 0; padding: 0; float: left; width: 132px; position: relative; z-index: 1; }
.magic_tabs li { list-style-type: none; margin: 0; padding: 0; }
.magic_tabs a { display: inline-block; width: 120px; margin-bottom: -1px; border: 1px solid #CC9933; color: #CC9933; font-weight: bold; line-height: 22px; margin-right: -1px; padding: 2px 5px; text-decoration: none; background: #f2f2f2; font-size: 12px; border-top-left-radius: 5px; border-bottom-left-radius: 5px; }
.magic_tabs a.tabactive { text-decoration: none; color: #000; font-weight: bold; background: #fff; border-right: none; width: 121px;}
.magic_tabs li a:hover { background: #CC9933; color: #fff; text-decoration: none; border-right: none; }
.magic_tabs li a.tabactive:hover { background: #fff; color: #000; }
.magic_tabCont { display: none; border: 1px solid #CC9933; padding: 10px; border-top-right-radius: 5px; border-bottom-right-radius: 5px; border-bottom-left-radius: 5px; }
.magic_tabContWrapper { float: left; width: 790px; clear: right; margin: 0; margin-left: -1px;}
.magic_tabCont.magic_active { display: block; }
.magic_tabCont div.margin-form label { padding: 0 4px; }
.magic_tabCont label { padding: 0; width: 200px; }
.magic_tabCont .margin-form label { padding: 0.2em 0 0; margin-right: 10px; width: auto; }
.magic_tabCont .margin-form { padding-top: 1px !important; padding-left: 210px !important; }
.magic_hint {
    display: block;
    position: relative;
    left: 0px;
    width: 396px;
    margin-top: 4px;
    margin-bottom: 2px;
    border: 1px solid #c93;
    padding: 6px;
    color: #7F7F7F;
    background-color: #ffc;
}
.margin-form input[type=text] {
    width: 400px;
}
.magic_tabCont fieldset { margin: 17px 0px; }
#magicscroll_icon {
    float: left;
    margin: 0 5px 5px 0;
}
</style>
<div id="container">
<h2 id="title">Magic 360 configuration</h2>
<div id="buttons-container-wrapper">
    <div id="buttons-container" class="buttons-container">
        <input class="button" type="submit" id="magic_submit" name="magic_submit" value="Save settings" />
        <input class="button" type="button" value="Reset settings" onclick="resetSettings()" />
    </div>
</div>
<ul class="magic_tabs">
<?php foreach($this->getParamsBlocks() as $sBlockId => $sBlockTitle) { ?>
<li><a id="<?php echo $sBlockId; ?>" onclick="return magic_changeTab(this);" <?php if($sBlockId == 'product') echo 'class="tabactive" '; ?>href="#"><?php echo $sBlockTitle; ?></a></li>
<?php } ?>
</ul>
<div class="magic_tabContWrapper">
<?php foreach($this->getParamsMap() as $sBlockId => $aGroups) {
    $oTool->params->setProfile($sBlockId);
?>
<div id="<?php echo $sBlockId; ?>_content" class="magic_tabCont<?php if($sBlockId == 'product') echo ' magic_active'; ?>">
    <?php foreach($aGroups as $sGroupTitle => $aParams) { ?>
    <fieldset>
    <legend><?php echo $sGroupTitle; ?></legend>
        <?php foreach($aParams as $sParamId) {
            $sParamValue = $oTool->params->getValue($sParamId);
            $blParamEnable = true;
        ?>
        <label for="<?php echo $sBlockId.'-'.$sParamId; ?>"><?php echo $oTool->params->getLabel($sParamId); ?></label>
        <div class="margin-form">
        <?php
        switch($oTool->params->getType($sParamId)) {
            case "array":
                if($oTool->params->getSubType($sParamId, $oTool->params->generalProfile) == 'radio') {
                    foreach($oTool->params->getValues($sParamId) as $sValue) {
                        ?><input type="radio" value="<?php echo $sValue; ?>"<?php echo (($sParamValue == $sValue)?' checked="checked"':''); ?><?php echo $blParamEnable ? '' : ' disabled="disabled"'; ?> name="<?php echo $sBlockId.'-'.$sParamId; ?>" id="<?php echo $sBlockId.'-'.$sParamId.'-'.$sValue; ?>" /><?php
                        ?><label class="t" for="<?php echo $sBlockId.'-'.$sParamId.'-'.$sValue; ?>"><?php
                        $sValueLower = strtolower($sValue);
                        if($sValueLower == "yes")
                            echo '<img src="'.$sImageUrl.'magic360/yes.gif" alt="Enabled" title="Enabled" />';
                        else if($sValueLower == "no")
                            echo '<img src="'.$sImageUrl.'magic360/no.gif" alt="Disabled" title="Disabled" />';
                        else if($sValueLower == "left")
                            echo '<img src="'.$sImageUrl.'magic360/left.gif" alt="Left" title="Left" />';
                        else if($sValueLower == "right")
                            echo '<img src="'.$sImageUrl.'magic360/right.gif" alt="Right" title="Right" />';
                        else if($sValueLower == "top")
                            echo '<img src="'.$sImageUrl.'magic360/top.gif" alt="Top" title="Top" />';
                        else if($sValueLower == "bottom")
                            echo '<img src="'.$sImageUrl.'magic360/bottom.gif" alt="Bottom" title="Bottom" />';
                        else echo $sValue;
                        ?></label><?php
                    }
                } else if($oTool->params->getSubType($sParamId, $oTool->params->generalProfile) == 'select') {
                    ?><select name="<?php echo $sBlockId.'-'.$sParamId; ?>" id="<?php echo $sBlockId.'-'.$sParamId; ?>"<?php echo $blParamEnable ? '' : ' disabled="disabled"'; ?>><?php
                    foreach($oTool->params->getValues($sParamId) as $sValue) {
                        ?><option value="<?php echo $sValue; ?>"<?php echo (($sParamValue==$sValue)?' selected="selected"':''); ?>><?php echo $sValue; ?></option><?php
                    }
                    ?></select><?php
                } else {
                    ?><input type="text" name="<?php echo $sBlockId.'-'.$sParamId; ?>" id="<?php echo $sBlockId.'-'.$sParamId; ?>" value="<?php echo $sParamValue; ?>"<?php echo $blParamEnable ? '' : ' disabled="disabled"'; ?> /><?php
                }
                break;
            case "num":
            case "text":
            default:
                ?><input type="text" name="<?php echo $sBlockId.'-'.$sParamId; ?>" id="<?php echo $sBlockId.'-'.$sParamId; ?>" value="<?php echo $sParamValue; ?>"<?php echo $blParamEnable ? '' : ' disabled="disabled"'; ?> /><?php
        }
        $sHint = '';
        if($oTool->params->getDescription($sParamId))
            $sHint = $oTool->params->getDescription($sParamId);
        if($oTool->params->getType($sParamId) != "array" && $oTool->params->valuesExists($sParamId, '', false)) {
            if($sHint != '') $sHint .= "<br />";
            $sHint .= "#allowed values: ".implode(", ",$oTool->params->getValues($sParamId));
        }
        if($sHint != '') {
            ?><p class="magic_hint clear"><?php echo $sHint; ?></p><?php
        }
        ?>
        </div>
        <div class="clear pspace"></div>
        <?php } ?>
    </fieldset>
    <?php } ?>
</div>
<?php } ?>
</div>
<div class="clear pspace"></div>
<input type="hidden" id="magic_tabs_current" name="magic_tabs_current" value="default" />
<script type="text/javascript">
//<![CDATA[

function resetSettings() {
    document.myedit.reset.value = 'true';
    document.myedit.magic_submit.click();
}

var magic_tabs_current = 'default';
function magic_changeTab(elm) {
    if(document.getElementById(magic_tabs_current)) {
        document.getElementById(magic_tabs_current).className = '';
        document.getElementById(magic_tabs_current+'_content').className = 'magic_tabCont';
    }
    magic_tabs_current = document.getElementById('magic_tabs_current').value = elm.id;
    document.getElementById(magic_tabs_current).className = 'tabactive';
    document.getElementById(magic_tabs_current+'_content').className = 'magic_tabCont magic_active';
    elm.blur();
    return false;
}
function scrollHandler() {
    var buttonsContainer = document.getElementById('buttons-container');
    var buttonsContainerWrapper = buttonsContainer.parentNode;
    if(typeof(buttonsContainerWrapper.getBoundingClientRect) == 'undefined') return;
    var buttonsContainerWrapperBox = buttonsContainerWrapper.getBoundingClientRect();
    if(buttonsContainerWrapperBox.top < 0) {
        magicToolboxAddClass(buttonsContainer, 'buttons-container-fixed');
        //buttonsContainer.style.width = buttonsContainerWrapperBox.width+'px';
        //buttonsContainer.style.left = buttonsContainerWrapperBox.left+'px';
    } else {
        magicToolboxRemoveClass(buttonsContainer, 'buttons-container-fixed');
    }
}
if(window.addEventListener) {
    window.addEventListener('scroll', scrollHandler, false);
    window.addEventListener('resize', scrollHandler, false);
} else {
    window.attachEvent('scroll', scrollHandler);
    window.attachEvent('resize', scrollHandler);
}
//]]>
</script>
<script type="text/javascript">
//<![CDATA[
var blocks = ["<?php echo implode('", "', array_keys($this->getParamsBlocks())); ?>"];
function magicToolboxHasClass(element, className) {
    return element.className.match(new RegExp('(\\s|^)'+className+'(\\s|$)'));
}
function magicToolboxAddClass(element, className) {
    if(!this.magicToolboxHasClass(element, className)) element.className += " "+className;
}
function magicToolboxRemoveClass(element, className) {
    if(magicToolboxHasClass(element, className)) {
        var reg = new RegExp('(\\s|^)'+className+'(\\s|$)');
        element.className = element.className.replace(reg, ' ');
    }
}


//]]>
</script>
</div>
<br />
