<?php

//class Magic360Output extends oxOutput {
class Magic360Output extends Magic360Output_parent {

    public $aSavedViewData = null;

    public $aProcessedBlocks = array();

    public $aMagic360ClassNamesMapping = array(
        'details' => 'product',
    );

    public $blIsAJAX = false;

    public $blMixedMode = false;
    public $s360HTML = '';

    public function __construct() {
        parent::__construct();
        $this->blIsAJAX = isset($_SERVER['HTTP_X_REQUESTED_WITH']) && ($_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest');
        if($this->blIsAJAX) {
            //NOTE: for product variants (when refreshing product images via ajax) (~ OXID 4.8.3)
            $this->aMagic360ClassNamesMapping['oxwarticledetails'] = 'product';
        }

    }

    public function process($sOutput, $sClassName) {

        if(!isset($this->aMagic360ClassNamesMapping[$sClassName])) return parent::process($sOutput, $sClassName);

        $sPage = $this->aMagic360ClassNamesMapping[$sClassName];

        $oTool = $this->getMagic360Tool();

        if(!$oTool->params->profileExists($sPage) || $oTool->params->checkValue('enable-effect', 'No', $sPage)) {
            return parent::process($sOutput, $sClassName);
        }
        $oTool->params->setProfile($sPage);

        $sOutput = parent::process($sOutput, $sClassName);

        if($this->blMixedMode) return $sOutput;

        //NOTE: after parent process
        if($this->aSavedViewData === null) return $sOutput;

        //NOTE: if the block has been processed by another MagicToolbox module
        if(isset($this->aProcessedBlocks[$sPage])) return $sOutput;

        $aViewData = &$this->aSavedViewData;

        $blOutputHeaders = false;
        $blProductHasVariants = false;
        $blProductHasParent = false;//NOTE: variant of product

        $oMyConfig = $this->getConfig();

        $sBaseShopUrl = $oMyConfig->getShopUrl();

        switch($sPage) {
            case 'product':

                $oProduct = (isset($aViewData['product']) && $aViewData['product']) ? $aViewData['product'] : $aViewData['oView']->getProduct();

                //NOTICE: oxarticles__oxartnum may not be unique and contain not desirable symbols
                //    but oxarticles__oxid, on the other hand, can contains strange value like this "be642cad637adf214.28850610"
                //$sOXID = $sProductId = isset($oProduct->oxarticles__oxartnum->value) ? $oProduct->oxarticles__oxartnum->value : null;
                $sOXID = isset($oProduct->oxarticles__oxid->value) ? $oProduct->oxarticles__oxid->value : null;

                //$varselid = oxConfig::getParameter('varselid');//array
                            //oxRegistry::getConfig()->getConfigParam('varselid');
                if(class_exists('oxRegistry')) {
                    $varselid = oxRegistry::getConfig()->getRequestParameter('varselid', false);
                } else {
                    //NOTE: for OXID versions < 4.7.0
                    $varselid = oxConfig::getParameter('varselid');//array
                }

                $blProductHasParent = method_exists($oProduct, 'getParentId') ? ($oProduct->getParentId() ? true : false) : false;

                //NOTE: for product variants (when refreshing product images via ajax)
                if(isset($_POST['renderPartial']) || $this->blIsAJAX/* ~ OXID 4.8.3 */ || $varselid/* ~ OXID 4.8.7 */) {
                    $aVariantSelections = $oProduct->getVariantSelections($varselid);

                    if($aVariantSelections && isset($aVariantSelections['oActiveVariant'])) {
                        $oProduct = $aVariantSelections['oActiveVariant'];
                        $sOXID = isset($oProduct->oxarticles__oxid->value) ? $oProduct->oxarticles__oxid->value : null;
                    }

                    //NOTE: include script to turn on tool before ajax refresh
                    $sOutput .= '
<script type="text/javascript">
    setTimeout(function() {
        if(typeof(Magic360) == "udefined") return;
        var mtOXID = "'.$sOXID.'";
        var mainEl = document.getElementById("productMagic360");
        if(!mainEl) return;
        Magic360.start(mainEl);
    }, 500);
    if(typeof(Magic360) !== "udefined") {
        magictoolboxBindProductForm("'.$sOXID.'");
    }
</script>';
                } else if(method_exists($aViewData['oView'], 'getVariantSelections') && $aViewData['oView']->getVariantSelections()) {
                    //NOTE: always include headers if product has variants
                    $blProductHasVariants = true;
                }

                $aGallery = array();
                $oDb = oxDb::getDb();
                $aRezult = $oDb->getAll("SELECT `GALLERY`, `COLUMNS` FROM `magic360_images` WHERE `OXID`='{$sOXID}'");
                if(empty($aRezult)) break;
                $aGallery = empty($aRezult[0][0]) ? array() : explode(';', $aRezult[0][0]);
                //NOTE: 'default' is not suitable for product variants
                //$oTool->params->setValue('columns', $aRezult[0][1], 'default');
                $oTool->params->setValue('columns', $aRezult[0][1], 'product');
                $iImagesCount = count($aGallery);
                if(!$iImagesCount) break;


                $aMagic360Data = array();

                $i = 1;

                foreach($aGallery as $iIndex => $sImagePath) {

                    $sImg = $sBaseShopUrl.$this->createMagic360Thumb($sImagePath, 'original', $sOXID);
                    $sMedium = $sBaseShopUrl.$this->createMagic360Thumb($sImagePath, 'thumb', $sOXID);

                    $aMagic360Data[] = array(
                        'medium' => $sMedium,
                        'img' => $sImg,
                    );

                    $i++;

                }


                if($iImagesCount > 1) {
                    $sPattern = '(<div\b[^>]*?\bclass\s*+=\s*+"[^"]*?\b(?:morepics|otherPictures)\b[^"]*+"[^>]*+>)'.
                                '('.
                                '(?:'.
                                    '[^<]++'.
                                    '|'.
                                    '<(?!/?div\b|!--)'.
                                    '|'.
                                    '<!--.*?-->'.
                                    '|'.
                                    '<div\b[^>]*+>'.
                                        '(?2)'.
                                    '</div\s*+>'.
                                ')*+'.
                                ')'.
                                '</div\s*+>';
                    //NOTE: cut selectors
                    $sOutput = preg_replace('#'.$sPattern.'#is', '', $sOutput);
                }

                $sReplace = $oTool->getMainTemplate($aMagic360Data, array("id" => "productMagic360"));
                $sReplace = '<div class="MagicToolboxContainer minWidth">'.$sReplace.'</div>';

                //NOTE: insert main template HTML
                $sActPicture = $aViewData['oView']->getActPicture();
                $sPattern = '<img\b[^>]*?src="[^"]*?/'.preg_quote(basename($sActPicture)).'"[^>]*+>';
                $sPattern = '(?:<a\b[^>]*+>[^<]*+'.$sPattern.'[^<]*+</a>|'.$sPattern.')';
                $sContainerPattern = '(<div\b[^>]+?class="[^"]*?picture[^"]*+"[^>]*+>)[^<]*+'.$sPattern.'[^<]*+(</div>)';
                $aMatches = array();
                if(preg_match('#'.$sContainerPattern.'#is', $sOutput, $aMatches)) {
                    //NOTE: fix line-height
                    $aMatches[1] = preg_replace('#class="([^"]*+)"#is', 'class="$1 pictureLineHeight"', $aMatches[1]);
                    $sOutput = str_replace($aMatches[0], $aMatches[1].$sReplace.$aMatches[2], $sOutput);
                } else {
                    $sOutput = preg_replace('#'.$sPattern.'#is', $sReplace, $sOutput, 1);
                }

                //NOTE: remove some extra elements
                //NOTE: zoom link
                $sOutput = preg_replace('#<a\b[^>]*?id="(?:zoomTrigger|test_zoom)"[^>]*+>.*?</a>#is', '', $sOutput);
                //NOTE: modal zoom
                $zoomModalPattern = '<div\b[^>]*?\bid\s*+=\s*+"(?:zoomModal|zoom)"[^>]*+>'.
                                    '('.
                                    '(?:'.
                                        '[^<]++'.
                                        '|'.
                                        '<(?!/?div\b|!--)'.
                                        '|'.
                                        '<!--.*?-->'.
                                        '|'.
                                        '<div\b[^>]*+>'.
                                            '(?1)'.
                                        '</div\s*+>'.
                                    ')*+'.
                                    ')'.
                                    '</div\s*+>';
                $sOutput = preg_replace('#'.$zoomModalPattern.'#is', '', $sOutput);

                //NOTE: include headers
                $blOutputHeaders = true;

                $this->aProcessedBlocks[$sPage] = 'magic360';

            break;

        }

        //NOTE: if this is a variant of product, we need to display headers for parent product or another variant of product
        if(!$blOutputHeaders && !$blProductHasVariants && !$blProductHasParent) return $sOutput;

        $oTool->params->resetProfile();

        $aHeaders = array();
        $aHeaders[] = $oTool->getHeadersTemplate($sBaseShopUrl.'modules/magic360/resources');

        if($sPage == 'product') {
            //NOTE: include script to turn off tool before ajax refresh
            $aHeaders[] = '
<script type="text/javascript">
    function magictoolboxBindProductForm(id) {
        if(typeof($) == "undefined") return;
        $(".oxProductForm, .js-oxProductForm, .js-oxWidgetReload").submit(function() {
            var mainEl = document.getElementById("productMagic360");
            if(!mainEl) return;
            Magic360.stop(mainEl);
        });
    }

    mjsAddEventMethod = \'je1\';
    if(typeof(magicJS.Doc.je1) == \'undefined\') mjsAddEventMethod = \'jAddEvent\';
    $mjs(window)[mjsAddEventMethod]("load", function() {
        if(typeof(Magic360) == "udefined") return;
        magictoolboxBindProductForm("'.$sOXID.'");
    });
</script>
';
        }

        $sOutput = preg_replace('#</head>#is', implode($aHeaders).'</head>', $sOutput, 1);

        return $sOutput;
    }

    public function processViewArray($aViewData, $sClassName) {
        if(isset($this->aMagic360ClassNamesMapping[$sClassName]) && $this->aSavedViewData === null) {
            $this->aSavedViewData = $aViewData;
        }
        return parent::processViewArray($aViewData, $sClassName);
    }

    public function &getMagic360Tool($blGetScrollTool = false) {
        static $oTool = null;
        static $oScrollTool = null;
        if($oTool === null) {
            require_once(dirname(__FILE__).'/classes/magic360.module.core.class.php');
            $oTool = new Magic360ModuleCoreClass();
            $oDb = oxDb::getDb();
            $aRezult = $oDb->getAll("SELECT `BLOCK`, `NAME`, `VALUE` FROM `magic360_config` WHERE `ENABLED`=1");

            //NOTE: create settings if it does not exists
            if(!$aRezult) {
                if(!class_exists('Magic360Events')) {
                    include getShopBasePath().'modules/magic360/magic360events.php';
                }
                Magic360Events::onActivate();
                $aRezult = $oDb->getAll("SELECT `BLOCK`, `NAME`, `VALUE` FROM `magic360_config` WHERE `ENABLED`=1");
            }

            foreach($aRezult as $aRow) {
                $oTool->params->setValue($aRow[1], $aRow[2], $aRow[0]);
            }

        }
        return $blGetScrollTool ? $oScrollTool : $oTool;
    }

    public function getMagic360Blocks() {
        return array(
			'product' => 'Product page',
		);
    }

    public function createMagic360Thumb($sSrc, $sType, $sProductId = null) {
        static $oImageHelper = null;
        if($oImageHelper === null) {
            $oMyConfig = $this->getConfig();
            //$sCacheDirRel = str_replace(getShopBasePath(), '/', $myConfig->getConfigParam('sCompileDir')).'magictoolbox_cache';
            $sCacheDirRel = '/'.$oMyConfig->getOutDir(false).$oMyConfig->getConfigParam('_sPictureDir').'/magictoolbox_cache';

            //NOTE: we can't reproduce this issue, but it appear on most customers sites. So this is a fix
            //NOTE: maybe we don't need it any more
            //$sPref = substr($sCacheDirRel, 0, 5);
            //if($sPref == '/home') {
            //    $sCacheDirRel = substr($sCacheDirRel, 5);
            //} else {
            //    $sPref = '';
            //}

            $oTool = $this->getMagic360Tool();
            require_once(dirname(__FILE__).'/classes/magictoolbox.imagehelper.class.php');
            $oImageHelper = new MagicToolboxImageHelperClass(/*$sPref.*/getShopBasePath(), $sCacheDirRel, $oTool->params);
        }
        return preg_replace('/^\//is', '', $oImageHelper->create('/out/pictures/master/magic360/'.$sSrc, $sType, $sProductId));
    }

}

?>
