<?php

class Magic360Events {

    public static function onActivate() {

        $oDb = oxDb::getDb();

        $sSQL = <<<SQL
CREATE TABLE IF NOT EXISTS `magic360_images` (
 `OXID` char(32) NOT NULL,
 `GALLERY` text,
 `COLUMNS` tinyint(2) UNSIGNED NOT NULL,
  PRIMARY KEY (`OXID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
SQL;
        $oDb->execute($sSQL);

        $table = $oDb->getOne("SHOW TABLES LIKE 'magic360_config'");
        if($table) {
            $version = $oDb->getOne("SELECT `VALUE` FROM `magic360_config` WHERE `BLOCK`='default' AND `NAME`='version'");
            $upgradeVersion = '4.3';
            if(version_compare($version, $upgradeVersion, '<') || $version == 'working') {
                $oDb->execute("DROP TABLE IF EXISTS `magic360_config_backup`");
                $oDb->execute("RENAME TABLE `magic360_config` TO `magic360_config_backup`");
            } else {
                return;
            }
        }

        //DROP TABLE IF EXISTS `magic360_config`;
        $sSQL = <<<SQL
CREATE TABLE IF NOT EXISTS `magic360_config` (
 `ID` int(11) NOT NULL AUTO_INCREMENT,
 `BLOCK` char(32) NOT NULL,
 `NAME` char(32) NOT NULL,
 `VALUE` text,
 `ENABLED` tinyint(1) UNSIGNED NOT NULL default '0',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
SQL;
        $oDb->execute($sSQL);

        $sSQL = <<<SQL
INSERT INTO `magic360_config` (`BLOCK`, `NAME`, `VALUE`, `ENABLED`) VALUES
 ('product', 'enable-effect', 'Yes', 1),
 ('product', 'magnify', 'Yes', 1),
 ('product', 'magnifier-width', '80%', 1),
 ('product', 'magnifier-shape', 'inner', 1),
 ('product', 'fullscreen', 'Yes', 1),
 ('product', 'spin', 'drag', 1),
 ('product', 'autospin-direction', 'clockwise', 1),
 ('product', 'sensitivityX', '50', 1),
 ('product', 'sensitivityY', '50', 1),
 ('product', 'mousewheel-step', '1', 1),
 ('product', 'autospin-speed', '3600', 1),
 ('product', 'smoothing', 'Yes', 1),
 ('product', 'autospin', 'once', 1),
 ('product', 'autospin-start', 'load,hover', 1),
 ('product', 'autospin-stop', 'click', 1),
 ('product', 'initialize-on', 'load', 1),
 ('product', 'start-column', '1', 1),
 ('product', 'start-row', 'auto', 1),
 ('product', 'loop-column', 'Yes', 1),
 ('product', 'loop-row', 'No', 1),
 ('product', 'reverse-column', 'No', 1),
 ('product', 'reverse-row', 'No', 1),
 ('product', 'column-increment', '1', 1),
 ('product', 'row-increment', '1', 1),
 ('product', 'thumb-max-width', '250', 1),
 ('product', 'thumb-max-height', '200', 1),
 ('product', 'square-images', 'disable', 1),
 ('product', 'show-message', 'Yes', 1),
 ('product', 'message', 'Drag image to spin', 1),
 ('product', 'loading-text', 'Loading...', 1),
 ('product', 'fullscreen-loading-text', 'Loading large spin...', 1),
 ('product', 'hint', 'Yes', 1),
 ('product', 'hint-text', 'Drag to spin', 1),
 ('product', 'mobile-hint-text', 'Swipe to spin', 1),
 ('product', 'imagemagick', 'off', 1),
 ('product', 'image-quality', '75', 1),
 ('product', 'icon', 'master/magic360/360icon.png', 1),
 ('product', 'watermark', '', 1),
 ('product', 'watermark-max-width', '30%', 1),
 ('product', 'watermark-max-height', '30%', 1),
 ('product', 'watermark-opacity', '50', 1),
 ('product', 'watermark-position', 'center', 1),
 ('product', 'watermark-offset-x', '0', 1),
 ('product', 'watermark-offset-y', '0', 1),
 ('default', 'version', '4.3.18', 1);
SQL;
        $oDb->execute($sSQL);

        if(class_exists('oxRegistry')) {
            $oMyConfig = oxRegistry::getConfig();
        } else {
            //NOTE: for OXID versions < 4.7.0
            $oMyConfig = oxConfig::getInstance();
        }

        //$sOxidVersion = $oMyConfig->getVersion();
        $sTheme = $oMyConfig->getConfigParam('sTheme');
        if($sTheme != 'azure') return;
        $oDb->execute("UPDATE `magic360_config` SET `VALUE`='380' WHERE `BLOCK`='product' AND `NAME`='thumb-max-width'");
        $oDb->execute("UPDATE `magic360_config` SET `VALUE`='340' WHERE `BLOCK`='product' AND `NAME`='thumb-max-height'");
        $oDb->execute("UPDATE `magic360_config` SET `VALUE`='80' WHERE `BLOCK`='product' AND `NAME`='selector-max-width'");
        $oDb->execute("UPDATE `magic360_config` SET `VALUE`='80' WHERE `BLOCK`='product' AND `NAME`='selector-max-height'");
        $oDb->execute("UPDATE `magic360_config` SET `VALUE`='150' WHERE `BLOCK`='category' AND `NAME`='thumb-max-width'");
        $oDb->execute("UPDATE `magic360_config` SET `VALUE`='150' WHERE `BLOCK`='category' AND `NAME`='thumb-max-height'");

    }

    public static function onDeactivate() {

    }

}

?>