<?php

/**
 * Admin Magic360 Images manager.
 * Admin Menu: Manage Products -> Articles -> Magic360 Images.
 * @package magic360
 */
class Magic360_Images extends oxAdminDetails {


    /**
     * Loads Magic360 data, passes data to Smarty
     * engine, returns name of template file "magic360_images.tpl".
     *
     * @return string
     */
    public function render() {

        parent::render();

        $this->_aViewData['aMagic360Images'] = array();
        $this->_aViewData['iMagic360ImagesCount'] = 0;
        $this->_aViewData['iMagic360Columns'] = 0;
        $this->_aViewData['iMagic360Rows'] = 0;
        $this->_aViewData['blMultiRows'] = false;

        if(method_exists($this, 'getEditObjectId')) {
            $sOXID = $this->getEditObjectId();
        } else {
            //$sOXID = oxConfig::getParameter('oxid');
            if(class_exists('oxRegistry')) {
                $sOXID = oxRegistry::getConfig()->getRequestParameter('oxid', false);
            } else {
                //NOTE: for OXID versions < 4.7.0
                $sOXID = oxConfig::getParameter('oxid');
            }
        }

        if($sOXID != '-1' && isset($sOXID)) {
            $oDb = oxDb::getDb();
            $aRezult = $oDb->getAll("SELECT `GALLERY`, `COLUMNS` FROM `magic360_images` WHERE `OXID`='{$sOXID}'");
            if(!empty($aRezult)) {
                $oMyConfig = $this->getConfig();
                $sBaseImageUrl = $oMyConfig->getOutUrl()./*'/'.*/$oMyConfig->getConfigParam('_sPictureDir').'/master/magic360/';
                $this->_aViewData['sBaseImageUrl'] = $sBaseImageUrl;
                $this->_aViewData['aMagic360Images'] = empty($aRezult[0][0]) ? array() : explode(';', $aRezult[0][0]);
                $this->_aViewData['iMagic360ImagesCount'] = count($this->_aViewData['aMagic360Images']);
                $this->_aViewData['iMagic360Columns'] = $aRezult[0][1];
                if($aRezult[0][1]) {
                    if($aRezult[0][1] < $this->_aViewData['iMagic360ImagesCount']) {
                        $this->_aViewData['iMagic360Rows'] = floor($this->_aViewData['iMagic360ImagesCount']/intval($aRezult[0][1]));
                        $this->_aViewData['blMultiRows'] = true;
                    } else {
                        $this->_aViewData['iMagic360Rows'] = 1;
                    }
                }
            }
        }

        return 'magic360_images.tpl';

    }

    /**
     * Uploads images to server.
     * Save multi-row options
     * Deletes selected master picture.
     * Deletes all master pictures.
     *
     * @return null
     */
    public function applyChanges() {

        $bRegistryClassExists = class_exists('oxRegistry');

        if(method_exists($this, 'getEditObjectId')) {
            $sOXID = $this->getEditObjectId();
        } else {
            //$sOXID = oxConfig::getParameter('oxid');
            if($bRegistryClassExists) {
                $sOXID = oxRegistry::getConfig()->getRequestParameter('oxid', false);
            } else {
                //NOTE: for OXID versions < 4.7.0
                $sOXID = oxConfig::getParameter('oxid');
            }
        }

        $oMyConfig = $this->getConfig();
        $sBaseImagePath = getShopBasePath().$oMyConfig->getOutDir(false).$oMyConfig->getConfigParam('_sPictureDir').'/master/magic360/';
        $sBaseImageUrl = $oMyConfig->getOutUrl()./*'/'.*/$oMyConfig->getConfigParam('_sPictureDir').'/master/magic360/';

        $sGallery = '';
        $aGallery = array();
        $iColumns = 0;
        $oDb = oxDb::getDb();
        $aRezult = $oDb->getAll("SELECT `GALLERY`, `COLUMNS` FROM `magic360_images` WHERE `OXID`='{$sOXID}'");
        if(!empty($aRezult)) {
            $aGallery = empty($aRezult[0][0]) ? array() : explode(';', $aRezult[0][0]);
            $iColumns = $aRezult[0][1];
        }
        $iImagesCount = count($aGallery);

        //$sMode = oxConfig::getParameter('fncmode');
        if($bRegistryClassExists) {
            $sMode = oxRegistry::getConfig()->getRequestParameter('fncmode', false);
        } else {
            //NOTE: for OXID versions < 4.7.0
            $sMode = oxConfig::getParameter('fncmode');
        }

        switch($sMode) {
            case 'upload':
                if(!empty($_FILES) && isset($_FILES['magic360images'])) {
                    foreach($_FILES['magic360images']['tmp_name'] as $iKey => $sTempName) {
                        if(!empty($sTempName) && file_exists($sTempName)) {
                            $sName = preg_replace('/[^a-zA-Z0-9()_\.-]/is', '', $_FILES['magic360images']['name'][$iKey]);
                            $sExt = substr($sName, strrpos($sName, '.'));
                            $sName = substr($sName, 0, -strlen($sExt));
                            $iIndex = 0;
                            $sSuffix = '';
                            while(file_exists($sBaseImagePath.$sName.$sSuffix.$sExt)) {
                                $sSuffix = "({$iIndex})";
                                $iIndex++;
                            }
                            if(move_uploaded_file($sTempName, $sBaseImagePath.$sName.$sSuffix.$sExt)) {
                                $aGallery[] = $sName.$sSuffix.$sExt;
                            }
                        }
                    }
                    if($iColumns == $iImagesCount) {
                        $iColumns = count($aGallery);
                    }
                }
            break;
            case 'save':
                if(isset($_POST['columns']) && !empty($_POST['columns']) && (intval($_POST['columns']) < $iImagesCount)) {
                    $iColumns = intval($_POST['columns']);
                } else {
                    $iColumns = $iImagesCount;
                }
            break;
            case 'delete':
                //$iIndex = (int)(oxConfig::getParameter('imageindex'));
                if(class_exists('oxRegistry')) {
                    $iIndex = (int)oxRegistry::getConfig()->getRequestParameter('imageindex', false);
                } else {
                    //NOTE: for OXID versions < 4.7.0
                    $iIndex = (int)(oxConfig::getParameter('imageindex'));
                }
                if(file_exists($sBaseImagePath.$aGallery[$iIndex])) {
                    @unlink($sBaseImagePath.$aGallery[$iIndex]);
                }
                unset($aGallery[$iIndex]);
                if($iColumns == $iImagesCount) {
                    $iColumns--;
                }
            break;
            case 'deleteAll':
                foreach($aGallery as $iImage) {
                    if(file_exists($sBaseImagePath.$iImage)) {
                        @unlink($sBaseImagePath.$iImage);
                    }
                }
                $aGallery = array();
                $iColumns = 0;
            break;
        }

        $sGallery = implode(';', $aGallery);
        if(empty($aRezult)) {
            $sSql = "INSERT INTO `magic360_images` (`OXID`, `GALLERY`, `COLUMNS`) VALUES ('{$sOXID}', '{$sGallery}', {$iColumns})";
        } else {
            $sSql = "UPDATE `magic360_images` SET `GALLERY`='{$sGallery}', `COLUMNS`={$iColumns} WHERE `OXID`='{$sOXID}'";
        }
        $oResult = $oDb->execute($sSql);
        //if($oResult) {} else {}

    }

}