<?php

/**
 * Admin Magic360 Settings manager.
 * Admin Menu: Master Settings -> Magic 360 Settings.
 * @package magic360
 */
class Magic360 extends oxAdminView {

    protected $sModuleDir = null;
    protected $oTool = null;
    protected $sMessage = null;
    protected $sCurrentTabs = '';
    protected $bRegistryClassExists = false;//NOTE: 'oxRegistry' class exists since version 4.7.0

    public function __construct() {

        parent::__construct();

        $this->bRegistryClassExists = class_exists('oxRegistry');

        $this->sModuleDir = getShopBasePath().'modules/magic360';
        $sCoreFile = $this->sModuleDir.'/classes/magic360.module.core.class.php';
        if(file_exists($sCoreFile)) {

            $oDb = oxDb::getDb();

            if($this->bRegistryClassExists) {
                $bReset = oxRegistry::getConfig()->getRequestParameter('reset', false);
            } else {
                //NOTE: for OXID versions < 4.7.0
                $bReset = oxConfig::getParameter('reset');
            }
            $bReset = ($bReset == 'true' ? true : false);


            require_once($sCoreFile);
            $this->oTool = new Magic360ModuleCoreClass();
            $aRezult = $oDb->getAll("SELECT `BLOCK`, `NAME`, `VALUE` FROM `magic360_config` WHERE `ENABLED`=1");

            //NOTE: create or reset settings
            if(!$aRezult || $bReset) {
                if(!class_exists('Magic360Events')) {
                    include getShopBasePath().'modules/magic360/magic360events.php';
                }
                Magic360Events::onActivate();
                $aRezult = $oDb->getAll("SELECT `BLOCK`, `NAME`, `VALUE` FROM `magic360_config` WHERE `ENABLED`=1");
            }

            foreach($aRezult as $aRow) {
                $this->oTool->params->setValue($aRow[1], $aRow[2], $aRow[0]);
            }
            //NOTE: change subtype for some params to display them like radio
            foreach($this->oTool->params->getParams() as $sParamId => $aParam) {
               if($this->oTool->params->getSubType($sParamId) == 'select' && count($this->oTool->params->getValues($sParamId)) < 6)
                   $this->oTool->params->setSubType($sParamId, 'radio');
            }

        } else {
            $this->sMessage = "Error: file {$sCoreFile} does not exists!";
        }

    }

    public function render() {

        parent::render();

        $oAuthUser = oxNew('oxuser');
        $oAuthUser->loadAdminUser();
        if($oAuthUser->oxuser__oxrights->value == 'malladmin') {
            if($this->sMessage === null) {
                $sTemplateFile = $this->sModuleDir.'/magic360settings.php';
                if(!file_exists($sTemplateFile)) {
                    $this->sMessage = "Error: file {$sTemplateFile} does not exists!";
                }
            }

            //$oSmarty = oxUtilsView::getInstance()->getSmarty();
            if($this->bRegistryClassExists) {
                $oSmarty = oxRegistry::get('oxUtilsView')->getSmarty();
            } else {
                //NOTE: for OXID versions < 4.9.0
                $oSmarty = oxUtilsView::getInstance()->getSmarty();
            }

            $oSmarty->assign('oViewConf', $this->_aViewData['oViewConf']);
            $oSmarty->assign('shop', $this->_aViewData['shop']);
            if($this->sMessage === null) {
                $oTool = &$this->oTool;
                //$shopUrl = $this->_aViewData['oViewConf']->getConfig()->getShopUrl();
                $sImageUrl = $this->getConfig()->getImageUrl($this->isAdmin());
                $sResourceUrl = $this->getConfig()->getResourceUrl('', $this->isAdmin());
                ob_start();
                require $sTemplateFile;
                $sSettingsTemplateContents = ob_get_contents();
                ob_end_clean();
                $oSmarty->assign('sSettingsContents', $sSettingsTemplateContents);
            } else {
                $oSmarty->assign('sSettingsContents', $this->sMessage);
            }
            echo $oSmarty->fetch('magic360.tpl');
            if(method_exists('oxUtils', 'getInstance')) {
                //NOTE: for OXID versions < 4.9.0
                oxUtils::getInstance()->showMessageAndExit('');
            } else {
                oxRegistry::getUtils()->showMessageAndExit('');
            }
        } else {
            return oxUtils::getInstance()->showMessageAndExit('Access denied!');
        }

    }

    public function saveSettings() {

        $oAuthUser = oxNew('oxuser');
        $oAuthUser->loadAdminUser();
        if($oAuthUser->oxuser__oxrights->value === 'malladmin' && $_SERVER['REQUEST_METHOD'] == 'POST') {

            if($this->bRegistryClassExists) {
                $bReset = oxRegistry::getConfig()->getRequestParameter('reset', false);
            } else {
                //NOTE: for OXID versions < 4.7.0
                $bReset = oxConfig::getParameter('reset');
            }
            $bReset = ($bReset == 'true' ? true : false);
            if($bReset) {
                return;
            }

            if(isset($_POST['magic_tabs_current'])) {
                $this->sCurrentTabs = $_POST['magic_tabs_current'];
            }

            $oDb = oxDb::getDb();

            foreach($this->getParamsMap() as $sBlockId => $aGroups) {
                foreach($aGroups as $aGroup) {
                    foreach($aGroup as $sParam) {
                        if(isset($_POST[$sBlockId.'-'.$sParam])) {
                            $sValue = trim($_POST[$sBlockId.'-'.$sParam]);
                            switch($this->oTool->params->getType($sParam)) {
                                case "num":
                                    $sValue = intval($sValue);
                                    break;
                                case "array":
                                    if(!in_array($sValue, $this->oTool->params->getValues($sParam))) $sValue = $this->oTool->params->getDefaultValue($sParam);
                                    break;
                                case "text":
                                    $sValue = addslashes($sValue);
                                    break;
                            }
                            $oDb->execute("UPDATE `magic360_config` SET `VALUE`='{$sValue}', `ENABLED`=1 WHERE `BLOCK`='{$sBlockId}' AND `NAME`='{$sParam}'");
                            $this->oTool->params->setValue($sParam, $sValue, $sBlockId);
                        } else {
                            $oDb->execute("UPDATE `magic360_config` SET `ENABLED`=0 WHERE `BLOCK`='{$sBlockId}' AND `NAME`='{$sParam}'");
                            if($this->oTool->params->paramExists($sParam, $sBlockId)) {
                                $this->oTool->params->removeParam($sParam, $sBlockId);
                            };
                        }
                    }
                }
            }

        }

    }


    public function getParamsBlocks() {
        return array(
			'product' => 'Product page',
		);
    }

    public function getParamsMap() {
        return array(
			'product' => array(
				'General' => array(
					'enable-effect',
				),
				'Magic 360' => array(
					'magnify',
					'magnifier-width',
					'magnifier-shape',
					'fullscreen',
					'spin',
					'autospin-direction',
					'sensitivityX',
					'sensitivityY',
					'mousewheel-step',
					'autospin-speed',
					'smoothing',
					'autospin',
					'autospin-start',
					'autospin-stop',
					'initialize-on',
					'start-column',
					'start-row',
					'loop-column',
					'loop-row',
					'reverse-column',
					'reverse-row',
					'column-increment',
					'row-increment',
				),
				'Positioning and Geometry' => array(
					'thumb-max-width',
					'thumb-max-height',
					'square-images',
				),
				'Miscellaneous' => array(
					'show-message',
					'message',
					'loading-text',
					'fullscreen-loading-text',
					'hint',
					'hint-text',
					'mobile-hint-text',
					'imagemagick',
					'image-quality',
					'icon',
				),
				'Watermark' => array(
					'watermark',
					'watermark-max-width',
					'watermark-max-height',
					'watermark-opacity',
					'watermark-position',
					'watermark-offset-x',
					'watermark-offset-y',
				),
			),
		);
    }


}

?>
