<?php

  $magictoolboxTools = array(
    'magiczoom' => 'Magic Zoom',
    'magiczoomplus' => 'Magic Zoom Plus',
    'magicthumb' => 'Magic Thumb',
    'magicmagnify' => 'Magic Magnify',
    'magicmagnifyplus' => 'Magic Magnify Plus',
    'magictouch' => 'Magic Touch',
    'magicslideshow' => 'Magic Slideshow',
    'magicscroll' => 'Magic Scroll',
    'magic360' => 'Magic 360',
  );

  if(isset($cl_box_groups) && is_array($cl_box_groups)) {

    $magictoolboxApps = array();
    foreach($magictoolboxTools as $toolID => $toolTitle) {
      if(file_exists(DIR_FS_ADMIN.'/'.$toolID.'.php')) {
        $magictoolboxApps[] = array(
          'code' => $toolID.'.php',
          'title' => $toolTitle,//BOX_MAGICTOOLBOX_MAGICZOOMPLUS,// admin/includes/languages/english/modules/boxes/magictoolbox.php
          'link' => tep_href_link($toolID.'.php')
        );
      }
    }
    if(!empty($magictoolboxApps)) {
      $cl_box_groups[] = array(
        'heading' => 'Magic Toolbox',//BOX_HEADING_MAGICTOOLBOX,// admin/includes/languages/english/modules/boxes/magictoolbox.php
        'apps' => $magictoolboxApps
      );
    }

  } else {
?>
<!-- magictoolbox //-->
          <tr>
            <td>
<?php
    $headingLink = '';
    $contentsLinks = array();
    foreach($magictoolboxTools as $toolID => $toolTitle) {
      if(file_exists(DIR_FS_ADMIN.'/'.$toolID.'.php')) {
        $contentsLinks[] = '<a href="'.tep_href_link($toolID.'.php').'" class="menuBoxContentLink">'.$toolTitle.'</a>';
        if(empty($headingLink)) $headingLink = tep_href_link($toolID.'.php', 'selected_box=magictoolbox');
      } else {
        unset($magictoolboxTools[$toolID]);
      }
    }
    $heading = array();
    $contents = array();
    $heading[] = array('text'  => 'Magic Toolbox',
                       'link'  => $headingLink);
    if($selected_box == 'magictoolbox') {
      $contents[] = array('text'  => implode('<br>', $contentsLinks));
    }
    $box = new box;
    echo $box->menuBox($heading, $contents);
?>
            </td>
          </tr>
<!-- magictoolbox_eof //-->
<?php
  }
