<?php



if(!defined('MagicThumbModuleCoreClassLoaded')) {

    define('MagicThumbModuleCoreClassLoaded', true);

    require_once(dirname(__FILE__) . '/magictoolbox.params.class.php');

    /**
     * MagicThumbModuleCoreClass
     *
     */
    class MagicThumbModuleCoreClass {

        /**
         * MagicToolboxParamsClass class
         *
         * @var   MagicToolboxParamsClass
         *
         */
        var $params;

        /**
         * Tool type
         *
         * @var   string
         *
         */
        var $type = 'standard';

        /**
         * Id
         *
         * @var   string
         *
         */
        var $id = '';

        /**
         * Constructor
         *
         * @return void
         */
        function __construct() {
            $this->params = new MagicToolboxParamsClass();
            $this->params->setScope('magicthumb');
            $this->params->setMapping(array(
                'loop' => array('Yes' => 'true', 'No' => 'false'),
                'keyboard' => array('Yes' => 'true', 'No' => 'false'),
                'rightClick' => array('Yes' => 'true', 'No' => 'false'),
                'lazyLoad' => array('Yes' => 'true', 'No' => 'false'),
                'autostart' => array('Yes' => 'true', 'No' => 'false')
            ));
            $this->loadDefaults();
        }

        /**
         * Method to get headers string
         *
         * @param string $jsPath  Path to JS file
         * @param string $cssPath Path to CSS file
         *
         * @return string
         */
        function getHeadersTemplate($jsPath = '', $cssPath = null) {
            //to prevent multiple displaying of headers
            if(!defined('MAGICTHUMB_MODULE_HEADERS')) {
                define('MAGICTHUMB_MODULE_HEADERS', true);
            } else {
                return '';
            }
            if($cssPath == null) {
                $cssPath = $jsPath;
            }
            $headers = array();
            $headers[] = '<!-- Magic Thumb osCommerce module version v4.9.1 [v1.6.103:v3.0.20] -->';
            $headers[] = '<script type="text/javascript">window["mgctlbx$Pltm"] = "osCommerce";</script>';
            $headers[] = '<link type="text/css" href="' . $cssPath . '/magicthumb.css" rel="stylesheet" media="screen" />';
            $headers[] = '<link type="text/css" href="' . $cssPath . '/magicthumb.module.css" rel="stylesheet" media="screen" />';
            $headers[] = '<script type="text/javascript" src="' . $jsPath . '/magicthumb.js"></script>';
            $headers[] = $this->getOptionsTemplate();
            return "\r\n" . implode("\r\n", $headers) . "\r\n";
        }

        /**
         * Method to get options string
         *
         * @return string
         */
        function getOptionsTemplate() {
            $addition = "\n\t\t'captionSource':'title',";

            if($this->params->checkValue('show-caption', 'No')) {
                $this->params->setValue('captionPosition', 'off');
            }

            return  "<script type=\"text/javascript\">\n\tvar mgtOptions = {{$addition}\n\t\t" . $this->params->serialize(true, ",\n\t\t") . "\n\t}\n</script>" .
                    "<script type=\"text/javascript\">\n\tvar mgtMobileOptions = {" .
                    "\n\t\t'slideMobileEffect':'" . str_replace('\'', '\\\'', $this->params->getValue('slideMobileEffect')) . "'," .
                    "\n\t\t'textClickHint':'" . str_replace('\'', '\\\'', $this->params->getValue('textClickHintForMobile')) . "'" .
                    "\n\t}\n</script>";
        }

        /**
         * Method to get main image HTML
         *
         * @param array $params Params
         *
         * @return string
         */
        function getMainTemplate($params) {
            // $img = '';
            // $thumb = '';
            // $thumb2x = '';
            // $id = '';
            // $alt = '';
            // $title = '';
            // $description = '';
            // $width = '';
            // $height = '';
            // $link = '';
            // $group = '';

            extract($params);

            if(empty($img)) {
                return '';
            }
            if(empty($thumb)) {
                $thumb = $img;
            }
            if(empty($id)) {
                $id = hash('md5', $img, false);
            }

            $this->id = $id;

            if(empty($alt)) {
                if(empty($title)) {
                    $title = '';
                    $alt = '';
                } else {
                    $alt = htmlspecialchars(htmlspecialchars_decode($title, ENT_QUOTES));
                }
            } else {
                if(empty($title)) {
                    $title = '';
                }
                $alt = htmlspecialchars(htmlspecialchars_decode($alt, ENT_QUOTES));
            }
            if(empty($description)) {
                $description = '';
            }

            if($this->params->checkValue('show-caption', 'No')) {
                $title = '';
            }

            if(empty($width)) {
                $width = '';
            } else {
                $width = " width=\"{$width}\"";
            }
            if(empty($height)) {
                $height = '';
            } else {
                $height = " height=\"{$height}\"";
            }

            $dataOptions = $this->params->serialize();

            if(!empty($link)) {
                $dataOptions .= 'link:' . $link . ';';
            }

            if(!empty($group)) {
                $dataOptions .= 'group:' . $group . ';';
            }

            if ('' != trim($dataOptions)) {
                $dataOptions = 'data-options="' . $dataOptions . '"';
            }

            if (!empty($thumb2x)) {
                //$thumb2x = ' srcset="' . $thumb2x . ' 2x"';
                //$thumb2x = ' srcset="' . $thumb . ' 1x, ' . $thumb2x . ' 2x"';
                $thumb2x = ' srcset="' . str_replace(' ', '%20', $thumb) . ' 1x, ' . str_replace(' ', '%20', $thumb2x) . ' 2x"';
            } else {
                $thumb2x = '';
            }

            return "<a title=\"{$title}\" class=\"MagicThumb\" id=\"MagicThumbImage{$id}\" href=\"{$img}\" {$dataOptions}><img itemprop=\"image\"{$width}{$height} {$thumb2x} src=\"{$thumb}\" alt=\"{$alt}\" /></a>";
        }

        /**
         * Method to get selectors HTML
         *
         * @param array $params Params
         *
         * @return string
         */
        function getSelectorTemplate($params) {
            // $img = '';
            // $medium = '';
            // $thumb = '';
            // $thumb2x = '';
            // $id = '';
            // $alt = '';
            // $title = '';
            // $width = '';
            // $height = '';

            extract($params);

            if(empty($img)) {
                return '';
            }
            if(empty($medium)) {
                $medium = $img;
            }
            if(empty($thumb)) {
                $thumb = $img;
            }
            if(empty($id)) {
                $id = $this->id;
            }


            if(empty($title)) {
                $title = '';
            } else {
                $title = htmlspecialchars(htmlspecialchars_decode($title, ENT_QUOTES));
            }
            if(empty($alt)) {
                $alt = $title;
            } else {
                $alt = htmlspecialchars(htmlspecialchars_decode($alt, ENT_QUOTES));
            }

            if($this->params->checkValue('show-caption', 'Yes') && !empty($title)) {
                $title = trim(preg_replace('#\s+#is', ' ', $title));
                $title = preg_replace('#<(/?)a([^>]*+)>#is', '[$1a$2]', $title);
                $title = " title=\"{$title}\"";
            } else {
                $title = '';
            }

            if(empty($width)) {
                $width = '';
            } else {
                $width = " width=\"{$width}\"";
            }
            if(empty($height)) {
                $height = '';
            } else {
                $height = " height=\"{$height}\"";
            }

            if (!empty($thumb2x)) {
                $thumb2x = ' srcset="' . $thumb2x . ' 2x"';
            } else {
                $thumb2x = '';
            }

            $template = "<a{$title} href=\"{$img}\" data-thumb-id=\"MagicThumbImage{$id}\" data-image=\"$medium\"><img{$width}{$height} src=\"{$thumb}\" {$thumb2x} alt=\"{$alt}\" /></a>";

            return $template;
        }

        /**
         * Method to load defaults options
         *
         * @return void
         */
        function loadDefaults() {
            $params = array(
				"enable-effect"=>array("id"=>"enable-effect","group"=>"General","order"=>"10","default"=>"No","label"=>"Enable effect","type"=>"array","subType"=>"radio","values"=>array("Yes","No"),"scope"=>"module"),
				"thumb-max-width"=>array("id"=>"thumb-max-width","group"=>"Positioning and Geometry","order"=>"10","default"=>"200","label"=>"Maximum width of thumbnails (in pixels)","type"=>"num","scope"=>"module"),
				"thumb-max-height"=>array("id"=>"thumb-max-height","group"=>"Positioning and Geometry","order"=>"11","default"=>"200","label"=>"Maximum height of thumbnails (in pixels)","type"=>"num","scope"=>"module"),
				"paps-image-max-width"=>array("id"=>"paps-image-max-width","group"=>"Positioning and Geometry","order"=>"30","default"=>"200","label"=>"Maximum width of paps module big image (in pixels)","type"=>"num","scope"=>"module"),
				"paps-image-max-height"=>array("id"=>"paps-image-max-height","group"=>"Positioning and Geometry","order"=>"31","default"=>"200","label"=>"Maximum height of paps module big image (in pixels)","type"=>"num","scope"=>"module"),
				"paps-thumb-max-width"=>array("id"=>"paps-thumb-max-width","group"=>"Positioning and Geometry","order"=>"40","default"=>"100","label"=>"Maximum width of paps module thumbnails (in pixels)","type"=>"num","scope"=>"module"),
				"paps-thumb-max-height"=>array("id"=>"paps-thumb-max-height","group"=>"Positioning and Geometry","order"=>"41","default"=>"100","label"=>"Maximum height of paps module thumbnails (in pixels)","type"=>"num","scope"=>"module"),
				"extra-thumb-max-width"=>array("id"=>"extra-thumb-max-width","group"=>"Positioning and Geometry","order"=>"50","default"=>"50","label"=>"Maximum width of extra images thumbnails (in pixels)","type"=>"num","scope"=>"module"),
				"extra-thumb-max-height"=>array("id"=>"extra-thumb-max-height","group"=>"Positioning and Geometry","order"=>"51","default"=>"50","label"=>"Maximum height of extra images thumbnails (in pixels)","type"=>"num","scope"=>"module"),
				"thumb-margin"=>array("id"=>"thumb-margin","group"=>"Positioning and Geometry","order"=>"70","default"=>"1","label"=>"Left/Right margin of thumbnail (in pixels)","type"=>"num","scope"=>"module"),
				"thumb-margin-top"=>array("id"=>"thumb-margin-top","group"=>"Positioning and Geometry","order"=>"80","default"=>"5","label"=>"Top margin of thumbnail (in pixels)","type"=>"num","scope"=>"module"),
				"square-images"=>array("id"=>"square-images","group"=>"Positioning and Geometry","order"=>"310","default"=>"disable","label"=>"Create square images","description"=>"The white/transparent padding will be added around the image or the image will be cropped.","type"=>"array","subType"=>"radio","values"=>array("extend","crop","disable"),"scope"=>"module"),
				"expandEffect"=>array("id"=>"expandEffect","group"=>"Expanded view","order"=>"10","default"=>"expand","label"=>"Effect while enlarging image","type"=>"array","subType"=>"select","values"=>array("expand","fade"),"scope"=>"magicthumb"),
				"expandSpeed"=>array("id"=>"expandSpeed","group"=>"Expanded view","order"=>"20","default"=>"350","label"=>"Duration when enlarging image (milliseconds)","description"=>"0-10000, e.g. 2000 = 2 seconds","type"=>"num","scope"=>"magicthumb"),
				"expandImageSize"=>array("id"=>"expandImageSize","group"=>"Expanded view","order"=>"30","default"=>"fit-screen","label"=>"Size of expanded box","type"=>"array","subType"=>"select","values"=>array("fit-screen","original"),"scope"=>"magicthumb"),
				"expandTrigger"=>array("id"=>"expandTrigger","group"=>"Expanded view","order"=>"40","default"=>"click","label"=>"Mouse trigger to expand","type"=>"array","subType"=>"select","values"=>array("click","hover"),"scope"=>"magicthumb"),
				"expandAlign"=>array("id"=>"expandAlign","group"=>"Expanded view","order"=>"50","default"=>"screen","label"=>"Align expanded box relative to screen or thumbnail","type"=>"array","subType"=>"select","values"=>array("screen","image"),"scope"=>"magicthumb"),
				"expandEasing"=>array("id"=>"expandEasing","group"=>"Expanded view","order"=>"60","default"=>"ease-in-out","label"=>"CSS3 Animation Easing","description"=>"CSS3 Animation Easing. See cubic-bezier.com","type"=>"text","scope"=>"magicthumb"),
				"gallerySpeed"=>array("id"=>"gallerySpeed","group"=>"Expanded view","order"=>"70","default"=>"250","label"=>"Duration when switching image (milliseconds)","description"=>"0-10000, e.g. 2000 = 2 seconds","type"=>"num","scope"=>"magicthumb"),
				"loop"=>array("id"=>"loop","group"=>"Expanded view","order"=>"80","default"=>"Yes","label"=>"Gallery in loop, rewind to the first item after the last or stop at the last item","type"=>"array","subType"=>"radio","values"=>array("Yes","No"),"scope"=>"magicthumb"),
				"selectorTrigger"=>array("id"=>"selectorTrigger","group"=>"Multiple images","order"=>"110","default"=>"click","label"=>"Trigger for selector","type"=>"array","subType"=>"select","values"=>array("click","hover"),"scope"=>"magicthumb"),
				"selectorEffect"=>array("id"=>"selectorEffect","group"=>"Multiple images","order"=>"115","default"=>"switch","label"=>"Effect for selector","type"=>"array","subType"=>"select","values"=>array("switch","expand"),"scope"=>"magicthumb"),
				"show-caption"=>array("id"=>"show-caption","group"=>"Title and Caption","order"=>"20","default"=>"Yes","label"=>"Show caption","type"=>"array","subType"=>"radio","values"=>array("Yes","No"),"scope"=>"module"),
				"captionPosition"=>array("id"=>"captionPosition","group"=>"Title and Caption","order"=>"150","default"=>"bottom","label"=>"Position of caption in zoom window","type"=>"array","subType"=>"select","values"=>array("bottom","right","off"),"scope"=>"magicthumb"),
				"link-to-product-page"=>array("id"=>"link-to-product-page","group"=>"Miscellaneous","order"=>"110","default"=>"Yes","label"=>"Link enlarged image to the product page","type"=>"array","subType"=>"radio","values"=>array("Yes","No"),"scope"=>"module"),
				"keyboard"=>array("id"=>"keyboard","group"=>"Miscellaneous","order"=>"230","default"=>"Yes","label"=>"Allow navigation with right / left keys and close on Esc","type"=>"array","subType"=>"radio","values"=>array("Yes","No"),"scope"=>"magicthumb"),
				"cssClass"=>array("id"=>"cssClass","group"=>"Miscellaneous","order"=>"250","default"=>"","label"=>"Extra CSS class applied to lightbox","type"=>"text","scope"=>"magicthumb"),
				"rightClick"=>array("id"=>"rightClick","group"=>"Miscellaneous","order"=>"260","default"=>"Yes","label"=>"Whether to allow context menu on right click","type"=>"array","subType"=>"radio","values"=>array("Yes","No"),"scope"=>"magicthumb"),
				"lazyLoad"=>array("id"=>"lazyLoad","group"=>"Miscellaneous","order"=>"270","default"=>"No","label"=>"Whether to load large image on demand","type"=>"array","subType"=>"radio","values"=>array("Yes","No"),"scope"=>"magicthumb"),
				"autostart"=>array("id"=>"autostart","group"=>"Miscellaneous","order"=>"280","default"=>"Yes","label"=>"Whether to start Thumb on image automatically on page load or manually","type"=>"array","subType"=>"radio","values"=>array("Yes","No"),"scope"=>"magicthumb"),
				"imagemagick"=>array("id"=>"imagemagick","advanced"=>"1","group"=>"Miscellaneous","order"=>"550","default"=>"off","label"=>"Path to ImageMagick binaries (convert tool)","description"=>"You can set 'auto' to automatically detect ImageMagick location or 'off' to disable ImageMagick and use php GD lib instead","type"=>"text","scope"=>"module"),
				"image-quality"=>array("id"=>"image-quality","group"=>"Miscellaneous","order"=>"560","default"=>"75","label"=>"Quality of thumbnails and watermarked images (1-100)","description"=>"1 = worst quality / 100 = best quality","type"=>"num","scope"=>"module"),
				"buttons"=>array("id"=>"buttons","group"=>"Buttons","order"=>"160","default"=>"auto","label"=>"Position of buttons in expand window","type"=>"array","subType"=>"select","values"=>array("auto","top left","top right","bottom left","bottom right","off"),"scope"=>"magicthumb"),
				"textBtnClose"=>array("id"=>"textBtnClose","group"=>"Buttons","order"=>"170","default"=>"Close","label"=>"Title of close button","type"=>"text","scope"=>"magicthumb"),
				"textBtnNext"=>array("id"=>"textBtnNext","group"=>"Buttons","order"=>"180","default"=>"Next","label"=>"Title of next button","type"=>"text","scope"=>"magicthumb"),
				"textBtnPrev"=>array("id"=>"textBtnPrev","group"=>"Buttons","order"=>"190","default"=>"Previous","label"=>"Title of previous button","type"=>"text","scope"=>"magicthumb"),
				"watermark"=>array("id"=>"watermark","group"=>"Watermark","order"=>"10","default"=>"","label"=>"Watermark image path","description"=>"Enter location of watermark image on your server. Leave field empty to disable watermark","type"=>"text","scope"=>"module"),
				"watermark-max-width"=>array("id"=>"watermark-max-width","group"=>"Watermark","order"=>"20","default"=>"30%","label"=>"Maximum width of watermark image","description"=>"pixels = fixed size (e.g. 50) / percent = relative for image size (e.g. 50%)","type"=>"text","scope"=>"module"),
				"watermark-max-height"=>array("id"=>"watermark-max-height","group"=>"Watermark","order"=>"21","default"=>"30%","label"=>"Maximum height of watermark image","description"=>"pixels = fixed size (e.g. 50) / percent = relative for image size (e.g. 50%)","type"=>"text","scope"=>"module"),
				"watermark-opacity"=>array("id"=>"watermark-opacity","group"=>"Watermark","order"=>"40","default"=>"50","label"=>"Watermark image opacity (1-100)","description"=>"0 = transparent, 100 = solid color","type"=>"num","scope"=>"module"),
				"watermark-position"=>array("id"=>"watermark-position","group"=>"Watermark","order"=>"50","default"=>"center","label"=>"Watermark position","description"=>"Watermark size settings will be ignored when watermark position is set to 'stretch'","type"=>"array","subType"=>"select","values"=>array("top","right","bottom","left","top-left","bottom-left","top-right","bottom-right","center","stretch"),"scope"=>"module"),
				"watermark-offset-x"=>array("id"=>"watermark-offset-x","advanced"=>"1","group"=>"Watermark","order"=>"60","default"=>"0","label"=>"Watermark horizontal offset","description"=>"Offset from left and/or right image borders. Pixels = fixed size (e.g. 20) / percent = relative for image size (e.g. 20%). Offset will disable if 'watermark position' set to 'center'","type"=>"text","scope"=>"module"),
				"watermark-offset-y"=>array("id"=>"watermark-offset-y","advanced"=>"1","group"=>"Watermark","order"=>"70","default"=>"0","label"=>"Watermark vertical offset","description"=>"Offset from top and/or bottom image borders. Pixels = fixed size (e.g. 20) / percent = relative for image size (e.g. 20%). Offset will disable if 'watermark position' set to 'center'","type"=>"text","scope"=>"module"),
				"hint"=>array("id"=>"hint","group"=>"Hint","order"=>"120","default"=>"once","label"=>"How to show hint","type"=>"array","subType"=>"select","values"=>array("once","always","off"),"scope"=>"magicthumb"),
				"textClickHint"=>array("id"=>"textClickHint","group"=>"Hint","order"=>"130","default"=>"Click to expand","label"=>"Hint that shows when zoom is active.","type"=>"text","scope"=>"magicthumb"),
				"textHoverHint"=>array("id"=>"textHoverHint","group"=>"Hint","order"=>"130","default"=>"Hover to expand","label"=>"Hint that shows when zoom is active.","type"=>"text","scope"=>"magicthumb"),
				"slideMobileEffect"=>array("id"=>"slideMobileEffect","group"=>"Mobile","order"=>"1","default"=>"rotate","label"=>"Switch image effect in expand window","type"=>"array","subType"=>"select","values"=>array("rotate","straight"),"scope"=>"magicthumb-mobile"),
				"textClickHintForMobile"=>array("id"=>"textClickHintForMobile","group"=>"Mobile","order"=>"2","default"=>"Tap to expand","label"=>"Hint that shows when zoom is active.","type"=>"text","scope"=>"magicthumb-mobile")
			);
            $this->params->appendParams($params);
        }
    }

}

?>
