<?php
/**
* Magic Slideshow osCommerce Module
*
* @version v4.9.1 [v1.6.103:v3.2.12]
* @author Magic Toolbox
* @copyright (C) 2008 Magic Toolbox. All rights reserved.
* @link http://www.magictoolbox.com/magicslideshow/
* @license http://www.magictoolbox.com/license/
*
* Magic Slideshow osCommerce Module comes with absolute no warranty.
*/

    defined('OPTIONS_AS_COLOR_SWATCHES_ENABLED') || define('OPTIONS_AS_COLOR_SWATCHES_ENABLED', false);

    if(!defined('NEW_OSC_VERSION')) {
        if(file_exists(DIR_FS_CATALOG.'/includes/version.php')) {
            $version = trim(implode('', file(DIR_FS_CATALOG.'includes/version.php')));
            if(version_compare($version, '2.3.0', '>=')) {
                define('NEW_OSC_VERSION', true);
            } else {
                define('NEW_OSC_VERSION', false);
            }
        } else {
            define('NEW_OSC_VERSION', false);
        }
    }
    defined('NEW_OSCMAX_VERSION') || define('NEW_OSCMAX_VERSION', false);

    function MagicSlideshowGetTool() {
        static $mainTool = null;
        if($mainTool == null) {
            require_once(dirname(__FILE__).'/magicslideshow.module.core.class.php');
            $mainTool = new MagicSlideshowModuleCoreClass;

            $result = tep_db_query("SHOW TABLES LIKE 'magicslideshow_configuration'");
            if($result && tep_db_num_rows($result)) {
                $result = tep_db_query('SELECT * FROM `magicslideshow_configuration` WHERE `enabled` = 1');
                while($fields = tep_db_fetch_array($result)) {
                    $mainTool->params->setValue($fields['name'], $fields['value'], $fields['block']);
                }
            }



            //NOTE: is this osCmax?
            $mainTool->params->setValue('oscmax', defined('PROJECT_VERSION') && preg_match('/oscmax/is', PROJECT_VERSION));

            //NOTE: dir-ws-images
            $dirWSimages = DIR_WS_IMAGES;
            !empty($dirWSimages) || ($dirWSimages = 'images/');
            if(defined('DYNAMIC_MOPICS_THUMBS_DIR')) {
                $dirWSimages .= DYNAMIC_MOPICS_THUMBS_DIR;
            }
            $mainTool->params->setValue('dir-ws-images', $dirWSimages);
            $mainTool->params->setValue('dir-ws-images-quoted', preg_quote(trim($dirWSimages), '/'));

        }
        return $mainTool;
    }

    function MagicSlideshow($content = null, $block = null) {

        $returnContent = false;
        if($content == null) {
            $content = ob_get_contents();
            ob_end_clean();
        } else {
            $returnContent = true;
            ob_end_flush();
        }

        if(!$block) {
            if(basename($_SERVER['SCRIPT_NAME']) == 'product_info.php') {
                //NOTE: product page
                //isset($GET['products_id']) && isset($GLOBALS['product_info'])
                $block = 'product';
            } else if(basename($_SERVER['SCRIPT_NAME']) == 'index.php') {
                if(isset($GLOBALS['category_depth']) && $GLOBALS['category_depth'] == 'top') {
                    $block = 'homeslideshow';
                }
            }
            //$categoryPage = (isset($GLOBALS['category_depth']) && $GLOBALS['category_depth'] == 'products' && intval($GLOBALS['current_category_id']) > 0 || intval($_GET['manufacturers_id']) > 0);
        }

        $tool = MagicSlideshowGetTool();
        //debug_log('block = '.$block);
        switch($block) {
            case 'homeslideshow':
                $tool->params->setProfile($block);
                if($tool->params->checkValue('enable-effect', 'No')) break;
                $homeslideshowData = array();
                $result = tep_db_query("SELECT * FROM `magicslideshow_images` WHERE `exclude`=0 ORDER BY `image_order`");
                while($fields = tep_db_fetch_array($result)) {
                    $fields['name'] = DIR_WS_IMAGES.'magicslideshow/'.ltrim($fields['name'], '/');
                    if(!file_exists(DIR_FS_CATALOG.$fields['name'])) continue;
                    $thumb = magicslideshowGetThumb($fields['name'], 'thumb', 'homeslideshow');
                    $img = magicslideshowGetThumb($fields['name'], 'original', 'homeslideshow');
                    $selector = magicslideshowGetThumb($fields['name'], 'selector', 'homeslideshow');
                    $homeslideshowData[$fields['id']] = array(
                        'title' => $fields['title'],
                        'alt' => $fields['title'],
                        'img' => $thumb,
                        'thumb' => $selector,
                        'fullscreen' => $img,
                        'description' => $fields['description'],
                        'link' => empty($fields['link']) ? false : $fields['link'],
                    );
                }
                if(empty($homeslideshowData)) break;
                $html = $tool->getMainTemplate($homeslideshowData, array('id' => 'HomeMagicSlideshow'));
                $html = '<div class="MagicToolboxContainer MagicToolboxHomePageSlideshowBlock">'.$html.'</div>';

                //NOTE: for osCommerce v2.3.x
                $pattern =  '<div\b[^>]*?\bclass="[^"]*?\bcontentContainer\b[^"]*+"[^>]*+>[^<]*+'.
                            '<div\b[^>]*?\bclass="[^"]*?\bcontentText\b[^"]*+"[^>]*+>'.
                            '('.//1
                            '(?:'.
                               '[^<]++'.
                               '|'.
                               '<(?!/?div\b|!--)'.
                               '|'.
                               '<!--.*?-->'.
                               '|'.
                               '<div\b[^>]*+>'.
                                   '(?1)'.
                               '</div\s*+>'.
                            ')*+'.
                            ')'.
                            '</div\s*+>';
                //NOTE: for Bootstrapped Responsive osCommerce
                $pattern =  $pattern.'|'.
                            '<div\b[^>]*?\bclass="[^"]*?\bcontentContainer\b[^"]*+"[^>]*+>[^<]*+'.
                            '<div\b[^>]*?\bclass="[^"]*?\balert-info\b[^"]*+"[^>]*+>'.
                            '('.//2
                            '(?:'.
                               '[^<]++'.
                               '|'.
                               '<(?!/?div\b|!--)'.
                               '|'.
                               '<!--.*?-->'.
                               '|'.
                               '<div\b[^>]*+>'.
                                   '(?2)'.
                               '</div\s*+>'.
                            ')*+'.
                            ')'.
                            '</div\s*+>'.
                            '(?:[^<]*+'.
                            '<div\b[^>]*?\bclass="[^"]*?\bcontentText\b[^"]*+"[^>]*+>'.
                            '('.//3
                            '(?:'.
                               '[^<]++'.
                               '|'.
                               '<(?!/?div\b|!--)'.
                               '|'.
                               '<!--.*?-->'.
                               '|'.
                               '<div\b[^>]*+>'.
                                   '(?3)'.
                               '</div\s*+>'.
                            ')*+'.
                            ')'.
                            '</div\s*+>'.
                            ')?';
                //NOTE: for osCommerce v2.2.x
                $pattern =  $pattern.'|'.
                            '<!--\s*+body_text\s*+//-->[^<]*+'.
                            '<td\b[^>]*+>';
                            '('.//4
                            '(?:'.
                               '[^<]++'.
                               '|'.
                               '<(?!/?td\b|!--)'.
                               '|'.
                               '<!--.*?-->'.
                               '|'.
                               '<td\b[^>]*+>'.
                                   '(?4)'.
                               '</td\s*+>'.
                            ')*+'.
                            ')'.
                            '</td\s*+>';
                //NOTE: for osCommerce v2.2.x with STS
                $pattern =  $pattern.'|'.
                            '<!--\s*+start\s*+Index\s*+content\s*+//-->';
                //$matches = array();
                //preg_match_all("#{$pattern}#is", $content, $matches, PREG_SET_ORDER);
                //debug_log($matches);
                $content = preg_replace("#{$pattern}#is", "$0{$html}", $content);
                defined('MAGICSLIDESHOW_HEADERS') || define('MAGICSLIDESHOW_HEADERS', true);
            break;
            case 'product':
                $tool->params->setProfile($block);
                if($tool->params->checkValue('enable-effect', 'No')) break;
                global $product_info;
                if(empty($product_info)) break;
                $items = array();
                $pid = (int)$product_info['products_id'];
                $productsImage = DIR_WS_IMAGES.ltrim($product_info['products_image'], '/');
                if(defined('TABLE_ADDITIONAL_IMAGES')) {
                    if(!empty($product_info['products_image_pop'])) {
                        $productsImage = DIR_WS_IMAGES.ltrim($product_info['products_image_pop'], '/');
                    } else if(!empty($product_info['products_image_med'])) {
                        $productsImage = DIR_WS_IMAGES.ltrim($product_info['products_image_med'], '/');
                    }
                }
                $thumb = magicslideshowGetThumb($productsImage, 'thumb', $pid);
                $img = magicslideshowGetThumb($productsImage, 'original', $pid);
                $selector = magicslideshowGetThumb($productsImage, 'selector', $pid);
                $items[] = array(
                    'title' => $product_info['products_name'],
                    'alt' => $product_info['products_name'],
                    'description' => $product_info['products_description'],
                    'img' => $thumb,
                    'thumb' => $selector,
                    'fullscreen' => $img,
                );

                //NOTE: osCommerce v2.3.x images
                global $pi_query;
                if(!empty($pi_query) && tep_db_num_rows($pi_query)) {
                    tep_db_data_seek($pi_query, 0);
                    while($pi = tep_db_fetch_array($pi_query)) {
                        $pi['image'] = DIR_WS_IMAGES.ltrim($pi['image'], '/');
                        $thumb = magicslideshowGetThumb($pi['image'], 'thumb', $pid);
                        $img = magicslideshowGetThumb($pi['image'], 'original', $pid);
                        $selector = magicslideshowGetThumb($pi['image'], 'selector', $pid);
                        $items[] = array(
                            'title' => $product_info['products_name'],
                            'alt' => $product_info['products_name'],
                            'description' => empty($pi['htmlcontent']) ? '' : $pi['htmlcontent'],
                            'img' => $thumb,
                            'thumb' => $selector,
                            'fullscreen' => $img,
                        );
                    }
                }

                //NOTE: Additional Images Module http://addons.oscommerce.com/info/1032
                if(defined('TABLE_ADDITIONAL_IMAGES')) {
                    $query = "SELECT additional_images_id, images_description, thumb_images, medium_images, popup_images FROM ".TABLE_ADDITIONAL_IMAGES." WHERE products_id = '{$pid}'";
                    $images_query = tep_db_query($query);
                    while($image = tep_db_fetch_array($images_query)) {
                        if(!empty($image['popup_images'])) {
                            $productsImage = DIR_WS_IMAGES.ltrim($image['popup_images'], '/');
                        } else if(!empty($image['medium_images'])) {
                            $productsImage = DIR_WS_IMAGES.ltrim($image['medium_images'], '/');
                        } else if(!empty($image['thumb_images'])) {
                            $productsImage = DIR_WS_IMAGES.ltrim($image['thumb_images'], '/');
                        } else {
                            continue;
                        }
                        $thumb = magicslideshowGetThumb($productsImage, 'thumb', $pid);
                        $img = magicslideshowGetThumb($productsImage, 'original', $pid);
                        $selector = magicslideshowGetThumb($productsImage, 'selector', $pid);
                        $items[] = array(
                            'title' => $product_info['products_name'],
                            'alt' => $product_info['products_name'],
                            'description' => empty($image['images_description']) ? '' : $image['images_description'],
                            'img' => $thumb,
                            'thumb' => $selector,
                            'fullscreen' => $img,
                        );
                    }
                    tep_db_free_result($images_query);
                }

                //NOTE: Multiple Images for Products for osCommerce v2.2
                $multipleImagesKeys = array('product_image_2', 'product_image_3', 'product_image_4', 'product_image_5', 'product_image_6');
                foreach($multipleImagesKeys as $key) {
                    if(!empty($product_info[$key])) {
                        $productsImage = DIR_WS_IMAGES.ltrim($product_info[$key], '/');
                        $thumb = magicslideshowGetThumb($productsImage, 'thumb', $pid);
                        $img = magicslideshowGetThumb($productsImage, 'original', $pid);
                        $selector = magicslideshowGetThumb($productsImage, 'selector', $pid);
                        $items[] = array(
                            'title' => $product_info['products_name'],
                            'alt' => $product_info['products_name'],
                            //'description' => $product_info['products_description'],
                            'img' => $thumb,
                            'thumb' => $selector,
                            'fullscreen' => $img,
                        );
                    }
                }

                if(empty($items)) break;
                $html = $tool->getMainTemplate($items, array('id' => $block.'MagicSlideshow'));
                //$html = '<div class="MagicToolboxContainer">'.$html.'</div>';
                //NOTE: added support for Bootstrapped Responsive osCommerce

                $html = '<div class="MagicToolboxContainer minWidth">'.$html.'</div>';

                //NOTE: for osCommerce v2.3.x
                $pattern =  '(?:<img\b[^>]*?src="'.DIR_WS_IMAGES.$product_info['products_image'].'"[^>]*+>[^<]*+)?'.
                            '(<div\b[^>]*?\b(?:id\s*+=\s*+"piGal"|class\s*+=\s*+"[^"]*?\bpiGal\b[^"]*+")[^>]*+>)'.//1
                            '('.//2
                            '(?:'.
                                '[^<]++'.
                                '|'.
                                '<(?!/?div\b|!--)'.
                                '|'.
                                '<!--.*?-->'.
                                '|'.
                                '<div\b[^>]*+>'.
                                    '(?2)'.
                                '</div\s*+>'.
                            ')*+'.
                            ')'.
                            '(</div\s*+>)'.//3
                            '(?:'.
                                '[^<]*+'.
                                '<div style="display: none;">'.
                                '('.//4
                                '(?:'.
                                    '[^<]++'.
                                    '|'.
                                    '<(?!/?div\b|!--)'.
                                    '|'.
                                    '<!--.*?-->'.
                                    '|'.
                                    '<div\b[^>]*+>'.
                                        '(?4)'.
                                    '</div\s*+>'.
                                ')*+'.
                                ')'.
                                '</div\s*+>'.
                            ')?'.
                            '(?:'.
                                '[^<]*+<script\b[^>]*+>.*?</script>'.
                            ')?';

                //NOTE: for osCommerce v2.2.x
                $src = DIR_WS_IMAGES.$product_info['products_image'];
                //NOTE: Additional Images Module http://addons.oscommerce.com/info/1032
                if(defined('TABLE_ADDITIONAL_IMAGES')) {
                    if(!empty($product_info['products_image_med'])) {
                        $src = DIR_WS_IMAGES.$product_info['products_image_med'];
                    } else if(!empty($product_info['products_image_pop'])) {
                        $src = DIR_WS_IMAGES.$product_info['products_image_pop'];
                    } else if(!empty($product_info['products_image'])) {
                        //$src = DIR_WS_IMAGES.$product_info['products_image'];
                    } else {
                        break;
                    }
                }
                $pattern =  $pattern.'|'.
                            '(<script\b[^>]*+>[^<]*+(?:<!--)?\s*document\.write\(\s*\')?'.//5
                            '<a\b[^>]*+>[^<]*+'.
                            '<img\b[^>]*?src="'.$src.'"[^>]*+>'.
                            '.*?'.
                            '</a>'.
                            '(?(5)\'\s*\)\s*;\s*(?://-->)?[^<]*+</script>)';

                //NOTE: Multiple Images for Products for osCommerce v2.2
                $pattern =  $pattern.'|'.
                            // <!-- BOF SUHY -->
                            '(?:'.
                            '<td\b[^>]*+>[^<]*+'.
                            '<div\b[^>]*+>[^<]*+'.
                            '<a\b[^>]*?\bclass="[^"]*?\bthumbnail\d[^"]*+"[^>]*+>'.
                            '('.//6
                            '(?:'.
                                '[^<]++'.
                                '|'.
                                '<(?!/?a\b|!--)'.
                                '|'.
                                '<!--.*?-->'.
                                '|'.
                                '<a\b[^>]*+>'.
                                    '(?6)'.
                                '</a\s*+>'.
                            ')*+'.
                            ')'.
                            '</a>[^<]*+'.
                            '<br\b[^>]*+>[^<]*+'.
                            '<a\b[^>]*+>[^<]*+</a>[^<]*+'.
                            '</div>[^<]*+'.
                            '</?td>[^<]*+'.//NOTE: wrong closed tag in module
                            ')+';
                            // <!-- EOF SUHY -->
                //NOTE: for some templates in osCommerce v2.2.x with STS
                $pattern =  $pattern.'|'.
                            '<img\b[^>]*?src="'.DIR_WS_IMAGES.$product_info['products_image'].'"[^>]*+>';

                magicslideshowColumnsBackup($content);
                //$matches = array();
                //preg_match_all("#{$pattern}#is", $content, $matches, PREG_SET_ORDER);
                //debug_log($matches);
                //$content = preg_replace("#{$pattern}#is", "$1{$html}$3", $content, 1);
                if(preg_match("#{$pattern}#is", $content, $matches)) {
                    $matches[1] = str_replace('piGal', 'MagicToolboxPiGalContainer', $matches[1]);
                    $content = preg_replace("#{$pattern}#is", "{$matches[1]}{$html}$3", $content, 1);
                }

                //NOTE: Additional Images Module http://addons.oscommerce.com/info/1032
                if(defined('TABLE_ADDITIONAL_IMAGES')) {
                    global $additional_images;
                    if(isset($additional_images) && is_object($additional_images) && get_class($additional_images) == 'displayimages') {
                        //NOTE: cut additional images
                        $content = str_replace($additional_images->groupoutput(), '', $content);
                    }
                }
                magicslideshowColumnsBackup($content);
                defined('MAGICSLIDESHOW_HEADERS') || define('MAGICSLIDESHOW_HEADERS', true);

            break;
            case 'new_products':
                $tool->params->setProfile($block);
                if($tool->params->checkValue('enable-effect', 'No')) break;
                global $new_products_query, $currencies;
                tep_db_data_seek($new_products_query, 0);
                $newProductsCount = tep_db_num_rows($new_products_query);
                $link = $tool->params->checkValue('link-to-product-page', 'Yes');
                $imagesDir = DIR_WS_IMAGES;
                while($product = tep_db_fetch_array($new_products_query)) {
                    $pid = (int)$product['products_id'];
                    $product['products_image'] = $imagesDir.ltrim($product['products_image'], '/');
                    $thumb = magicslideshowGetThumb($product['products_image'], 'thumb', $pid);
                    $img = magicslideshowGetThumb($product['products_image'], 'original', $pid);
                    $selector = magicslideshowGetThumb($product['products_image'], 'selector', $pid);
                    $productsPrice = $currencies->display_price($product['products_price'], tep_get_tax_rate($product['products_tax_class_id']));
                    $items[] = array(
                        'title' => $product['products_name'].'<br />'.$productsPrice,
                        'alt' => $product['products_name'],
                        'description' => $product['products_description'],
                        'img' => $thumb,
                        'thumb' => $selector,
                        'fullscreen' => $img,
                        'link' => $link ? tep_href_link(FILENAME_PRODUCT_INFO, 'products_id='.$product['products_id']) : false,
                    );
                }
                if(empty($items)) break;
                $html = $tool->getMainTemplate($items, array('id' => $block.'MagicSlideshow'));
                $html = '<div class="MagicToolboxContainer MagicToolboxNewProductsBlock">'.$html.'</div>';
                if(!empty($GLOBALS['new_prods_content'])) {
                    //NOTE: for osCommerce v2.3.x
                    $content = str_replace($GLOBALS['new_prods_content'], $html, $content);                    
                } else {
                    $pattern1 = '((?|'.//1
                                //NOTE: for osCommerce v2.3.x
                                '<(div)\b[^>]*?\bclass="[^"]*?\bcontentText\b[^"]*+"[^>]*+>'.//2
                                '|'.
                                //NOTE: for osCommerce v2.2.x
                                '<(table)\b[^>]*?\bclass="[^"]*?\binfoBoxContents\b[^"]*+"[^>]*+>'.//2
                                '))'.
                                '('.//3
                                '(?:'.
                                   '[^<]++'.
                                   '|'.
                                   '<(?!/?\2\b|!--)'.
                                   '|'.
                                   '<!--.*?-->'.
                                   '|'.
                                   '<\2\b[^>]*+>'.
                                       '(?3)'.
                                   '</\2\s*+>'.
                                ')*+'.
                                ')'.
                                '</\2\s*+>';
                    //NOTE: separate pattern because table.infoBoxContents must be matched first
                    $pattern2 =  '('.//1
                                //NOTE: for osCommerce v2.2.x with STS
                                '<!--\s*+new_products\s*+//-->[^<]*+<(table)\b[^>]*+>'.//2
                                ')'.
                                '('.//3
                                '(?:'.
                                   '[^<]++'.
                                   '|'.
                                   '<(?!/?\2\b|!--)'.
                                   '|'.
                                   '<!--.*?-->'.
                                   '|'.
                                   '<\2\b[^>]*+>'.
                                       '(?3)'.
                                   '</\2\s*+>'.
                                ')*+'.
                                ')'.
                                '</\2\s*+>';
                    //$matches = array();
                    //preg_match_all("#{$pattern1}#is", $content, $matches, PREG_SET_ORDER);
                    //debug_log($matches);
                    //preg_match_all("#{$pattern2}#is", $content, $matches, PREG_SET_ORDER);
                    //debug_log($matches);
                    $matches = array();
                    if(preg_match("#{$pattern1}#is", $content, $matches) || preg_match("#{$pattern2}#is", $content, $matches)) {
                        if($matches[2] == 'table') {
                            $html = "<tr><td>{$html}</td></tr>";
                        }
                        //$content = preg_replace("#{$pattern}#is", "$1{$html}</$2>", $content);
                        $html = "{$matches[1]}{$html}</{$matches[2]}>";
                        $content = str_replace($matches[0], $html, $content);
                    }
                }
                defined('MAGICSLIDESHOW_HEADERS') || define('MAGICSLIDESHOW_HEADERS', true);
            break;
            case 'whats_new':
            case 'specials':
            case 'reviews':
                $whats_new = $block == 'whats_new';
                $specials = $block == 'specials';
                $reviews = $block == 'reviews';

                $tool->params->setProfile($block);
                if($tool->params->checkValue('enable-effect', 'No')) break;
                global $currencies, $languages_id;
                $link = $tool->params->checkValue('link-to-product-page', 'Yes');
                if($whats_new) {
                    //$query = "SELECT products_id, products_image, products_tax_class_id, products_price FROM ".TABLE_PRODUCTS." WHERE products_status = '1' ORDER BY products_date_added DESC LIMIT ".MAX_RANDOM_SELECT_NEW;
                    $query = "SELECT p.products_id, p.products_image, p.products_tax_class_id, p.products_price, pd.products_name, pd.products_description ".
                             "FROM ".TABLE_PRODUCTS." p, ".TABLE_PRODUCTS_DESCRIPTION." pd ".
                             "WHERE p.products_status = '1' AND p.products_id = pd.products_id AND pd.language_id = '".(int)$languages_id."' ".
                             "ORDER BY p.products_date_added DESC LIMIT ".MAX_RANDOM_SELECT_NEW;
                } else if($specials) {
                    //$query = "SELECT p.products_id, pd.products_name, p.products_price, p.products_tax_class_id, p.products_image, s.specials_new_products_price FROM ".TABLE_PRODUCTS." p, ".TABLE_PRODUCTS_DESCRIPTION." pd, ".TABLE_SPECIALS." s WHERE p.products_status = '1' AND p.products_id = s.products_id AND pd.products_id = s.products_id AND pd.language_id = '".(int)$languages_id."' AND s.status = '1' ORDER BY s.specials_date_added DESC LIMIT ".MAX_RANDOM_SELECT_SPECIALS;
                    $query = "SELECT p.products_id, pd.products_name, pd.products_description, p.products_price, p.products_tax_class_id, p.products_image, s.specials_new_products_price ".
                             "FROM ".TABLE_PRODUCTS." p, ".TABLE_PRODUCTS_DESCRIPTION." pd, ".TABLE_SPECIALS." s ".
                             "WHERE p.products_status = '1' AND p.products_id = s.products_id AND pd.products_id = s.products_id AND pd.language_id = '".(int)$languages_id."' AND s.status = '1' ".
                             "ORDER BY s.specials_date_added DESC LIMIT ".MAX_RANDOM_SELECT_SPECIALS;
                } else if($reviews) {
                    //$query = "SELECT r.reviews_id, r.reviews_rating, p.products_id, pd.products_name, pd.products_description, p.products_image FROM ".TABLE_REVIEWS." r, ".TABLE_REVIEWS_DESCRIPTION." rd, ".TABLE_PRODUCTS." p, ".TABLE_PRODUCTS_DESCRIPTION." pd WHERE p.products_status = '1' AND p.products_id = r.products_id AND r.reviews_id = rd.reviews_id AND rd.languages_id = '".(int)$languages_id."' AND p.products_id = pd.products_id AND pd.language_id = '".(int)$languages_id."' AND r.reviews_status = 1 ORDER BY r.reviews_id DESC LIMIT ".MAX_RANDOM_SELECT_REVIEWS;
                    $query = "SELECT r.reviews_id, r.reviews_rating, p.products_id, pd.products_name, pd.products_description, p.products_image ".
                             "FROM ".TABLE_REVIEWS." r, ".TABLE_REVIEWS_DESCRIPTION." rd, ".TABLE_PRODUCTS." p, ".TABLE_PRODUCTS_DESCRIPTION." pd ".
                             "WHERE p.products_status = '1' AND p.products_id = r.products_id AND r.reviews_id = rd.reviews_id AND rd.languages_id = '".(int)$languages_id."' AND p.products_id = pd.products_id AND pd.language_id = '".(int)$languages_id."' ".
                             "ORDER BY r.reviews_id DESC LIMIT ".MAX_RANDOM_SELECT_REVIEWS;
                }

                $result = tep_db_query($query);
                $items = array();
                $imagesDir = DIR_WS_IMAGES;
                while($product = tep_db_fetch_array($result)) {
                    $pid = (int)$product['products_id'];
                    $product['products_image'] = $imagesDir.ltrim($product['products_image'], '/');
                    $thumb = magicslideshowGetThumb($product['products_image'], 'thumb', $pid);
                    $img = magicslideshowGetThumb($product['products_image'], 'original', $pid);
                    $selector = magicslideshowGetThumb($product['products_image'], 'selector', $pid);
                    $product['products_name'] = tep_get_products_name($product['products_id']);
                    if($whats_new) {
                        $product['specials_new_products_price'] = tep_get_products_special_price($product['products_id']);
                        if(tep_not_null($product['specials_new_products_price'])) {
                            $price = '<s>'.$currencies->display_price($product['products_price'], tep_get_tax_rate($product['products_tax_class_id'])).'</s><br>';
                            $price .= '<span class="productSpecialPrice">'.$currencies->display_price($product['specials_new_products_price'], tep_get_tax_rate($product['products_tax_class_id'])).'</span>';
                        } else {
                            $price = $currencies->display_price($product['products_price'], tep_get_tax_rate($product['products_tax_class_id']));
                        }
                    } else if($specials) {
                        $price = '<s>'.$currencies->display_price($product['products_price'], tep_get_tax_rate($product['products_tax_class_id'])).'</s><br>';
                        $price .= '<span class="productSpecialPrice">'.$currencies->display_price($product['specials_new_products_price'], tep_get_tax_rate($product['products_tax_class_id'])).'</span>';
                    } else if($reviews) {
                        $review_query = tep_db_query("SELECT reviews_text FROM ".TABLE_REVIEWS_DESCRIPTION." WHERE reviews_id = '".(int)$product['reviews_id']."' AND languages_id = '".(int)$languages_id."'");
                        $reviews_text = tep_db_fetch_array($review_query);
                        $product['products_description']
                        /*$product['reviews_text']*/ = tep_break_string(tep_output_string_protected($reviews_text['reviews_text']), 15, '-<br>');
                        //$stars = '<br><div align="center">'.tep_image(DIR_WS_IMAGES.'stars_'.$product['reviews_rating'].'.gif', sprintf(BOX_REVIEWS_TEXT_OF_5_STARS, $product['reviews_rating'])).'</div>';
                        $price = '';
                    }
                    $items[] = array(
                        'title' => $product['products_name'],//.'<br />'.$price,
                        'alt' => $product['products_name'],
                        'description' => $product['products_description'],
                        'img' => $thumb,
                        'thumb' => $selector,
                        'fullscreen' => $img,
                        'link' => $link ? tep_href_link($reviews ? FILENAME_PRODUCT_REVIEWS_INFO : FILENAME_PRODUCT_INFO, 'products_id='.$product['products_id'].($reviews ? '&reviews_id='.$product['reviews_id'] : '')) : false,
                    );
                }
                if(!empty($items)) {
                    $html = $tool->getMainTemplate($items, array('id' => $block.'MagicSlideshow'));
                    $html = '<div class="MagicToolboxContainer">'.$html.'</div>';
                    $html = str_replace('$', '\$', $html);
                    $pattern =  '<table\b[^>]*?\bclass="[^"]*?\binfoBoxContents\b[^"]*+"[^>]*+>'.
                                '('.
                                '(?:'.
                                   '[^<]++'.
                                   '|'.
                                   '<(?!/?table\b|!--)'.
                                   '|'.
                                   '<!--.*?-->'.
                                   '|'.
                                   '<table\b[^>]*+>'.
                                       '(?1)'.
                                   '</table\s*+>'.
                                ')*+'.
                                ')'.
                                '</table\s*+>';
                    //$matches = array();
                    //preg_match_all("#{$pattern}#is", $content, $matches, PREG_SET_ORDER);
                    //debug_log($matches);
                    $content = preg_replace("#{$pattern}#is", "{$html}", $content);
                    defined('MAGICSLIDESHOW_HEADERS') || define('MAGICSLIDESHOW_HEADERS', true);
                }


            break;

            default:
        }

        if(defined('MAGICSLIDESHOW_HEADERS') && !defined('MAGICSLIDESHOW_HEADERS_DISPLAYED')) {
            $tool->params->resetProfile();
            $content = preg_replace_callback('#(?<!["\'])</head>#is', 'magicslideshowHeaderCallback', $content, 1);
        }

        if($returnContent == true) return $content;
        else echo $content;

    }

    function magicslideshowColumnsBackup(&$content) {
        //NOTE: backup left/right columns content
        static $backups = null;
        if($backups == null) {
            $backups = array();
            $matches = array();
            $pattern = '^(?|'.
                        '(.*?<!--\s*+body_text\s*+//-->)(.*?)(<!--\s*+body_text_eof\s*+//-->.*+)?'.
                        '|'.
                        '()(.*?<!--\s*+bodyContent\s*+//-->)(.*+)'.
                       ')$';
            if(preg_match("#{$pattern}#is", $content, $matches)) {
                $backups['left'] = $matches[1];
                $content = $matches[2];
                $backups['right'] = $matches[3];
            }
        } else {
            if(!empty($backups)) {
                $content = $backups['left'].$content.$backups['right'];
            }
            $backups = null;
        }
    }


    function MagicSlideshowSTSHead($content) {
        if(defined('MAGICSLIDESHOW_HEADERS') && !defined('MAGICSLIDESHOW_HEADERS_DISPLAYED')) {
            return preg_replace_callback('#</head>#is', 'magicslideshowHeaderCallback', $content, 1);
        } else {
            return $content;
        }
    }

    function magicslideshowHeaderCallback($matches) {
        if(defined('MAGICSLIDESHOW_HEADERS_DISPLAYED')) {
            return $matches[0];
        }
        define('MAGICSLIDESHOW_HEADERS_DISPLAYED', true);
        $tool = MagicSlideshowGetTool();
        $tool->params->resetProfile();

        //$styles = array();
        //$styles[] = "\n<style type=\"text/css\">\n";
        //$styles[] = "\ndiv.MagicToolboxContainer.MagicToolboxNewProductsBlock { margin: 0 auto; text-aling: center; }\n";
        //$styles[] = "\n</style>\n";
        //$styles = implode('', $styles);

        $https = isset($_SERVER['HTTP_X_FORWARDED_PROTO']) && $_SERVER['HTTP_X_FORWARDED_PROTO'] == 'https' ||
                 isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] && strtolower($_SERVER['HTTPS']) != 'off' ||
                 isset($_SERVER['SSL_PROTOCOL']) && $_SERVER['SSL_PROTOCOL'];
        return $tool->getHeadersTemplate(($https ? HTTPS_SERVER : HTTP_SERVER).DIR_WS_CATALOG.DIR_WS_MODULES.'magicslideshow/core')./*$styles.*/$matches[0];
    }

    function magicslideshowGetThumb($src, $size = null, $pid = null) {
        static $imageHelper = null;
        if($imageHelper === null) {
            $tool = MagicSlideshowGetTool();            
            require_once(dirname(__FILE__).'/magictoolbox.imagehelper.class.php');
            $imageHelper = new MagicToolboxImageHelperClass(DIR_FS_CATALOG, '/'.DIR_WS_IMAGES.'magictoolbox_cache', $tool->params, null, DIR_WS_CATALOG);
        }
        $src = str_replace('%20', ' ', $src);
        if($size === null) $size = 'thumb';
        //$thumb = $imageHelper->create($src, $size, $pid);
        return $imageHelper->create('/'.$src, $size, $pid);
    }

    function magicslideshowProcessBlock($class, $group, &$oscTemplate) {

        //NOTE: for osCommerce v2.3.0 or above

        switch($class) {
            case 'bm_specials':
                $block = 'specials';
                global $languages_id;
                $query = "SELECT p.products_id, pd.products_name, pd.products_description, p.products_price, p.products_image, s.specials_new_products_price FROM ".TABLE_PRODUCTS." p, ".TABLE_PRODUCTS_DESCRIPTION." pd, ".TABLE_SPECIALS." s WHERE p.products_status = '1' AND p.products_id = s.products_id AND pd.products_id = s.products_id AND pd.language_id = '".(int)$languages_id."' AND s.status = '1' ORDER BY s.specials_date_added DESC LIMIT ".MAX_RANDOM_SELECT_SPECIALS;
                break;
            case 'bm_reviews':
                $block = 'reviews';
                global $languages_id;
                $query = "SELECT r.reviews_id, r.reviews_rating, p.products_id, pd.products_name, pd.products_description, p.products_image FROM ".TABLE_REVIEWS." r, ".TABLE_REVIEWS_DESCRIPTION." rd, ".TABLE_PRODUCTS." p, ".TABLE_PRODUCTS_DESCRIPTION." pd WHERE p.products_status = '1' AND p.products_id = r.products_id AND r.reviews_id = rd.reviews_id AND rd.languages_id = '".(int)$languages_id."' AND p.products_id = pd.products_id AND pd.language_id = '".(int)$languages_id."' AND r.reviews_status = 1 ORDER BY r.reviews_id DESC LIMIT ".MAX_RANDOM_SELECT_REVIEWS;
                break;
            case 'bm_whats_new':
                $block = 'whats_new';
                global $languages_id;
                $query = "SELECT p.products_id, p.products_image, p.products_price, pd.products_name, pd.products_description FROM ".TABLE_PRODUCTS." p, ".TABLE_PRODUCTS_DESCRIPTION." pd WHERE p.products_status = '1' AND p.products_id = pd.products_id AND pd.language_id = '".(int)$languages_id."' ORDER BY p.products_date_added DESC LIMIT ".MAX_RANDOM_SELECT_NEW;
                break;
            default: return;
        }

        $tool = MagicSlideshowGetTool();
        $tool->params->setProfile($block);

        if(!$tool->params->checkValue('enable-effect', 'No', $block)) {

            $link = $tool->params->checkValue('link-to-product-page', 'Yes');

            $block_content = end($oscTemplate->_blocks[$group]);
            //$result = tep_db_query("SELECT COUNT(*) AS count FROM ".TABLE_PRODUCTS." WHERE products_status='1'");
            //$fields = tep_db_fetch_array($result);
            //$count = (int)$fields['count'];
            //if($count) {
            //}
            $result = tep_db_query($query);
            $items = array();
            $reviews = ($block == 'reviews');
            while($product = tep_db_fetch_array($result)) {
                $pid = (int)$product['products_id'];
                $product['products_image'] = DIR_WS_IMAGES.ltrim($product['products_image'], '/');
                $thumb = magicslideshowGetThumb($product['products_image'], 'thumb', $pid);
                $img = magicslideshowGetThumb($product['products_image'], 'original', $pid);
                $selector = magicslideshowGetThumb($product['products_image'], 'selector', $pid);
                $items[] = array(
                    'title' => $product['products_name'],
                    'alt' => $product['products_name'],
                    'description' => $product['products_description'],
                    'img' => $thumb,
                    'thumb' => $selector,
                    'fullscreen' => $img,
                    'link' => $link ? tep_href_link($reviews ? FILENAME_PRODUCT_REVIEWS_INFO : FILENAME_PRODUCT_INFO, 'products_id='.$product['products_id'].($reviews ? '&reviews_id='.$product['reviews_id'] : '')) : false,
                );
            }
            if(!empty($items)) {
                $html = $tool->getMainTemplate($items, array('id' => $block.'MagicSlideshow'));
                $html = '<div class="MagicToolboxContainer">'.$html.'</div>';
                $pattern =  '(<div\b[^>]*?\bclass="[^"]*?\b(?:infoBoxContents|panel-body)\b[^"]*+"[^>]*+>)'.
                            '('.
                            '(?:'.
                               '[^<]++'.
                               '|'.
                               '<(?!/?div\b|!--)'.
                               '|'.
                               '<!--.*?-->'.
                               '|'.
                               '<div\b[^>]*+>'.
                                   '(?2)'.
                               '</div\s*+>'.
                            ')*+'.
                            ')'.
                            '</div\s*+>';
                $block_content = preg_replace("#{$pattern}#is", "$1{$html}</div>", $block_content);
                $oscTemplate->_blocks[$group][key($oscTemplate->_blocks[$group])] = $block_content;
                defined('MAGICSLIDESHOW_HEADERS') || define('MAGICSLIDESHOW_HEADERS', true);
            }

        }

    }
