<?php

    $templateHTML = 'The settings does not exist! Make sure that the module is installed correctly.';

    if(!$magicscrollConfigurationExists) {
        return;
    }

    $action = isset($_POST['magicscroll-submit-action']) ? $_POST['magicscroll-submit-action'] : false;
    $activeTab = isset($_POST['magicscroll-active-tab']) ? $_POST['magicscroll-active-tab'] : false;

    $imageBasePath = MT_FS_ROOT.'images'.MT_DS.'magicscroll'.MT_DS;
    $imageBaseUrl = MT_WS_ROOT.'images/magicscroll/';

    if($_SERVER['REQUEST_METHOD'] == 'POST') {
        switch($action) {
            case 'save':
                if(isset($_POST['magictoolbox']) && is_array($_POST['magictoolbox'])) {
                    tep_db_query("UPDATE `magicscroll_configuration` SET `enabled` = 0 WHERE `block` != 'default'");
                    foreach($_POST['magictoolbox'] as $block => $params) {
                        if(!is_array($params)) continue;
                        foreach($params as $id => $value) {
                            $value = tep_db_prepare_input($value);
                            tep_db_query("UPDATE `magicscroll_configuration` SET `value` = '{$value}', `enabled` = 1 WHERE `block` = '{$block}' AND `name` = '{$id}'");
                        }
                    }
                }
                if(isset($_POST['images-update-data']) && is_array($_POST['images-update-data'])) {
                    is_dir($imageBasePath) || mkdir($imageBasePath);
                    foreach($_POST['images-update-data'] as $imageId => $imageData) {
                        if((int)$imageData['delete'] && !empty($imageData['name'])) {
                            @unlink($imageBasePath.$imageData['name']);
                            tep_db_query("DELETE FROM `magicscroll_images` WHERE `id` = {$imageId}");
                        } else {
                            $imageData['title'] = str_replace(array('"', '\'') , array('&quot;', '\'\''), $imageData['title']);
                            $imageData['description'] = str_replace(array('"', '\'') , array('&quot;', '\'\''), $imageData['description']);
                            //$imageData['description'] = addslashes($imageData['description']);
                            $imageData['link'] = str_replace(array('"', '\'') , array('&quot;', '\'\''), $imageData['link']);
                            $imageData['order'] = intval($imageData['order']);
                            $imageData['exclude'] = isset($imageData['exclude']) ? 1 : 0;
                            tep_db_query("UPDATE `magicscroll_images` SET `title` = '{$imageData['title']}', `description` = '{$imageData['description']}', `link` = '{$imageData['link']}', `image_order` = {$imageData['order']}, `exclude` = {$imageData['exclude']} WHERE `id` = {$imageId}");
                        }
                    }
                }
                $messageStack->add('Settings was saved.', 'success');
                break;
            case 'reset':
                tep_db_query("UPDATE `magicscroll_configuration` SET `value` = `default_value`, `enabled`=`default_enabled` WHERE `block`='{$activeTab}'");
                $messageStack->add('Settings was reset to defaults.', 'success');
                break;
            case 'upload':
                if(isset($_FILES['magicscroll-image-files']['tmp_name']) && is_array($_FILES['magicscroll-image-files']['tmp_name'])) {
                    is_dir($imageBasePath) || mkdir($imageBasePath);
                    foreach($_FILES['magicscroll-image-files']['tmp_name'] as $key => $tempName) {
                        if(!empty($tempName) && file_exists($tempName)) {
                            $name = preg_replace('/[^a-zA-Z0-9()_\.-]/is', '', $_FILES['magicscroll-image-files']['name'][$key]);
                            $ext = substr($name, strrpos($name, '.'));
                            $name = substr($name, 0, -strlen($ext));
                            $index = 0;
                            $suffix = '';
                            while(file_exists($imageBasePath.$name.$suffix.$ext)) {
                                $suffix = "({$index})";
                                $index++;
                            }
                            if(move_uploaded_file($tempName, $imageBasePath.$name.$suffix.$ext)) {
                                tep_db_query("INSERT INTO `magicscroll_images` (`name`, `title`, `description`, `link`, `image_order`, `exclude`) VALUES ('{$name}{$suffix}{$ext}', '', '', '', 0, 0)");
                            }
                        }
                    }
                }
                $messageStack->add('Image(s) was uploaded.', 'success');
            default :
        }
    }

    require_once(MT_FS_ROOT.'includes'.MT_DS.'modules'.MT_DS.'magicscroll'.MT_DS.'magicscroll.module.core.class.php');
    $tool = new MagicScrollModuleCoreClass;
    $result = tep_db_query('SELECT * FROM `magicscroll_configuration` WHERE `enabled` = 1');
    while($fields = tep_db_fetch_array($result)) {
        $tool->params->setValue($fields['name'], $fields['value'], $fields['block']);
    }

    $homeslideshowData = array();
    $result = tep_db_query("SELECT * FROM `magicscroll_images` ORDER BY `image_order`");
    while($fields = tep_db_fetch_array($result)) {
        $homeslideshowData[] = array(
            'id' => $fields['id'],
            'name' => $fields['name'],
            'title' => $fields['title'],
            'description' => $fields['description'],
            'link' => $fields['link'],
            'order' => $fields['image_order'],
            'exclude' => $fields['exclude'],
        );
    }

    $blocks = array(
		'default' => 'General',
		'homeslideshow' => 'Home page scroller',
		'product' => 'Product page',
		'new_products' => 'New products block',
		'whats_new' => 'New products box (sidebar)',
		'specials' => 'Specials box (sidebar)',
		'reviews' => 'Reviews box (sidebar)',
	);
    $map = array(
		'default' => array(
			'Positioning and Geometry' => array(
				'thumb-max-width' => true,
				'thumb-max-height' => true,
				'square-images' => true,
			),
			'Scroll' => array(
				'width' => true,
				'height' => true,
				'orientation' => true,
				'mode' => true,
				'items' => true,
				'speed' => true,
				'autoplay' => true,
				'loop' => true,
				'step' => true,
				'arrows' => true,
				'pagination' => true,
				'easing' => true,
				'scrollOnWheel' => true,
				'lazy-load' => true,
				'scroll-extra-styles' => true,
				'show-image-title' => true,
			),
			'Miscellaneous' => array(
				'link-to-product-page' => true,
				'imagemagick' => true,
				'image-quality' => true,
			),
			'Watermark' => array(
				'watermark' => true,
				'watermark-max-width' => true,
				'watermark-max-height' => true,
				'watermark-opacity' => true,
				'watermark-position' => true,
				'watermark-offset-x' => true,
				'watermark-offset-y' => true,
			),
		),
		'homeslideshow' => array(
			'General' => array(
				'enable-effect' => true,
			),
			'Setup slideshow for home page' => array(
			),
			'Positioning and Geometry' => array(
				'thumb-max-width' => false,
				'thumb-max-height' => false,
			),
			'Scroll' => array(
				'width' => false,
				'height' => false,
				'orientation' => false,
				'mode' => false,
				'items' => false,
				'speed' => false,
				'autoplay' => false,
				'loop' => false,
				'step' => false,
				'arrows' => false,
				'pagination' => false,
				'easing' => false,
				'scrollOnWheel' => false,
				'lazy-load' => false,
				'scroll-extra-styles' => false,
				'show-image-title' => false,
			),
			'Miscellaneous' => array(
				'link-to-product-page' => false,
			),
		),
		'product' => array(
			'General' => array(
				'enable-effect' => true,
			),
			'Positioning and Geometry' => array(
				'thumb-max-width' => false,
				'thumb-max-height' => false,
			),
			'Scroll' => array(
				'width' => false,
				'height' => false,
				'orientation' => false,
				'mode' => false,
				'items' => false,
				'speed' => false,
				'autoplay' => false,
				'loop' => false,
				'step' => false,
				'arrows' => false,
				'pagination' => false,
				'easing' => false,
				'scrollOnWheel' => false,
				'lazy-load' => false,
				'scroll-extra-styles' => false,
				'show-image-title' => false,
			),
		),
		'new_products' => array(
			'General' => array(
				'enable-effect' => true,
			),
			'Positioning and Geometry' => array(
				'thumb-max-width' => false,
				'thumb-max-height' => false,
			),
			'Scroll' => array(
				'width' => false,
				'height' => false,
				'orientation' => false,
				'mode' => false,
				'items' => false,
				'speed' => false,
				'autoplay' => false,
				'loop' => false,
				'step' => false,
				'arrows' => false,
				'pagination' => false,
				'easing' => false,
				'scrollOnWheel' => false,
				'lazy-load' => false,
				'scroll-extra-styles' => false,
				'show-image-title' => false,
			),
			'Miscellaneous' => array(
				'link-to-product-page' => false,
			),
		),
		'whats_new' => array(
			'General' => array(
				'enable-effect' => true,
			),
			'Positioning and Geometry' => array(
				'thumb-max-width' => false,
				'thumb-max-height' => false,
			),
			'Scroll' => array(
				'width' => false,
				'height' => false,
				'orientation' => false,
				'mode' => false,
				'items' => false,
				'speed' => false,
				'autoplay' => false,
				'loop' => false,
				'step' => false,
				'arrows' => false,
				'pagination' => false,
				'easing' => false,
				'scrollOnWheel' => false,
				'lazy-load' => false,
				'scroll-extra-styles' => false,
				'show-image-title' => false,
			),
			'Miscellaneous' => array(
				'link-to-product-page' => false,
			),
		),
		'specials' => array(
			'General' => array(
				'enable-effect' => true,
			),
			'Positioning and Geometry' => array(
				'thumb-max-width' => false,
				'thumb-max-height' => false,
			),
			'Scroll' => array(
				'width' => false,
				'height' => false,
				'orientation' => false,
				'mode' => false,
				'items' => false,
				'speed' => false,
				'autoplay' => false,
				'loop' => false,
				'step' => false,
				'arrows' => false,
				'pagination' => false,
				'easing' => false,
				'scrollOnWheel' => false,
				'lazy-load' => false,
				'scroll-extra-styles' => false,
				'show-image-title' => false,
			),
			'Miscellaneous' => array(
				'link-to-product-page' => false,
			),
		),
		'reviews' => array(
			'General' => array(
				'enable-effect' => true,
			),
			'Positioning and Geometry' => array(
				'thumb-max-width' => false,
				'thumb-max-height' => false,
			),
			'Scroll' => array(
				'width' => false,
				'height' => false,
				'orientation' => false,
				'mode' => false,
				'items' => false,
				'speed' => false,
				'autoplay' => false,
				'loop' => false,
				'step' => false,
				'arrows' => false,
				'pagination' => false,
				'easing' => false,
				'scrollOnWheel' => false,
				'lazy-load' => false,
				'scroll-extra-styles' => false,
				'show-image-title' => false,
			),
			'Miscellaneous' => array(
				'link-to-product-page' => false,
			),
		),
	);

    require(DIR_WS_INCLUDES.'modules/magicscroll/magictoolbox.settings.editor.class.php');
    $settings = new MagictoolboxSettingsEditorClass(MT_FS_ROOT.'includes'.MT_DS.'modules'.MT_DS.'magicscroll'.MT_DS.'core');
    $settings->paramsMap = &$map;
    $settings->core = &$tool;
    $settings->profiles = &$blocks;
    $settings->pathToJS = MT_FS_ROOT.'includes'.MT_DS.'modules'.MT_DS.'magicscroll'.MT_DS.'core';
    $settings->action = tep_href_link('magicscroll.php', '', 'NONSSL');//htmlentities($_SERVER['REQUEST_URI'])
    $settings->setResourcesURL(DIR_WS_INCLUDES.'modules/magicscroll/resources/');
    $settings->jQueryNoConflictLevel(0);
    $settings->customSlideshowProfileId = 'homeslideshow';
    $settings->customSlideshowGroupTitle = 'Setup slideshow for home page';
    $settings->customSlideshowGroupTitle = 'Setup slideshow for home page';
    $settings->imageBaseUrl = $imageBaseUrl;
    $settings->customSlideshowImagesData = &$homeslideshowData;
    $settings->isMagicScrollBundled = false;
    $templateHTML = $settings->getHTML();
