<?php /* Copyright (c) 2025 MagicToolbox */

    class osC_MagicZoomPlus {

        var $content, $tool, $params, $db, $imgKey, $scroll;

        function __construct() {
            /*if ( SERVICE_BANNER_SHOW_DUPLICATE == 'True' ) {
                $this->_show_duplicates_in_group = true;
            }*/
            require_once(DIR_FS_CATALOG . 'includes/magictoolbox/magiczoomplus.module.core.class.php');
            $this->tool = new MagicZoomPlusModuleCoreClass();
            $this->params = & $this->tool->params;
            $this->db = & $GLOBALS['osC_Database'];

            $this->loadParams();

            if($this->tool->params->checkValue('magicscroll', 'yes')) {
                require_once(DIR_FS_CATALOG . 'includes/magictoolbox/magicscroll.module.core.class.php');
                $this->scroll = new MagicScrollModuleCoreClass(false);
                //NOTE: load params in a separate profile, in order not to overwrite the options of MagicScroll module (in the future)
                $this->scroll->params->appendParams($this->tool->params->getParams(), 'product-magicscroll-options');
                $this->scroll->params->setValue('orientation', ($this->tool->params->checkValue('template', array('left', 'right')) ? 'vertical' : 'horizontal'), 'product-magicscroll-options');
            }
        }

        function loadParams() {
            foreach($this->params->getParams() as $key => $param) {
                $value = @constant('MODULE_MAGICZOOMPLUS_' . strtoupper($key));
                if($value === null) $value = $param["default"];
                $this->params->setValue($key, $value);
            }
        }

        function afterPageContent() {

            $gzh = in_array('ob_gzhandler', ob_list_handlers()); 
            $this->content = ob_get_clean();
            if($gzh) {
                ob_start('ob_gzhandler');
            }

            $group = basename($_SERVER['SCRIPT_FILENAME']);
            if (($pos = strrpos($group, '.')) !== false) {
                $group = substr($group, 0, $pos);
            }

            //if(isset($GLOBALS['osC_Product']) && is_a($GLOBALS['osC_Product'], 'osC_Product')) {
            if($group == 'products') {
                $headers = $this->tool->getHeadersTemplate(HTTP_SERVER . DIR_WS_HTTP_CATALOG . 'includes/magictoolbox');
                if($this->tool->params->checkValue('magicscroll', 'yes')) {
                    $this->scroll->params->resetProfile();
                    $headers .= $this->scroll->getHeadersTemplate(HTTP_SERVER . DIR_WS_HTTP_CATALOG . 'includes/magictoolbox', null, false);
                }
                $this->content = preg_replace('/<\/head>/is', $headers . '</head>', $this->content, 1);

                foreach($GLOBALS['osC_Product']->getImages() as $key => $image) {
                    if($image['default_flag'] == 1) {
                        $this->imgKey = $key;
                        $product_image = preg_quote(DIR_WS_IMAGES . 'products/product_info/' . $image['image'], '/');
                        $pattern = "<img[^>]*src=\"$product_image\"[^>]*(?:>)(?:[^<]*<\/img>)?";
                        $pattern = "(?:<a[^>]*>){$pattern}(.*?)(?:<\/a>)";
                        $this->content = preg_replace_callback("/{$pattern}/is", array($this, "callbackImageReplace"), $this->content);
                    }
                }
            }

            echo $this->content;

            //print_r($GLOBALS['osC_Product']);
            //echo "adhaldhjasklhdakls";
            //print_r($GLOBALS);
        }

        function callbackImageReplace($matches) {
            $images = $GLOBALS['osC_Product']->getImages();
            $title = $GLOBALS['osC_Product']->getTitle();
            $main = $this->tool->getMainTemplate(array(
                'id' => $GLOBALS['osC_Product']->getID(),
                'img' => DIR_WS_IMAGES . 'products/originals/' . $images[$this->imgKey]['image'],
                'thumb' => DIR_WS_IMAGES . 'products/product_info/' . $images[$this->imgKey]['image'],
                'title' => $title,
                'description' => $GLOBALS['osC_Product']->getDescription()
            ));
            $thumbs = array();
            if(count($images) > 1) {
                foreach($images as $k => $image) {
                    $r = $this->tool->getSelectorTemplate(array(
                        'id' => $GLOBALS['osC_Product']->getID(),
                        'img' => DIR_WS_IMAGES . 'products/originals/' . $image['image'],
                        'medium' => DIR_WS_IMAGES . 'products/product_info/' . $image['image'],
                        'thumb' => DIR_WS_IMAGES . 'products/mini/' . $image['image'],
                        'title' => $title,
                    ));
                    $thumbs[] = str_replace('<a ', '<a style="margin: 0 5px;" ', $r);
                }
            }
            $this->tool->params->setValue('thumb-max-width', 200);
            $this->tool->params->setValue('thumb-max-height', 200);
            $this->tool->params->setValue('selector-max-width', 50);
            $this->tool->params->setValue('selector-max-height', 50);
            // template helper class
            require_once(DIR_FS_CATALOG . 'includes/magictoolbox/magictoolbox.templatehelper.class.php');
            MagicToolboxTemplateHelperClass::setPath(DIR_FS_CATALOG . 'includes/magictoolbox/templates');
            MagicToolboxTemplateHelperClass::setOptions($this->tool->params);
            return MagicToolboxTemplateHelperClass::render(array(
                'main' => $main,
                'thumbs' => $thumbs,
                'magicscrollOptions' => empty($this->scroll) ? '' : $this->scroll->params->serialize(false, '', 'product-magicscroll-options'),
                'pid' => $GLOBALS['osC_Product']->getID(),
            ));
        }

        function install() {

            $values = $v =array();
            foreach($this->params->getParams() as $p) {
                switch($p["type"]) {
                    case "array":
                        //$func = "tep_cfg_select_option(array(\'" . implode("\', \'",$p['values']) . "\'), ";
                        $func = 'osc_cfg_set_boolean_value(array(\'' . implode('\', \'', $p['values']) . '\'))';
                        //die($func);
                        break;
                    case "num":
                    case "text":
                    default: $func = 'NULL';
                }
                if(!isset($p["description"])) $p["description"] = '';
                $v = array();
                $v[] = '\'' . addslashes($p['label']) . '\'';
                $v[] = '\'' . addslashes('MODULE_MAGICZOOMPLUS_' . strtoupper($p['id'])) . '\'';
                $v[] = '\'' . addslashes($p['default']) . '\'';
                $v[] = '\'' . addslashes($p["description"]) . '<br/>' . ((($p["type"] != "array") && isset($p["values"])) ? ("#allowed values: " . implode(", ",$p["values"])) : "") . '\'';
                $v[] = 6;
                $v[] = 0;
                $v[] = ($func == 'NULL') ? $func : ('\'' . addslashes($func) . '\'');
                //$v[] = $func;
                $v[] = 'NOW()';
                $values[] = implode(',', $v);
            }
            $this->db->simpleQuery(
                'INSERT INTO ' . 
                        TABLE_CONFIGURATION . ' (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) 
                    VALUES (' . implode('), (', $values) . ')'
            );

            //NOTE: fix url's in css files
            $this->fixCSS();

        }

        function remove() {
            $this->db->simpleQuery('DELETE FROM ' . TABLE_CONFIGURATION . ' WHERE configuration_key LIKE \'MODULE_MAGICZOOMPLUS_%\'');
        }

        function keys() {
            $keys = array_keys($this->params->getParams());
            for($i=0, $l=count($keys); $i<$l; $i++) {
                $keys[$i] = 'MODULE_MAGICZOOMPLUS_' . strtoupper($keys[$i]);
            }
            return $keys;
        }

        function fixCSS() {

            //NOTE: fix url's in css files
            define('MT_DS', DIRECTORY_SEPARATOR);
            $path = str_replace('/', MT_DS, DIR_FS_CATALOG.'includes/magictoolbox');
            $list = glob($path.MT_DS.'*');
            $files = array();
            if(is_array($list)) {
                for($i = 0; $i < count($list); $i++) {
                    if(is_dir($list[$i])) {
                        if(!in_array(basename($list[$i]), array('.svn', '.git'))) {
                            $add = glob($list[$i].MT_DS.'*');
                            if(is_array($add)) {
                                $list = array_merge($list, $add);
                            }
                        }
                    } else if(preg_match('#\.css$#i', $list[$i])) {
                        $files[] = $list[$i];
                    }
                }
            }

            foreach($files as $file) {
                if(!is_writable($file)) {
                    continue;
                }
                $cssPath = dirname($file);
                $cssRelPath = str_replace(str_replace(MT_DS, '/', $path), '', str_replace(MT_DS, '/', $cssPath));
                $toolPath = DIR_WS_HTTP_CATALOG.'includes/magictoolbox'.$cssRelPath;
                $pattern = '#url\(\s*(\'|")?(?!data:|mhtml:|http(?:s)?:|/)([^\)\s\'"]+?)(?(1)\1)\s*\)#is';
                $replace = 'url($1'.$toolPath.'/$2$1)';
                $fileContents = file_get_contents($file);
                $fixedFileContents = preg_replace($pattern, $replace, $fileContents);
                //preg_match_all($pattern, $fileContents, $matches, PREG_SET_ORDER);
                //debug_log($matches);
                if($fixedFileContents != $fileContents) {
                    $fp = fopen($file, 'w+');
                    if($fp) {
                        fwrite($fp, $fixedFileContents);
                        fclose($fp);
                    }
                }
            }

        }

    }

?>
