<?php /* Copyright (c) 2025 MagicToolbox */

    class osC_Services_magiczoomplus_Admin {
        var $title,
            $description,
            $uninstallable = true,
            $depends,
            $precedes;

        function __construct() {
            global $osC_MagicZoomPlus, $osC_Database;
            
            //$osC_Language->loadIniFile('modules/services/magictoolbox.php');

            $this->title = 'Magic Zoom Plus'; //$osC_Language->get('services_banner_title');
            //$this->description = $osC_Language->get('services_banner_description');
            
            require_once(DIR_FS_CATALOG . 'includes/classes/magiczoomplus.php');
            if(!is_a($osC_MagicZoomPlus, 'osC_MagicZoomPlus')) {
                $osC_MagicZoomPlus = new osC_MagicZoomPlus();
            }
        }

        function install() {
            global $osC_MagicZoomPlus;
            $osC_MagicZoomPlus->install();
            /*$osC_Database->simpleQuery("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) VALUES ('Display Duplicate Banners', 'SERVICE_BANNER_SHOW_DUPLICATE', '-1', 'Show duplicate banners in the same banner group on the same page?', '6', '0', 'osc_cfg_use_get_boolean_value', 'osc_cfg_set_boolean_value(array(1, -1))', now())");*/
            $this->sendStat('install');
        }

        function remove() {
            global $osC_MagicZoomPlus;
            $osC_MagicZoomPlus->remove();
            /*$osC_Database->simpleQuery("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");*/
            $this->sendStat('uninstall');
        }

        function keys() {
            global $osC_MagicZoomPlus;
            return $osC_MagicZoomPlus->keys();
            //return array('this array should not be empty');
        }

        function sendStat($action = '') {

            //NOTE: don't send from working copy
            if('working' == 'v2.1.5' || 'working' == 'v5.3.7') {
                return;
            }

            $hostname = 'www.magictoolbox.com';

            $url = $_SERVER['HTTP_HOST'].preg_replace('/\/$/i', '', DIR_WS_HTTP_CATALOG);
            $url = urlencode(urldecode($url));

            $platformVersion = preg_replace('/^.*?v(\d+(?:\.\d+)+).*?$/is', '$1', PROJECT_VERSION);

            $path = "api/stat/?action={$action}&tool_name=magiczoomplus&license=trial&tool_version=v5.3.7&module_version=v2.1.5&platform_name=oscommerce3&platform_version={$platformVersion}&url={$url}";
            $handle = @fsockopen('ssl://' . $hostname, 443, $errno, $errstr, 30);
            if($handle) {
                $headers  = "GET /{$path} HTTP/1.1\r\n";
                $headers .= "Host: {$hostname}\r\n";
                $headers .= "Connection: Close\r\n\r\n";
                fwrite($handle, $headers);
                fclose($handle);
            }

        }

    }

?>
