<?php
/**
* Magic Zoom osCMax Module
*
* @version v4.9.1 [v1.6.103:v5.3.7]
* @author Magic Toolbox
* @copyright (C) 2008 Magic Toolbox. All rights reserved.
* @link http://www.magictoolbox.com/magiczoom/
* @license http://www.magictoolbox.com/license/
*
* Magic Zoom osCMax Module comes with absolute no warranty.
*/

    defined('OPTIONS_AS_COLOR_SWATCHES_ENABLED') || define('OPTIONS_AS_COLOR_SWATCHES_ENABLED', false);

    defined('NEW_OSC_VERSION') || define('NEW_OSC_VERSION', false);
    if(!defined('NEW_OSCMAX_VERSION')) {
        $match = array();
        if(defined('PROJECT_VERSION') && preg_match('/\d+\.\d+(?:\.\d+)*/is', PROJECT_VERSION, $match) && version_compare($match[0], '2.5.0', '>=')) {
            define('NEW_OSCMAX_VERSION', true);
        } else {
            define('NEW_OSCMAX_VERSION', false);
        }
    }

    function MagicZoomGetTool() {
        static $mainTool = null;
        if($mainTool == null) {
            require_once(dirname(__FILE__).'/magiczoom.module.core.class.php');
            $mainTool = new MagicZoomModuleCoreClass;

            $result = tep_db_query("SHOW TABLES LIKE 'magiczoom_configuration'");
            if($result && tep_db_num_rows($result)) {
                $result = tep_db_query('SELECT * FROM `magiczoom_configuration` WHERE `enabled` = 1');
                while($fields = tep_db_fetch_array($result)) {
                    $mainTool->params->setValue($fields['name'], $fields['value'], $fields['block']);
                }
            }

            //NOTE: load locale config
            require_once(DIR_WS_LANGUAGES.$GLOBALS['language'].'/modules/magictoolbox/magiczoom.php');
            if(defined('MODULE_MAGICTOOLBOX_MAGICZOOM_MESSAGE')) {
                $mainTool->params->setValue('message', MODULE_MAGICTOOLBOX_MAGICZOOM_MESSAGE);
            }
            if(defined('MODULE_MAGICTOOLBOX_MAGICZOOM_LOADING_MESSAGE')) {
                $mainTool->params->setValue('loading-msg', MODULE_MAGICTOOLBOX_MAGICZOOM_LOADING_MESSAGE);
            }

            //NOTE: is this CRELoaded engine?
            $mainTool->params->setValue('creloaded', function_exists('tep_javascript_image_original'));

            //NOTE: is this osCmax?
            $mainTool->params->setValue('oscmax', defined('PROJECT_VERSION') && preg_match('/oscmax/is', PROJECT_VERSION));

            //NOTE: dir-ws-images
            $dirWSimages = DIR_WS_IMAGES;
            !empty($dirWSimages) || ($dirWSimages = 'images/');
            if(defined('DYNAMIC_MOPICS_THUMBS_DIR')) {
                $dirWSimages .= DYNAMIC_MOPICS_THUMBS_DIR;
            }
            $mainTool->params->setValue('dir-ws-images', $dirWSimages);
            $mainTool->params->setValue('dir-ws-images-quoted', preg_quote(trim($dirWSimages), '/'));

        }
        return $mainTool;
    }


    $tool = MagicZoomGetTool();

    //NOTE: rewrite 'tep_javascript_image' function for CRELoaded engine
    //NOTE: original 'tep_javascript_image' function of CRELoaded engine should be rename to 'tep_javascript_image_original'
    //      (includes/functions/html_output.php -> function tep_javascript_image)
    if($tool->params->checkValue('creloaded', true)) {
        function tep_javascript_image($src, $name, $alt = '', $width = '', $height = '', $parameters = '', $popup = false) {

            $tool = MagicZoomGetTool();
            $tool->params->setProfile('product');

            if(!$tool->params->checkValue('enable-effect', 'No'))
            if(($GLOBALS['content'] == 'product_info' || $GLOBALS['content'] == 'product_info_tabs')) {
                $img = '';
                foreach(array('', '_med', '_lrg') as $key) {
                    if(!empty($GLOBALS['product_info']['products_image'.$key])) {
                        $img = $GLOBALS['product_info']['products_image'.$key];
                    }
                }

                if(empty($img)) return tep_javascript_image_original($src, $name, $alt, $width, $height, $parameters, $popup);
                $img = $tool->params->getValue('dir-ws-images').$img;
                $thumb = magiczoomGetThumb($img, null, $GLOBALS['product_info']['products_id']);
                $img = magiczoomGetThumb($img, 'original', $GLOBALS['product_info']['products_id']);

                $return = callback_MagicToolbox(array('', '', ''), $img, $thumb, $tool->params->getValue('thumb-max-width'), 'productImage', '', $alt);
                //NOTE: to the picture does not become too small
                $return = preg_replace('#class="([^"]*?MagicToolboxContainer[^"]*+)"#i', 'class="$1 minWidth"', $return);
                //NOTE: to output headers
                defined('MAGICZOOM_HEADERS') || define('MAGICZOOM_HEADERS', true);

                return $return;
            }

            return tep_javascript_image_original($src, $name, $alt, $width, $height, $parameters, $popup);
        }
    }

    function MagicZoom($content = null, $block = null) {
        //debug_log("MagicZoom => {$block}");

        $returnContent = false;
        if($content == null) {
            $content = ob_get_contents();
            ob_end_clean();
        } else {
            $returnContent = true;
            ob_end_flush();
        }
        $tool = MagicZoomGetTool();

        $product_info = &$GLOBALS['product_info'];
        if(isset($GLOBALS['review'])) $product_info = $GLOBALS['review'];        

        if(!defined('MULTIPLE_IMAGES_FOR_PRODUCTS') && is_array($product_info) && array_key_exists('product_image_2', $product_info)) {
            //NOTE: Multiple Images for Products for osCommerce v2.2
            define('MULTIPLE_IMAGES_FOR_PRODUCTS', true);
        }

        //NOTE: is Enabled Color Swatches on current page
        $isColorSwatchesEnabled = false;
        if(isset($GLOBALS['products_image']))
        if($GLOBALS['products_image'] != $product_info['products_image']) {
            $isColorSwatchesEnabled = true;
        }

        //NOTE: backup left/right columns content
        if(NEW_OSC_VERSION) {
            $columnsPattern = '/^(.*?<\!--\sbodyContent\s\/\/-->)(.*?)(<\!--\sbodyWrapper\s\/\/-->.*)?$/is';
            $replace1 = '$2';
            $replace2 = '$1_MAGICTOOLBOX_COLUMNS_BACKUP_$3';
        } else {
            $columnsPattern = '/^(.*?<\!--\sbody_text\s\/\/-->)(.*?)(<\!--\sbody_text_eof\s\/\/-->.*)?$/is';
            $replace1 = '$1_MAGICTOOLBOX_COLUMNS_BACKUP_$3';
            $replace2 = '$2';
        }
        $contentBackup = preg_replace($columnsPattern, $replace1, $content);
        if($contentBackup === null || $contentBackup == $content) {
            $contentBackup = false;
        } else {
            $content = preg_replace($columnsPattern, $replace2, $content);
        }
        if($contentBackup == false) {
            $contentBackup = preg_replace('/^(.*?<\!--\scontent\s\/\/-->)(.*?)(<\!--\scontent_eof\s\/\/-->.*)?$/is', '$1_MAGICTOOLBOX_COLUMNS_BACKUP_$3', $content);
            if($contentBackup === null || $contentBackup == $content) {
                $contentBackup = false;
            } else {
                $content = preg_replace('/^(.*?<\!--\scontent\s\/\/-->)(.*?)(<\!--\scontent_eof\s\/\/-->.*)?$/is', '$2', $content);
            }
        }


        //NOTE: backup <noscript> tags
        $GLOBALS['magictoolbox_noscripts_backups'] = array();
        $content = preg_replace_callback('#(<noscript>.*</noscript>)#iUs', 'MagicToolbox_callback_noscript', $content);

        //$categoryPage = false;
        //$productPage = false;

        $page = '';
        if(!$block &&
           ((
             !$tool->params->checkValue('enable-effect', 'No', 'category') &&
             ($GLOBALS['category_depth'] == 'products' && intval($GLOBALS['current_category_id']) > 0 || intval($_GET['manufacturers_id']) > 0) &&
             ($page = 'category')
             //||
             //(isset($GLOBALS['category_depth']) && in_array($GLOBALS['category_depth'], array('top', 'nested'))) &&
             //!$tool->params->checkValue('enable-effect', 'No', 'new_products') &&
             //($page = 'new_products')
            ) &&
            preg_match('#/index.php$#is', $_SERVER['SCRIPT_NAME'])
            || !$tool->params->checkValue('enable-effect', 'No', 'products_new') && (preg_match('#/products_new.php$#is', $_SERVER['SCRIPT_NAME']) || (NEW_OSCMAX_VERSION && isset($_REQUEST['new_products']))) && ($page = 'products_new')
           ) ||
           $block && !$tool->params->checkValue('enable-effect', 'No', $block) && ($page = $block) /*&& !($block == 'reviews' && preg_match('#/product_info.php$#is', $_SERVER['SCRIPT_NAME']))*/
          ) {

            if($page == 'new_products') $block = null;
            //debug_log("page => {$page}");
            $tool->params->setProfile($page);

            $list_box_contents = isset($GLOBALS['list_box_contents']) ? $GLOBALS['list_box_contents'] : null;
            $info_box_contents = isset($GLOBALS['info_box_contents']) ? $GLOBALS['info_box_contents'] : null;

            if($list_box_contents && isset($list_box_contents[0][0]['params']) && preg_match('/productListing-heading/is', $list_box_contents[0][0]['params'])) {
                // remove table header
                array_shift($list_box_contents);
            }

            if(!isset($list_box_contents[0]['text']) && !isset($list_box_contents[0][0]['text']) || $block) {
                $products_list_contents = $info_box_contents;
            } else {
                $products_list_contents = $list_box_contents;
            }

            if($tool->params->getValue('oscmax') && isset($GLOBALS['box_content'])) {
                $products_list_contents = $GLOBALS['box_content'];
            }

            if($block) {
                if(!$tool->params->getValue('oscmax')) {
                    $products_list_contents = array($products_list_contents);
                } else {
                    $products_list_contents = array(array(array('text' => $GLOBALS['boxContent'])));
                }
            } else {
                if($page == 'products_new') {
                    $products_list_contents = array(array());
                    if(NEW_OSCMAX_VERSION) {
                        tep_db_data_seek($GLOBALS['listing_query'], 0);
                        while($products_new = tep_db_fetch_array($GLOBALS['listing_query'])) {
                            $products_list_contents[0][] = $products_new;
                        }
                    } else {
                        tep_db_data_seek($GLOBALS['products_new_query'], 0);
                        while($products_new = tep_db_fetch_array($GLOBALS['products_new_query'])) {
                            $products_list_contents[0][] = $products_new;
                        }
                    }
                }

                if($page == 'special_products' && isset($GLOBALS['specials_query'])) {
                    $products_list_contents = array(array());
                    tep_db_data_seek($GLOBALS['specials_query'], 0);
                    while($specials = tep_db_fetch_array($GLOBALS['specials_query'])) {
                        $products_list_contents[0][] = $specials;
                    }
                }

                if($page == 'review_products' && isset($GLOBALS['reviews_query'])) {
                    $products_list_contents = array(array());
                    tep_db_data_seek($GLOBALS['reviews_query'], 0);
                    while($reviews = tep_db_fetch_array($GLOBALS['reviews_query'])) {
                        $products_list_contents[0][] = $reviews;
                    }
                }
            }

            if(NEW_OSC_VERSION && ($page == 'category' || $page == 'new_products' || $page == 'products_new' || $page == 'special_products')) {

                //NOTICE: in OSC 2.3.x this code causes the module is not working on New products page (products_new.php)
                //        why this code is necessary?
                //if($page != 'special_products') $products_list_contents = array();

                $pattern = '/<a[^>]*?href="([^"]*?products_id=(\d*)[^"]*)"[^>]*><img[^>]*?src="([^"]*)"[^>]*><\/a>/is';
                $matches = array();
                $wrapper = false;
                switch($page) {
                    case 'category':
                        $isGalleryMatched = preg_match_all($pattern, $GLOBALS['prod_list_contents'], $matches, PREG_SET_ORDER);
                        $group = 'CategoryPage';
                        break;
                    case 'new_products':
                        $isGalleryMatched = preg_match_all($pattern, $GLOBALS['new_prods_content'], $matches, PREG_SET_ORDER);
                        $group = 'NewProductsBlock';
                        //NOTE: added support for Bootstrapped Responsive osCommerce
                        $wrapper = 'MagicToolboxNewProductsBlockContainer';
                        break;
                    //NOTE: added support for Bootstrapped Responsive osCommerce
                    case 'products_new':
                        $isGalleryMatched = preg_match_all($pattern, $GLOBALS['prod_list_contents'], $matches, PREG_SET_ORDER);
                        $group = 'NewProductsPage';
                        $wrapper = 'MagicToolboxProductsNewContainer';
                        break;
                    //NOTE: added support for Bootstrapped Responsive osCommerce
                    case 'special_products':
                        $isGalleryMatched = preg_match_all($pattern, $GLOBALS['prod_list_contents'], $matches, PREG_SET_ORDER);
                        $group = 'SpecialProductsPage';
                        $wrapper = 'MagicToolboxSpecialProductsContainer';
                        break;
                }
                if($isGalleryMatched) {
                    $products_list_contents = array();
                    foreach($matches as $match) {
                        if($tool->params->checkValue('link-to-product-page', 'Yes')) {
                            $link = $match[1];
                        } else {
                            $link = '';
                        }
                        $id = $match[2];
                        $src = $match[3];
                        $productInfo = MagicToolbox_getProductInfo($id);
                        $title = $productInfo['title'];
                        $description = $productInfo['description'];
                        $pid = empty($id) ? null : $id;
                        $thumb = magiczoomGetThumb($src, 'thumb', $pid);
                        $img = magiczoomGetThumb($src, 'original', $pid);
                        $template = $tool->getMainTemplate(compact('img', 'thumb', 'id', 'group', 'title', 'description', 'link'));
                        if($wrapper) {
                            $template = '<div class="'.$wrapper.'">'.$template.'</div>';
                        }
                        $content = str_replace($match[0], $template, $content);
                    }
                }
            }

            if(is_array($products_list_contents))//NOTE: to fix warning at category page that has no product
            foreach($products_list_contents as $row) {
              foreach($row as $key => $arr) {
                if(!is_int($key)) {
                    continue;
                }
                //if($page == 'products_new' || $page == 'special_products' || $page == 'review_products') {
                if(in_array($page, array('products_new', 'special_products', 'review_products')) && isset($arr['products_image'])) {
                    $imgOrig = $img = $tool->params->getValue('dir-ws-images').$arr['products_image'];
                    $id = $arr['products_id'];
                    $aHref = false;
                    if(function_exists('tep_href_link')) {
                        if($page == 'products_new' || $page == 'special_products') {
                            $aHref = tep_href_link(FILENAME_PRODUCT_INFO, 'products_id='.$id);
                        } else if($page == 'review_products') {
                            $aHref = tep_href_link(FILENAME_PRODUCT_REVIEWS_INFO, 'products_id='.$id.'&reviews_id='.$arr['reviews_id']);
                        }
                    }
                } else {
                    $text = $arr['text'];
                    if(NEW_OSCMAX_VERSION) {
                        $img = preg_replace("/^.*?<a[^>]*>[^<]*<img[^>]*?src=\"([^\"]*)\"[^>]*?class=\"img\"[^>]*>[^<]*<\/a>.*$/is", '$1', $text);
                    } else {
                        $img = preg_replace("/^.*?<img[^>]*src=\"(.*?)\".*$/is", '$1', $text);
                    }
                    if($img == $text || preg_match('#buy.now|pixel_(?:trans|black|silver)|review\.png#is', $img)) {
                        continue;
                    }
                    $imgOrig = $img;
                    //$aClass = preg_replace("/^.*?<a[^>]*class=\"(.*?)\".*$/is", '$1', $text);
                    $aHref = preg_replace("/^.*?<a[^>]*href=\"(.*?)\".*$/is", '$1', $text);
                    $id = preg_replace("/^.*?products_id=(\d+).*$/is", '$1', $aHref);

                    $title = preg_replace("/^.*?<img[^>]*title=\"(.*?)\".*$/is", '$1', $text);
                    if($title == $text) $title = preg_replace("/^.*?<img[^>]*alt=\"(.*?)\".*$/is", '$1', $text);
                    if($title == $text) $title = '';

                    /*if($aClass == $text) {
                        $text = preg_replace("/^(.*?)<a(.*)$/is", "$1<a class=\"MagicThumb\"$2", $text);
                    } else {
                        $text = preg_replace("/^(.*?<a[^>]*)class=\".*?\"(.*)$/is", "$1class=\"".trim($aClass)." MagicThumb\"$2", $text);
                    }*/
                }
                $pInfo = MagicToolbox_getProductInfo($id);

                if(defined('DYNAMIC_MOPICS_THUMBS_DIR')) {
                    $img = str_replace(DYNAMIC_MOPICS_THUMBS_DIR, DYNAMIC_MOPICS_BIGIMAGES_DIR, $img);
                    $imgOrig_ = str_replace(DYNAMIC_MOPICS_THUMBS_DIR, '', $img);
                    $imgOrig = '(?:(?:'.preg_quote($imgOrig, '/').')|(?:'.preg_quote($imgOrig_, '/').'))';
                } else {
                    $imgOrig = preg_quote($imgOrig, '/');
                }

                if(tep_db_num_rows(tep_db_query("show tables like '%additional_images'")) >= 1) {
                    /* support Additional Images Module osCommerce addon (http://addons.oscommerce.com/info/1032) */
                    $img = preg_replace('/[sml]\.([^\.]+)$/is', '.$1', $img);
                }
                //$img = preg_replace("/^\/?(?:product_thumb|imagemagic|timthumb|oscthumb)\.php\?(?:img|src)=([^\&]*)\&.*$/is", '$1', $img);
                $img = preg_replace("/^\/?[a-zA-Z_]+\.php\?(?:img|src)=([^\&]*)\&.*$/is", '$1', $img);
                $img = str_replace('thumbs_cache/', '', $img);
                if(isset($GLOBALS['oscthumb'])) {
                    if(!function_exists('mt_urlsafe_b64decode')) {
                        function mt_urlsafe_b64decode($string) {
                            $data = str_replace(array('-', '_', '.'), array('+', '/', '='), $string);
                            $mod4 = strlen($data) % 4;
                            if($mod4) {
                                $data .= substr('====', $mod4);
                            }
                            return base64_decode($data);
                        }
                    }
                    if(CFG_ENCRYPT_FILENAMES == 'True' && CFG_ENCRYPTION_KEY != '') {
                        $result = '';
                        $key=CFG_ENCRYPTION_KEY;
                        $string = mt_urlsafe_b64decode($img);
                        for($i=0; $i < strlen($string); $i++) {
                            $char = substr($string, $i, 1);
                            $keychar = substr($key, ($i % strlen($key)) - 1, 1);
                            $char = chr(ord($char)-ord($keychar));
                            $result .= $char;
                        }
                        $img = $result;
                    }
                }
                $img = preg_replace('/^\//is', '', $img);
                $pid = empty($id) ? null : $id;
                $thumb = magiczoomGetThumb($img, 'thumb', $pid);
                $img = magiczoomGetThumb($img, 'original', $pid);

                if($pInfo !== false) {
                    $title = trim($pInfo['title']);
                    $description = trim($pInfo['description']);
                } else $description = '';

                if($tool->params->checkValue('link-to-product-page', 'Yes')) {
                    $link = $aHref;
                } else {
                $link = '';
                }

                $id = substr(md5($page.$img), 0, 10);

                $text = $tool->getMainTemplate(compact('img', 'thumb', 'id', 'title', 'description', 'link'));

                if($page == 'products_new' || $page == 'special_products' || $page == 'review_products') {
                    //$content = preg_replace('/<a[^>]+><img[^>]+?src=\"'.$imgOrig.'\"[^>]+><\/a>/is', $text, $content);
                    //NOTE: fixed regexp to add support for Bootstrapped Responsive osCommerce
                    $content = preg_replace('/(<a\b[^>]*+>[^<]*+)?<img\b[^>]+?src="'.$imgOrig.'"[^>]+>(?(1)[^<]*+<\/a>)/is', $text, $content);
                } else {
                    if($tool->params->getValue('oscmax')) {
                        $content = preg_replace('/<a[^>]+><img[^>]+?src=\"'.$imgOrig.'\"[^>]+><\/a>/is', $text, $content);
                    } else {
                        $text = preg_replace('/<a[^>]+><img[^>]+?src=\"'.$imgOrig.'\"[^>]+><\/a>/is', $text, $arr['text']);
                        $content = str_replace($arr['text'], $text, $content);
                    }
                }
              }
            }
            //if($block) {
            //    defined('MAGICZOOM_HEADERS') || define('MAGICZOOM_HEADERS', true);
            //}
            //$categoryPage = true;
            defined('MAGICZOOM_HEADERS') || define('MAGICZOOM_HEADERS', true);
        } else

        if(!$tool->params->checkValue('enable-effect', 'No', 'product') && $product_info && is_array($product_info) && !$block /*&& !$categoryPage*/) {

            $tool->params->setProfile('product');

            //$productPage = true;
            defined('MAGICZOOM_HEADERS') || define('MAGICZOOM_HEADERS', true);

            if($tool->params->checkValue('creloaded', false)) {
                /* product image parce - only for original osCommerce distributive (no CRELoaded engine!)*/
                $product_image = $product_info['products_image'];

                $srcAddons = '';
                if($isColorSwatchesEnabled && OPTIONS_AS_COLOR_SWATCHES_ENABLED && is_array($GLOBALS['products_options_array']) && !empty($GLOBALS['products_options_array'])) {
                    $srcAddons = array();
                    foreach($GLOBALS['products_options_array'] as $po) {
                        // comented.. maybe should be used for old versions of color swatches
                        //$srcAddons[] = $po['att_id'];
                        $srcAddons[] = preg_quote($po['image'], '/');
                    }
                    //$srcAddons = '(?:(?:options\/)?(?:(?:'.implode(')|(?:', $srcAddons).'))_)?';
                    $srcAddons = '(?:(?:options\/)?(?:(?:'.implode(')|(?:', $srcAddons).')))?';
                    $product_image = '';
                }

                if(isset($product_info['products_image_med']) && isset($product_info['products_image_pop'])) {
                    if(!empty($product_info['products_image_med'])) {
                        $product_image = $product_info['products_image_med'];
                    } elseif(!empty($product_info['products_image_pop'])) {
                        $product_image = $product_info['products_image_pop'];
                    }
                }

                if(isset($product_info['products_image_med']) && !empty($product_info['products_largeimage'])) {
                    /* support Additional Images Module osCommerce addon (http://addons.oscommerce.com/info/1032) */
                    $product_image = $product_info['products_largeimage'];
                }

                /* support More Pics 6 (extra pics) v2.0.5 */
                if(isset($GLOBALS['main_image'])) {
                    $product_image = $GLOBALS['main_image'];
                }

                if(NEW_OSCMAX_VERSION) {
                    $product_image = preg_quote(DIR_WS_IMAGES.DYNAMIC_MOPICS_PRODUCTS_DIR.$product_info['products_image'], '/');
                } else
                if(function_exists('thumbimage')) {
                    // support Automatic Thumbnail osCommerce addon
                    $GLOBALS['magictoolbox']['product_image_orig'] = $tool->params->getValue('dir-ws-images').$product_image;
                    $product_image = $tool->params->getValue('dir-ws-images-quoted').'(thumbs_cache\/)?(imagecache\/([0-9]+x[0-9]+_)?)?'.preg_quote($product_image, '/');
                } else if(isset($GLOBALS['oscthumb'])) {
                    $GLOBALS['oscthumb_product_image_orig'] = $tool->params->getValue('dir-ws-images').$product_image;
                    $product_image = preg_quote($GLOBALS['oscthumb']->_encrypt('/'.$tool->params->getValue('dir-ws-images').$product_image), '/');
                } else {
                    $d = $tool->params->getValue('dir-ws-images-quoted');
                    if(defined('DYNAMIC_MOPICS_THUMBS_DIR')) {
                        $d = str_replace(preg_quote(DYNAMIC_MOPICS_THUMBS_DIR, '/'), '(?:'.preg_quote(DYNAMIC_MOPICS_THUMBS_DIR, '/').')?', $d);
                    }
                    $product_image = $d.$srcAddons.preg_quote($product_image, '/');
                }

                $isGalleryMatched = false;
                if(NEW_OSC_VERSION && isset($GLOBALS['pi_query'])/* && (tep_db_num_rows($GLOBALS['pi_query']) > 0)*/) {
                    $galleryPattern='(<div\b[^>]*?\bid\s*+=\s*+"piGal"[^>]*+>)'.
                                    '('.
                                    '(?:'.
                                        '[^<]++'.
                                        '|'.
                                        '<(?!/?div\b|!--)'.
                                        '|'.
                                        '<!--.*?-->'.
                                        '|'.
                                        '<div\b[^>]*+>'.
                                            '(?2)'.
                                        '</div\s*+>'.
                                    ')*+'.
                                    ')'.
                                    '</div\s*+>[^<]*+'.
                                    '(?:'.
                                        '<div style="display: none;">'.
                                        '('.
                                        '(?:'.
                                            '[^<]++'.
                                            '|'.
                                            '<(?!/?div\b|!--)'.
                                            '|'.
                                            '<!--.*?-->'.
                                            '|'.
                                            '<div\b[^>]*+>'.
                                                '(?3)'.
                                            '</div\s*+>'.
                                        ')*+'.
                                        ')'.
                                        '</div\s*+>[^<]*+'.
                                    ')?'.
                                    '<script\b[^>]*+>.*?</script>';
                    $matches = array();
                    $isGalleryMatched = preg_match('#'.$galleryPattern.'#is', $content, $matches);
                    if($isGalleryMatched) {
                        $iPattern = '(?|'.
                                        '<li\b[^>]*+>[^<]*+'.
                                        '<a\b[^>]*+>[^<]*+'.
                                        '<img\b[^>]*?src="([^"]*+)"[^>]*+>[^<]*+'.
                                        '</a>[^<]*+'.
                                        '(?:'.
                                            '<div style="display: none;">'.
                                            '('.
                                            '(?:'.
                                                '[^<]++'.
                                                '|'.
                                                '<(?!/?div\b|!--)'.
                                                '|'.
                                                '<!--.*?-->'.
                                                '|'.
                                                '<div\b[^>]*+>'.
                                                    '(?2)'.
                                                '</div\s*+>'.
                                            ')*+'.
                                            ')'.
                                            '</div\s*+>[^<]*+'.
                                        ')?'.
                                        '</li>'.
                                        '|'.
                                        '<a\b[^>]*+>[^<]*+'.
                                            '<img\b[^>]*?src="([^"]*+)"[^>]*+>[^<]*+'.
                                        '</a>'.
                                        '|'.
                                        '<img\b[^>]*?src="([^"]*+)"[^>]*+>'.
                                    ')';
                        $iMain = preg_replace("#.*?(<li\b[^>]*+>.*?</li>|<a\b[^>]*+>.*?</a>|<img\b[^>]*+>).*+#is", '$1', $matches[2], 1);
                        $iMain = preg_replace_callback("#{$iPattern}#is", 'callback_MagicToolbox_product', $iMain, 1);
                        $iSelectors = '';
                        if(tep_db_num_rows($GLOBALS['pi_query']) > 0) {
                            $iCount = 0;
                            $iSelectors = preg_replace_callback("#{$iPattern}#is", 'callback_MagicToolbox_extra', $matches[2], -1, $iCount);
                            if($iCount > 1) {
                                $iSelectors = preg_replace('#<ul\b[^>]*+>(.*?)</ul>#is', '$1', $iSelectors);
                                $iSelectors = '<div class="MagicToolboxSelectorsContainer">'.$iSelectors.'</div>';
                            } else {
                                $iSelectors = '';
                            }
                        }
                        $content = str_replace($matches[0], $matches[1].$iMain.$iSelectors.'</div>', $content);
                    } else {
                        //NOTE: added support for Bootstrapped Responsive osCommerce
                        //      https://github.com/gburton/Responsive-osCommerce
                        $galleryPattern='(<div\b[^>]*?\bclass\s*+=\s*+"[^"]*?\bpiGal\b[^"]*+"[^>]*+>)'.
                                        '('.
                                        '(?:'.
                                            '[^<]++'.
                                            '|'.
                                            '<(?!/?div\b|!--)'.
                                            '|'.
                                            '<!--.*?-->'.
                                            '|'.
                                            '<div\b[^>]*+>'.
                                                '(?2)'.
                                            '</div\s*+>'.
                                        ')*+'.
                                        ')'.
                                        '</div\s*+>[^<]*+'.
                                        '(?:'.
                                            '<div style="display: none;">'.
                                            '('.
                                            '(?:'.
                                                '[^<]++'.
                                                '|'.
                                                '<(?!/?div\b|!--)'.
                                                '|'.
                                                '<!--.*?-->'.
                                                '|'.
                                                '<div\b[^>]*+>'.
                                                    '(?3)'.
                                                '</div\s*+>'.
                                            ')*+'.
                                            ')'.
                                            '</div\s*+>[^<]*+'.
                                        ')?';
                        $matches = array();
                        $isGalleryMatched = preg_match('#'.$galleryPattern.'#is', $content, $matches);
                        if($isGalleryMatched) {
                            $iPattern = '<img\b[^>]*?src="([^"]*+)"[^>]*+>';
                            $iMain = preg_replace("#.*?(<img\b[^>]*+>).*+#is", '$1', $matches[2], 1);
                            $iMain = preg_replace_callback("#{$iPattern}#is", 'callback_MagicToolbox_product', $iMain, 1);
                            $iSelectors = '';
                            if(tep_db_num_rows($GLOBALS['pi_query']) > 0) {
                                $iCount = 0;
                                $iSelectors = preg_replace_callback("#{$iPattern}#is", 'callback_MagicToolbox_extra', $matches[2], -1, $iCount);
                                if($iCount > 1) {
                                    $iSelectors = '<div class="MagicToolboxSelectorsContainer">'.$iSelectors.'</div>';
                                } else {
                                    $iSelectors = '';
                                }
                            }
                            $content = str_replace($matches[0], '<div class="pull-right">'.$iMain.$iSelectors.'</div>', $content);
                        }
                    }
                } else if(defined('MULTIPLE_IMAGES_FOR_PRODUCTS')) {
                    //Multiple Images for Products for osCommerce v2.2
                    $extra_image = preg_quote($product_info['products_image'], '/');
                    $pattern = "<img[^>]*src=\"(".$tool->params->getValue('dir-ws-images-quoted').$extra_image.")\"[^>]*>";
                    $pattern = "<a[^>]*?class=\"thumbnail1\"[^>]*><span>.*?<\/span>{$pattern}<\/a><br>\s*<a[^>]*>.*?<\/a>[^<]*?";
                    $content = preg_replace_callback("/{$pattern}/is", 'callback_MagicToolbox_product', $content);
                } else {
                    //$pattern = "<img[^>]*src=\"((?:(?:(?:product_thumb)|(?:imagemagic)|(?:oscthumb))\.php\?(?:img|src)\=)?\/?".$product_image."(?:\&[^\&\"]+)*)\"[^>]*(?:>)(?:[^<]*<\/img>)?";
                    $pattern = "<img[^>]*src=\"((?:[a-zA-Z_]+\.php\?(?:img|src)\=)?\/?".$product_image."(?:\&[^\&\"]+)*)\"[^>]*(?:>)(?:[^<]*<\/img>)?";
                    $pattern = "(?:<a[^>]*>[^<]*){$pattern}(.*?)(?:<\/a>)";
                    $content = preg_replace_callback("/{$pattern}/is", 'callback_MagicToolbox_product', $content);
                }

                if(!$isGalleryMatched) {
                    //NOTE: fix for product details page (#59070)
                    $pattern = '(<div\b[^>]*?\bid\s*+=\s*+"piGal"[^>]*+>)'.
                            '('.
                            '(?:'.
                                '[^<]++'.
                                '|'.
                                '<(?!/?div\b|!--)'.
                                '|'.
                                '<!--.*?-->'.
                                '|'.
                                '<div\b[^>]*+>'.
                                    '(?2)'.
                                '</div\s*+>'.
                            ')*+'.
                            ')'.
                            '</div\s*+>';
                    $matches = array();
                    if(preg_match('%'.$pattern.'%is', $content, $matches)) {
                        $newhtml = preg_replace_callback("/.*?src=\"((?:[a-zA-Z_]+\.php\?(?:img|src)\=)?\/?".$product_image."(?:\&[^\&\"]+)*)\".*/ims", "callback_MagicToolbox_product", $matches[0]);
                        $content = str_replace($matches[0], $newhtml.'<!-- MAGICTOOLBOX_MULTIPLE -->', $content);
                        $new_m = array();
                        if(tep_db_num_rows(tep_db_query("show tables like '%".TABLE_PRODUCTS_IMAGES."'")) >= 1) {
                            $products_additional_images_query = tep_db_query("SELECT image FROM ".TABLE_PRODUCTS_IMAGES." WHERE products_id='".intval($product_info['products_id'])."'");
                            if(tep_db_num_rows($products_additional_images_query) >= 1) {
                                while($additional_image = tep_db_fetch_array($products_additional_images_query)) {
                                    $img = preg_quote($additional_image['image'], '/');
                                    $pattern = "<img[^>]*src=\"([^\"]*?".$tool->params->getValue('dir-ws-images-quoted').$img.")\"[^>]*(?:>)(?:[^<]*<\/img>)?";
                                    $new_m[] = preg_replace_callback("/{$pattern}/is", 'callback_MagicToolbox_extra', '<img src="'.$tool->params->getValue('dir-ws-images').$additional_image['image'].'" alt="" />');
                                }
                            }
                        }
                        $content = str_replace('<!-- MAGICTOOLBOX_MULTIPLE -->', count($new_m) ? '<div class="MagicToolboxSelectorsContainer">'.join('', $new_m).'</div>' : '', $content);
                    }
                }

            }

            /* color swatches */
            if($isColorSwatchesEnabled && OPTIONS_AS_COLOR_SWATCHES_ENABLED && is_array($GLOBALS['products_options_array']) && !empty($GLOBALS['products_options_array'])) {
                $mainImageId = 'MagicZoomImageproductImage';

                $pattern = "<div id='div_colors' name='div_colors'([^>]*?)onMouseOver=change_product_image\((.*?)\) onMouseOut=change_product_image_back\((this)\)><\/div>";
                $content = preg_replace_callback("/{$pattern}/is", 'callback_MagicToolbox_colorSwatches', $content);
                $scripts = 'function MagicToolbox_change_product_image_back(obj){}';

                $scripts .= 'function MagicToolbox_change_product_image(obj, img, att_id, id, thumb){';

                //if('magiczoom' == 'magiczoom2') $scripts .= 'MagicZoom_stopZooms();';
                $scripts .= "MagicZoom.stop($mjs('{$mainImageId}'));";

                $scripts .= "var path = '".DIR_WS_IMAGES."' + ((att_id==0) ? '' : 'options/');
                    window.document.getElementsByName('id[1]')[0].value=id;
                    colors = window.document.getElementsByName('div_colors');
                    for(i=0;i<colors.length;i++) {
                        if(colors[i]!=obj) {
                            colors[i].style.border='2px solid #BBBBBB';
                        }
                    }
                    window.document.getElementById('{$mainImageId}').href= path+img ;";

                $scripts .=  "window.document.getElementById('{$mainImageId}').firstChild.src = thumb;
                        obj.style.border='2px solid #000000';";

                //if('magiczoom' == 'magiczoom2') $scripts .= 'MagicZoom_findZooms();';
                $scripts .= "MagicZoom.start($mjs('{$mainImageId}'));";

                $scripts .= '}';

                $content = preg_replace('/(function change_product_image\()/is', $scripts.'$1', $content);
            }

            /* support Additional Images Module osCommerce addon (http://addons.oscommerce.com/info/1032) */
            if(tep_db_num_rows(tep_db_query("show tables like '%additional_images'")) >= 1) {
                $products_additional_images_query = tep_db_query("SELECT thumb_images, medium_images FROM ".TABLE_ADDITIONAL_IMAGES." WHERE products_id='".intval($product_info['products_id'])."'");
                if(tep_db_num_rows($products_additional_images_query) >= 1) {
                    while($additional_image = tep_db_fetch_array($products_additional_images_query)) {
                        if(!empty($additional_image['medium_images'])) {
                            $img = $additional_image['medium_images'];
                        } else {
                            $img = $additional_image['thumb_images'];
                        }
                        $GLOBALS['mz_current_ultra_pic'] = preg_replace('/[sml]\.([^\.]+)$/is', '.$1', $img);
                        $img = preg_quote($img, '/');
                        $pattern = "<img[^>]*src=\"(".$tool->params->getValue('dir-ws-images-quoted').$img.")\"[^>]*(?:>)(?:[^<]*<\/img>)?";
                        $pattern = "(?:<a[^>]*>){$pattern}(.*?)(?:<\/a>)";
                        $content = preg_replace_callback("/{$pattern}/is", 'callback_MagicToolbox_extra', $content);
                        unset($GLOBALS['mz_current_ultra_pic']);
                    }
                }
            }

            /* extra images */
            if(tep_db_num_rows(tep_db_query("show tables like '%products_extra_images'")) >= 1) {
                $products_extra_images_query = tep_db_query("SELECT products_extra_image FROM ".TABLE_PRODUCTS_EXTRA_IMAGES." WHERE products_id='".intval($product_info['products_id'])."'");
                if(tep_db_num_rows($products_extra_images_query) >= 1) {
                    while($extra_image = tep_db_fetch_array($products_extra_images_query)) {
                        $tool->params->setValue('extra-images', true);
                        $GLOBALS['mz_current_ultra_pic'] = $extra_image['products_extra_image'];
                        $extra_image = preg_quote($extra_image['products_extra_image'], '/');
                        //$pattern = "<img[^>]*src=\"((?:(?:(?:product_thumb)|(?:imagemagic)|(?:oscthumb))\.php\?img\=)?".$tool->params->getValue('dir-ws-images-quoted').$extra_image."(?:\&[^\&\"]+)*)\"[^>]*(?:>)(?:[^<]*<\/img>)?";
                        $pattern = "<img[^>]*src=\"((?:[a-zA-Z_]+\.php\?(?:img|src)\=)?".$tool->params->getValue('dir-ws-images-quoted').$extra_image."(?:\&[^\&\"]+)*)\"[^>]*(?:>)(?:[^<]*<\/img>)?";
                        $pattern = "(?:<a[^>]*>){$pattern}(.*?)(?:<\/a>)";
                        $content = preg_replace_callback("/{$pattern}/is", 'callback_MagicToolbox_extra', $content);
                        unset($GLOBALS['mz_current_ultra_pic']);
                        $tool->params->setValue('extra-images', false);
                    }
                }
            }

            /* More Pics 6 (extra pics) v 1.3 */
            foreach($product_info as $fieldName => $fieldValue) {
                if(preg_match('/^products_subimage[1-6]$/is', $fieldName)) {
                    $extra_image = preg_quote($fieldValue, '/');
                    //$pattern = "<img[^>]*src=\"((?:(?:(?:product_thumb)|(?:imagemagic)|(?:oscthumb))\.php\?img\=)?".$tool->params->getValue('dir-ws-images-quoted').$extra_image."(?:\&[^\&\"]+)*)\"[^>]*(?:>)(?:[^<]*<\/img>)?";
                    $pattern = "<img[^>]*src=\"((?:[a-zA-Z_]+\.php\?(?:img|src)\=)?".$tool->params->getValue('dir-ws-images-quoted').$extra_image."(?:\&[^\&\"]+)*)\"[^>]*(?:>)(?:[^<]*<\/img>)?";
                    $pattern = "(?:<a[^>]*>){$pattern}(.*?)(?:<\/a>)";
                    $content = preg_replace_callback("/{$pattern}/is", 'callback_MagicToolbox_extra', $content);
                }
            }

            /* More Pics 6 (extra pics) v2.0.5 */
            if(isset($GLOBALS['products_images_query'])) {
                mysql_data_seek($GLOBALS['products_images_query'], 0);
                while($images = tep_db_fetch_array($GLOBALS['products_images_query'])) {
                    //$pattern = "<img[^>]*src=\"((?:(?:(?:product_thumb)|(?:imagemagic)|(?:oscthumb))\.php\?img\=)?".$tool->params->getValue('dir-ws-images-quoted').$images['image_filename']."(?:\&[^\&\"]+)*)\"[^>]*(?:>)(?:[^<]*<\/img>)?";
                    $pattern = "<img[^>]*src=\"((?:[a-zA-Z_]+\.php\?(?:img|src)\=)?".$tool->params->getValue('dir-ws-images-quoted').$images['image_filename']."(?:\&[^\&\"]+)*)\"[^>]*(?:>)(?:[^<]*<\/img>)?";
                    $pattern = "(?:<a[^>]*>){$pattern}(.*?)(?:<\/a>)";
                    $content = preg_replace_callback("/{$pattern}/is", 'callback_MagicToolbox_extra', $content);
                }
            }

            //Multiple Images for Products for osCommerce v2.2
            if(defined('MULTIPLE_IMAGES_FOR_PRODUCTS')) {
                foreach($product_info as $fieldName => $fieldValue) {
                    if(preg_match('/^product_image_[2-6]$/is', $fieldName)) {
                        $extra_image = preg_quote($fieldValue, '/');
                        $pattern = "<img[^>]*src=\"(".$tool->params->getValue('dir-ws-images-quoted').$extra_image.")\"[^>]*>";
                        $pattern = "<a[^>]*?class=\"thumbnail".str_replace('product_image_', '', $fieldName)."\"[^>]*><span>.*?<\/span>{$pattern}<\/a><br>\s*<a[^>]*>.*?<\/a>[^<]*?";
                        $content = preg_replace_callback("/{$pattern}/is", 'callback_MagicToolbox_extra', $content);
                    }
                }
            }

            /* ultra pics */
            $ultraPics = array();
            foreach($product_info as $fieldName => $fieldValue) {
                preg_match('/^products_image_((?:sm)|(?:xl))_([0-9]+)$/is', $fieldName, $matches);
                if(!empty($matches)) {
                    if(!isset($ultraPics[intval($matches[2])])) {
                        $ultraPics[intval($matches[2])] = array();
                    }
                    $ultraPics[intval($matches[2])][($matches[1] == 'sm') ? 'thumb' : 'img'] = $fieldValue;
                }
            }
            foreach($ultraPics as $pic) {
                if(!isset($pic['img']) || empty($pic['img'])) {
                    $imgExists = false;
                    if(isset($pic['thumb']) && !empty($pic['thumb'])) {
                        $pic['img'] = $pic['thumb'];
                    } else continue;
                } else $imgExists = true;
                if(!isset($pic['thumb']) || empty($pic['thumb'])) {
                    $thumbExists = false;
                    $pic['thumb'] = $pic['img'];
                } else $thumbExists = true;
                $img = preg_quote($pic['thumb'], '/');
                //$pattern = "<img[^>]*src=\"((?:(?:(?:product_thumb)|(?:imagemagic)|(?:oscthumb))\.php\?img\=)?".$tool->params->getValue('dir-ws-images-quoted').$img."(?:\&[^\&\"]+)*)\"[^>]*(?:>)(?:[^<]*<\/img>)?";
                $pattern = "<img[^>]*src=\"((?:[a-zA-Z_]+\.php\?(?:img|src)\=)?".$tool->params->getValue('dir-ws-images-quoted').$img."(?:\&[^\&\"]+)*)\"[^>]*(?:>)(?:[^<]*<\/img>)?";
                if($thumbExists && $imgExists) $pattern = "(?:<a[^>]*>){$pattern}(.*?)(?:<\/a>)";
                $GLOBALS['mz_current_ultra_pic'] = $pic['img'];
                $content = preg_replace_callback("/{$pattern}/is", 'callback_MagicToolbox_extra', $content);
                unset($GLOBALS['mz_current_ultra_pic']);
            }

            if(NEW_OSCMAX_VERSION) {
                //Dynamic MoPics v3.000
                $slideshowPattern = '/<div[^>]*?id="slideshow"[^>]*>[^<]*<ul>[^<]*<!--.*?-->'.
                '((?:[^<]*<li>[^<]*<a[^>]*>[^<]*<img[^>]*?src="[^"]*"[^>]*>[^<]*<\/a>[^<]*<\/li>)+)'.
                '[^<]*<\/ul>[^<]*<\/div>/is';
                $matches = array();
                if(preg_match($slideshowPattern, $content, $matches)) {
                    $iPattern = '/<a[^>]*>[^<]*<img[^>]*?src="([^"]*?)"[^>]*>[^<]*<\/a>([^<]*)/is';
                    $iCount = 0;
                    $iSelectors = preg_replace_callback($iPattern, 'callback_MagicToolbox_extra', $matches[1], -1, $iCount);
                    if($iCount > 1) {
                        $content = preg_replace('/(<div[^>]*?id="slideshow"[^>]*>[^<]*<ul>)(.*?)(<\/ul>[^<]*<\/div>)/is', '$1'.$iSelectors.'$3', $content);
                    }
                }
            } else
            /* support: Dynamic MoPics (http://www.oscommerce.com/community/contributions,1114) */
            if(file_exists(DIR_WS_MODULES.'dynamic_mopics.php')) {
                ob_start();
                include(DIR_WS_MODULES.'dynamic_mopics.php');
                $moPicsContents = ob_get_contents();
                ob_end_clean();
                $moPicsContents = preg_replace('/<noscript>.*?<\/noscript>/is', '', $moPicsContents);
                $pattern = $tool->params->getValue('dir-ws-images-quoted').'[^\"\>]+?';
                $pattern = '<img[^>]*src=\"('.$pattern.')\"[^>]*(?:\/?>)';
                $pattern2 = '(?:<a[^>]*?href=\"[^\"]+?\\\\\'(.*?)\\\\\'[^\"]+?\"[^>]*>)'.$pattern.'(.*?)(?:<\/a>)';
                $l = false;
                if(!preg_match_all('/'.$pattern2.'/is', $moPicsContents, $moPicsMatches)) {
                    $pattern2 = '(?:<a[^>]*?href=\"(.*?)\?[^\"]+?\"[^>]*>)'.$pattern.'(.*?)(?:<\/a>)';
                    preg_match_all('/'.$pattern2.'/is', $moPicsContents, $moPicsMatches);
                    $l = true;
                }
                foreach($moPicsMatches[2] as $key => $thumb) {
                    if($l) {
                        $image = $moPicsMatches[1][$key];
                        $image = str_replace(((getenv('HTTPS') == 'on') ? HTTPS_SERVER : HTTP_SERVER).DIR_WS_CATALOG, '', $image);
                    } else {
                        $href = $moPicsMatches[1][$key];
                        $pic = preg_replace('/^.*?pic\=([^\&]+).*$/is', '$1', $href);
                        $type = preg_replace('/^.*?(?:\?|\&)type\=(.*?)(?:\&.*|)$/is', '$1', $href);
                        $imagebase = mopics_get_imagebase($product_info['products_image'], DIR_WS_IMAGES.DYNAMIC_MOPICS_BIGIMAGES_DIR);
                        $search = array('imagebase', mopics_match_pattern(DYNAMIC_MOPICS_PATTERN));
                        $replace = array($imagebase, $pic);
                        $image = str_replace($search, $replace, DYNAMIC_MOPICS_PATTERN).'.'.$type;
                        $image = str_replace($tool->params->getValue('dir-ws-images'), '', $image);
                    }
                    $GLOBALS['mz_current_ultra_pic'] = $image;
                    //$pattern = "<img[^>]*src=\"((?:(?:product_thumb|imagemagic|oscthumb)\.php\?img\=)?".preg_quote($thumb, '/')."(?:\&[^\&\"]+)*)\"[^>]*(?:>)(?:[^<]*<\/img>)?";
                    $pattern = "<img[^>]*src=\"((?:[a-zA-Z_]+\.php\?(?:img|src)\=)?".preg_quote($thumb, '/')."(?:\&[^\&\"]+)*)\"[^>]*(?:>)(?:[^<]*<\/img>)?";
                    $pattern = "(?:<a[^>]*>){$pattern}(.*?)(?:<\/a>)";
                    $content = preg_replace_callback("/{$pattern}/is", 'callback_MagicToolbox_extra', $content);
                    unset($GLOBALS['mz_current_ultra_pic']);
                }
            }

            /* paps images */
            if(isset($GLOBALS['arr_filenames'])) $paps_images = $GLOBALS['arr_filenames'];
            else $paps_images = array();
            if(count($paps_images) > 0) {
                foreach($paps_images as $paps_image) {
                    $paps_image = preg_quote($paps_image, '/');
                    $pattern = "<img[^>]*src=\"(paps_makethumb.php\?pic\=(".$tool->params->getValue('dir-ws-images-quoted')."paps\/{$paps_image})[^\"]*)\"[^>]*(?:>)(?:[^<]*<\/img>)?";
                    $pattern = "(?:<a[^>]*>\s*){$pattern}(?:<\/a>)";
                    $content = preg_replace_callback("/{$pattern}/is", 'callback_MagicToolbox_paps', $content);
                }
            }

            /* main paps image */
            $pattern = "<img[^>]*src=\"(paps_makethumb.php\?pic\=".$tool->params->getValue('dir-ws-images-quoted')."paps\/[^\"]*)\"[^>]*(?:>)(?:[^<]*<\/img>)?";
            $pattern = "(<td[^>]*>\s*){$pattern}(\s*<\/td>)";
            $content = preg_replace_callback("/{$pattern}/is", 'callback_MagicToolbox_paps_main', $content);

        }

        /* restore <noscript> tags */
        foreach($GLOBALS['magictoolbox_noscripts_backups'] as $k => $noscript) {
            $content = str_replace('_MAGICTOOLBOX_NOSCRIPT_BACKUP_'.($k+1), $noscript, $content);
        }
        unset($GLOBALS['magictoolbox_noscripts_backups']);

        /* restore left/right columns content */
        if($contentBackup) {
            if(NEW_OSC_VERSION) {
                $content = str_replace('_MAGICTOOLBOX_COLUMNS_BACKUP_', $contentBackup, $content);
            } else {
                $content = str_replace('_MAGICTOOLBOX_COLUMNS_BACKUP_', $content, $contentBackup);
            }
        }

        if((/*$categoryPage || $productPage || */defined('MAGICZOOM_HEADERS')) && !defined('MAGICZOOM_HEADERS_DISPLAYED')) {
            $content = preg_replace_callback('#(?<!["\'])</head>#is', 'magiczoomHeaderCallback', $content, 1);
        }

        if($returnContent == true) return $content;
        else echo $content;
    }

    function MagicToolbox_getProductInfo($id, $key = null) {
        $result = array();

        $query = tep_db_query("SELECT products_name, products_description FROM ".TABLE_PRODUCTS_DESCRIPTION." WHERE products_id='".intval($id)."' AND language_id='".intval($GLOBALS['languages_id'])."'");
        if(tep_db_num_rows($query) >= 1) {
            while($info = tep_db_fetch_array($query)) {
                $result['title'] = $info['products_name'];
                $result['description'] = $info['products_description'];
                break;
            }
        }

        if(empty($result)) return false;

        if($key != null) {
            if(!isset($result[$key])) return false;
            return $result[$key];
        }
        return $result;
    }

    function MagicToolbox_callback_noscript($matches) {
        $GLOBALS['magictoolbox_noscripts_backups'][] = $matches[0];
        return '_MAGICTOOLBOX_NOSCRIPT_BACKUP_'.count($GLOBALS['magictoolbox_noscripts_backups']);
    }

    function callback_MagicToolbox_colorSwatches($matches) {
        $params = explode(', ', $matches[2]);
        $img = substr(trim($params[1]), 1, -1);
        $path = (substr(trim($params[2]), 1, -1) == 0) ? DIR_WS_IMAGES : DIR_WS_IMAGES.'options/';
        $img = $path.$img;

        if(isset($GLOBALS['product_info']['products_id'])) {
            $pid = $GLOBALS['product_info']['products_id'];
        } else {
            $pid = null;
        }
        $thumb = magiczoomGetThumb($img, null, $pid);
        $img = magiczoomGetThumb($img, 'original', $pid);
        return "<div id=\"div_colors\" name=\"div_colors\" ".$matches[1]." onMouseOver=\"MagicToolbox_change_product_image({$matches[2]}, '{$thumb}');\" onMouseOut=\"MagicToolbox_change_product_image_back(".$matches[3].");\"></div>";
    }

    function callback_MagicToolbox_product($matches) {
        $tool = MagicZoomGetTool();
        if($isColorSwatchesEnabled && OPTIONS_AS_COLOR_SWATCHES_ENABLED && is_array($GLOBALS['products_options_array']) && !empty($GLOBALS['products_options_array'])) {
            $tmp = array();
            foreach($GLOBALS['products_options_array'] as $po) {
                if(!empty($po['att_id'])) $tmp[] = $po['att_id'];
            }
            $tmp = '^(options\/)?(('.implode(')|(', $tmp).'))_';
            $matches[1] = preg_replace("/{$tmp}/is", '', $matches[1]);
        }

        if(function_exists('thumbimage')) {
            // support Automatic Thumbnail osCommerce addon
            $img = $GLOBALS['magictoolbox']['product_image_orig'];
        } else if(isset($GLOBALS['oscthumb'])) {
            $img = $GLOBALS['oscthumb_product_image_orig'];
        } else {
            $img = $matches[1];
            //$img = preg_replace("/^(?:product_thumb|imagemagic|oscthumb)\.php\?(?:img|src)=([^\&]*)\&.*$/is", '$1', $img);
            $img = preg_replace("/^\/?[a-zA-Z_]+\.php\?(?:img|src)=([^\&]*)\&.*$/is", '$1', $img);
            $img = preg_replace('/^\//is', '', $img);
        }

        $product_info = &$GLOBALS['product_info'];
        if(isset($GLOBALS['review'])) $product_info = $GLOBALS['review'];

        if(isset($product_info['products_image_med']) && isset($product_info['products_image_pop'])) {
            /* support Additional Images Module osCommerce addon (http://addons.oscommerce.com/info/1032) */
            // remove Small/Medium/Large sufix
            $img = preg_replace('/[sml]\.([^\.]+)$/is', '.$1', $img);
        }

        if(isset($product_info['products_largeimage']) && !empty($product_info['products_largeimage'])) {
            /* support Sm, Med, and Lg Images osCommerce addon (http://addons.oscommerce.com/info/695) */
            $img = $tool->params->getValue('dir-ws-images').$product_info['products_largeimage'];
        }

        if(defined('DYNAMIC_MOPICS_THUMBS_DIR')) {
            $img = str_replace(DYNAMIC_MOPICS_THUMBS_DIR, DYNAMIC_MOPICS_BIGIMAGES_DIR, $img);
            if(NEW_OSCMAX_VERSION) {
                $img = str_replace(DYNAMIC_MOPICS_PRODUCTS_DIR, DYNAMIC_MOPICS_BIGIMAGES_DIR, $img);
            }
        }

        if(isset($GLOBALS['product_info']['products_id'])) {
            $pid = $GLOBALS['product_info']['products_id'];
        } else {
            $pid = null;
        }
        $thumb = magiczoomGetThumb($img, null, $pid);
        $img = magiczoomGetThumb($img, 'original', $pid);
        return callback_MagicToolbox($matches, $img, $thumb, $tool->params->getValue('thumb-max-width'), 'productImage');
    }

    function callback_MagicToolbox_extra($matches) {
        $tool = MagicZoomGetTool();
        if(!isset($GLOBALS['mz_current_ultra_pic']) || empty($GLOBALS['mz_current_ultra_pic'])) {
            $img = $matches[1];
        } else {
            $img = $GLOBALS['mz_current_ultra_pic'];
            if(!preg_match('/^'.preg_quote(DIR_WS_IMAGES, '/').'/is', $img)) {
                $img = $tool->params->getValue('dir-ws-images').$img;
            }
        }

        if(NEW_OSCMAX_VERSION/* && defined('DYNAMIC_MOPICS_THUMBS_DIR')*/) {
            $img = str_replace(DYNAMIC_MOPICS_THUMBS_DIR, DYNAMIC_MOPICS_BIGIMAGES_DIR, $img);
        }

        if(isset($GLOBALS['product_info']['products_id'])) {
            $pid = $GLOBALS['product_info']['products_id'];
        } else {
            $pid = null;
        }
        //$img = preg_replace("/^(?:product_thumb|imagemagic|oscthumb)\.php\?img=([^\&]*)\&.*$/is", '$1', $img);
        $img = preg_replace("/^\/?[a-zA-Z_]+\.php\?(?:img|src)=([^\&]*)\&.*$/is", '$1', $img);
        $thumb = magiczoomGetThumb($img, null, $pid);
        $thumb2 = magiczoomGetThumb($img, 'extra-thumb', $pid);
        $img = magiczoomGetThumb($img, 'original', $pid);

        return callback_MagicToolbox($matches, $img, $thumb, $tool->params->getValue('extra-thumb-max-width'), 'productImage', $thumb2);
    }

    function callback_MagicToolbox_paps_main($matches) {
        $tool = MagicZoomGetTool();
        $paps_images = $GLOBALS['arr_filenames'];
        $thumb = $matches[2];
        $thumb = preg_replace("/\&w\=[0-9]+/is", "&w=".$tool->params->getValue('paps-image-max-width'), $thumb);
        $thumb = preg_replace("/pic=".$tool->params->getValue('dir-ws-images-quoted')."paps\/\&/is", "pic=".$tool->params->getValue('dir-ws-images'). "paps/".$paps_images[0]."&", $thumb);
        $img = $tool->params->getValue('dir-ws-images')."paps/".$paps_images[0];
        return callback_MagicToolbox($matches, $img, $thumb, $tool->params->getValue('paps-image-max-width'), 'Paps', 'Paps');
    }

    function callback_MagicToolbox_paps($matches) {
        $tool = MagicZoomGetTool();
        $thumb = $matches[1];
        $thumb2 = preg_replace("/\&w\=[0-9]+/is", "&w=".$tool->params->getValue('paps-thumb-max-width'), $thumb);
        $thumb = preg_replace("/\&w\=[0-9]+/is", "&w=".$tool->params->getValue('paps-image-max-width'), $thumb);
        $img = $matches[2];
        return callback_MagicToolbox($matches, $img, $thumb, $tool->params->getValue('paps-thumb-max-width'), 'Paps', $thumb2);
    }

    function callback_MagicToolbox($matches, $img, $thumb, $size, $id = '', $type = '', $title = '') {
        $tool = MagicZoomGetTool();

        $alt = '';
        if(!empty($matches[0])) {
            preg_match("/alt=\"(.*?)\"/", $matches[0], $alt);
            $alt = $alt[1];
        }

        $product_info = &$GLOBALS['product_info'];
        if(isset($GLOBALS['review'])) $product_info = $GLOBALS['review'];

        if(empty($title)) {
            if(!empty($alt)) $title = $alt;
            if(!empty($product_info['products_name'])) $title = $product_info['products_name'];
        }
        if($tool->params->checkValue('creloaded', true)) {
            $title = str_replace('&#39;;', '&#39;', str_replace('&#39', '&#39;', $title));
            $title = stripslashes($title);
        }
        if(!empty($product_info['products_description'])) $description = $product_info['products_description'];

        if(!empty($alt)) $alt = " alt=\"{$alt}\" ";

        /*if(empty($title)) {
            preg_match("/alt=\"(.*?)\"/", $matches[0], $alt);
            $alt = $alt[1];
            if(!empty($alt)) $title = $alt;
        }*/
        //if(!empty($title))$title = " title=\"{$title}\"";
        /*if($GLOBALS["mt_conf"]["show_caption"]["value"] == "No") $title = '';*/

        $style = 'style="margin: '.$tool->params->getValue('thumb-margin-top').'px '.$tool->params->getValue('thumb-margin').'px 0px;"';

        $onClick = '';
        /* uncoment 3 folowing lines for enable onClick popup (NOTE: working only with primary image! Only for MagicZoom!)*/
        //$onClick = preg_replace("/^.*href=\"javascript\:(.*?)\".*$/is", "$1", $matches[0]);
        //if($onClick == $matches[0]) $onClick = '';
        //else $onClick = "onclick=\"{$onClick}\" ";

        $html = '';

        if($type == '' || $type == 'Paps') {
            $html = $tool->getMainTemplate(compact('img', 'thumb', 'id', 'title', 'description'));
            $html = preg_replace("/^<a /is", "<a style=\"margin:0 auto;\" ", $html);
            $html = preg_replace("/^<a /is", '<a '.$onClick.' ', $html);
            $html = preg_replace("/^<img /is", '<img '.$alt.' ', $html);
            /*$html = "<img src=\"{$thumb}\" />";
            $html = "<a {$onClick}id=\"MagicZoomImage{$id}\" class=\"MagicZoom\" href=\"{$img}\" rel=\"{$GLOBALS["mz_rel"]}\"{$title}>{$html}</a>";*/
            $html = "<div class=\"MagicToolboxModule{$type} MagicToolboxContainer\" {$style}>{$html}</div>";
        } else {
            if(defined('ADDIMAGES_GROUP_WITH_PARENT') && (ADDIMAGES_GROUP_WITH_PARENT == 'true') || defined('MOPICS_GROUP_WITH_PARENT') && (MOPICS_GROUP_WITH_PARENT == 'true') || defined('MULTIPLE_IMAGES_FOR_PRODUCTS')) {
                $id = md5($img);
                $html = $tool->getMainTemplate(compact('img', 'thumb', 'id', 'title', 'description'));
                $html = preg_replace('/^<img /is', '<img '.$alt.' ', $html);
                $html = "<div class=\"MagicToolboxModule MagicToolboxContainer\" {$style}>{$html}</div>";
            } else {
                $medium = $thumb;
                $thumb = $type;
                $html = $tool->getSelectorTemplate(compact('img', 'medium', 'thumb', 'id', 'title', 'description'));
                $html = preg_replace('/^<img /is', '<img '.$alt.' ', $html);
                $html = '<div class="MagicToolboxSelector">'.$html.'</div>';
                /*$html = "<img src=\"{$thumb2}\" />";*/
                /*$html = "<a rel=\"MagicZoomImage{$id}\" href=\"{$img}\" rev=\"{$thumb}\"{$title}>{$html}</a>";*/
            }
        }

        if($tool->params->checkValue('creloaded', true) && $type == '' || defined('ULTIMATE_ADDITIONAL_IMAGES') || $tool->params->getValue('extra-images') || NEW_OSC_VERSION || defined('MULTIPLE_IMAGES_FOR_PRODUCTS') || NEW_OSCMAX_VERSION) {
            return $html;
        } else {
            return addslashes($html);
        }
    }

    function MagicZoomSTSHead($content) {
        if(defined('MAGICZOOM_HEADERS') && !defined('MAGICZOOM_HEADERS_DISPLAYED')) {
            return preg_replace_callback('#</head>#is', 'magiczoomHeaderCallback', $content, 1);
        } else {
            return $content;
        }
    }

    function magiczoomHeaderCallback($matches) {
        if(defined('MAGICZOOM_HEADERS_DISPLAYED')) {
            return $matches[0];
        }
        define('MAGICZOOM_HEADERS_DISPLAYED', true);
        $tool = MagicZoomGetTool();
        $tool->params->resetProfile();

        //$styles = array();
        //$styles[] = "\n<style type=\"text/css\">\n";
//         if(NEW_OSC_VERSION) {
//             $styles[] = "
//     /*div.MagicToolboxContainer, */div.MagicToolboxSelectorsContainer {
//         width: ".$tool->params->getValue('thumb-max-width')."px;
//     }
//     div.MagicToolboxSelector {
//         float: left; margin: 3px;
//     }
// ";
//         }
        //$styles[] = "\n</style>\n";
        //$styles = implode('', $styles);

        $https = isset($_SERVER['HTTP_X_FORWARDED_PROTO']) && $_SERVER['HTTP_X_FORWARDED_PROTO'] == 'https' ||
                 isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] && strtolower($_SERVER['HTTPS']) != 'off' ||
                 isset($_SERVER['SSL_PROTOCOL']) && $_SERVER['SSL_PROTOCOL'];
        return $tool->getHeadersTemplate(($https ? HTTPS_SERVER : HTTP_SERVER).DIR_WS_CATALOG.DIR_WS_MODULES.'magiczoom/core')./*$styles.*/$matches[0];
    }

    function magiczoomGetThumb($src, $size = null, $pid = null) {
        static $imageHelper = null;
        if($imageHelper === null) {
            $tool = MagicZoomGetTool();            
            require_once(dirname(__FILE__).'/magictoolbox.imagehelper.class.php');
            $imageHelper = new MagicToolboxImageHelperClass(DIR_FS_CATALOG, '/'.DIR_WS_IMAGES.'magictoolbox_cache', $tool->params, null, DIR_WS_CATALOG);
        }
        $src = str_replace('%20', ' ', $src);
        if($size === null) $size = 'thumb';
        //$thumb = $imageHelper->create($src, $size, $pid);
        return $imageHelper->create('/'.$src, $size, $pid);
    }

    function magiczoomProcessBlock($class, $group, &$oscTemplate) {

        //NOTE: for osCommerce v2.3.0 or above

        switch($class) {
            case 'bm_specials':
                $block = 'specials';
                break;
            case 'bm_reviews':
                $block = 'reviews';
                break;
            case 'bm_whats_new':
                $block = 'whats_new';
                break;
            default: return;
        }

        $tool = MagicZoomGetTool();
        $tool->params->setProfile($block);

        if(!$tool->params->checkValue('enable-effect', 'No', $block)) {

            $link = $tool->params->checkValue('link-to-product-page', 'Yes');

            $block_content = end($oscTemplate->_blocks[$group]);
            $pattern = '/<a[^>]*?href="([^"]*?products_id=(\d*)[^"]*+)"[^>]*+>[^<]*+<img[^>]*?src="([^"]*+)(?<!box_write_review\.gif)"[^>]*+>[^<]*+<\/a>/is';
            $matches = array();
            $isGalleryMatched = preg_match_all($pattern, $block_content, $matches, PREG_SET_ORDER);
            if($isGalleryMatched) {
                foreach($matches as $match) {
                    $href = $match[1];
                    $id = $match[2];
                    $src = $match[3];
                    $productInfo = MagicToolbox_getProductInfo($id);
                    $title = $productInfo['title'];
                    $description = $productInfo['description'];
                    $pid = empty($id) ? null : $id;
                    $thumb = magiczoomGetThumb($src, 'thumb', $pid);
                    $img = magiczoomGetThumb($src, 'original', $pid);

                    $template = $tool->getMainTemplate(array(
                        'img' => $img,
                        'thumb' => $thumb,
                        'id' => $class.$id,
                        'title' => $title,
                        'description' => $description,
                        'link' => $link ? $href : false,
                        'group' => $class
                    ));
                    $block_content = str_replace($match[0], $template, $block_content);
                }
                $oscTemplate->_blocks[$group][key($oscTemplate->_blocks[$group])] = $block_content;
                defined('MAGICZOOM_HEADERS') || define('MAGICZOOM_HEADERS', true);
            }

        }

    }
