<?php
    /**
     *  osCMax module installer class
     */

    require_once(dirname(__FILE__).'/magictoolbox.installer.core.class.php');

    class MagicToolboxoscmaxModuleInstallerClass extends MagicToolboxCoreInstallerClass {
        var $sts = false;
        var $cre = false;
        var $new_osCommerce = false;//for oscommerce 2.3.0 and above
        var $new_CRE_Loaded = false;//for creloaded 6.5.0 and above
        var $new_osCmax = false;//for oscmax 2.5.0 and above
        var $files = array();
        var $dirs = array();

        function __construct() {
            $this->dir = dirname(dirname(__FILE__));
            $this->modDir = dirname(__FILE__).'/module';

            if(file_exists($this->dir.'/includes/classes/sts.php')) {
                $this->sts = true;
            }

            if(file_exists($this->dir.'/includes/classes/rci.php') || file_exists($this->dir.'/includes/classes/rco.php')) {
                $this->cre = true;
            }

            $version = $this->getPlatformVersion();
            if(version_compare($version, '2.5.0', '>=')) {
                $this->new_osCmax = true;
            }

            $this->dirs = array(
                '/includes',
                '/includes/modules'
            );
            if(file_exists($this->dir.'/includes/languages/english/modules')) {
                $this->dirs[] = '/includes/languages/english/modules';
            } else {
                $this->dirs[] = '/includes/languages/english';
            }

            $this->files = array(
                '/includes/application_top.php',
                '/includes/application_bottom.php',
                '/includes/modules/product_listing.php',
                //'/includes/modules/new_products.php'
            );

            if(file_exists($this->dir.'/includes/modules/new_products.php')) {
                $this->files[] = '/includes/modules/new_products.php';
            }


            if($this->new_osCommerce) {
                $this->dirs = array_merge($this->dirs, array(
                    '/includes/classes'
                ));
                $this->files = array_merge($this->files, array(
                    '/includes/classes/osc_template.php'
                ));
            } else {
                $this->dirs = array_merge($this->dirs, array(
                    '/includes/boxes'
                ));
                $boxes = array(
                    '/includes/boxes/reviews.php',
                    '/includes/boxes/specials.php',
                    '/includes/boxes/whats_new.php',
                );

                foreach($boxes as $file) {
                    if(file_exists($this->dir.$file)) {
                        $this->files[] = $file;
                    }
                }
            }

            if($this->sts) {
                $this->dirs = array_merge($this->dirs, array(
                    '/includes/classes'
                ));
                $this->files = array_merge($this->files, array(
                    '/includes/classes/sts.php'
                ));
            }

            if($this->cre) {
                $this->dirs = array_merge($this->dirs, array(
                    '/includes/functions'
                ));
                $this->files = array_merge($this->files, array(
                    '/includes/modules/product_listing_col.php',
                    '/includes/functions/html_output.php'
                ));
            }

            if($this->new_osCmax) {
                if(file_exists($this->dir.'/includes/modules/product_listing_col.php')) {
                    $this->files = array_merge($this->files, array(
                        '/includes/modules/product_listing_col.php'
                    ));
                }
            }

            $adminFolders = $this->getAdminFolders();
            if($this->new_osCmax) {
                foreach($adminFolders as $adminFolder) {
                    $this->dirs[] = "/{$adminFolder}/includes";
                    $this->dirs[] = "/{$adminFolder}/includes/boxes";
                    $this->files[] = "/{$adminFolder}/includes/menu.php";
                }
            } else {
                foreach($adminFolders as $adminFolder) {
                    $this->dirs[] = "/{$adminFolder}/includes";
                    $this->dirs[] = "/{$adminFolder}/includes/boxes";
                    $this->files[] = "/{$adminFolder}/index.php";
                    $this->files[] = "/{$adminFolder}/includes/column_left.php";
                }
            }

            require_once($this->dir.'/includes/configure.php');

            //for fix url's in css files
            if(!(getenv('HTTPS') == 'on')) {
                $this->resDir = DIR_WS_HTTP_CATALOG.DIR_WS_MODULES.'magiczoom/core';
            } else {
                $this->resDir = DIR_WS_HTTPS_CATALOG.DIR_WS_MODULES.'magiczoom/core';
            }

        }

        function getAdminFolders() {
            static $adminFolders = null;
            if($adminFolders === null) {
                $adminFolders = array();
                $list = glob($this->dir.'/*');
                if($list !== false) {
                    foreach($list as $path) {
                        if(is_dir($path) && file_exists($path.'/includes/column_left.php')) {
                            $adminFolders[] = preg_replace('#^.*?/([^/]+)/?$#is', '$1', $path);
                        }
                    }
                }
            }
            return $adminFolders;
        }


        function isModuleInstalled() {
            $this->setStatus('check', 'module');
            if(file_exists($this->dir.'/includes/modules/magiczoom')) {
                return true;
            }
            return false;
        }


        function checkPlace() {
            $this->setStatus('check', 'place');
            if(!file_exists($this->dir.'/includes/application_top.php')) {
                $this->setError('Wrong location: please upload the files from the ZIP archive to the osCMax store directory.');
                return false;
            }
            return true;
        }

        function checkPerm() {
            $this->setStatus('check', 'perm');
            list($result, $wrang) = $this->checkFilesPerm(array_merge($this->dirs, $this->files));
            if(!$result) {
                $this->setError('This installer need to modify some osCMax store files.');
                $this->setError('Please check write access for following files of your osCMax store:');
                $this->setError($wrang, '&nbsp;&nbsp;&nbsp;-&nbsp;');
                return false;
            }
            return true;
        }

        function backupFiles() {
            $this->setStatus('backup', 'files');
            list($result, $wrang) = $this->createBackups($this->files);
            if(!$result) {
                $this->setError('Can\'t create backups for following files:');
                $this->setError($wrang, '&nbsp;&nbsp;&nbsp;-&nbsp;');
                $this->setError('Please check write access');
                return false;
            }
            return true;
        }

        function restoreStep_backupFiles() {
            $this->removeBackups($this->files);
            return true;
        }

        function installFiles() {
            $this->setStatus('install', 'files');

            $adminFiles = array();
            if($this->new_osCmax) {
                foreach($this->getAdminFolders() as $adminFolder) {
                    $adminFiles[] = "/{$adminFolder}/includes/menu.php";
                }
            } else {
                foreach($this->getAdminFolders() as $adminFolder) {
                    $adminFiles[] = "/{$adminFolder}/index.php";
                    $adminFiles[] = "/{$adminFolder}/includes/column_left.php";
                }
            }

            foreach($this->files as $file) {
                if(in_array($file, $adminFiles)) {
                    continue;
                }
                $f = preg_replace('/^(.*?)\.php$/is', '$1_original.php', $file);
                if(copy($this->dir.$file, $this->dir.$f)) {
                    $this->log('CREATE FILE '.$this->dir.$f);
                }
                @chmod($this->dir.$f, 0755);
            }

            $boxes = array(
                '/includes/boxes/reviews.php',
                '/includes/boxes/specials.php',
                '/includes/boxes/whats_new.php',
            );

            foreach($boxes as $fileIndex => $file) {
                if(file_exists($this->dir.$file)) {
                    unset($boxes[$fileIndex]);
                }
            }

            //NOTE: copy includes folder
            $this->copyDir($this->modDir.'/catalog/includes', $this->dir.'/includes');

            //NOTE: remove unnecessary files 
            foreach($boxes as $file) {
                unlink($this->dir.$file);
            }


            if($this->sts) {
                //modify classes/sts.php file
                $c = file_get_contents($this->dir.'/includes/classes/sts.php');
                $r = 'require_once(DIR_WS_MODULES.\'magiczoom/magiczoom.php\');'."\n" .
                     '$this->template[\'content\'] = MagicZoom($this->template[\'content\']);'."\n" .
                     '$this->template[\'template_html\'] = MagicZoomSTSHead($this->template[\'template_html\']);'."\n";
                $p = 'foreach ($this->template as $key=>$value) {';
                $c = str_replace($p, $r.$p , $c);
                file_put_contents($this->dir.'/includes/classes/sts.php', $c);
            }

            if($this->cre) {
                //modify functions/html_output.php file
                $c = file_get_contents($this->dir.'/includes/functions/html_output.php');
                $c = str_replace('function tep_javascript_image(', 'function tep_javascript_image_original(' , $c);
                file_put_contents($this->dir.'/includes/functions/html_output.php', $c);
            }


            $adminFolders = $this->getAdminFolders();
            if($this->new_osCmax) {
                foreach($adminFolders as $adminFolder) {
                    $filePath = "{$this->dir}/{$adminFolder}/includes/menu.php";
                    $c = file_get_contents($filePath);
                    $pattern = '\s*+(?:<!-- END OF MENU -->|</ul>\s*+$)';
                    //$matches = array();
                    //preg_match_all("#{$pattern}#is", $c, $matches, PREG_SET_ORDER);
                    //debug_log($matches);
                    $replace = '

<!-- MAGICTOOLBOX -->
<'.'?php
  if (tep_admin_check_boxes(\'magictoolbox.php\') == true) { ?>
    <li>
      <a href="#">Magic Toolbox</a>
        <ul>
           <'.'?php require(DIR_WS_BOXES . \'magictoolbox.php\'); ?>
        </ul>
    </li>
<'.'?php } ?>
$0';
                    $c = preg_replace("#{$pattern}#is", $replace, $c, 1);
                    file_put_contents($filePath, $c);       
                    // copy admin folder
                    $this->copyDir($this->modDir.'/catalog/YOUR-ADMIN-FOLDER', "{$this->dir}/{$adminFolder}");
                }
            } else {
                foreach($adminFolders as $adminFolder) {
                    $filePath = "{$this->dir}/{$adminFolder}/includes/column_left.php";
                    $c = file_get_contents($filePath);
                    $pattern =
                        'if\s*+\(\s*+tep_admin_check_boxes\s*+\(\s*+\'articles\.php\'\s*+\)\s*+==\s*+true\)\s*+{\s*+'.
                            'require\s*+\(\s*+DIR_WS_BOXES\s*+\.\s*+\'articles\.php\'\s*+\)\s*+;\s*+'.
                        '}';
                    $replace = '$0
// ADDED: Magic Toolbox
  if (tep_admin_check_boxes(\'magictoolbox.php\') == true) {
    require(DIR_WS_BOXES . \'magictoolbox.php\');
  }
';
                    $c = preg_replace('#'.$pattern.'#is', $replace, $c);
                    file_put_contents($filePath, $c);

                    $filePath = "{$this->dir}/{$adminFolder}/index.php";
                    $c = file_get_contents($filePath);
                    $pattern = '\?>[^<]*+<!doctype html';
                    $replace = "  include('includes/boxes/magictoolbox.php');\n$0";
                    $c = preg_replace('#'.$pattern.'#is', $replace, $c);
                    file_put_contents($filePath, $c);

                    //NOTE: copy admin folder
                    $this->copyDir($this->modDir.'/catalog/YOUR-ADMIN-FOLDER', "{$this->dir}/{$adminFolder}");
                }
            }


            return true;
        }

        function restoreStep_installFiles() {
            $this->restoreFromBackups($this->files);
            $this->removeDir($this->dir.'/includes/modules/magiczoom');
            @unlink($this->dir.'/includes/languages/english/modules/magictoolbox/magiczoom.php');
            if($this->isEmptyDir($this->dir.'/includes/languages/english/modules/magictoolbox')) {
                $this->removeDir($this->dir.'/includes/languages/english/modules/magictoolbox');
            }
            return true;
        }

        function installDB() {
            if(!$this->executeSQL(file($this->modDir.'/install.sql', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES))) return false;
            $sqlFileName = $this->new_osCmax ? 'install_2.5.x.sql' : 'install_2.0.x.sql';
            if(!$this->executeSQL(file($this->modDir.'/'.$sqlFileName, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES))) return false;
            return true;
        }

        function restoreStep_installDB() {
            if(!$this->executeSQL(file($this->modDir.'/uninstall.sql', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES))) return false;
            $sqlFileName = $this->new_osCmax ? 'uninstall_2.5.x.sql' : 'uninstall_2.0.x.sql';
            //TODO: check for last module
            if(!$this->executeSQL(file($this->modDir.'/'.$sqlFileName, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES))) return false;
            return true;
        }

        function executeSQL($queries) {
            $link = mysql_connect(DB_SERVER, DB_SERVER_USERNAME, DB_SERVER_PASSWORD);
            if(!$link) {
                $this->setError('Could not connect: '.mysql_error());
                return false;
            }
            $db_selected = mysql_select_db(DB_DATABASE, $link);
            if(!$db_selected) {
                $this->setError('Can\'t use '.DB_DATABASE.' : '.mysql_error());
                mysql_close($link);
                return false;
            }
            $sql = '';
            foreach($queries as $query) {
                $query = trim($query);
                if(substr($query, 0, 2) == '--') continue;
                $sql .= $query;
                if(substr($query, -1) != ';') continue;
                $result = mysql_query($sql);
                if(!$result) {
                    $this->setError('Error while trying execute query.<br/>Query: '.$sql.'<br/>Mysql Error: '.mysql_error());
                    mysql_close($link);
                    return false;
                }
                $sql = '';
            }
            mysql_close($link);
            return true;
        }

        function upgrade($files) {
            $path = $this->dir.'/includes/modules/magiczoom/core/';
            foreach($files as $name => $file) {
                if(file_exists($path.$name)) {
                    unlink($path.$name);
                }
                file_put_contents($path.$name, $file);
                chmod($path.$name, 0755);
            }
            return true;
        }

        function getPlatformVersion() {
            static $version = null;
            if($version === null) {
                $version = '';
                $application_top_contents = '';
                if(file_exists($this->dir.'/includes/application_top_original.php')) {
                    //if module installed
                    $application_top_contents = file_get_contents($this->dir.'/includes/application_top_original.php');
                } else if(file_exists($this->dir.'/includes/application_top.php')) {
                    $application_top_contents = file_get_contents($this->dir.'/includes/application_top.php');
                }
                if($application_top_contents) {
                    $match = array();
                    if(preg_match('/define\s*\(\s*\'PROJECT_VERSION\'\s*,\s*\'[^\']+\'\s*\)/', $application_top_contents, $match)) {
                        $version = preg_replace('/^.*?(\d+\.\d+(?:\.\d+)*).*?$/is', '$1', $match[0]);
                    }
                }
            }
            return $version;
        }

    }
