<?php

ini_set('max_execution_time', '0');

$images_dir = "magic360images"; # this is path for folder with images
$magic360dir = "media/magictoolbox/magic360/";


require_once 'app/Mage.php';
Mage::app('default');

$images_array = NULL;
$serialize_images = NULL;

function serialize_array($images_arrays){
	$url = Mage::getBaseUrl('media')."magictoolbox/magic360";
	$file = NULL;
	$position = NULL;
	$disabled = '0';
	$removed = '0';
	$s_array = array();

	foreach ($images_arrays as $key => $images_array) {
		$rel_dir = "/".get_dirs_names($key);
		$s_array[$key] = array();
		$position = 0;
		foreach ($images_array as $image) {
			$file = $rel_dir.$key."_".$image;
			$temp_array = array('url'=>$url.$file, 'file'=>$file, 'position'=>$position, 'disabled'=>$disabled, 'removed'=>$removed);
			array_push($s_array[$key], $temp_array);
			$position++;
		}
	}
	return $s_array;
}

function save_to_bd($serialize_object){
	if(!empty($serialize_object)){
        $resource = Mage::getSingleton('core/resource');
        $connection = $resource->getConnection('core_write');
        $table = $resource->getTableName('magic360/gallery');
        $lengthLimit = 9000;

		foreach ($serialize_object as $key => $value) {
		$id = $key;
		$columns = count($value);
		$gallery = Mage::helper('core')->jsonEncode($value);
		$result = $connection->query("SELECT product_id FROM {$table} WHERE product_id = {$id}");
            if($result) {
                $rows = $result->fetch(PDO::FETCH_ASSOC);
                if($rows) {
                    if(empty($value)) {
                        $connection->query("DELETE FROM {$table} WHERE product_id = {$id}");
                    } else {
                        $galleryParts = array();
                        $gLen = strlen($gallery);
                        while($gLen > $lengthLimit) {
                            $galleryParts[] = substr($gallery, 0, $lengthLimit);
                            $gallery = substr($gallery, $lengthLimit);
                            $gLen = strlen($gallery);
                        }
                        $galleryParts[] = $gallery;
                        $query = "UPDATE {$table} SET columns = {$columns}, gallery = '{$galleryParts[0]}' WHERE product_id = {$id}";
                        $connection->query($query);
                        unset($galleryParts[0]);
                        if(count($galleryParts)) {
                            foreach($galleryParts as $galleryPart) {
                                $query = "UPDATE {$table} SET gallery = concat(gallery, '{$galleryPart}') WHERE product_id = {$id}";
                                $connection->query($query);
                            }
                        }
                    }
                } else {
                    if(!empty($value)) {
                        $galleryParts = array();
                        $gLen = strlen($gallery);
                        while($gLen > $lengthLimit) {
                            $galleryParts[] = substr($gallery, 0, $lengthLimit);
                            $gallery = substr($gallery, $lengthLimit);
                            $gLen = strlen($gallery);
                        }
                        $galleryParts[] = $gallery;
                        $query = "INSERT INTO {$table} (product_id, columns, gallery) VALUES ({$id}, {$columns}, '{$galleryParts[0]}')";
                        $connection->query($query);
                        unset($galleryParts[0]);
                        if(count($galleryParts)) {
                            foreach($galleryParts as $galleryPart) {
                                $query = "UPDATE {$table} SET gallery = concat(gallery, '{$galleryPart}') WHERE product_id = {$id}";
                                $connection->query($query);
                            }
                        }
                    }
                }
            }
		//$connection->query("INSERT INTO {$table} (product_id, columns, gallery) VALUES ({$id}, {$columns}, '{$gallery}')");
            echo "Images for product id: ".$key." imported<br />";
		}
		echo "<br />All data saved<br />";
	} else{
		echo "<br />Nothing to save<br />";
	}

}

function get_ids($sku){
	$resource = Mage::getSingleton('core/resource');
	$connection = $resource->getConnection('core_read');
	$table = $resource->getTableName('catalog_product_entity');
	$row_array = array();
	foreach ($sku as $value) {
		$select = $connection->select()
		->from($table, array('sku', 'entity_id')) // select * from tablename or use array('id','name') selected values
		->where('sku=?', $value);
		$result = $connection->fetchRow($select);
		if(!empty($result)){
		    array_push($row_array, $result);
		} else{
		    echo "<span style='color:red; font-weight: bold;'>Did not find ID for SKU: ".$value."</span><br />";
		}
	}

	return $row_array;
}

#return path with created dirs
function create_dirs($magic360dir, $dirs){
	if(!is_dir($magic360dir.$dirs)){
		mkdir($magic360dir.$dirs, 0777, true);
	}
	return $magic360dir.$dirs;

}

function copy_images($path, $images, $images_dir, $sku_ids){
	foreach ($images as $key => $value) {
		$current_sku = get_current_sku($key, $sku_ids);
		$full_path = create_dirs($path, get_dirs_names($key));
		foreach ($value as $image) {
			if(!copy($images_dir."/".$current_sku."/".$image, $full_path.$key."_".$image)){
				echo "Image ".$image." was not coppied in".$full_path.$key."<br />\n\n	";
			}
		}
	}
}

function get_current_sku($id, $ids){
	foreach ($ids as $value) {
		if ($value['entity_id'] == $id){
			return $value['sku'];
			break;
		}
	}
}

function get_dirs_names($str){
	if (is_int($str)){
		$str = (string) $str;
	}
	if(strlen($str) < 2) {
		$str = '0'.$str;
	}
	$first_dir = substr($str, 0, 1);
	$second_dir = substr($str, 1, 1);
	return $first_dir."/".$second_dir."/";

}

function get_sku($images_dir){
	return remove_hidden_dirs(array_slice(scandir($images_dir), 2));
}

//delete items that start from '.' like .DS_STORE and files that include substr "thumb"
function remove_hidden_dirs($files_array){
	foreach ($files_array as $key => $image_item) {
    	if (substr($image_item, 0, 1)==='.'){
                unset($files_array[$key]);
        }
        // remove files that include substr "t(T)humb(s)"
        if (preg_match('/.*[Tt]humb[s]*\.[a-zA-Z]{2,4}/ims',$image_item)){
            unset($files_array[$key]);
        }
    }
    return $files_array;
}

function parse_images($images_dir, $sku_ids){
	$images = array();

	if (!empty($sku_ids)){
		echo "<br/><span style='font-weight:bold;'>Start parse SKU and images:</span>\n\n<br /><br />";
		foreach ($sku_ids as $value) {
                $images[$value['entity_id']] = remove_hidden_dirs(array_slice(scandir($images_dir."/".$value['sku']."/"), 2));
			    natsort($images[$value['entity_id']]);
			    echo "SKU ".$value['sku']." successfully parsed!!!\n<br />";
	    }
		echo "\n All SKUs have been parsed\n\n<br /><br />";
	}
	else{
		echo "SKU was not found\n<br />";
	}

	return $images;

}


function run($images_dir, $magic360dir){
    $sku = get_sku($images_dir);
	$sku_ids = get_ids($sku); //return associative array with id(entity_id) and sku for all skus
	$images_array = parse_images($images_dir, $sku_ids);
	copy_images($magic360dir, $images_array, $images_dir, $sku_ids);
	$serialize_images = serialize_array($images_array);
	save_to_bd($serialize_images);
}

function view(){
	$html  = '
	<html>
	  <head>
	    <title>Magic360 upload images tool</title>
	  </head>
	  <body>
	    <div style="width:500px; margin: 0 auto; text-align:center;">
	      Press button to import images to magento products<br /><br />
	      <form method="post" action="bulk_360.php">
		<input type="hidden" name="magic360_validate" value="iergh234CDdsfssssfds110dfd">
		<input type="submit" name="formSubmit" value="Submit">
	      </form>
	    </div>
	  </body>
	</html>';

	echo $html;
}


if($_POST['formSubmit'] == "Submit")
  {
    $hidden = $_POST['magic360_validate'];
    if ($hidden == "iergh234CDdsfssssfds110dfd"){
    	run($images_dir, $magic360dir);
    }
  }
  else{
	view();
  }
  
?>
