<?php

namespace MagicToolbox\MagicZoom\Observer;

/**
 * MagicZoom Observer
 *
 */
class ProductSaveAfter implements \Magento\Framework\Event\ObserverInterface
{
    /**
     * Helper
     *
     * @var \MagicToolbox\MagicZoom\Helper\Data
     */
    public $magicToolboxHelper = null;

    /**
     * Constructor
     *
     * @param \MagicToolbox\MagicZoom\Helper\Data $magicToolboxHelper
     * @return void
     */
    public function __construct(
        \MagicToolbox\MagicZoom\Helper\Data $magicToolboxHelper
    ) {
        $this->magicToolboxHelper = $magicToolboxHelper;
    }

    /**
     * Execute method
     *
     * @param \Magento\Framework\Event\Observer $observer
     * @return void
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $product = $observer->getProduct();

        $mediaGalleryEntries = $product->getMediaGalleryEntries();
        if (!$mediaGalleryEntries) {
            return;
        }

        foreach ($mediaGalleryEntries as $entry) {
            if ($entry->getDisabled() || $entry->getMediaType() != 'external-video') {
                continue;
            }
            $videoContent = $entry->getExtensionAttributes()->getVideoContent();
            if ($videoContent) {
                $videoUrl = $videoContent->getVideoUrl();
                $videoMetadata = $videoContent->getVideoMetadata();
                if (empty($videoMetadata)) {
                    $videoMetadata = [];
                } else {
                    $videoMetadata = json_decode($videoMetadata, true);
                }
                if (is_array($videoMetadata)) {
                    if (isset($videoMetadata['width'], $videoMetadata['height'])) {
                        continue;
                    }
                } else {
                    continue;
                }

                $videoMetadata = $this->magicToolboxHelper->updateVideoMetadata(
                    $entry->getId(),
                    $videoUrl,
                    $videoMetadata
                );
            }
        }
    }
}
