<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * LiteCommerce
 * 
 * NOTICE OF LICENSE
 * 
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to licensing@litecommerce.com so we can send you a copy immediately.
 * 
 * PHP version 5.3.0
 * 
 * @category  LiteCommerce
 * @author    Magic Toolbox <support@magictoolbox.com>
 * @copyright Copyright (c) 2011 Magic Toolbox <support@magictoolbox.com>. All rights reserved
 * @license   http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 * @link      http://www.magictoolbox.com/
 * @see       ____file_see____
 * @since     1.0.0
 */

namespace XLite\Module\MagicToolbox\MagicZoomPlus\View\Header;

/**
 * Header
 *
 * @see   ____class_see____
 * @since 1.0.0
 *
 * @ListChild (list="center", zone="customer", weight="0")
 *
 */
class DrupalHeader extends \XLite\Module\MagicToolbox\MagicZoomPlus\View\Header {

    /**
     * Method to get MagicZoomPlus options
     *
     * @return string
     * @see    ____func_see____
     * @since  1.0.0
     */
    public function getHTML() {
        $headers = '';
        if(/*$this->viewListName == 'center' && */\Includes\Utils\ModulesManager::isActiveModule('CDev\DrupalConnector') && $this->target == 'product') {
            $tool = \XLite\Module\MagicToolbox\MagicZoomPlus\MagicZoomPlusTool::getInstance();
            $magiczoomplus = $tool->getMagicZoomPlus();
            if(!$magiczoomplus->params->checkValue('enable-effect', 'No')) {
                //NOTICE: we have to include JS file here because, when Drupal 7 integrated with the LiteCommerce 3,
                //        JS file, connected with 'getJSFiles' metod, does not connect as normal 'script' tag
                //        and loaded later than the options
                $shortJSPath = 'modules/MagicToolbox/MagicZoomPlus/js';
                $shortCSSPath = 'modules/MagicToolbox/MagicZoomPlus/css';
                $jsPath = \XLite\Core\Layout::getInstance()->getResourceWebPath($shortJSPath, \XLite\Core\Layout::WEB_PATH_OUTPUT_URL, \XLite::CUSTOMER_INTERFACE);
                $cssPath = \XLite\Core\Layout::getInstance()->getResourceWebPath($shortCSSPath, \XLite\Core\Layout::WEB_PATH_OUTPUT_URL, \XLite::CUSTOMER_INTERFACE);
                $headers = '';
                $headers .= $magiczoomplus->getHeadersTemplate($jsPath, $cssPath);
                $scroll = $tool->getScroll();
                if($scroll) {
                    $headers .= "\n".$scroll->getHeadersTemplate($jsPath, $cssPath, false);
                }
            }
        }
        return $headers;
    }

}
