<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * LiteCommerce
 * 
 * NOTICE OF LICENSE
 * 
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to licensing@litecommerce.com so we can send you a copy immediately.
 * 
 * PHP version 5.3.0
 * 
 * @category  LiteCommerce
 * @author    Magic Toolbox <support@magictoolbox.com>
 * @copyright Copyright (c) 2011 Magic Toolbox <support@magictoolbox.com>. All rights reserved
 * @license   http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 * @link      http://www.magictoolbox.com/
 * @see       ____file_see____
 * @since     1.0.0
 */

namespace XLite\Module\MagicToolbox\MagicZoomPlus;

/**
 * MagicZoomPlusTool
 *
 * @see   ____class_see____
 * @since 1.0.0
 */
class MagicZoomPlusTool extends \XLite\Base\Singleton {

    /**
     * MagicZoomPlus module core class
     *
     * @var   \XLite\Module\MagicToolbox\MagicZoomPlus\Classes\MagicZoomPlusModuleCoreClass
     * @see   ____var_see____
     * @since 1.0.0
     *
     */
    protected $magiczoomplus;

    /**
     * MagicScroll module core class
     *
     * @var   \XLite\Module\MagicToolbox\MagicZoomPlus\Classes\MagicScrollModuleCoreClass
     * @see   ____var_see____
     * @since 1.0.0
     *
     */
    protected $scroll;

    /**
     * Protected constructor.
     * Load and set up MagicZoomPlus module core class
     *
     * @return void
     * @see    ____func_see____
     * @since  1.0.0
     */
    protected function __construct() {
        $this->magiczoomplus = new \XLite\Module\MagicToolbox\MagicZoomPlus\Classes\MagicZoomPlusModuleCoreClass();
        $config = \XLite\Core\Config::getInstance()->MagicToolbox->MagicZoomPlus;
        //foreach($this->magiczoomplus->params->getParams() as $id => $param) {
        //    $value = $config->__get($id);
        //    if($value !== null) {
        //        $this->magiczoomplus->params->setValue($id, $value);
        //    }
        //}
        foreach($config as $key => $value) {
            $this->magiczoomplus->params->setValue($key, $value);
        }
        if($this->magiczoomplus->type == 'standard' && $this->magiczoomplus->params->checkValue('magicscroll', 'Yes')) {
            $this->scroll = new \XLite\Module\MagicToolbox\MagicZoomPlus\Classes\MagicScrollModuleCoreClass();
            foreach($this->scroll->params->getParams() as $id => $param) {
                $value = $config->__get($id);
                if($value !== null) {
                    $this->scroll->params->setValue($id, $value);
                }
            }
            $this->scroll->params->setValue('orientation', $this->magiczoomplus->params->checkValue('template', array('left', 'right')) ? 'vertical' : 'horizontal');
        } else {
            $this->scroll = null;
        }
    }

    /**
     * Method to get MagicZoomPlus module core class
     *
     * @return \XLite\Module\MagicToolbox\MagicZoomPlus\Classes\MagicZoomPlusModuleCoreClass
     * @see    ____func_see____
     * @since  1.0.0
     */
    public function getMagicZoomPlus() {
        return $this->magiczoomplus;
    }

    /**
     * Method to get MagicScroll module core class
     *
     * @return \XLite\Module\MagicToolbox\MagicZoomPlus\Classes\MagicScrollModuleCoreClass
     * @see    ____func_see____
     * @since  1.0.0
     */
    public function getScroll() {
        return $this->scroll;
    }

}
