<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * LiteCommerce
 * 
 * NOTICE OF LICENSE
 * 
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to licensing@litecommerce.com so we can send you a copy immediately.
 * 
 * PHP version 5.3.0
 * 
 * @category  LiteCommerce
 * @author    Magic Toolbox <support@magictoolbox.com>
 * @copyright Copyright (c) 2011 Magic Toolbox <support@magictoolbox.com>. All rights reserved
 * @license   http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 * @link      http://www.magictoolbox.com/
 * @see       ____file_see____
 * @since     1.0.0
 */

namespace XLite\Module\MagicToolbox\MagicZoom;

/**
 * MagicZoomTool
 *
 * @see   ____class_see____
 * @since 1.0.0
 */
class MagicZoomTool extends \XLite\Base\Singleton {

    /**
     * MagicZoom module core class
     *
     * @var   \XLite\Module\MagicToolbox\MagicZoom\Classes\MagicZoomModuleCoreClass
     * @see   ____var_see____
     * @since 1.0.0
     *
     */
    protected $magiczoom;

    /**
     * MagicScroll module core class
     *
     * @var   \XLite\Module\MagicToolbox\MagicZoom\Classes\MagicScrollModuleCoreClass
     * @see   ____var_see____
     * @since 1.0.0
     *
     */
    protected $scroll;

    /**
     * Protected constructor.
     * Load and set up MagicZoom module core class
     *
     * @return void
     * @see    ____func_see____
     * @since  1.0.0
     */
    protected function __construct() {
        $this->magiczoom = new \XLite\Module\MagicToolbox\MagicZoom\Classes\MagicZoomModuleCoreClass();
        $config = \XLite\Core\Config::getInstance()->MagicToolbox->MagicZoom;
        //foreach($this->magiczoom->params->getParams() as $id => $param) {
        //    $value = $config->__get($id);
        //    if($value !== null) {
        //        $this->magiczoom->params->setValue($id, $value);
        //    }
        //}
        foreach($config as $key => $value) {
            $this->magiczoom->params->setValue($key, $value);
        }
        if($this->magiczoom->type == 'standard' && $this->magiczoom->params->checkValue('magicscroll', 'Yes')) {
            $this->scroll = new \XLite\Module\MagicToolbox\MagicZoom\Classes\MagicScrollModuleCoreClass();
            foreach($this->scroll->params->getParams() as $id => $param) {
                $value = $config->__get($id);
                if($value !== null) {
                    $this->scroll->params->setValue($id, $value);
                }
            }
            $this->scroll->params->setValue('orientation', $this->magiczoom->params->checkValue('template', array('left', 'right')) ? 'vertical' : 'horizontal');
        } else {
            $this->scroll = null;
        }
    }

    /**
     * Method to get MagicZoom module core class
     *
     * @return \XLite\Module\MagicToolbox\MagicZoom\Classes\MagicZoomModuleCoreClass
     * @see    ____func_see____
     * @since  1.0.0
     */
    public function getMagicZoom() {
        return $this->magiczoom;
    }

    /**
     * Method to get MagicScroll module core class
     *
     * @return \XLite\Module\MagicToolbox\MagicZoom\Classes\MagicScrollModuleCoreClass
     * @see    ____func_see____
     * @since  1.0.0
     */
    public function getScroll() {
        return $this->scroll;
    }

}
