<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * LiteCommerce
 * 
 * NOTICE OF LICENSE
 * 
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to licensing@litecommerce.com so we can send you a copy immediately.
 * 
 * PHP version 5.3.0
 * 
 * @category  LiteCommerce
 * @author    Magic Toolbox <support@magictoolbox.com>
 * @copyright Copyright (c) 2011 Magic Toolbox <support@magictoolbox.com>. All rights reserved
 * @license   http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 * @link      http://www.magictoolbox.com/
 * @see       ____file_see____
 * @since     1.0.0
 */

namespace XLite\Module\MagicToolbox\MagicThumb\View\Product\Details\Customer;

/**
 * MagicThumbView
 *
 * @see   ____class_see____
 * @since 1.0.0
 *
 * @ListChild (list="product.details.page.magictoolbox.image", weight="0")
 */

class MagicThumbView extends \XLite\View\Product\Details\Customer\ACustomer {

    /**
     * Main Image HTML
     *
     * @var   string
     * @see   ____var_see____
     * @since 1.0.0
     */
    protected $mainImageHTML = '';

    /**
     * Selectors HTML array
     *
     * @var   array
     * @see   ____var_see____
     * @since 1.0.0
     */
    protected $selectorsHTML = array();

    /**
     * Current layout
     *
     * @var   string
     * @see   ____var_see____
     * @since 1.0.0
     */
    protected $magicToolboxLayout = 'bottom';

    /**
     * Additional classes
     *
     * @var   string
     * @see   ____var_see____
     * @since 1.0.0
     *
     */
    protected $additionalClasses = '';

    /**
     * Scroll options
     *
     * @var   string
     * @see   ____var_see____
     * @since 1.0.0
     *
     */
    protected $scrollOptions = '';

    /**
     * Product unique ID
     *
     * @var   integer
     * @see   ____var_see____
     * @since 1.0.0
     *
     */
    protected $pid = null;

    /**
     * Return widget default template
     *
     * @return string
     * @see    ____func_see____
     * @since  1.0.0
     */
    protected function getDefaultTemplate() {
        return 'modules/MagicToolbox/MagicThumb/templates/magictoolbox.tpl';
    }

    /**
     * Check visibility
     *
     * @return boolean
     * @see    ____func_see____
     * @since  1.0.0
     */
    protected function isVisible() {
        return parent::isVisible() && $this->getProduct()->countImages() > 0;
    }


    /**
     * Method to get main image HTML
     *
     * @return string
     * @see    ____func_see____
     * @since  1.0.0
     */
    public function getMainImageHTML() {
        return $this->mainImageHTML;
    }

    /**
     * Method to get selectors HTML
     *
     * @return array
     * @see    ____func_see____
     * @since  1.0.0
     */
    public function getSelectorsHTML() {
        return $this->selectorsHTML;
    }

    /**
     * Method to get selectors count
     *
     * @return integer
     * @see    ____func_see____
     * @since  1.0.0
     */
    public function getSelectorsCount() {
        return count($this->selectorsHTML);
    }

    /**
     * Method to get current layout
     *
     * @return string
     * @see    ____func_see____
     * @since  1.0.0
     */
    public function getLayout() {
        return $this->magicToolboxLayout;
    }


    /**
     * Method to get ID
     *
     * @return integer|string
     * @see    ____func_see____
     * @since  1.0.0
     */
    public function getPid() {
        return ($this->pid !== null) ? $this->pid : '';
    }

    /**
     * Method to get additional classes
     *
     * @return string
     * @see    ____func_see____
     * @since  1.0.0
     */
    public function getAdditionalClasses() {
        return $this->additionalClasses;
    }

    /**
     * Method to get scroll options
     *
     * @return string
     * @see    ____func_see____
     * @since  1.0.0
     */
    public function getScrollOptions() {
        return $this->scrollOptions;
    }

    /**
     * Method to get option value
     *
     * @param string $option Option name
     *
     * @return mixed
     * @see    ____func_see____
     * @since  1.0.0
     */
    public function getOptionValue($option) {
        $tool = \XLite\Module\MagicToolbox\MagicThumb\MagicThumbTool::getInstance();
        $magicthumb = $tool->getMagicThumb();
        return $magicthumb->params->getValue($option);
    }

    /**
     * Register CSS files
     *
     * @return array
     * @see    ____func_see____
     * @since  1.0.0
     */
    public function getCSSFiles() {
        $list = parent::getCSSFiles();
        if(!\Includes\Utils\ModulesManager::isActiveModule('CDev\DrupalConnector')) {
            $tool = \XLite\Module\MagicToolbox\MagicThumb\MagicThumbTool::getInstance();
            $magicthumb = $tool->getMagicThumb();
            if(!$magicthumb->params->checkValue('enable-effect', 'No')) {
                $list[] = 'modules/MagicToolbox/MagicThumb/css/magicthumb.css';
                $list[] = 'modules/MagicToolbox/MagicThumb/css/magicthumb.module.css';
                $scroll = $tool->getScroll();
                if($scroll) {
                    $list[] = 'modules/MagicToolbox/MagicThumb/css/magicscroll.css';
                }
            }
        }
        return $list;
    }

    /**
     * Register JS files
     *
     * @return array
     * @see    ____func_see____
     * @since  1.0.0
     */
    public function getJSFiles() {
        $list = parent::getJSFiles();
        if(!\Includes\Utils\ModulesManager::isActiveModule('CDev\DrupalConnector')) {
            $tool = \XLite\Module\MagicToolbox\MagicThumb\MagicThumbTool::getInstance();
            $magicthumb = $tool->getMagicThumb();
            if(!$magicthumb->params->checkValue('enable-effect', 'No')) {
                $list[] = 'modules/MagicToolbox/MagicThumb/js/magicthumb.js';
                $scroll = $tool->getScroll();
                if($scroll) {
                    $list[] = 'modules/MagicToolbox/MagicThumb/js/magicscroll.js';
                }
            }
        }
        return $list;
    }

    /**
     * Method to render MagicThumb HTML
     *
     * @return boolean
     * @see    ____func_see____
     * @since  1.0.0
     */
    public function renderTemplate() {

        $tool = \XLite\Module\MagicToolbox\MagicThumb\MagicThumbTool::getInstance();
        $magicthumb = $tool->getMagicThumb();
        if($magicthumb->params->checkValue('enable-effect', 'No')) return false;
        //to prevent all option to be included in rel
        $magicthumb->params->setProfile('product');
        $product = $this->getProduct();
        $this->id = $product->getId();
        $productName = $product->getName();
        $briefDescription = $product->getBriefDescription();
        $fullDescription = $product->getDescription();
        $images = $this->getProduct()->getImages();
        $imagesCount = count($images);
        if(!$imagesCount) return false;



        foreach($images as $index => $image) {

            $img = $image->getURL();
            list($width, $height, $thumb) = $image->getResizedURL(intval($magicthumb->params->getValue('thumb-max-width')), intval($magicthumb->params->getValue('thumb-max-height')));
            list($width, $height, $selector) = $image->getResizedURL(intval($magicthumb->params->getValue('selector-max-width')), intval($magicthumb->params->getValue('selector-max-height')));
            $alt = $magicthumb->params->checkValue('use-individual-titles', 'Yes') ? $image->getAlt() : '';
            if($index == 0) {
                $this->mainImageHTML = $magicthumb->getMainTemplate(array(
                    'id' => 'Product' . $this->id,
                    'img' => $img,
                    'thumb' => $thumb,
                    'title' => $alt?$alt:$productName,
                    'briefDescription' => $briefDescription,
                    'fullDescription' => $fullDescription,
                ));
                if($imagesCount == 1) break;
            }
            $this->selectorsHTML[] = $magicthumb->getSelectorTemplate(array(
                'id' => 'Product' . $this->id,
                'group' => 'productPage',
                'img' => $img,
                'medium' => $thumb,
                'thumb' => $selector,
                'title' => $alt?$alt:$productName
            ));


        }

        $this->magicToolboxLayout = $magicthumb->params->getValue('template');
        if($magicthumb->params->checkValue('magicscroll', 'Yes')) {
            $additionalClasses = $magicthumb->params->getValue('scroll-extra-styles');
            if(empty($additionalClasses)) {
                $this->additionalClasses = ' MagicScroll';
            } else {
                $this->additionalClasses = ' MagicScroll '.trim($additionalClasses);
            }
            $dataOptions = $tool->getScroll()->params->serialize();
            if(empty($dataOptions)) {
                $this->scrollOptions = '';
            } else {
                $this->scrollOptions = " data-options=\"{$dataOptions}\"";
            }
        }


        $magicthumb->params->resetProfile();

        return true;

    }

}
