<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * LiteCommerce
 * 
 * NOTICE OF LICENSE
 * 
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to licensing@litecommerce.com so we can send you a copy immediately.
 * 
 * PHP version 5.3.0
 * 
 * @category  LiteCommerce
 * @author    Magic Toolbox <support@magictoolbox.com>
 * @copyright Copyright (c) 2011 Magic Toolbox <support@magictoolbox.com>. All rights reserved
 * @license   http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 * @link      http://www.magictoolbox.com/
 * @see       ____file_see____
 * @since     1.0.0
 */

namespace XLite\Module\MagicToolbox\MagicThumb;

/**
 * MagicThumbTool
 *
 * @see   ____class_see____
 * @since 1.0.0
 */
class MagicThumbTool extends \XLite\Base\Singleton {

    /**
     * MagicThumb module core class
     *
     * @var   \XLite\Module\MagicToolbox\MagicThumb\Classes\MagicThumbModuleCoreClass
     * @see   ____var_see____
     * @since 1.0.0
     *
     */
    protected $magicthumb;

    /**
     * MagicScroll module core class
     *
     * @var   \XLite\Module\MagicToolbox\MagicThumb\Classes\MagicScrollModuleCoreClass
     * @see   ____var_see____
     * @since 1.0.0
     *
     */
    protected $scroll;

    /**
     * Protected constructor.
     * Load and set up MagicThumb module core class
     *
     * @return void
     * @see    ____func_see____
     * @since  1.0.0
     */
    protected function __construct() {
        $this->magicthumb = new \XLite\Module\MagicToolbox\MagicThumb\Classes\MagicThumbModuleCoreClass();
        $config = \XLite\Core\Config::getInstance()->MagicToolbox->MagicThumb;
        //foreach($this->magicthumb->params->getParams() as $id => $param) {
        //    $value = $config->__get($id);
        //    if($value !== null) {
        //        $this->magicthumb->params->setValue($id, $value);
        //    }
        //}
        foreach($config as $key => $value) {
            $this->magicthumb->params->setValue($key, $value);
        }
        if($this->magicthumb->type == 'standard' && $this->magicthumb->params->checkValue('magicscroll', 'Yes')) {
            $this->scroll = new \XLite\Module\MagicToolbox\MagicThumb\Classes\MagicScrollModuleCoreClass();
            foreach($this->scroll->params->getParams() as $id => $param) {
                $value = $config->__get($id);
                if($value !== null) {
                    $this->scroll->params->setValue($id, $value);
                }
            }
            $this->scroll->params->setValue('orientation', $this->magicthumb->params->checkValue('template', array('left', 'right')) ? 'vertical' : 'horizontal');
        } else {
            $this->scroll = null;
        }
    }

    /**
     * Method to get MagicThumb module core class
     *
     * @return \XLite\Module\MagicToolbox\MagicThumb\Classes\MagicThumbModuleCoreClass
     * @see    ____func_see____
     * @since  1.0.0
     */
    public function getMagicThumb() {
        return $this->magicthumb;
    }

    /**
     * Method to get MagicScroll module core class
     *
     * @return \XLite\Module\MagicToolbox\MagicThumb\Classes\MagicScrollModuleCoreClass
     * @see    ____func_see____
     * @since  1.0.0
     */
    public function getScroll() {
        return $this->scroll;
    }

}
