<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * LiteCommerce
 * 
 * NOTICE OF LICENSE
 * 
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to licensing@litecommerce.com so we can send you a copy immediately.
 * 
 * PHP version 5.3.0
 * 
 * @category  LiteCommerce
 * @author    Magic Toolbox <support@magictoolbox.com>
 * @copyright Copyright (c) 2011 Magic Toolbox <support@magictoolbox.com>. All rights reserved
 * @license   http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 * @link      http://www.magictoolbox.com/
 * @see       ____file_see____
 * @since     1.0.0
 */


namespace XLite\Module\MagicToolbox\MagicThumb\Classes;



if(!defined('MagicToolboxTemplateHelperClassLoaded')) {

    define('MagicToolboxTemplateHelperClassLoaded', true);

    class MagicToolboxTemplateHelperClass {

        public static $extension = 'php';
        public static $path;
        public static $options;

        static function setExtension($extension) {
            self::$extension = $extension;
        }

        static function setPath($path) {
            self::$path = $path;
        }

        static function setOptions($options) {
            self::$options = $options;
        }

        static function prepareMagicScrollClass() {
            $magicscroll = self::$options->checkValue('magicscroll', 'Yes') ? ' MagicScroll' : '';
            if(!empty($magicscroll)) {
                $additionalClasses = self::$options->getValue('scroll-extra-styles');
                if(!empty($additionalClasses)) {
                    $magicscroll = $magicscroll.' '.$additionalClasses;
                }
            }
            return $magicscroll;
        }

        static function render($name, $options = null) {
            $main = '';
            $thumbs = array();
            $pid = '';
            $magicscrollOptions = '';
            if(func_num_args() == 1) {
                $options = $name;
                $name = self::$options->getValue('template');
            }
            extract($options);

            $items = self::$options->getValue('items');
            $items = is_numeric($items) ? (int)$items : 0;
            if(count($thumbs) > $items) {
                $magicscroll = self::prepareMagicScrollClass();
            } else {
                $magicscroll = '';
            }

            ob_start();
            require(self::$path.DIRECTORY_SEPARATOR.preg_replace('/[^a-zA-Z0-9_]/is', '-', $name).'.tpl.'.self::$extension);
            //return str_replace("\n", ' ', str_replace("\r", ' ', ob_get_clean()));
            return ob_get_clean();
        }

    }

}
