<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * LiteCommerce
 * 
 * NOTICE OF LICENSE
 * 
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to licensing@litecommerce.com so we can send you a copy immediately.
 * 
 * PHP version 5.3.0
 * 
 * @category  LiteCommerce
 * @author    Magic Toolbox <support@magictoolbox.com>
 * @copyright Copyright (c) 2011 Magic Toolbox <support@magictoolbox.com>. All rights reserved
 * @license   http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 * @link      http://www.magictoolbox.com/
 * @see       ____file_see____
 * @since     1.0.0
 */

namespace XLite\Module\MagicToolbox\MagicSlideshow\View;

/**
 * Select
 *
 * @see   ____class_see____
 * @since 1.0.0
 */
class Select extends \XLite\View\FormField {

    /**
     * Widget param names
     */
    const PARAM_FIELD_NAME = 'field';
    const PARAM_VALUE    = 'paramValue';
    const PARAM_FIELD_ID   = 'fieldId';
    const PARAM_CLASS_NAME = 'className';

    /**
     * MagicSlideshow module core class
     *
     * @var   \XLite\Module\MagicToolbox\MagicSlideshow\Classes\MagicSlideshowModuleCoreClass
     * @see   ____var_see____
     * @since 1.0.0
     *
     */
    static protected $_toolCoreClass = null;

    /**
     * Return widget default template
     *
     * @return string
     * @see    ____func_see____
     * @since  1.0.0
     */
    protected function getDefaultTemplate() {
        return 'modules/MagicToolbox/MagicSlideshow/select.tpl';
    }

    /**
     * Define widget parameters
     *
     * @return void
     * @see    ____func_see____
     * @since  1.0.0
     */
    protected function defineWidgetParams() {
        parent::defineWidgetParams();
        $this->widgetParams += array(
            self::PARAM_FIELD_NAME => new \XLite\Model\WidgetParam\String('Field name', ''),
            self::PARAM_FIELD_ID   => new \XLite\Model\WidgetParam\String('Field ID', ''),
            self::PARAM_CLASS_NAME => new \XLite\Model\WidgetParam\String('Class name', ''),
            self::PARAM_VALUE    => new \XLite\Model\WidgetParam\String('Value', '')
        );
    }

    /**
     * Method to get MagicSlideshow parameter values
     *
     * @return array
     * @see    ____func_see____
     * @since  1.0.0
     */
    protected function getParamValues() {
        if(null === self::$_toolCoreClass) {
            self::$_toolCoreClass = new \XLite\Module\MagicToolbox\MagicSlideshow\Classes\MagicSlideshowModuleCoreClass();
        }
        return self::$_toolCoreClass->params->getValues($this->getParam(self::PARAM_FIELD_NAME));
    }

}
