<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * LiteCommerce
 * 
 * NOTICE OF LICENSE
 * 
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to licensing@litecommerce.com so we can send you a copy immediately.
 * 
 * PHP version 5.3.0
 * 
 * @category  LiteCommerce
 * @author    Magic Toolbox <support@magictoolbox.com>
 * @copyright Copyright (c) 2011 Magic Toolbox <support@magictoolbox.com>. All rights reserved
 * @license   http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 * @link      http://www.magictoolbox.com/
 * @see       ____file_see____
 * @since     1.0.0
 */

namespace XLite\Module\MagicToolbox\MagicSlideshow\View;

/**
 * Header
 *
 * @see   ____class_see____
 * @since 1.0.0
 *
 * @ListChild (list="head", zone="customer", weight="10000")
 *
 */
class Header extends \XLite\View\AView {

    /**
     * Method to get MagicSlideshow options
     *
     * @return string
     * @see    ____func_see____
     * @since  1.0.0
     */
    public function getHTML() {
        $headers = '';
        if($this->target == 'product') {
            $tool = \XLite\Module\MagicToolbox\MagicSlideshow\MagicSlideshowTool::getInstance();
            $magicslideshow = $tool->getMagicSlideshow();
            if(!$magicslideshow->params->checkValue('enable-effect', 'No')) {
                //$shortJSPath = 'modules/MagicToolbox/MagicSlideshow/js';
                //$shortCSSPath = 'modules/MagicToolbox/MagicSlideshow/css';
                //$jsPath = \XLite\Core\Layout::getInstance()->getResourceWebPath($shortJSPath, \XLite\Core\Layout::WEB_PATH_OUTPUT_URL, \XLite::CUSTOMER_INTERFACE);
                //$cssPath = \XLite\Core\Layout::getInstance()->getResourceWebPath($shortCSSPath, \XLite\Core\Layout::WEB_PATH_OUTPUT_URL, \XLite::CUSTOMER_INTERFACE);
                $headers = $magicslideshow->getOptionsTemplate();
                $scroll = $tool->getScroll();
                if($scroll) {
                    $headers .= "\n".$scroll->getOptionsTemplate();
                }
            }
        }
        return $headers;
    }

    /**
     * Return widget default template
     *
     * @return string
     * @see    ____func_see____
     * @since  1.0.0
     */
    protected function getDefaultTemplate() {
        return 'modules/MagicToolbox/MagicSlideshow/templates/header.tpl';
    }

    /**
     * Check visibility
     *
     * @return boolean
     * @see    ____func_see____
     * @since  1.0.0
     */
    protected function isVisible() {
        return parent::isVisible()/* && \Includes\Utils\ModulesManager::isActiveModule('MagicToolbox\MagicSlideshow')*/;
    }

}
