<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * LiteCommerce
 * 
 * NOTICE OF LICENSE
 * 
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to licensing@litecommerce.com so we can send you a copy immediately.
 * 
 * PHP version 5.3.0
 * 
 * @category  LiteCommerce
 * @author    Magic Toolbox <support@magictoolbox.com>
 * @copyright Copyright (c) 2011 Magic Toolbox <support@magictoolbox.com>. All rights reserved
 * @license   http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 * @link      http://www.magictoolbox.com/
 * @see       ____file_see____
 * @since     1.0.0
 */

namespace XLite\Module\MagicToolbox\MagicScroll\View\Product\Details\Customer;

/**
 * MagicScrollView
 *
 * @see   ____class_see____
 * @since 1.0.0
 *
 * @ListChild (list="product.details.page.magictoolbox.image", weight="0")
 */

class MagicScrollView extends \XLite\View\Product\Details\Customer\ACustomer {

    /**
     * Rendered HTML
     *
     * @var   string
     * @see   ____var_see____
     * @since 1.0.0
     */
    protected $renderedHTML = '';

    /**
     * Product unique ID
     *
     * @var   integer
     * @see   ____var_see____
     * @since 1.0.0
     *
     */
    protected $pid = null;

    /**
     * Return widget default template
     *
     * @return string
     * @see    ____func_see____
     * @since  1.0.0
     */
    protected function getDefaultTemplate() {
        return 'modules/MagicToolbox/MagicScroll/templates/magictoolbox.tpl';
    }

    /**
     * Check visibility
     *
     * @return boolean
     * @see    ____func_see____
     * @since  1.0.0
     */
    protected function isVisible() {
        return parent::isVisible() && $this->getProduct()->countImages() > 0;
    }

    /**
     * Method to get rendered HTML
     *
     * @return string
     * @see    ____func_see____
     * @since  1.0.0
     */
    public function getHTML() {
        return $this->renderedHTML;
    }


    /**
     * Method to get ID
     *
     * @return integer|string
     * @see    ____func_see____
     * @since  1.0.0
     */
    public function getPid() {
        return ($this->pid !== null) ? $this->pid : '';
    }

    /**
     * Method to get option value
     *
     * @param string $option Option name
     *
     * @return mixed
     * @see    ____func_see____
     * @since  1.0.0
     */
    public function getOptionValue($option) {
        $tool = \XLite\Module\MagicToolbox\MagicScroll\MagicScrollTool::getInstance();
        $magicscroll = $tool->getMagicScroll();
        return $magicscroll->params->getValue($option);
    }

    /**
     * Register CSS files
     *
     * @return array
     * @see    ____func_see____
     * @since  1.0.0
     */
    public function getCSSFiles() {
        $list = parent::getCSSFiles();
        if(!\Includes\Utils\ModulesManager::isActiveModule('CDev\DrupalConnector')) {
            $tool = \XLite\Module\MagicToolbox\MagicScroll\MagicScrollTool::getInstance();
            $magicscroll = $tool->getMagicScroll();
            if(!$magicscroll->params->checkValue('enable-effect', 'No')) {
                $list[] = 'modules/MagicToolbox/MagicScroll/css/magicscroll.css';
                $list[] = 'modules/MagicToolbox/MagicScroll/css/magicscroll.module.css';
                $scroll = $tool->getScroll();
                if($scroll) {
                    $list[] = 'modules/MagicToolbox/MagicScroll/css/magicscroll.css';
                }
            }
        }
        return $list;
    }

    /**
     * Register JS files
     *
     * @return array
     * @see    ____func_see____
     * @since  1.0.0
     */
    public function getJSFiles() {
        $list = parent::getJSFiles();
        if(!\Includes\Utils\ModulesManager::isActiveModule('CDev\DrupalConnector')) {
            $tool = \XLite\Module\MagicToolbox\MagicScroll\MagicScrollTool::getInstance();
            $magicscroll = $tool->getMagicScroll();
            if(!$magicscroll->params->checkValue('enable-effect', 'No')) {
                $list[] = 'modules/MagicToolbox/MagicScroll/js/magicscroll.js';
                $scroll = $tool->getScroll();
                if($scroll) {
                    $list[] = 'modules/MagicToolbox/MagicScroll/js/magicscroll.js';
                }
            }
        }
        return $list;
    }

    /**
     * Method to render MagicScroll HTML
     *
     * @return boolean
     * @see    ____func_see____
     * @since  1.0.0
     */
    public function renderTemplate() {

        $tool = \XLite\Module\MagicToolbox\MagicScroll\MagicScrollTool::getInstance();
        $magicscroll = $tool->getMagicScroll();
        if($magicscroll->params->checkValue('enable-effect', 'No')) return false;
        //to prevent all option to be included in rel
        $magicscroll->params->setProfile('product');
        $product = $this->getProduct();
        $this->id = $product->getId();
        $productName = $product->getName();
        $briefDescription = $product->getBriefDescription();
        $fullDescription = $product->getDescription();
        $images = $this->getProduct()->getImages();
        $imagesCount = count($images);
        if(!$imagesCount) return false;
        //if($imagesCount < $magicscroll->params->getValue('items')) {
        //    $magicscroll->params->setValue('items', $imagesCount);
        //}


        $magicscrollData = array();

        foreach($images as $index => $image) {

            list($width, $height, $thumb) = $image->getResizedURL(intval($magicscroll->params->getValue('thumb-max-width')), intval($magicscroll->params->getValue('thumb-max-height')));
            $alt = $magicscroll->params->checkValue('use-individual-titles', 'Yes') ? $image->getAlt() : '';

            $magicscrollData[] = array(
                'title' => $alt?$alt:$productName,
                'img' => $thumb,
            );

        }


        $this->renderedHTML = $magicscroll->getMainTemplate($magicscrollData, array("id" => "productMagicScroll"));

        $magicscroll->params->resetProfile();

        return true;

    }

}
